/******************************************************************************
 * Author:   Laurent Kneip                                                    *
 * Contact:  kneip.laurent@gmail.com                                          *
 * License:  Copyright (c) 2013 Laurent Kneip, ANU. All rights reserved.      *
 *                                                                            *
 * Redistribution and use in source and binary forms, with or without         *
 * modification, are permitted provided that the following conditions         *
 * are met:                                                                   *
 * * Redistributions of source code must retain the above copyright           *
 *   notice, this list of conditions and the following disclaimer.            *
 * * Redistributions in binary form must reproduce the above copyright        *
 *   notice, this list of conditions and the following disclaimer in the      *
 *   documentation and/or other materials provided with the distribution.     *
 * * Neither the name of ANU nor the names of its contributors may be         *
 *   used to endorse or promote products derived from this software without   *
 *   specific prior written permission.                                       *
 *                                                                            *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"*
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE  *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE *
 * ARE DISCLAIMED. IN NO EVENT SHALL ANU OR THE CONTRIBUTORS BE LIABLE        *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR *
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER *
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT         *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY  *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF     *
 * SUCH DAMAGE.                                                               *
 ******************************************************************************/


#include <opengv/absolute_pose/modules/gp3p/modules.hpp>


void
opengv::absolute_pose::modules::gp3p::compute(
    Eigen::Matrix<double,48,85> & groebnerMatrix )
{
  double factor = 0.0;

  sPolynomial9(groebnerMatrix);

  sPolynomial10(groebnerMatrix);
  groebnerRow9_000000_f(groebnerMatrix,10);

  sPolynomial11(groebnerMatrix);
  groebnerRow10_000010_f(groebnerMatrix,11);
  groebnerRow10_000000_f(groebnerMatrix,11);

  sPolynomial12(groebnerMatrix);
  groebnerRow10_000010_f(groebnerMatrix,12);
  groebnerRow11_000000_f(groebnerMatrix,12);
  groebnerRow10_000000_f(groebnerMatrix,12);

  sPolynomial13(groebnerMatrix);
  groebnerRow10_000010_f(groebnerMatrix,13);
  groebnerRow10_000100_f(groebnerMatrix,13);
  groebnerRow12_000010_f(groebnerMatrix,13);
  groebnerRow12_000100_f(groebnerMatrix,13);
  groebnerRow10_000000_f(groebnerMatrix,13);
  groebnerRow12_000000_f(groebnerMatrix,13);

  sPolynomial14(groebnerMatrix);
  groebnerRow10_000100_f(groebnerMatrix,14);
  groebnerRow12_000100_f(groebnerMatrix,14);
  groebnerRow10_000000_f(groebnerMatrix,14);
  groebnerRow12_000000_f(groebnerMatrix,14);

  sPolynomial15(groebnerMatrix);
  groebnerRow10_000100_f(groebnerMatrix,15);
  groebnerRow12_000100_f(groebnerMatrix,15);
  groebnerRow14_000000_f(groebnerMatrix,15);
  groebnerRow10_000000_f(groebnerMatrix,15);
  groebnerRow12_000000_f(groebnerMatrix,15);

  sPolynomial16(groebnerMatrix);
  groebnerRow15_010000_f(groebnerMatrix,16);
  groebnerRow10_100000_f(groebnerMatrix,16);
  groebnerRow12_100000_f(groebnerMatrix,16);
  groebnerRow15_100000_f(groebnerMatrix,16);
  groebnerRow10_000000_f(groebnerMatrix,16);
  groebnerRow12_000000_f(groebnerMatrix,16);
  groebnerRow15_000000_f(groebnerMatrix,16);

  sPolynomial17(groebnerMatrix);
  groebnerRow15_000000_f(groebnerMatrix,17);

  sPolynomial18(groebnerMatrix);
  groebnerRow15_000100_f(groebnerMatrix,18);
  groebnerRow17_000000_f(groebnerMatrix,18);
  groebnerRow15_000000_f(groebnerMatrix,18);

  sPolynomial19(groebnerMatrix);
  groebnerRow12_010000_f(groebnerMatrix,19);
  groebnerRow15_010000_f(groebnerMatrix,19);
  groebnerRow10_100000_f(groebnerMatrix,19);
  groebnerRow12_100000_f(groebnerMatrix,19);
  groebnerRow15_100000_f(groebnerMatrix,19);
  groebnerRow16_000000_f(groebnerMatrix,19);
  groebnerRow10_000000_f(groebnerMatrix,19);
  groebnerRow12_000000_f(groebnerMatrix,19);
  groebnerRow15_000000_f(groebnerMatrix,19);

  sPolynomial20(groebnerMatrix);
  groebnerRow10_000100_f(groebnerMatrix,20);
  groebnerRow12_000001_f(groebnerMatrix,20);
  groebnerRow12_000100_f(groebnerMatrix,20);
  groebnerRow15_000001_f(groebnerMatrix,20);
  groebnerRow15_000100_f(groebnerMatrix,20);
  groebnerRow17_000000_f(groebnerMatrix,20);
  groebnerRow10_000000_f(groebnerMatrix,20);
  groebnerRow12_000000_f(groebnerMatrix,20);
  groebnerRow15_000000_f(groebnerMatrix,20);

  sPolynomial21(groebnerMatrix);
  groebnerRow19_000100_f(groebnerMatrix,21);
  groebnerRow17_000000_f(groebnerMatrix,21);
  groebnerRow16_000000_f(groebnerMatrix,21);
  groebnerRow19_000000_f(groebnerMatrix,21);

  sPolynomial22(groebnerMatrix);
  groebnerRow19_000010_f(groebnerMatrix,22);
  groebnerRow18_000000_f(groebnerMatrix,22);
  groebnerRow16_000000_f(groebnerMatrix,22);
  groebnerRow19_000000_f(groebnerMatrix,22);

  sPolynomial23(groebnerMatrix);
  groebnerRow19_000001_f(groebnerMatrix,23);
  groebnerRow20_000000_f(groebnerMatrix,23);
  groebnerRow16_000000_f(groebnerMatrix,23);
  groebnerRow19_000000_f(groebnerMatrix,23);

  sPolynomial24(groebnerMatrix);
  groebnerRow15_100100_f(groebnerMatrix,24);
  groebnerRow16_000100_f(groebnerMatrix,24);
  groebnerRow19_000100_f(groebnerMatrix,24);
  groebnerRow21_000000_f(groebnerMatrix,24);
  groebnerRow12_000100_f(groebnerMatrix,24);
  groebnerRow15_000100_f(groebnerMatrix,24);
  groebnerRow17_000000_f(groebnerMatrix,24);
  groebnerRow12_100000_f(groebnerMatrix,24);
  groebnerRow15_100000_f(groebnerMatrix,24);
  groebnerRow16_000000_f(groebnerMatrix,24);
  groebnerRow19_000000_f(groebnerMatrix,24);
  groebnerRow12_000000_f(groebnerMatrix,24);
  groebnerRow15_000000_f(groebnerMatrix,24);

  sPolynomial25(groebnerMatrix);
  groebnerRow15_100010_f(groebnerMatrix,25);
  groebnerRow16_000010_f(groebnerMatrix,25);
  groebnerRow19_000010_f(groebnerMatrix,25);
  groebnerRow22_000000_f(groebnerMatrix,25);
  groebnerRow12_000010_f(groebnerMatrix,25);
  groebnerRow15_000010_f(groebnerMatrix,25);
  groebnerRow18_000000_f(groebnerMatrix,25);
  groebnerRow12_100000_f(groebnerMatrix,25);
  groebnerRow15_100000_f(groebnerMatrix,25);
  groebnerRow16_000000_f(groebnerMatrix,25);
  groebnerRow19_000000_f(groebnerMatrix,25);
  groebnerRow12_000000_f(groebnerMatrix,25);
  groebnerRow15_000000_f(groebnerMatrix,25);

  sPolynomial26(groebnerMatrix);
  groebnerRow15_100001_f(groebnerMatrix,26);
  groebnerRow16_000001_f(groebnerMatrix,26);
  groebnerRow19_000001_f(groebnerMatrix,26);
  groebnerRow23_000000_f(groebnerMatrix,26);
  groebnerRow12_000001_f(groebnerMatrix,26);
  groebnerRow15_000001_f(groebnerMatrix,26);
  groebnerRow20_000000_f(groebnerMatrix,26);
  groebnerRow12_100000_f(groebnerMatrix,26);
  groebnerRow15_100000_f(groebnerMatrix,26);
  groebnerRow16_000000_f(groebnerMatrix,26);
  groebnerRow19_000000_f(groebnerMatrix,26);
  groebnerRow12_000000_f(groebnerMatrix,26);
  groebnerRow15_000000_f(groebnerMatrix,26);

  sPolynomial27(groebnerMatrix);
  groebnerRow12_100100_f(groebnerMatrix,27);
  groebnerRow15_100100_f(groebnerMatrix,27);
  groebnerRow16_000100_f(groebnerMatrix,27);
  groebnerRow19_000100_f(groebnerMatrix,27);
  groebnerRow21_000000_f(groebnerMatrix,27);
  groebnerRow10_000100_f(groebnerMatrix,27);
  groebnerRow12_000100_f(groebnerMatrix,27);
  groebnerRow15_000100_f(groebnerMatrix,27);
  groebnerRow17_000000_f(groebnerMatrix,27);
  groebnerRow10_100000_f(groebnerMatrix,27);
  groebnerRow24_000000_f(groebnerMatrix,27);
  groebnerRow12_100000_f(groebnerMatrix,27);
  groebnerRow15_100000_f(groebnerMatrix,27);
  groebnerRow16_000000_f(groebnerMatrix,27);
  groebnerRow19_000000_f(groebnerMatrix,27);
  groebnerRow10_000000_f(groebnerMatrix,27);
  groebnerRow12_000000_f(groebnerMatrix,27);
  groebnerRow15_000000_f(groebnerMatrix,27);

  sPolynomial28(groebnerMatrix);
  groebnerRow12_100010_f(groebnerMatrix,28);
  groebnerRow15_100010_f(groebnerMatrix,28);
  groebnerRow16_000010_f(groebnerMatrix,28);
  groebnerRow19_000010_f(groebnerMatrix,28);
  groebnerRow22_000000_f(groebnerMatrix,28);
  groebnerRow10_000010_f(groebnerMatrix,28);
  groebnerRow12_000010_f(groebnerMatrix,28);
  groebnerRow15_000010_f(groebnerMatrix,28);
  groebnerRow18_000000_f(groebnerMatrix,28);
  groebnerRow10_100000_f(groebnerMatrix,28);
  groebnerRow25_000000_f(groebnerMatrix,28);
  groebnerRow12_100000_f(groebnerMatrix,28);
  groebnerRow15_100000_f(groebnerMatrix,28);
  groebnerRow16_000000_f(groebnerMatrix,28);
  groebnerRow19_000000_f(groebnerMatrix,28);
  groebnerRow10_000000_f(groebnerMatrix,28);
  groebnerRow12_000000_f(groebnerMatrix,28);
  groebnerRow15_000000_f(groebnerMatrix,28);

  sPolynomial29(groebnerMatrix);
  groebnerRow12_100001_f(groebnerMatrix,29);
  groebnerRow15_100001_f(groebnerMatrix,29);
  groebnerRow16_000001_f(groebnerMatrix,29);
  groebnerRow19_000001_f(groebnerMatrix,29);
  groebnerRow23_000000_f(groebnerMatrix,29);
  groebnerRow10_000001_f(groebnerMatrix,29);
  groebnerRow12_000001_f(groebnerMatrix,29);
  groebnerRow15_000001_f(groebnerMatrix,29);
  groebnerRow20_000000_f(groebnerMatrix,29);
  groebnerRow10_100000_f(groebnerMatrix,29);
  groebnerRow26_000000_f(groebnerMatrix,29);
  groebnerRow12_100000_f(groebnerMatrix,29);
  groebnerRow15_100000_f(groebnerMatrix,29);
  groebnerRow16_000000_f(groebnerMatrix,29);
  groebnerRow19_000000_f(groebnerMatrix,29);
  groebnerRow10_000000_f(groebnerMatrix,29);
  groebnerRow12_000000_f(groebnerMatrix,29);
  groebnerRow15_000000_f(groebnerMatrix,29);

  sPolynomial30(groebnerMatrix);
  groebnerRow18_000000_f(groebnerMatrix,30);
  groebnerRow17_000000_f(groebnerMatrix,30);
  groebnerRow25_000000_f(groebnerMatrix,30);
  groebnerRow24_000000_f(groebnerMatrix,30);
  groebnerRow28_000000_f(groebnerMatrix,30);
  groebnerRow27_000000_f(groebnerMatrix,30);

  sPolynomial31(groebnerMatrix);
  groebnerRow20_000000_f(groebnerMatrix,31);
  groebnerRow17_000000_f(groebnerMatrix,31);
  groebnerRow26_000000_f(groebnerMatrix,31);
  groebnerRow24_000000_f(groebnerMatrix,31);
  groebnerRow29_000000_f(groebnerMatrix,31);
  groebnerRow27_000000_f(groebnerMatrix,31);

  sPolynomial32(groebnerMatrix);
  groebnerRow31_100000_f(groebnerMatrix,32);
  groebnerRow30_100000_f(groebnerMatrix,32);
  groebnerRow17_000000_f(groebnerMatrix,32);
  groebnerRow26_000000_f(groebnerMatrix,32);
  groebnerRow25_000000_f(groebnerMatrix,32);
  groebnerRow24_000000_f(groebnerMatrix,32);
  groebnerRow29_000000_f(groebnerMatrix,32);
  groebnerRow28_000000_f(groebnerMatrix,32);
  groebnerRow27_000000_f(groebnerMatrix,32);
  groebnerRow16_000000_f(groebnerMatrix,32);
  groebnerRow19_000000_f(groebnerMatrix,32);
  groebnerRow31_000000_f(groebnerMatrix,32);
  groebnerRow30_000000_f(groebnerMatrix,32);

  sPolynomial33(groebnerMatrix);
  groebnerRow26_000000_f(groebnerMatrix,33);
  groebnerRow25_000000_f(groebnerMatrix,33);
  groebnerRow24_000000_f(groebnerMatrix,33);
  groebnerRow29_000000_f(groebnerMatrix,33);
  groebnerRow28_000000_f(groebnerMatrix,33);
  groebnerRow27_000000_f(groebnerMatrix,33);
  groebnerRow16_000000_f(groebnerMatrix,33);
  groebnerRow19_000000_f(groebnerMatrix,33);
  groebnerRow31_000000_f(groebnerMatrix,33);
  groebnerRow30_000000_f(groebnerMatrix,33);
  groebnerRow32_000000_f(groebnerMatrix,33);

  sPolynomial34(groebnerMatrix);
  groebnerRow32_100000_f(groebnerMatrix,34);
  groebnerRow33_100000_f(groebnerMatrix,34);
  groebnerRow25_000000_f(groebnerMatrix,34);
  groebnerRow24_000000_f(groebnerMatrix,34);
  groebnerRow29_000000_f(groebnerMatrix,34);
  groebnerRow28_000000_f(groebnerMatrix,34);
  groebnerRow27_000000_f(groebnerMatrix,34);
  groebnerRow16_000000_f(groebnerMatrix,34);
  groebnerRow19_000000_f(groebnerMatrix,34);
  groebnerRow31_000000_f(groebnerMatrix,34);
  groebnerRow30_000000_f(groebnerMatrix,34);
  groebnerRow32_000000_f(groebnerMatrix,34);
  groebnerRow33_000000_f(groebnerMatrix,34);

  sPolynomial35(groebnerMatrix);
  groebnerRow32_100000_f(groebnerMatrix,35);
  groebnerRow33_100000_f(groebnerMatrix,35);
  groebnerRow34_100000_f(groebnerMatrix,35);
  groebnerRow24_000000_f(groebnerMatrix,35);
  groebnerRow29_000000_f(groebnerMatrix,35);
  groebnerRow28_000000_f(groebnerMatrix,35);
  groebnerRow27_000000_f(groebnerMatrix,35);
  groebnerRow16_000000_f(groebnerMatrix,35);
  groebnerRow19_000000_f(groebnerMatrix,35);
  groebnerRow31_000000_f(groebnerMatrix,35);
  groebnerRow30_000000_f(groebnerMatrix,35);
  groebnerRow32_000000_f(groebnerMatrix,35);
  groebnerRow33_000000_f(groebnerMatrix,35);
  groebnerRow34_000000_f(groebnerMatrix,35);

  sPolynomial36(groebnerMatrix);
  groebnerRow15_000001_f(groebnerMatrix,36);
  groebnerRow15_000010_f(groebnerMatrix,36);
  groebnerRow15_000100_f(groebnerMatrix,36);
  groebnerRow31_100000_f(groebnerMatrix,36);
  groebnerRow30_100000_f(groebnerMatrix,36);
  groebnerRow32_100000_f(groebnerMatrix,36);
  groebnerRow33_100000_f(groebnerMatrix,36);
  groebnerRow34_100000_f(groebnerMatrix,36);
  groebnerRow35_100000_f(groebnerMatrix,36);
  groebnerRow12_100000_f(groebnerMatrix,36);
  groebnerRow15_100000_f(groebnerMatrix,36);
  groebnerRow29_000000_f(groebnerMatrix,36);
  groebnerRow28_000000_f(groebnerMatrix,36);
  groebnerRow27_000000_f(groebnerMatrix,36);
  groebnerRow16_000000_f(groebnerMatrix,36);
  groebnerRow19_000000_f(groebnerMatrix,36);
  groebnerRow31_000000_f(groebnerMatrix,36);
  groebnerRow30_000000_f(groebnerMatrix,36);
  groebnerRow32_000000_f(groebnerMatrix,36);
  groebnerRow33_000000_f(groebnerMatrix,36);
  groebnerRow34_000000_f(groebnerMatrix,36);
  groebnerRow35_000000_f(groebnerMatrix,36);
  groebnerRow12_000000_f(groebnerMatrix,36);
  groebnerRow15_000000_f(groebnerMatrix,36);

  sPolynomial37(groebnerMatrix);
  groebnerRow12_000100_f(groebnerMatrix,37);
  groebnerRow15_000010_f(groebnerMatrix,37);
  groebnerRow15_000100_f(groebnerMatrix,37);
  groebnerRow30_100000_f(groebnerMatrix,37);
  groebnerRow32_100000_f(groebnerMatrix,37);
  groebnerRow33_100000_f(groebnerMatrix,37);
  groebnerRow34_100000_f(groebnerMatrix,37);
  groebnerRow35_100000_f(groebnerMatrix,37);
  groebnerRow12_100000_f(groebnerMatrix,37);
  groebnerRow15_100000_f(groebnerMatrix,37);
  groebnerRow29_000000_f(groebnerMatrix,37);
  groebnerRow28_000000_f(groebnerMatrix,37);
  groebnerRow27_000000_f(groebnerMatrix,37);
  groebnerRow16_000000_f(groebnerMatrix,37);
  groebnerRow19_000000_f(groebnerMatrix,37);
  groebnerRow31_000000_f(groebnerMatrix,37);
  groebnerRow30_000000_f(groebnerMatrix,37);
  groebnerRow32_000000_f(groebnerMatrix,37);
  groebnerRow33_000000_f(groebnerMatrix,37);
  groebnerRow34_000000_f(groebnerMatrix,37);
  groebnerRow35_000000_f(groebnerMatrix,37);
  groebnerRow12_000000_f(groebnerMatrix,37);
  groebnerRow15_000000_f(groebnerMatrix,37);

  sPolynomial38(groebnerMatrix);
  groebnerRow12_000100_f(groebnerMatrix,38);
  groebnerRow15_000001_f(groebnerMatrix,38);
  groebnerRow15_000100_f(groebnerMatrix,38);
  groebnerRow31_100000_f(groebnerMatrix,38);
  groebnerRow32_100000_f(groebnerMatrix,38);
  groebnerRow33_100000_f(groebnerMatrix,38);
  groebnerRow34_100000_f(groebnerMatrix,38);
  groebnerRow35_100000_f(groebnerMatrix,38);
  groebnerRow12_100000_f(groebnerMatrix,38);
  groebnerRow15_100000_f(groebnerMatrix,38);
  groebnerRow37_100000_f(groebnerMatrix,38);
  groebnerRow28_000000_f(groebnerMatrix,38);
  groebnerRow27_000000_f(groebnerMatrix,38);
  groebnerRow16_000000_f(groebnerMatrix,38);
  groebnerRow19_000000_f(groebnerMatrix,38);
  groebnerRow36_000000_f(groebnerMatrix,38);
  groebnerRow31_000000_f(groebnerMatrix,38);
  groebnerRow30_000000_f(groebnerMatrix,38);
  groebnerRow32_000000_f(groebnerMatrix,38);
  groebnerRow33_000000_f(groebnerMatrix,38);
  groebnerRow34_000000_f(groebnerMatrix,38);
  groebnerRow35_000000_f(groebnerMatrix,38);
  groebnerRow12_000000_f(groebnerMatrix,38);
  groebnerRow15_000000_f(groebnerMatrix,38);
  groebnerRow37_000000_f(groebnerMatrix,38);

  sPolynomial39(groebnerMatrix);
  groebnerRow12_000001_f(groebnerMatrix,39);
  groebnerRow12_000010_f(groebnerMatrix,39);
  groebnerRow12_000100_f(groebnerMatrix,39);
  groebnerRow15_000001_f(groebnerMatrix,39);
  groebnerRow15_000010_f(groebnerMatrix,39);
  groebnerRow15_000100_f(groebnerMatrix,39);
  groebnerRow31_100000_f(groebnerMatrix,39);
  groebnerRow30_100000_f(groebnerMatrix,39);
  groebnerRow32_100000_f(groebnerMatrix,39);
  groebnerRow10_100000_f(groebnerMatrix,39);
  groebnerRow33_100000_f(groebnerMatrix,39);
  groebnerRow34_100000_f(groebnerMatrix,39);
  groebnerRow35_100000_f(groebnerMatrix,39);
  groebnerRow12_100000_f(groebnerMatrix,39);
  groebnerRow15_100000_f(groebnerMatrix,39);
  groebnerRow37_100000_f(groebnerMatrix,39);
  groebnerRow38_100000_f(groebnerMatrix,39);
  groebnerRow27_000000_f(groebnerMatrix,39);
  groebnerRow16_000000_f(groebnerMatrix,39);
  groebnerRow19_000000_f(groebnerMatrix,39);
  groebnerRow36_000000_f(groebnerMatrix,39);
  groebnerRow31_000000_f(groebnerMatrix,39);
  groebnerRow30_000000_f(groebnerMatrix,39);
  groebnerRow32_000000_f(groebnerMatrix,39);
  groebnerRow10_000000_f(groebnerMatrix,39);
  groebnerRow33_000000_f(groebnerMatrix,39);
  groebnerRow34_000000_f(groebnerMatrix,39);
  groebnerRow35_000000_f(groebnerMatrix,39);
  groebnerRow12_000000_f(groebnerMatrix,39);
  groebnerRow15_000000_f(groebnerMatrix,39);
  groebnerRow37_000000_f(groebnerMatrix,39);
  groebnerRow38_000000_f(groebnerMatrix,39);

  sPolynomial40(groebnerMatrix);
  groebnerRow10_000100_f(groebnerMatrix,40);
  groebnerRow12_000010_f(groebnerMatrix,40);
  groebnerRow12_000100_f(groebnerMatrix,40);
  groebnerRow15_000010_f(groebnerMatrix,40);
  groebnerRow15_000100_f(groebnerMatrix,40);
  groebnerRow30_100000_f(groebnerMatrix,40);
  groebnerRow32_100000_f(groebnerMatrix,40);
  groebnerRow10_100000_f(groebnerMatrix,40);
  groebnerRow33_100000_f(groebnerMatrix,40);
  groebnerRow34_100000_f(groebnerMatrix,40);
  groebnerRow35_100000_f(groebnerMatrix,40);
  groebnerRow12_100000_f(groebnerMatrix,40);
  groebnerRow15_100000_f(groebnerMatrix,40);
  groebnerRow37_100000_f(groebnerMatrix,40);
  groebnerRow38_100000_f(groebnerMatrix,40);
  groebnerRow39_100000_f(groebnerMatrix,40);
  groebnerRow16_000000_f(groebnerMatrix,40);
  groebnerRow19_000000_f(groebnerMatrix,40);
  groebnerRow36_000000_f(groebnerMatrix,40);
  groebnerRow30_000000_f(groebnerMatrix,40);
  groebnerRow32_000000_f(groebnerMatrix,40);
  groebnerRow10_000000_f(groebnerMatrix,40);
  groebnerRow33_000000_f(groebnerMatrix,40);
  groebnerRow34_000000_f(groebnerMatrix,40);
  groebnerRow35_000000_f(groebnerMatrix,40);
  groebnerRow12_000000_f(groebnerMatrix,40);
  groebnerRow15_000000_f(groebnerMatrix,40);
  groebnerRow37_000000_f(groebnerMatrix,40);
  groebnerRow38_000000_f(groebnerMatrix,40);
  groebnerRow39_000000_f(groebnerMatrix,40);

  sPolynomial41(groebnerMatrix);
  groebnerRow10_000100_f(groebnerMatrix,41);
  groebnerRow12_000001_f(groebnerMatrix,41);
  groebnerRow12_000100_f(groebnerMatrix,41);
  groebnerRow15_000001_f(groebnerMatrix,41);
  groebnerRow15_000100_f(groebnerMatrix,41);
  groebnerRow31_100000_f(groebnerMatrix,41);
  groebnerRow32_100000_f(groebnerMatrix,41);
  groebnerRow10_100000_f(groebnerMatrix,41);
  groebnerRow33_100000_f(groebnerMatrix,41);
  groebnerRow34_100000_f(groebnerMatrix,41);
  groebnerRow35_100000_f(groebnerMatrix,41);
  groebnerRow12_100000_f(groebnerMatrix,41);
  groebnerRow15_100000_f(groebnerMatrix,41);
  groebnerRow37_100000_f(groebnerMatrix,41);
  groebnerRow38_100000_f(groebnerMatrix,41);
  groebnerRow39_100000_f(groebnerMatrix,41);
  groebnerRow40_100000_f(groebnerMatrix,41);
  groebnerRow19_000000_f(groebnerMatrix,41);
  groebnerRow36_000000_f(groebnerMatrix,41);
  groebnerRow31_000000_f(groebnerMatrix,41);
  groebnerRow32_000000_f(groebnerMatrix,41);
  groebnerRow10_000000_f(groebnerMatrix,41);
  groebnerRow33_000000_f(groebnerMatrix,41);
  groebnerRow34_000000_f(groebnerMatrix,41);
  groebnerRow35_000000_f(groebnerMatrix,41);
  groebnerRow12_000000_f(groebnerMatrix,41);
  groebnerRow15_000000_f(groebnerMatrix,41);
  groebnerRow37_000000_f(groebnerMatrix,41);
  groebnerRow38_000000_f(groebnerMatrix,41);
  groebnerRow39_000000_f(groebnerMatrix,41);
  groebnerRow40_000000_f(groebnerMatrix,41);

  sPolynomial42(groebnerMatrix);
  groebnerRow32_000100_f(groebnerMatrix,42);
  groebnerRow33_000010_f(groebnerMatrix,42);
  groebnerRow34_000010_f(groebnerMatrix,42);
  groebnerRow33_000100_f(groebnerMatrix,42);
  groebnerRow34_000100_f(groebnerMatrix,42);
  groebnerRow35_000100_f(groebnerMatrix,42);
  groebnerRow37_000010_f(groebnerMatrix,42);
  groebnerRow38_000010_f(groebnerMatrix,42);
  groebnerRow37_000100_f(groebnerMatrix,42);
  groebnerRow38_000100_f(groebnerMatrix,42);
  groebnerRow39_000100_f(groebnerMatrix,42);
  groebnerRow30_100000_f(groebnerMatrix,42);
  groebnerRow32_100000_f(groebnerMatrix,42);
  groebnerRow33_100000_f(groebnerMatrix,42);
  groebnerRow34_100000_f(groebnerMatrix,42);
  groebnerRow35_100000_f(groebnerMatrix,42);
  groebnerRow37_100000_f(groebnerMatrix,42);
  groebnerRow38_100000_f(groebnerMatrix,42);
  groebnerRow39_100000_f(groebnerMatrix,42);
  groebnerRow40_100000_f(groebnerMatrix,42);
  groebnerRow41_100000_f(groebnerMatrix,42);
  groebnerRow36_000000_f(groebnerMatrix,42);
  groebnerRow30_000000_f(groebnerMatrix,42);
  groebnerRow32_000000_f(groebnerMatrix,42);
  groebnerRow33_000000_f(groebnerMatrix,42);
  groebnerRow34_000000_f(groebnerMatrix,42);
  groebnerRow35_000000_f(groebnerMatrix,42);
  groebnerRow37_000000_f(groebnerMatrix,42);
  groebnerRow38_000000_f(groebnerMatrix,42);
  groebnerRow39_000000_f(groebnerMatrix,42);
  groebnerRow40_000000_f(groebnerMatrix,42);
  groebnerRow41_000000_f(groebnerMatrix,42);

  sPolynomial43(groebnerMatrix);
  groebnerRow32_000100_f(groebnerMatrix,43);
  groebnerRow33_000001_f(groebnerMatrix,43);
  groebnerRow33_000010_f(groebnerMatrix,43);
  groebnerRow34_000010_f(groebnerMatrix,43);
  groebnerRow33_000100_f(groebnerMatrix,43);
  groebnerRow34_000100_f(groebnerMatrix,43);
  groebnerRow35_000100_f(groebnerMatrix,43);
  groebnerRow37_000001_f(groebnerMatrix,43);
  groebnerRow37_000010_f(groebnerMatrix,43);
  groebnerRow38_000010_f(groebnerMatrix,43);
  groebnerRow37_000100_f(groebnerMatrix,43);
  groebnerRow38_000100_f(groebnerMatrix,43);
  groebnerRow39_000100_f(groebnerMatrix,43);
  groebnerRow31_100000_f(groebnerMatrix,43);
  groebnerRow30_100000_f(groebnerMatrix,43);
  groebnerRow32_100000_f(groebnerMatrix,43);
  groebnerRow33_100000_f(groebnerMatrix,43);
  groebnerRow34_100000_f(groebnerMatrix,43);
  groebnerRow35_100000_f(groebnerMatrix,43);
  groebnerRow37_100000_f(groebnerMatrix,43);
  groebnerRow38_100000_f(groebnerMatrix,43);
  groebnerRow39_100000_f(groebnerMatrix,43);
  groebnerRow40_100000_f(groebnerMatrix,43);
  groebnerRow41_100000_f(groebnerMatrix,43);
  groebnerRow36_000000_f(groebnerMatrix,43);
  groebnerRow42_000000_f(groebnerMatrix,43);
  groebnerRow31_000000_f(groebnerMatrix,43);
  groebnerRow30_000000_f(groebnerMatrix,43);
  groebnerRow32_000000_f(groebnerMatrix,43);
  groebnerRow33_000000_f(groebnerMatrix,43);
  groebnerRow34_000000_f(groebnerMatrix,43);
  groebnerRow35_000000_f(groebnerMatrix,43);
  groebnerRow37_000000_f(groebnerMatrix,43);
  groebnerRow38_000000_f(groebnerMatrix,43);
  groebnerRow39_000000_f(groebnerMatrix,43);
  groebnerRow40_000000_f(groebnerMatrix,43);
  groebnerRow41_000000_f(groebnerMatrix,43);

  sPolynomial44(groebnerMatrix);
  groebnerRow31_000100_f(groebnerMatrix,44);
  groebnerRow30_000100_f(groebnerMatrix,44);
  groebnerRow33_000100_f(groebnerMatrix,44);
  groebnerRow34_000100_f(groebnerMatrix,44);
  groebnerRow35_000100_f(groebnerMatrix,44);
  groebnerRow37_000100_f(groebnerMatrix,44);
  groebnerRow38_000100_f(groebnerMatrix,44);
  groebnerRow39_000100_f(groebnerMatrix,44);
  groebnerRow31_100000_f(groebnerMatrix,44);
  groebnerRow30_100000_f(groebnerMatrix,44);
  groebnerRow32_100000_f(groebnerMatrix,44);
  groebnerRow33_100000_f(groebnerMatrix,44);
  groebnerRow34_100000_f(groebnerMatrix,44);
  groebnerRow35_100000_f(groebnerMatrix,44);
  groebnerRow37_100000_f(groebnerMatrix,44);
  groebnerRow38_100000_f(groebnerMatrix,44);
  groebnerRow39_100000_f(groebnerMatrix,44);
  groebnerRow40_100000_f(groebnerMatrix,44);
  groebnerRow41_100000_f(groebnerMatrix,44);
  groebnerRow36_000000_f(groebnerMatrix,44);
  groebnerRow31_000000_f(groebnerMatrix,44);
  groebnerRow30_000000_f(groebnerMatrix,44);
  groebnerRow32_000000_f(groebnerMatrix,44);
  groebnerRow33_000000_f(groebnerMatrix,44);
  groebnerRow34_000000_f(groebnerMatrix,44);
  groebnerRow35_000000_f(groebnerMatrix,44);
  groebnerRow37_000000_f(groebnerMatrix,44);
  groebnerRow38_000000_f(groebnerMatrix,44);
  groebnerRow39_000000_f(groebnerMatrix,44);
  groebnerRow40_000000_f(groebnerMatrix,44);
  groebnerRow41_000000_f(groebnerMatrix,44);

  sPolynomial45(groebnerMatrix);
  groebnerRow36_000100_f(groebnerMatrix,45);
  groebnerRow36_010000_f(groebnerMatrix,45);
  groebnerRow12_000100_f(groebnerMatrix,45);
  groebnerRow15_000100_f(groebnerMatrix,45);
  groebnerRow37_000100_f(groebnerMatrix,45);
  groebnerRow38_000100_f(groebnerMatrix,45);
  groebnerRow39_000100_f(groebnerMatrix,45);
  groebnerRow32_100000_f(groebnerMatrix,45);
  groebnerRow33_100000_f(groebnerMatrix,45);
  groebnerRow34_100000_f(groebnerMatrix,45);
  groebnerRow35_100000_f(groebnerMatrix,45);
  groebnerRow12_100000_f(groebnerMatrix,45);
  groebnerRow15_100000_f(groebnerMatrix,45);
  groebnerRow37_100000_f(groebnerMatrix,45);
  groebnerRow38_100000_f(groebnerMatrix,45);
  groebnerRow39_100000_f(groebnerMatrix,45);
  groebnerRow40_100000_f(groebnerMatrix,45);
  groebnerRow41_100000_f(groebnerMatrix,45);
  groebnerRow36_000000_f(groebnerMatrix,45);
  groebnerRow44_000000_f(groebnerMatrix,45);
  groebnerRow32_000000_f(groebnerMatrix,45);
  groebnerRow33_000000_f(groebnerMatrix,45);
  groebnerRow34_000000_f(groebnerMatrix,45);
  groebnerRow35_000000_f(groebnerMatrix,45);
  groebnerRow12_000000_f(groebnerMatrix,45);
  groebnerRow15_000000_f(groebnerMatrix,45);
  groebnerRow37_000000_f(groebnerMatrix,45);
  groebnerRow38_000000_f(groebnerMatrix,45);
  groebnerRow39_000000_f(groebnerMatrix,45);
  groebnerRow40_000000_f(groebnerMatrix,45);
  groebnerRow41_000000_f(groebnerMatrix,45);

  sPolynomial46(groebnerMatrix);
  groebnerRow36_000010_f(groebnerMatrix,46);
  groebnerRow36_010000_f(groebnerMatrix,46);
  groebnerRow12_000010_f(groebnerMatrix,46);
  groebnerRow15_000010_f(groebnerMatrix,46);
  groebnerRow37_000010_f(groebnerMatrix,46);
  groebnerRow38_000010_f(groebnerMatrix,46);
  groebnerRow38_000100_f(groebnerMatrix,46);
  groebnerRow39_000100_f(groebnerMatrix,46);
  groebnerRow30_100000_f(groebnerMatrix,46);
  groebnerRow32_100000_f(groebnerMatrix,46);
  groebnerRow33_100000_f(groebnerMatrix,46);
  groebnerRow34_100000_f(groebnerMatrix,46);
  groebnerRow35_100000_f(groebnerMatrix,46);
  groebnerRow12_100000_f(groebnerMatrix,46);
  groebnerRow15_100000_f(groebnerMatrix,46);
  groebnerRow37_100000_f(groebnerMatrix,46);
  groebnerRow38_100000_f(groebnerMatrix,46);
  groebnerRow39_100000_f(groebnerMatrix,46);
  groebnerRow40_100000_f(groebnerMatrix,46);
  groebnerRow41_100000_f(groebnerMatrix,46);
  groebnerRow36_000000_f(groebnerMatrix,46);
  groebnerRow42_000000_f(groebnerMatrix,46);
  groebnerRow44_000000_f(groebnerMatrix,46);
  groebnerRow45_000000_f(groebnerMatrix,46);
  groebnerRow30_000000_f(groebnerMatrix,46);
  groebnerRow32_000000_f(groebnerMatrix,46);
  groebnerRow33_000000_f(groebnerMatrix,46);
  groebnerRow34_000000_f(groebnerMatrix,46);
  groebnerRow35_000000_f(groebnerMatrix,46);
  groebnerRow12_000000_f(groebnerMatrix,46);
  groebnerRow15_000000_f(groebnerMatrix,46);
  groebnerRow37_000000_f(groebnerMatrix,46);
  groebnerRow38_000000_f(groebnerMatrix,46);
  groebnerRow39_000000_f(groebnerMatrix,46);
  groebnerRow40_000000_f(groebnerMatrix,46);
  groebnerRow41_000000_f(groebnerMatrix,46);

  sPolynomial47(groebnerMatrix);
  groebnerRow36_000001_f(groebnerMatrix,47);
  groebnerRow36_010000_f(groebnerMatrix,47);
  groebnerRow12_000001_f(groebnerMatrix,47);
  groebnerRow15_000001_f(groebnerMatrix,47);
  groebnerRow37_000001_f(groebnerMatrix,47);
  groebnerRow37_000010_f(groebnerMatrix,47);
  groebnerRow38_000010_f(groebnerMatrix,47);
  groebnerRow37_000100_f(groebnerMatrix,47);
  groebnerRow38_000100_f(groebnerMatrix,47);
  groebnerRow39_000100_f(groebnerMatrix,47);
  groebnerRow31_100000_f(groebnerMatrix,47);
  groebnerRow30_100000_f(groebnerMatrix,47);
  groebnerRow32_100000_f(groebnerMatrix,47);
  groebnerRow33_100000_f(groebnerMatrix,47);
  groebnerRow34_100000_f(groebnerMatrix,47);
  groebnerRow35_100000_f(groebnerMatrix,47);
  groebnerRow12_100000_f(groebnerMatrix,47);
  groebnerRow15_100000_f(groebnerMatrix,47);
  groebnerRow37_100000_f(groebnerMatrix,47);
  groebnerRow38_100000_f(groebnerMatrix,47);
  groebnerRow39_100000_f(groebnerMatrix,47);
  groebnerRow40_100000_f(groebnerMatrix,47);
  groebnerRow41_100000_f(groebnerMatrix,47);
  groebnerRow36_000000_f(groebnerMatrix,47);
  groebnerRow43_000000_f(groebnerMatrix,47);
  groebnerRow42_000000_f(groebnerMatrix,47);
  groebnerRow46_000000_f(groebnerMatrix,47);
  groebnerRow44_000000_f(groebnerMatrix,47);
  groebnerRow45_000000_f(groebnerMatrix,47);
  groebnerRow31_000000_f(groebnerMatrix,47);
  groebnerRow30_000000_f(groebnerMatrix,47);
  groebnerRow32_000000_f(groebnerMatrix,47);
  groebnerRow33_000000_f(groebnerMatrix,47);
  groebnerRow34_000000_f(groebnerMatrix,47);
  groebnerRow35_000000_f(groebnerMatrix,47);
  groebnerRow12_000000_f(groebnerMatrix,47);
  groebnerRow15_000000_f(groebnerMatrix,47);
  groebnerRow37_000000_f(groebnerMatrix,47);
  groebnerRow38_000000_f(groebnerMatrix,47);
  groebnerRow39_000000_f(groebnerMatrix,47);
  groebnerRow40_000000_f(groebnerMatrix,47);
  groebnerRow41_000000_f(groebnerMatrix,47);

  factor = 1.0 / groebnerMatrix(10,66);
  groebnerMatrix.row(10) = factor * groebnerMatrix.row(10);
  factor = 1.0 / groebnerMatrix(12,70);
  groebnerMatrix.row(12) = factor * groebnerMatrix.row(12);
  factor = 1.0 / groebnerMatrix(15,71);
  groebnerMatrix.row(15) = factor * groebnerMatrix.row(15);
  factor = 1.0 / groebnerMatrix(30,64);
  groebnerMatrix.row(30) = factor * groebnerMatrix.row(30);
  factor = 1.0 / groebnerMatrix(31,63);
  groebnerMatrix.row(31) = factor * groebnerMatrix.row(31);
  factor = 1.0 / groebnerMatrix(32,65);
  groebnerMatrix.row(32) = factor * groebnerMatrix.row(32);
  factor = 1.0 / groebnerMatrix(33,67);
  groebnerMatrix.row(33) = factor * groebnerMatrix.row(33);
  factor = 1.0 / groebnerMatrix(34,68);
  groebnerMatrix.row(34) = factor * groebnerMatrix.row(34);
  factor = 1.0 / groebnerMatrix(35,69);
  groebnerMatrix.row(35) = factor * groebnerMatrix.row(35);
  factor = 1.0 / groebnerMatrix(36,56);
  groebnerMatrix.row(36) = factor * groebnerMatrix.row(36);
  factor = 1.0 / groebnerMatrix(37,72);
  groebnerMatrix.row(37) = factor * groebnerMatrix.row(37);
  factor = 1.0 / groebnerMatrix(38,73);
  groebnerMatrix.row(38) = factor * groebnerMatrix.row(38);
  factor = 1.0 / groebnerMatrix(39,74);
  groebnerMatrix.row(39) = factor * groebnerMatrix.row(39);
  factor = 1.0 / groebnerMatrix(40,75);
  groebnerMatrix.row(40) = factor * groebnerMatrix.row(40);
  factor = 1.0 / groebnerMatrix(41,76);
  groebnerMatrix.row(41) = factor * groebnerMatrix.row(41);
  factor = 1.0 / groebnerMatrix(42,58);
  groebnerMatrix.row(42) = factor * groebnerMatrix.row(42);
  factor = 1.0 / groebnerMatrix(43,57);
  groebnerMatrix.row(43) = factor * groebnerMatrix.row(43);
  factor = 1.0 / groebnerMatrix(44,60);
  groebnerMatrix.row(44) = factor * groebnerMatrix.row(44);
  factor = 1.0 / groebnerMatrix(45,61);
  groebnerMatrix.row(45) = factor * groebnerMatrix.row(45);
  factor = 1.0 / groebnerMatrix(46,59);
  groebnerMatrix.row(46) = factor * groebnerMatrix.row(46);
  factor = 1.0 / groebnerMatrix(47,62);
  groebnerMatrix.row(47) = factor * groebnerMatrix.row(47);
  factor = groebnerMatrix(10,70);
  groebnerMatrix.row(10) = groebnerMatrix.row(10) - factor * groebnerMatrix.row(12);
  factor = groebnerMatrix(10,71);
  groebnerMatrix.row(10) = groebnerMatrix.row(10) - factor * groebnerMatrix.row(15);
  factor = groebnerMatrix(10,75);
  groebnerMatrix.row(10) = groebnerMatrix.row(10) - factor * groebnerMatrix.row(40);
  factor = groebnerMatrix(10,76);
  groebnerMatrix.row(10) = groebnerMatrix.row(10) - factor * groebnerMatrix.row(41);
  factor = groebnerMatrix(12,71);
  groebnerMatrix.row(12) = groebnerMatrix.row(12) - factor * groebnerMatrix.row(15);
  factor = groebnerMatrix(12,75);
  groebnerMatrix.row(12) = groebnerMatrix.row(12) - factor * groebnerMatrix.row(40);
  factor = groebnerMatrix(12,76);
  groebnerMatrix.row(12) = groebnerMatrix.row(12) - factor * groebnerMatrix.row(41);
  factor = groebnerMatrix(15,75);
  groebnerMatrix.row(15) = groebnerMatrix.row(15) - factor * groebnerMatrix.row(40);
  factor = groebnerMatrix(15,76);
  groebnerMatrix.row(15) = groebnerMatrix.row(15) - factor * groebnerMatrix.row(41);
  factor = groebnerMatrix(30,65);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(32);
  factor = groebnerMatrix(30,67);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(33);
  factor = groebnerMatrix(30,68);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(34);
  factor = groebnerMatrix(30,69);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(35);
  factor = groebnerMatrix(30,72);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(30,73);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(30,74);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(30,75);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(40);
  factor = groebnerMatrix(30,76);
  groebnerMatrix.row(30) = groebnerMatrix.row(30) - factor * groebnerMatrix.row(41);
  factor = groebnerMatrix(31,65);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(32);
  factor = groebnerMatrix(31,67);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(33);
  factor = groebnerMatrix(31,68);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(34);
  factor = groebnerMatrix(31,69);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(35);
  factor = groebnerMatrix(31,72);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(31,73);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(31,74);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(31,75);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(40);
  factor = groebnerMatrix(31,76);
  groebnerMatrix.row(31) = groebnerMatrix.row(31) - factor * groebnerMatrix.row(41);
  factor = groebnerMatrix(32,67);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(33);
  factor = groebnerMatrix(32,68);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(34);
  factor = groebnerMatrix(32,69);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(35);
  factor = groebnerMatrix(32,72);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(32,73);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(32,74);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(32,75);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(40);
  factor = groebnerMatrix(32,76);
  groebnerMatrix.row(32) = groebnerMatrix.row(32) - factor * groebnerMatrix.row(41);
  factor = groebnerMatrix(33,68);
  groebnerMatrix.row(33) = groebnerMatrix.row(33) - factor * groebnerMatrix.row(34);
  factor = groebnerMatrix(33,69);
  groebnerMatrix.row(33) = groebnerMatrix.row(33) - factor * groebnerMatrix.row(35);
  factor = groebnerMatrix(33,72);
  groebnerMatrix.row(33) = groebnerMatrix.row(33) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(33,73);
  groebnerMatrix.row(33) = groebnerMatrix.row(33) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(33,74);
  groebnerMatrix.row(33) = groebnerMatrix.row(33) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(33,75);
  groebnerMatrix.row(33) = groebnerMatrix.row(33) - factor * groebnerMatrix.row(40);
  factor = groebnerMatrix(33,76);
  groebnerMatrix.row(33) = groebnerMatrix.row(33) - factor * groebnerMatrix.row(41);
  factor = groebnerMatrix(34,69);
  groebnerMatrix.row(34) = groebnerMatrix.row(34) - factor * groebnerMatrix.row(35);
  factor = groebnerMatrix(34,72);
  groebnerMatrix.row(34) = groebnerMatrix.row(34) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(34,73);
  groebnerMatrix.row(34) = groebnerMatrix.row(34) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(34,74);
  groebnerMatrix.row(34) = groebnerMatrix.row(34) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(34,75);
  groebnerMatrix.row(34) = groebnerMatrix.row(34) - factor * groebnerMatrix.row(40);
  factor = groebnerMatrix(34,76);
  groebnerMatrix.row(34) = groebnerMatrix.row(34) - factor * groebnerMatrix.row(41);
  factor = groebnerMatrix(35,72);
  groebnerMatrix.row(35) = groebnerMatrix.row(35) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(35,73);
  groebnerMatrix.row(35) = groebnerMatrix.row(35) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(35,74);
  groebnerMatrix.row(35) = groebnerMatrix.row(35) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(35,75);
  groebnerMatrix.row(35) = groebnerMatrix.row(35) - factor * groebnerMatrix.row(40);
  factor = groebnerMatrix(35,76);
  groebnerMatrix.row(35) = groebnerMatrix.row(35) - factor * groebnerMatrix.row(41);
  factor = groebnerMatrix(36,72);
  groebnerMatrix.row(36) = groebnerMatrix.row(36) - factor * groebnerMatrix.row(37);
  factor = groebnerMatrix(36,73);
  groebnerMatrix.row(36) = groebnerMatrix.row(36) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(36,74);
  groebnerMatrix.row(36) = groebnerMatrix.row(36) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(36,75);
  groebnerMatrix.row(36) = groebnerMatrix.row(36) - factor * groebnerMatrix.row(40);
  factor = groebnerMatrix(36,76);
  groebnerMatrix.row(36) = groebnerMatrix.row(36) - factor * groebnerMatrix.row(41);
  factor = groebnerMatrix(37,73);
  groebnerMatrix.row(37) = groebnerMatrix.row(37) - factor * groebnerMatrix.row(38);
  factor = groebnerMatrix(37,74);
  groebnerMatrix.row(37) = groebnerMatrix.row(37) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(37,75);
  groebnerMatrix.row(37) = groebnerMatrix.row(37) - factor * groebnerMatrix.row(40);
  factor = groebnerMatrix(37,76);
  groebnerMatrix.row(37) = groebnerMatrix.row(37) - factor * groebnerMatrix.row(41);
  factor = groebnerMatrix(38,74);
  groebnerMatrix.row(38) = groebnerMatrix.row(38) - factor * groebnerMatrix.row(39);
  factor = groebnerMatrix(38,75);
  groebnerMatrix.row(38) = groebnerMatrix.row(38) - factor * groebnerMatrix.row(40);
  factor = groebnerMatrix(38,76);
  groebnerMatrix.row(38) = groebnerMatrix.row(38) - factor * groebnerMatrix.row(41);
  factor = groebnerMatrix(39,75);
  groebnerMatrix.row(39) = groebnerMatrix.row(39) - factor * groebnerMatrix.row(40);
  factor = groebnerMatrix(39,76);
  groebnerMatrix.row(39) = groebnerMatrix.row(39) - factor * groebnerMatrix.row(41);
  factor = groebnerMatrix(40,76);
  groebnerMatrix.row(40) = groebnerMatrix.row(40) - factor * groebnerMatrix.row(41);
  factor = groebnerMatrix(42,59);
  groebnerMatrix.row(42) = groebnerMatrix.row(42) - factor * groebnerMatrix.row(46);
  factor = groebnerMatrix(42,60);
  groebnerMatrix.row(42) = groebnerMatrix.row(42) - factor * groebnerMatrix.row(44);
  factor = groebnerMatrix(42,61);
  groebnerMatrix.row(42) = groebnerMatrix.row(42) - factor * groebnerMatrix.row(45);
  factor = groebnerMatrix(42,62);
  groebnerMatrix.row(42) = groebnerMatrix.row(42) - factor * groebnerMatrix.row(47);
  factor = groebnerMatrix(43,59);
  groebnerMatrix.row(43) = groebnerMatrix.row(43) - factor * groebnerMatrix.row(46);
  factor = groebnerMatrix(43,60);
  groebnerMatrix.row(43) = groebnerMatrix.row(43) - factor * groebnerMatrix.row(44);
  factor = groebnerMatrix(43,61);
  groebnerMatrix.row(43) = groebnerMatrix.row(43) - factor * groebnerMatrix.row(45);
  factor = groebnerMatrix(43,62);
  groebnerMatrix.row(43) = groebnerMatrix.row(43) - factor * groebnerMatrix.row(47);
  factor = groebnerMatrix(44,61);
  groebnerMatrix.row(44) = groebnerMatrix.row(44) - factor * groebnerMatrix.row(45);
  factor = groebnerMatrix(44,62);
  groebnerMatrix.row(44) = groebnerMatrix.row(44) - factor * groebnerMatrix.row(47);
  factor = groebnerMatrix(45,62);
  groebnerMatrix.row(45) = groebnerMatrix.row(45) - factor * groebnerMatrix.row(47);
  factor = groebnerMatrix(46,62);
  groebnerMatrix.row(46) = groebnerMatrix.row(46) - factor * groebnerMatrix.row(47);
}
