/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENRIJN_VERSION_H_
#define _OPENRIJN_VERSION_H_

#include <GTLCore/Version.h>
#include <OpenRijn/Export.h>

#define OPENRIJN_VERSION_MAJOR GTL_CORE_VERSION_MAJOR
#define OPENRIJN_VERSION_MINOR GTL_CORE_VERSION_MINOR
#define OPENRIJN_VERSION_REVISION GTL_CORE_VERSION_REVISION

namespace OpenRijn {
  OPENRIJN_EXPORT GTLCore::String LibraryShortName();
  OPENRIJN_EXPORT GTLCore::String LibraryName();
  OPENRIJN_EXPORT GTLCore::String LibraryCopyright();
  OPENRIJN_EXPORT GTLCore::String LibraryLicence();
  OPENRIJN_EXPORT GTLCore::String LibraryVersionString();;
  OPENRIJN_EXPORT int LibraryVersionMajor();
  OPENRIJN_EXPORT int LibraryVersionMinor();
  OPENRIJN_EXPORT int LibraryVersionRevision();
  /**
   * Give the latest version of the Rijn language supported by this library.
   */
  OPENRIJN_EXPORT int LanguageVersion();
  OPENRIJN_EXPORT int LanguageVersionRevision();
}

#endif
