# 4/7/2021

### Attending:

* Cary Phillips
* Christina Tempelaar-Lietz
* Eskil Steenberg
* Kimball Thurston
* Larry Gritz
* Peter Hillman
* Nick Porcino

### Discussion:

* Issue
  [#996](https://github.com/AcademySoftwareFoundation/openexr/issues/996)
  The exception occurs inside the call: ImfOpenInputFile().

  * Almost certainly something that's been fixed, the stack trace is
    identical to others. It's from OpenEXR v2.3.

* Issue [#136](https://github.com/AcademySoftwareFoundation/Imath/issues/136)
Cmake targets provide wrong include dirs and libraries.

  * Nick: Most likely user error, it seems to be doing the right thing.

  * Need to confirm that OpenEXR works properly as a subproject.

  * Larry: I'm experiencing something weird with OIIO. OpenEXRConfig.h
    is missing, I don’t understand the transitive dependencies. Not
    sure what’s going on. But I may have some insight to share.

* Is LibraryDefine.cmake necessary?

  * Kimball: The CMake book says there should be a config pseudo
    library that’s generating the Config.h.
  
  * LibraryDefine.cmake can probably be removed. Probably a result of
    moving everything together in the reorganization.
  
* PR
  [#995](https://github.com/AcademySoftwareFoundation/openexr/issues/995)
Don't impose C++14 on downstream projects

  * Proposing a change. We compile for c++14 by default, but we make it
    impossible for downstream projects to use C++11.

  * Only affects downstream projects that consume OpenEXR/Imath that
    wants to use C++11. It was a downstream user of OIIO.

* CI:

  * Would be useful to have a basic project that consumes OpenEXR, as
    a sanity check.

* 3.1/Core

  * Kimball: done a clean up of the API. May make one more change. I’m
    pretty close, basic writing is finished. Writing tests.
  
  * What is the sequence for integrating this with the C++ side?

  * Can you mix and match? Yes, they’re totally separate. I have
    performance tests of reading with each.
  
  * Want to be able to convert the type from half to float, or have to
    include the half-to-float table.

  * Is that necessary in the C API? It’s mean to be lightweight. A lot of
    these does-it-under-the hood thing end up being performance
    problems.
  
  * ES: As a C programmer, I’d like that conversion. 

  * ffmpeg requires a C api.

  * Nick: Just do this:

        #if __cplusplus__
        struct half_t {}
        #else
        class half {
        ...
        
  * What about fuzz tests? Peter: we have our own fuzz
    test. Imf::checkFile() is the entry point. C API could be added to
    that.
  
* 3.1 branch?

  * 3.1 would be both API’s but independent of each other. 

  * 3.1 -> 3.2 is fine as long as source doesn’t change, but ABI can change.

  * There already is a C API. It’s t2o functions that reads a 4
    channel rgb single part. Too simple to be useful.
  
* Weta CLA? Will sort it out.

* VES discussion at TAC meeting:

  * May is the draft of the reference platform.
  
  * Sunset guidelines? No hard answers. But they’ll go away and consider it. 

  * It puts a burden on the CI.
  
* Security: how far back should we support?

  * Should announce a policy change, something like "We will support
    3.1, 3.0, and 2.5. Backport as requested.

  * How hard is it to backport to 2.4? Things have changed, it might
    be error prone.

  * New fuzz issues aren't easy to test in 2.4 because that release
    doesn't include the test program.


