/*###############################################################################
# Linux Management Providers (LMP), Power Supply provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_POWERSUPPLYISSPARE_H_
#define OPENDRIM_POWERSUPPLYISSPARE_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_ManagedElement.h"
#include "CIM_ManagedElementAccess.h"
#include "cmpiCIM_RedundancySet.h"
#include "CIM_RedundancySetAccess.h"
*/

const static char* OpenDRIM_PowerSupplyIsSpare_classnames[] = {"OpenDRIM_PowerSupplyIsSpare"};
static string OpenDRIM_PowerSupplyIsSpare_NAMESPACE = _NAMESPACE;
const static string Antecedent_role = "Antecedent";
const static char* Antecedent_classnames[] = {"OpenDRIM_PowerSupply"};
const static string Antecedent_NAMESPACE = _NAMESPACE;

const static string Dependent_role = "Dependent";
const static char* Dependent_classnames[] = {"OpenDRIM_PowerSupplyRedundancySet"};
const static string Dependent_NAMESPACE = _NAMESPACE;

class OpenDRIM_PowerSupplyIsSpare {

public:
	
	Objectpath Antecedent;
	bool Antecedent_isNULL;
	
	Objectpath Dependent;
	bool Dependent_isNULL;
	
	unsigned short SpareStatus;
	bool SpareStatus_isNULL;
	
	unsigned short FailoverSupported;
	bool FailoverSupported_isNULL;
	
	OpenDRIM_PowerSupplyIsSpare() {
		Antecedent_isNULL = true;
		Dependent_isNULL = true;
		SpareStatus_isNULL = true;
		FailoverSupported_isNULL = true;
	}
	
	~OpenDRIM_PowerSupplyIsSpare() {}
	
	string getKeys() const {
		return CF_toLowCase(".Antecedent=\"" + CF_quoteString(Antecedent.toString()) + "\""".Dependent=\"" + CF_quoteString(Dependent.toString()) + "\"");
	}

	int getAntecedent(Objectpath& value) const {
		if (Antecedent_isNULL==true)
			return NOT_FOUND;
		value = Antecedent;
		return OK;
	}
	
	int setAntecedent(const Objectpath& newValue) {
		Antecedent = newValue;
		Antecedent.setNamespace(Antecedent_NAMESPACE);
		Antecedent_isNULL = false;
		return OK;
	}

	int getDependent(Objectpath& value) const {
		if (Dependent_isNULL==true)
			return NOT_FOUND;
		value = Dependent;
		return OK;
	}
	
	int setDependent(const Objectpath& newValue) {
		Dependent = newValue;
		Dependent.setNamespace(Dependent_NAMESPACE);
		Dependent_isNULL = false;
		return OK;
	}

	int getSpareStatus(unsigned short& value) const {
		if (SpareStatus_isNULL==true)
			return NOT_FOUND;
		value = SpareStatus;
		return OK;
	}
	
	int setSpareStatus(const unsigned short& newValue) {
		SpareStatus = newValue;
		SpareStatus_isNULL = false;
		return OK;
	}

	int getFailoverSupported(unsigned short& value) const {
		if (FailoverSupported_isNULL==true)
			return NOT_FOUND;
		value = FailoverSupported;
		return OK;
	}
	
	int setFailoverSupported(const unsigned short& newValue) {
		FailoverSupported = newValue;
		FailoverSupported_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_POWERSUPPLYISSPARE_H_*/
