/* ----------------------------------------------------------------- */
/*           The Japanese TTS System "Open JTalk"                    */
/*           developed by HTS Working Group                          */
/*           http://open-jtalk.sourceforge.net/                      */
/* ----------------------------------------------------------------- */
/*                                                                   */
/*  Copyright (c) 2008-2013  Nagoya Institute of Technology          */
/*                           Department of Computer Science          */
/*                                                                   */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/* - Redistributions of source code must retain the above copyright  */
/*   notice, this list of conditions and the following disclaimer.   */
/* - Redistributions in binary form must reproduce the above         */
/*   copyright notice, this list of conditions and the following     */
/*   disclaimer in the documentation and/or other materials provided */
/*   with the distribution.                                          */
/* - Neither the name of the HTS working group nor the names of its  */
/*   contributors may be used to endorse or promote products derived */
/*   from this software without specific prior written permission.   */
/*                                                                   */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            */
/* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       */
/* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          */
/* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS */
/* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          */
/* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,   */
/* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/* POSSIBILITY OF SUCH DAMAGE.                                       */
/* ----------------------------------------------------------------- */

#ifndef NJD_SET_DIGIT_RULE_H
#define NJD_SET_DIGIT_RULE_H

#ifdef __cplusplus
#define NJD_SET_DIGIT_RULE_H_START extern "C" {
#define NJD_SET_DIGIT_RULE_H_END   }
#else
#define NJD_SET_DIGIT_RULE_H_START
#define NJD_SET_DIGIT_RULE_H_END
#endif                          /* __CPLUSPLUS */

NJD_SET_DIGIT_RULE_H_START;

#define NJD_SET_DIGIT_KAZU "\x90\x94"
#define NJD_SET_DIGIT_SUUSETSUZOKU "\x90\x94\x90\xda\x91\xb1"
#define NJD_SET_DIGIT_JOSUUSHI "\x8f\x95\x90\x94\x8e\x8c"
#define NJD_SET_DIGIT_FUKUSHIKANOU "\x95\x9b\x8e\x8c\x89\xc2\x94\x5c"
#define NJD_SET_DIGIT_HAIHUN1 "\x81\x5c"
#define NJD_SET_DIGIT_HAIHUN2 "\x81\x7c"
#define NJD_SET_DIGIT_HAIHUN3 "\x81\x5d"
#define NJD_SET_DIGIT_KAKKO1 "\x81\x69"
#define NJD_SET_DIGIT_KAKKO2 "\x81\x6a"
#define NJD_SET_DIGIT_BANGOU "\x94\xd4\x8d\x86"
#define NJD_SET_DIGIT_TEN1 "\x81\x44"
#define NJD_SET_DIGIT_TEN2 "\x81\x45"
#define NJD_SET_DIGIT_TEN_FEATURE "\x81\x44,\x96\xbc\x8e\x8c,\x90\xda\x94\xf6,\x8f\x95\x90\x94\x8e\x8c,*,*,*,\x81\x44,\x83\x65\x83\x93,\x83\x65\x83\x93,0/2,*,-1"
#define NJD_SET_DIGIT_ZERO "\x81\x5a"
#define NJD_SET_DIGIT_ZERO_BEFORE_DP "\x83\x8c\x81\x5b"
#define NJD_SET_DIGIT_ZERO_AFTER_DP "\x83\x5b\x83\x8d"
#define NJD_SET_DIGIT_TWO "\x93\xf1"
#define NJD_SET_DIGIT_TWO_BEFORE_DP "\x83\x6a\x81\x5b"
#define NJD_SET_DIGIT_TWO_AFTER_DP "\x83\x6a\x81\x5b"
#define NJD_SET_DIGIT_FIVE "\x8c\xdc"
#define NJD_SET_DIGIT_FIVE_BEFORE_DP "\x83\x53\x81\x5b"
#define NJD_SET_DIGIT_FIVE_AFTER_DP "\x83\x53\x81\x5b"
#define NJD_SET_DIGIT_NIN "\x90\x6c"
#define NJD_SET_DIGIT_GATSU "\x8c\x8e"
#define NJD_SET_DIGIT_NICHI "\x93\xfa"
#define NJD_SET_DIGIT_NICHIKAN "\x93\xfa\x8a\xd4"
#define NJD_SET_DIGIT_ONE "\x88\xea"
#define NJD_SET_DIGIT_TSUITACHI "\x88\xea\x93\xfa,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x88\xea\x93\xfa,\x83\x63\x83\x43\x83\x5e\x83\x60,\x83\x63\x83\x43\x83\x5e\x83\x60,4/4,*"

static const char *njd_set_digit_rule_numeral_list1[] = {
   "\x81\x9b", "0", "\x81\x5a",
   "\x82\x50", "1", "\x88\xea",
   "\x82\x51", "2", "\x93\xf1",
   "\x82\x52", "3", "\x8e\x4f",
   "\x82\x53", "4", "\x8e\x6c",
   "\x82\x54", "5", "\x8c\xdc",
   "\x82\x55", "6", "\x98\x5a",
   "\x82\x56", "7", "\x8e\xb5",
   "\x82\x57", "8", "\x94\xaa",
   "\x82\x58", "9", "\x8b\xe3",
   "\x88\xea", "1", "\x88\xea",
   "\x93\xf1", "2", "\x93\xf1",
   "\x8e\x4f", "3", "\x8e\x4f",
   "\x8e\x6c", "4", "\x8e\x6c",
   "\x8c\xdc", "5", "\x8c\xdc",
   "\x98\x5a", "6", "\x98\x5a",
   "\x8e\xb5", "7", "\x8e\xb5",
   "\x94\xaa", "8", "\x94\xaa",
   "\x8b\xe3", "9", "\x8b\xe3",
   "\x82\xa2\x82\xbf", "1", "\x88\xea",
   "\x82\xc9", "2", "\x93\xf1",
   "\x82\xb3\x82\xf1", "3", "\x8e\x4f",
   "\x82\xe6\x82\xf1", "4", "\x8e\x6c",
   "\x82\xb2", "5", "\x8c\xdc",
   "\x82\xeb\x82\xad", "6", "\x98\x5a",
   "\x82\xc8\x82\xc8", "7", "\x8e\xb5",
   "\x82\xcd\x82\xbf", "8", "\x94\xaa",
   "\x82\xab\x82\xe3\x82\xa4", "9", "\x8b\xe3",
   "\x81\x5a", "0", "\x81\x5a",
   "\x82\x4f", "0", "\x81\x5a",
   "\x88\xeb", "1", "\x88\xea",
   "\x93\xf3", "2", "\x93\xf1",
   "\xe6\xc6", "2", "\x93\xf1",
   "\x83\x6a", "2", "\x93\xf1",
   "\x8e\x51", "3", "\x8e\x4f",
   "\x82\xb5", "4", "\x8e\x6c",
   "\x82\xb5\x82\xbf", "7", "\x8e\xb5",
   "\x82\xad", "9", "\x8b\xe3",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numeral_list2[] = {
   "",
   "\x8f\x5c,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x8f\x5c,\x83\x57\x83\x85\x83\x45,\x83\x57\x83\x85\x81\x5b,1/2,*",
   "\x95\x53,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x95\x53,\x83\x71\x83\x83\x83\x4e,\x83\x71\x83\x83\x83\x4e,2/2,*",
   "\x90\xe7,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x90\xe7,\x83\x5a\x83\x93,\x83\x5a\x83\x93,1/2,*",
   NULL
};

static const char *njd_set_digit_rule_numeral_list3[] = {
   "",
   "\x96\x9c,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x96\x9c,\x83\x7d\x83\x93,\x83\x7d\x83\x93,1/2,*",
   "\x89\xad,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x89\xad,\x83\x49\x83\x4e,\x83\x49\x83\x4e,1/2,*",
   "\x92\x9b,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x92\x9b,\x83\x60\x83\x87\x83\x45,\x83\x60\x83\x87\x81\x5b,1/2,C3",
   "\x8b\x9e,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x8b\x9e,\x83\x50\x83\x43,\x83\x50\x83\x43,1/2,*",
   "\x9a\xb4,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x9a\xb4,\x83\x4b\x83\x43,\x83\x4b\x83\x43,1/2,*",
   "\x89\xd1\x97\x5c,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x89\xd1\x97\x5c,\x83\x57\x83\x87,\x83\x57\x83\x87,1/1,*", /* No character in EUC-JP */
   "\x8f\xf5,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x8f\xf5,\x83\x57\x83\x87\x83\x45,\x83\x57\x83\x87\x83\x45,1/2,*",
   "\x8d\x61,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x8d\x61,\x83\x52\x83\x45,\x83\x52\x83\x45,1/2,*",
   "\x8a\xc0,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x8a\xc0,\x83\x4a\x83\x93,\x83\x4a\x83\x93,1/2,*",
   "\x90\xb3,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x90\xb3,\x83\x5a\x83\x43,\x83\x5a\x83\x43,1/2,*",
   "\x8d\xda,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x8d\xda,\x83\x54\x83\x43,\x83\x54\x83\x43,1/2,*",
   "\x8b\xc9,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x8b\xc9,\x83\x53\x83\x4e,\x83\x53\x83\x4e,1/2,*",
   "\x8d\x50\x89\xcd\x8d\xb9,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x8d\x50\x89\xcd\x8d\xb9,\x83\x53\x83\x45\x83\x4b\x83\x56\x83\x83,\x83\x53\x83\x45\x83\x4b\x83\x56\x83\x83,1/4,*",
   "\x88\xa2\x91\x6d\x8b\x5f,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x88\xa2\x91\x6d\x8b\x5f,\x83\x41\x83\x5c\x83\x45\x83\x4d,\x83\x41\x83\x5c\x83\x45\x83\x4d,2/4,*",
   "\x93\xdf\x97\x52\x91\xbc,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x93\xdf\x97\x52\x91\xbc,\x83\x69\x83\x86\x83\x5e,\x83\x69\x83\x86\x83\x5e,1/3,*",
   "\x95\x73\x89\xc2\x8e\x76\x8b\x63,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x95\x73\x89\xc2\x8e\x76\x8b\x63,\x83\x74\x83\x4a\x83\x56\x83\x4d,\x83\x74\x83\x4a\x83\x56\x83\x4d,2/4,*",
   "\x96\xb3\x97\xca\x91\xe5\x90\x94,\x96\xbc\x8e\x8c,\x90\x94,*,*,*,*,\x96\xb3\x97\xca\x91\xe5\x90\x94,\x83\x80\x83\x8a\x83\x87\x83\x45\x83\x5e\x83\x43\x83\x58\x83\x45,\x83\x80\x83\x8a\x83\x87\x81\x5b\x83\x5e\x83\x43\x83\x58\x83\x45,6/7,*",
   NULL
};

static const char *njd_set_digit_rule_numeral_list4[] = {
   "\x88\xea", "\x93\xf1", "\x8e\x4f", "\x8e\x6c", "\x8c\xdc", "\x98\x5a", "\x8e\xb5", "\x94\xaa", "\x8b\xe3", "\x89\xbd", "\x8a\xf4", "\x90\x94",
   NULL
};

static const char *njd_set_digit_rule_numeral_list5[] = {
   "\x8f\x5c", "\x95\x53", "\x90\xe7", "\x96\x9c", "\x89\xad", "\x92\x9b", "\x8b\x9e", "\x9a\xb4", "\x89\xd1\x97\x5c", "\x8f\xf5", "\x8d\x61", "\x8a\xc0", "\x90\xb3", "\x8d\xda", "\x8b\xc9",
   "\x8d\x50\x89\xcd\x8d\xb9", "\x88\xa2\x91\x6d\x8b\x5f", "\x93\xdf\x97\x52\x91\xbc", "\x95\x73\x89\xc2\x8e\x76\x8b\x63", "\x96\xb3\x97\xca\x91\xe5\x90\x94",
   NULL
};

static const char *njd_set_digit_rule_numeral_list6[] = {
   "\x95\x53", "\x90\xe7", NULL
};

static const char *njd_set_digit_rule_numeral_list7[] = {
   "\x8e\x4f", "1",
   "\x98\x5a", "2",
   "\x94\xaa", "2",
   "\x89\xbd", "1",
   NULL, NULL
};

static const char *njd_set_digit_rule_numeral_list8[] = {
   "\x95\x53", NULL
};

static const char *njd_set_digit_rule_numeral_list9[] = {
   "\x98\x5a", "\x83\x8d\x83\x62", "0", "2",
   "\x94\xaa", "\x83\x6e\x83\x62", "0", "2",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numeral_list10[] = {
   "\x90\xe7", "\x92\x9b", NULL
};

static const char *njd_set_digit_rule_numeral_list11[] = {
   "\x88\xea", "\x83\x43\x83\x62", "0", "2",
   "\x94\xaa", "\x83\x6e\x83\x62", "0", "2",
   "\x8f\x5c", "\x83\x57\x83\x85\x83\x62", "1", "2",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1b[] = {
   /* from paper */
   "\x94\x4e" /* \x82\xcb\x82\xf1 */ , "\x89\x7e",
   /* from dictionary */
   "\x94\x4e\x8a\xd4", "\x94\x4e\x90\xb6", "\x94\x4e\x91\xe3", "\x94\x4e\x93\x78", "\x94\x4e\x94\xc5", "\x94\x4e\x97\x5d", "\x94\x4e\x97\x5d", "\x94\x4e\x97\x88", "\x82\xa6\x82\xf1",
   NULL
};

static const char *njd_set_digit_rule_conv_table1b[] = {
   "\x8e\x6c", "\x83\x88", "0", "1",
   NULL, NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1c1[] = {
   /* from paper */
   "\x8e\x9e", "\x8e\x9e\x8a\xd4", "\x90\x6c",
   /* from dictionary */
   "\x8e\x9e\x8c\xc0", "\x8e\x9e\x94\xbc", "\x90\x6c\x8c\x8e", "\x90\x6c\x91\x4f", "\x90\x6c\x91\x67",
   NULL
};

static const char *njd_set_digit_rule_conv_table1c1[] = {
   "\x8e\x6c", "\x83\x88", "0", "1",
   "\x8e\xb5", "\x83\x56\x83\x60", "1", "2",
   NULL, NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1c2[] = {
   /* from paper */
   "\x8e\x9e", "\x8e\x9e\x8a\xd4",
   /* from dictionary */
   "\x8e\x9e\x8c\xc0", "\x8e\x9e\x94\xbc",
   NULL
};

static const char *njd_set_digit_rule_conv_table1c2[] = {
   "\x8b\xe3", "\x83\x4e", "0", "1",
   NULL, NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1d[] = {
   /* from paper */
   "\x93\xfa" /* \x82\xc9\x82\xbf */ ,
   /* from dictionary */
   "\x93\xfa\x8a\xd4",
   NULL
};

static const char *njd_set_digit_rule_conv_table1d[] = {
   /* "\x8e\x6c", "\x83\x88\x83\x62", "1", "2", *//* modified */
   "\x8e\xb5", "\x83\x56\x83\x60", "1", "2",
   "\x8b\xe3", "\x83\x4e", "0", "1",
   NULL, NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1e[] = {
   /* from paper */
   "\x8c\x8e" /* \x82\xaa\x82\xc2 */ ,
   NULL
};

static const char *njd_set_digit_rule_conv_table1e[] = {
   "\x8e\x6c", "\x83\x56", "0", "1",
   "\x8e\xb5", "\x83\x56\x83\x60", "1", "2",
   "\x8b\xe3", "\x83\x4e", "0", "1",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1f[] = {
   /* from paper */
   /* "\x89\x48", "\x94\x63", *//* modified */
   NULL
};

static const char *njd_set_digit_rule_conv_table1f[] = {
   "\x98\x5a", "\x83\x8d\x83\x62", "1", "2",
   "\x94\xaa", "\x83\x6e\x83\x62", "1", "2",
   "\x8f\x5c", "\x83\x57\x83\x85\x83\x62", "1", "2",
   "\x95\x53", "\x83\x71\x83\x83\x83\x62", "1", "2",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1g[] = {
   /* from paper */
   "\x8c\xc2", "\x8a\x4b", "\x95\xaa" /* \x82\xd3\x82\xf1 */ , "\x94\xad", "\x96\x7b", "\x94\xab", "\x8c\xfb", "\x90\xd8\x82\xea", "\x94\xa0",
   /* from dictionary */
   "\x82\xa9\x8c\x8e", "\x82\xa9\x8d\x91", "\x82\xa9\x8f\x8a", "\x82\xa9\x8f\xf0", "\x82\xa9\x91\xba", "\x82\xa9\x94\x4e", "\x83\x4a\x8c\x8e", "\x83\x4a\x8d\x91", "\x83\x4a\x8e\x9b", "\x83\x4a\x8f\x8a", "\x83\x4a\x8f\xf0", "\x83\x4a\x91\xba",
   "\x83\x4a\x93\x58", "\x83\x4a\x94\x4e", "\x83\x50\x8c\x8e", "\x83\x50\x8d\x91", "\x83\x50\x8f\x8a", "\x83\x50\x8f\xf0", "\x83\x50\x91\xba", "\x83\x50\x94\x4e", "\x83\x95\x8c\x8e", "\x83\x95\x8d\x91", "\x83\x95\x8f\x8a",
   "\x83\x95\x8f\xf0", "\x83\x95\x91\xba", "\x83\x95\x94\x4e", "\x83\x96\x8c\x8e", "\x83\x96\x8d\x91", "\x83\x96\x8f\x8a", "\x83\x96\x8f\xf0", "\x83\x96\x91\xba", "\x83\x96\x94\x4e", "\x8c\xc2\x8c\x8e", "\x8c\xc2\x8c\xfb",
   "\x8c\xc2\x8d\x91", "\x8c\xc2\x8f\xf0", "\x8c\xc2\x94\x4e", "\x89\xd3\x8c\x8e", "\x89\xd3\x8d\x91", "\x89\xd3\x8f\x8a", "\x89\xd3\x8f\xf0", "\x89\xd3\x94\x4e", "\x82\xa9\x82\xaf", "\x82\xad\x82\xbe\x82\xe8", "\x82\xaf\x82\xbd",
   "\x89\xbf", "\x89\xdb", "\x89\xe6", "\x89\xf1", "\x89\xf1\x8a\xf5", "\x89\xf1\x90\xb6", "\x89\xf1\x90\xed", "\x89\xf1\x90\xfc", "\x89\xf1\x95\xaa", "\x8a\x43\x97\xa2", "\x83\x4a\x83\x43\x83\x8a", "\x8a\x5c", "\x8a\x70",
   "\x8a\x94", "\x8a\xa5", "\x8a\xaa", "\x8a\xca", "\x8a\xd1", "\x8a\xd1\x96\xda", "\x8a\xd4", "\x8a\xee", "\x8a\xfa", "\x8a\xfa\x90\xb6", "\x8b\x40", "\x8b\x43\x88\xb3", "\x8b\x47", "\x8b\x52",
   "\x8b\x71", "\x8b\x72", "\x8b\x85", "\x8b\x89", "\x8b\xb4", "\x8b\xc7", "\x8b\xc8", "\x8b\xc9", "\x8f\x64\x82\xcb", "\x8b\xd2", "\x8b\xe0", "\x8b\xe5", "\x8b\xe6", "\x8b\xeb", "\x8c\x76",
   "\x8c\x85", "\x83\x50\x83\x5e", "\x8d\x5a", "\x8d\x60", "\x8d\x73", "\x8d\x80", "\x91\x67", "\x8c\x8f", "\x8c\xac", "\x8c\xbe", "\x8c\xcb", "\x8c\xce", "\x8c\xf5\x94\x4e", "\x90\xce",
   "\x82\xd2\x82\xab", "\x82\xd8\x82\xf1", "\x94\x67", "\x94\x68", "\x94\x73", "\x94\x74", "\x94\x8f", "\x94\x91", "\x94\xc5", "\x94\xc6", "\x94\xc7", "\x95\x43", "\x95\x43", "\x95\x4d", "\x95\x55",
   "\x95\x5b", "\x95\x69", "\x95\xaa\x8a\xd4", "\x95\xaa\x96\xda", "\x95\xd0", "\x95\xd0", "\x95\xd1", "\x95\xd2", "\x95\xd3", "\x95\xd5", "\x95\xe0", "\x95\xe0", "\x95\xf1", "\x95\xfb", "\x95\xfb",
   "\x96\x40", "\x96\x7b\x97\xa7\x82\xc4",
   NULL
};

static const char *njd_set_digit_rule_conv_table1g[] = {
   "\x88\xea", "\x83\x43\x83\x62", "1", "2",
   "\x98\x5a", "\x83\x8d\x83\x62", "1", "2",
   "\x94\xaa", "\x83\x6e\x83\x62", "1", "2",
   "\x8f\x5c", "\x83\x57\x83\x85\x83\x62", "1", "2",
   "\x95\x53", "\x83\x71\x83\x83\x83\x62", "1", "2",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1h[] = {
   /* from paper */
   "\x81\x44", "\x81\x45", "\x8d\xcb", "\x93\xaa", "\x92\x85", "\x91\xab", "\x8e\xda", "\x92\xd8", "\x92\xca\x82\xe8", "\x83\x5a\x83\x93\x83\x60", "\x83\x56\x81\x5b\x83\x56\x81\x5b",
   /* from dictionary */
   "\x82\x62\x82\x62", "\x82\x83\x82\x83", "\x82\x83\x82\x8d", "\x83\x54\x83\x43\x83\x4e\x83\x8b", "\x83\x54\x83\x93\x83\x60\x81\x5b\x83\x80", "\x83\x56\x81\x5b\x83\x59\x83\x93", "\x83\x56\x81\x5b\x83\x67", "\x83\x56\x83\x8a\x83\x93\x83\x4f",
   "\x83\x56\x83\x93\x83\x4b\x83\x7c\x81\x5b\x83\x8b\x83\x68\x83\x8b", "\x83\x58\x83\x43\x83\x58\x83\x74\x83\x89\x83\x93", "\x83\x58\x83\x45\x83\x46\x81\x5b\x83\x66\x83\x93\x83\x4e\x83\x8d\x81\x5b\x83\x6c", "\x83\x58\x83\x4e\x83\x8c", "\x83\x5a\x83\x62\x83\x67", "\x83\x5a\x83\x93\x83\x67",
   "\x83\x5c\x83\x8b", "\x83\x5d\x81\x5b\x83\x93", "\x91\x57", "\x91\x57", "\x8a\xc6", "\x8d\xb7", "\x8d\xb7\x82\xb5", "\x8d\xce", "\x8d\xce\x8e\x99", "\x8d\xec", "\x8d\xfb", "\x8d\xfc", "\x8e\x4d", "\x9e\xa8",
   "\xe4\x7a", "\x8e\x71", "\x8e\x8b", "\x8e\xae", "\x8e\xb8", "\x8e\xba", "\x8e\xcb", "\x8e\xd0", "\x8e\xd9", "\x8e\xed", "\x8e\xf1", "\x8e\xfc", "\x8e\xfc\x8a\xf5", "\x8e\xfc\x94\x4e", "\x8f\x42",
   "\x8f\x54", "\x8f\x54\x8a\xd4", "\x8f\x57", "\x8f\x68", "\x8f\x8a", "\x8f\x9f", "\x8f\xa1", "\x8f\xb0", "\x8f\xcd", "\x90\x46", "\x90\x46", "\x90\x48", "\x90\x65\x93\x99", "\x90\x69",
   "\x90\x69\x90\x94", "\x95\x69", "\x82\xb7\x82\xb6", "\x82\xbb\x82\xa4", "\x82\xbb\x82\xeb\x82\xa2", "\x8b\xd8", "\x90\x94", "\x90\xa1", "\x90\xa2", "\x90\xc7", "\x90\xc8", "\x90\xce", "\x90\xdf", "\x90\xed",
   "\x90\xfc", "\x91\x49", "\x91\x4b", "\x91\x77", "\x91\x8a", "\x91\xb5", "\x82\xbd\x82\xd1", "\x82\xc2\x82\xa9\x82\xdd", "\x82\xc2\x82\xaa\x82\xa2", "\x82\xc2\x82\xd4", "\x82\xc2\x82\xdc\x82\xdd", "\x82\xc2\x90\xdc",
   "\x82\xc2\x90\xdc\x82\xe8", "\x82\xc6\x82\xa8\x82\xe8", "\x82\xc6\x82\xab", "\x82\xc6\x82\xb1\x82\xeb", "\x82\xc6\x82\xb9", "\x8b\xca", "\x8c\x8e", "\x8e\xe8", "\x91\xa9", "\x91\xb1\x82\xab", "\x91\xcc", "\x91\xce",
   "\x91\xec", "\x92\x4d", "\x94\xbd", "\x92\x9a", "\x92\x9a\x96\xda", "\x92\xb9", "\x92\xca", "\x92\xcd\x82\xdd", "\x92\xf8", "\x93\x48", "\x93\x58", "\x93\x5d", "\x93\x5f", "\x93\x6c", "\x93\x8f",
   "\x93\x90", "\x93\x94", "\x93\x99", "\x93\x99\x90\xc8", "\x93\x99\x92\x6e", "\x93\x99\x95\xaa", "\x93\x9a", "\x93\xbe", "\x93\xd3", "\x97\xb1", "\x8e\xed\x97\xde", "\x8d\xce\x94\x6e", "\x90\xa2\x8b\x49",
   NULL
};

static const char *njd_set_digit_rule_conv_table1h[] = {
   "\x88\xea", "\x83\x43\x83\x62", "1", "2",
   "\x94\xaa", "\x83\x6e\x83\x62", "1", "2",
   "\x8f\x5c", "\x83\x57\x83\x85\x83\x62", "1", "2",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1i[] = {
   /* from paper */
   "\x83\x4c\x83\x8d", "\x83\x4a\x83\x8d\x83\x8a\x81\x5b",
   /* from dictionary */
   "\x82\x83\x82\x81\x82\x8c", "\x82\x8b\x82\x82", "\x82\x8b\x82\x87", "\x82\x8b\x82\x8c", "\x82\x8b\x82\x8d", "\x82\x8b\x82\x94", "\x82\x8b\x82\x97", "\x82\x8b\x83\x4f\x83\x89\x83\x80", "\x82\x8b\x83\x6f\x83\x43\x83\x67", "\x82\x8b\x83\x77\x83\x8b\x83\x63",
   "\x82\x8b\x83\x81\x81\x5b\x83\x67\x83\x8b", "\x82\x8b\x83\x8a\x83\x62\x83\x67\x83\x8b", "\x82\x8b\x83\x8f\x83\x62\x83\x67", "\x83\x4a\x83\x69\x83\x5f\x83\x68\x83\x8b", "\x83\x4a\x83\x89\x83\x62\x83\x67", "\x83\x4b\x83\x8d\x83\x93", "\x83\x4c\x83\x85\x83\x8a\x81\x5b",
   "\x83\x4c\x83\x8d\x83\x4a\x83\x8d\x83\x8a\x81\x5b", "\x83\x4c\x83\x8d\x83\x4f\x83\x89\x83\x80", "\x83\x4c\x83\x8d\x83\x67\x83\x93", "\x83\x4c\x83\x8d\x83\x6f\x83\x43\x83\x67", "\x83\x4c\x83\x8d\x83\x77\x83\x8b\x83\x63", "\x83\x4c\x83\x8d\x83\x81\x81\x5b\x83\x67\x83\x8b",
   "\x83\x4c\x83\x8d\x83\x8a\x83\x62\x83\x67\x83\x8b", "\x83\x4c\x83\x8d\x83\x8f\x83\x62\x83\x67", "\x83\x4c\x83\x8d\x83\x8f\x83\x62\x83\x67\x8e\x9e", "\x83\x4e\x83\x89\x83\x58", "\x83\x4e\x83\x8d\x81\x5b\x83\x69", "\x83\x4e\x83\x8d\x81\x5b\x83\x6c", "\x83\x4f\x83\x40\x83\x89\x83\x6a",
   "\x83\x50\x81\x5b\x83\x58", "\x83\x52\x81\x5b\x83\x58", "\x8b\xcc",
   NULL
};

static const char *njd_set_digit_rule_conv_table1i[] = {
   "\x98\x5a", "\x83\x8d\x83\x62", "1", "2",
   "\x8f\x5c", "\x83\x57\x83\x85\x83\x62", "1", "2",
   "\x95\x53", "\x83\x71\x83\x83\x83\x62", "1", "2",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1j[] = {
   /* from paper */
   "\x83\x67\x83\x93",
   /* from dictionary */
   "\x82\x94", "\x83\x5e\x83\x8b", "\x83\x65\x83\x89", "\x83\x67\x83\x89\x83\x43",
   NULL
};

static const char *njd_set_digit_rule_conv_table1j[] = {
   "\x88\xea", "\x83\x43\x83\x62", "1", "2",
   "\x8f\x5c", "\x83\x57\x83\x85\x83\x62", "1", "2",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class1k[] = {
   /* from paper */
   "\x96\x5b" /* \x82\xd3\x82\xb3 */ , "\x92\x8c", "\x81\x93", "\x83\x7c\x83\x93\x83\x68",
   /* from dictionary */
   "\x82\x90\x82\x81", "\x82\x90\x82\x90\x82\x8d", "\x83\x70\x81\x5b\x83\x5a\x83\x93\x83\x67", "\x83\x70\x81\x5b\x83\x7e\x83\x8b", "\x83\x70\x83\x58\x83\x4a\x83\x8b", "\x83\x70\x83\x62\x83\x4e", "\x83\x70\x83\x62\x83\x67", "\x83\x73\x81\x5b\x83\x73\x81\x5b\x83\x47\x83\x80",
   "\x83\x73\x83\x52", "\x83\x79\x81\x5b\x83\x57", "\x95\xc5", "\x83\x79\x83\x41", "\x83\x79\x83\x5a\x83\x5e", "\x83\x79\x83\x5c", "\x83\x79\x83\x6a\x81\x5b", "\x83\x79\x83\x6a\x83\x71", "\x83\x79\x83\x93\x83\x58", "\x83\x7c\x83\x43\x83\x93\x83\x67",
   "\x90\x55\x82\xe8", "\x90\x6a", "\x91\xdc", "\x92\xa3\x82\xe8", "\x95\xbd\x95\xc4", "\x95\xbd\x95\xfb\x83\x4c\x83\x8d", "\x95\xbd\x95\xfb\x83\x4c\x83\x8d\x83\x81\x81\x5b\x83\x67\x83\x8b", "\x95\xbd\x95\xfb\x83\x5a\x83\x93\x83\x60\x83\x81\x81\x5b\x83\x67\x83\x8b",
   "\x95\xbd\x95\xfb\x83\x81\x81\x5b\x83\x67\x83\x8b",
   NULL
};

static const char *njd_set_digit_rule_conv_table1k[] = {
   "\x8f\x5c", "\x83\x57\x83\x85\x83\x62", "1", "2",
   NULL, NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class2b[] = {
   /* from paper */
   "\x95\xaa", "\x94\xc5", "\x94\x73", "\x94\xad", "\x94\x8f", "\x94\xab",
   /* from dictionary */
   "\x94\x67", "\x94\x68", "\x94\x91", "\x94\xc6", "\x94\xc7", "\x95\x69", "\x95\xaa\x8a\xd4", "\x95\xaa\x96\xda", "\x95\xd0", "\x95\xd1", "\x95\xd2", "\x95\xd3", "\x95\xd5", "\x95\xe0", "\x95\xf1",
   "\x95\xfb",
   NULL
};

static const char *njd_set_digit_rule_conv_table2b[] = {
   "\x88\xea", "2",
   "\x8e\x4f", "2",
   "\x8e\x6c", "2",
   "\x98\x5a", "2",
   "\x94\xaa", "2",
   "\x8f\x5c", "2",
   "\x95\x53", "2",
   "\x90\xe7", "2",
   "\x96\x9c", "2",
   "\x89\xbd", "2",
   NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class2c[] = {
   /* from paper */
   "\x96\x7b", "\x95\x43", "\x95\x5b", "\x95\x55", "\x94\xa0",
   /* from dictionary */
   "\x96\x7b\x97\xa7\x82\xc4", "\x94\x74", "\x90\x6a", "\x92\x8c",
   NULL
};

static const char *njd_set_digit_rule_conv_table2c[] = {
   "\x88\xea", "2",
   "\x8e\x4f", "1",
   "\x98\x5a", "2",
   "\x94\xaa", "2",
   "\x8f\x5c", "2",
   "\x95\x53", "2",
   "\x90\xe7", "1",
   "\x96\x9c", "1",
   "\x89\xbd", "1",
   NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class2d[] = {
/* from paper */
   /* "\x89\x48", "\x94\x63", *//* modified */
   NULL
};

static const char *njd_set_digit_rule_conv_table2d[] = {
   "\x8e\x4f", "1",
   "\x98\x5a", "2",
   "\x94\xaa", "2",
   "\x8f\x5c", "2",
   "\x95\x53", "2",
   "\x90\xe7", "1",
   "\x96\x9c", "1",
   "\x89\xbd", "1",
   NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class2e[] = {
   /* from paper */
   "\x8c\xac", "\x90\xce", "\x91\xab", "\x8e\xda",
   /* from dictionary */
   "\x82\xa9\x82\xaf", "\x8f\x64\x82\xcb", "\x8c\x8f", "\x8e\xd9",
   NULL
};

static const char *njd_set_digit_rule_conv_table2e[] = {
   "\x8e\x4f", "1",
   "\x90\xe7", "1",
   "\x96\x9c", "1",
   NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class2f[] = {
   /* from paper */
   "\x8a\x4b",
   NULL
};

static const char *njd_set_digit_rule_conv_table2f[] = {
   "\x8e\x4f", "1",
   NULL, NULL
};

static const char *njd_set_digit_rule_voiced_sound_symbol_list[] = {
   "\x83\x4a", "\x83\x4b",
   "\x83\x4c", "\x83\x4d",
   "\x83\x4e", "\x83\x4f",
   "\x83\x50", "\x83\x51",
   "\x83\x52", "\x83\x53",
   "\x83\x54", "\x83\x55",
   "\x83\x56", "\x83\x57",
   "\x83\x58", "\x83\x59",
   "\x83\x5a", "\x83\x5b",
   "\x83\x5c", "\x83\x5d",
   "\x83\x5e", "\x83\x5f",
   "\x83\x60", "\x83\x61",
   "\x83\x63", "\x83\x64",
   "\x83\x65", "\x83\x66",
   "\x83\x67", "\x83\x68",
   "\x83\x6e", "\x83\x6f",
   "\x83\x71", "\x83\x72",
   "\x83\x74", "\x83\x75",
   "\x83\x77", "\x83\x78",
   "\x83\x7a", "\x83\x7b",
   NULL, NULL
};

static const char *njd_set_digit_rule_semivoiced_sound_symbol_list[] = {
   "\x83\x6e", "\x83\x70",
   "\x83\x71", "\x83\x73",
   "\x83\x74", "\x83\x76",
   "\x83\x77", "\x83\x79",
   "\x83\x7a", "\x83\x7c",
   NULL, NULL
};

static const char *njd_set_digit_rule_numerative_class3[] = {
   /* from paper */
   "\x93\x8f", "\x83\x80\x83\x6c",
   /* from dictionary */
   "\x82\xa9\x82\xaf", "\x83\x4a\x83\x50",
   "\x82\xad\x82\xbe\x82\xe8", "\x83\x4e\x83\x5f\x83\x8a",
   "\x82\xaf\x82\xbd", "\x83\x50\x83\x5e",
   "\x82\xb7\x82\xb6", "\x83\x58\x83\x57",
   "\x82\xbb\x82\xeb\x82\xa2", "\x83\x5c\x83\x8d\x83\x43",
   "\x82\xbd\x82\xd1", "\x83\x5e\x83\x72",
   "\x82\xc2\x82\xa9\x82\xdd", "\x83\x63\x83\x4a\x83\x7e",
   "\x82\xc2\x82\xaa\x82\xa2", "\x83\x63\x83\x4b\x83\x43",
   "\x82\xc2\x82\xdc\x82\xdd", "\x83\x63\x83\x7d\x83\x7e",
   "\x82\xc6\x82\xa8\x82\xe8", "\x83\x67\x83\x49\x83\x8a",
   "\x82\xc6\x82\xb1\x82\xeb", "\x83\x67\x83\x52\x83\x8d",
   "\x82\xc6\x82\xb9", "\x83\x67\x83\x5a",
   "\x82\xdc\x82\xed\x82\xe8", "\x83\x7d\x83\x8f\x83\x8a",
   "\x83\x56\x81\x5b\x83\x59\x83\x93", "\x83\x56\x81\x5b\x83\x59\x83\x93",
   "\x83\x5a\x83\x62\x83\x67", "\x83\x5a\x83\x62\x83\x67",
   "\x88\xac\x82\xe8", "\x83\x6a\x83\x4d\x83\x8a",
   "\x89\xf1\x82\xe8", "\x83\x7d\x83\x8f\x83\x8a",
   "\x8a\x94", "\x83\x4a\x83\x75",
   "\x8a\xc6", "\x83\x54\x83\x49",
   "\x8b\xd8", "\x83\x58\x83\x57",
   "\x8c\x85", "\x83\x50\x83\x5e",
   "\x83\x50\x83\x5e", "\x83\x50\x83\x5e",
   "\x8c\x8e", "\x83\x63\x83\x4c",
   "\x8c\xbe", "\x83\x52\x83\x67",
   "\x8c\xfb", "\x83\x4e\x83\x60",
   "\x8d\xb7\x82\xb5", "\x83\x54\x83\x56",
   "\x8e\x4d", "\x83\x54\x83\x89",
   "\x8e\x52", "\x83\x84\x83\x7d",
   "\x8e\xd9", "\x83\x56\x83\x83\x83\x4e",
   "\x8e\xda", "\x83\x56\x83\x83\x83\x4e",
   "\x8f\x64\x82\xcb", "\x83\x4a\x83\x54\x83\x6c",
   "\x90\x55\x82\xe8", "\x83\x74\x83\x8a",
   "\x90\x6a", "\x83\x6e\x83\x8a",
   "\x90\xd8\x82\xea", "\x83\x4c\x83\x8c",
   "\x91\xa9", "\x83\x5e\x83\x6f",
   "\x91\xb1\x82\xab", "\x83\x63\x83\x64\x83\x4c",
   "\x91\xb5", "\x83\x5c\x83\x8d\x83\x43",
   "\x91\xdc", "\x83\x74\x83\x4e\x83\x8d",
   "\x92\x8c", "\x83\x6e\x83\x56\x83\x89",
   "\x92\xa3\x82\xe8", "\x83\x6e\x83\x8a",
   "\x92\xca\x82\xe8", "\x83\x67\x83\x49\x83\x8a",
   "\x92\xcd\x82\xdd", "\x83\x63\x83\x4a\x83\x7e",
   "\x92\xd8", "\x83\x63\x83\x7b",
   "\x94\xa0", "\x83\x6e\x83\x52",
   "\x94\xab", "\x83\x6e\x83\x60",
   "\x94\xd3", "\x83\x6f\x83\x93",
   "\x95\x69", "\x83\x56\x83\x69",
   "\x95\x72", "\x83\x72\x83\x93",
   "\x95\xaa\x82\xaf", "\x83\x8f\x83\x50",
   "\x96\x8b", "\x83\x7d\x83\x4e",
   "\x96\xe9", "\x83\x84",
   "\x96\xe9", "\x83\x88",
   "\x97\xb1", "\x83\x63\x83\x75",
   "\x98\x67", "\x83\x8f\x83\x4e",
   "\x9e\xa8", "\x83\x54\x83\x49",
   "\x82\xc2\x90\xdc", "\x83\x63\x83\x49\x83\x8a",
   "\x82\xc2\x90\xdc\x82\xe8", "\x83\x63\x83\x49\x83\x8a",
   "\x97\xb1", "\x83\x63\x83\x75",
   "\x82\xc2\x82\xd4", "\x83\x63\x83\x75",
   "\x82\xc6\x82\xab", "\x83\x67\x83\x4c",
   "\x8f\x64\x82\xcb", "\x83\x4b\x83\x54\x83\x6c",
   NULL, NULL
};

static const char *njd_set_digit_rule_conv_table3[] = {
   "\x88\xea", "\x83\x71\x83\x67", "0", "2",
   "\x93\xf1", "\x83\x74\x83\x5e", "0", "2",
   /* "\x8e\x4f", "\x83\x7e", "1", "1", *//* modified */
   NULL, NULL, NULL, NULL
};

static const char *njd_set_digit_rule_conv_table4[] = {
   "\x88\xea", "\x88\xea\x90\x6c,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x88\xea\x90\x6c,\x83\x71\x83\x67\x83\x8a,\x83\x71\x83\x67\x83\x8a,2/3,*",
   "\x93\xf1", "\x93\xf1\x90\x6c,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x93\xf1\x90\x6c,\x83\x74\x83\x5e\x83\x8a,\x83\x74\x83\x5e\x83\x8a,3/3,*",
   NULL, NULL
};

static const char *njd_set_digit_rule_conv_table5[] = {
   "\x88\xea", "\x88\xea\x93\xfa,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x88\xea\x93\xfa,\x83\x43\x83\x60\x83\x6a\x83\x60,\x83\x43\x83\x60\x83\x6a\x83\x60,4/4,*",
   "\x93\xf1", "\x93\xf1\x93\xfa,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x93\xf1\x93\xfa,\x83\x74\x83\x63\x83\x4a,\x83\x74\x83\x63\x83\x4a,3/3,*",
   "\x8e\x4f", "\x8e\x4f\x93\xfa,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x8e\x4f\x93\xfa,\x83\x7e\x83\x62\x83\x4a,\x83\x7e\x83\x62\x83\x4a,3/3,*",
   "\x8e\x6c", "\x8e\x6c\x93\xfa,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x8e\x6c\x93\xfa,\x83\x88\x83\x62\x83\x4a,\x83\x88\x83\x62\x83\x4a,3/3,*",
   "\x8c\xdc", "\x8c\xdc\x93\xfa,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x8c\xdc\x93\xfa,\x83\x43\x83\x63\x83\x4a,\x83\x43\x83\x63\x83\x4a,3/3,*",
   "\x98\x5a", "\x98\x5a\x93\xfa,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x98\x5a\x93\xfa,\x83\x80\x83\x43\x83\x4a,\x83\x80\x83\x43\x83\x4a,3/3,*",
   "\x8e\xb5", "\x8e\xb5\x93\xfa,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x8e\xb5\x93\xfa,\x83\x69\x83\x6d\x83\x4a,\x83\x69\x83\x6d\x83\x4a,3/3,*",
   "\x94\xaa", "\x94\xaa\x93\xfa,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x94\xaa\x93\xfa,\x83\x88\x83\x45\x83\x4a,\x83\x88\x83\x45\x83\x4a,3/3,*",
   "\x8b\xe3", "\x8b\xe3\x93\xfa,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x8b\xe3\x93\xfa,\x83\x52\x83\x52\x83\x6d\x83\x4a,\x83\x52\x83\x52\x83\x6d\x83\x4a,4/4,*",
   "\x8f\x5c", "\x8f\x5c\x93\xfa,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x8f\x5c\x93\xfa,\x83\x67\x83\x45\x83\x4a,\x83\x67\x81\x5b\x83\x4a,3/3,*",
   NULL, NULL
};
static const char *njd_set_digit_rule_conv_table6[] = {
   "\x88\xea", "\x88\xea\x93\xfa\x8a\xd4,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x88\xea\x93\xfa\x8a\xd4,\x83\x43\x83\x60\x83\x6a\x83\x60\x83\x4a\x83\x93,\x83\x43\x83\x60\x83\x6a\x83\x60\x83\x4a\x83\x93,4/6,*",
   "\x93\xf1", "\x93\xf1\x93\xfa\x8a\xd4,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x93\xf1\x93\xfa,\x83\x74\x83\x63\x83\x4a\x83\x4a\x83\x93,\x83\x74\x83\x63\x83\x4a\x83\x4a\x83\x93,3/5,*",
   "\x8e\x4f", "\x8e\x4f\x93\xfa\x8a\xd4,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x8e\x4f\x93\xfa,\x83\x7e\x83\x62\x83\x4a\x83\x4a\x83\x93,\x83\x7e\x83\x62\x83\x4a\x83\x4a\x83\x93,3/5,*",
   "\x8e\x6c", "\x8e\x6c\x93\xfa\x8a\xd4,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x8e\x6c\x93\xfa,\x83\x88\x83\x62\x83\x4a\x83\x4a\x83\x93,\x83\x88\x83\x62\x83\x4a\x83\x4a\x83\x93,3/5,*",
   "\x8c\xdc", "\x8c\xdc\x93\xfa\x8a\xd4,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x8c\xdc\x93\xfa,\x83\x43\x83\x63\x83\x4a\x83\x4a\x83\x93,\x83\x43\x83\x63\x83\x4a\x83\x4a\x83\x93,3/5,*",
   "\x98\x5a", "\x98\x5a\x93\xfa\x8a\xd4,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x98\x5a\x93\xfa,\x83\x80\x83\x43\x83\x4a\x83\x4a\x83\x93,\x83\x80\x83\x43\x83\x4a\x83\x4a\x83\x93,3/5,*",
   "\x8e\xb5", "\x8e\xb5\x93\xfa\x8a\xd4,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x8e\xb5\x93\xfa,\x83\x69\x83\x6d\x83\x4a\x83\x4a\x83\x93,\x83\x69\x83\x6d\x83\x4a\x83\x4a\x83\x93,3/5,*",
   "\x94\xaa", "\x94\xaa\x93\xfa\x8a\xd4,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x94\xaa\x93\xfa,\x83\x88\x83\x45\x83\x4a\x83\x4a\x83\x93,\x83\x88\x83\x45\x83\x4a\x83\x4a\x83\x93,3/5,*",
   "\x8b\xe3", "\x8b\xe3\x93\xfa\x8a\xd4,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x8b\xe3\x93\xfa,\x83\x52\x83\x52\x83\x6d\x83\x4a\x83\x4a\x83\x93,\x83\x52\x83\x52\x83\x6d\x83\x4a\x83\x4a\x83\x93,4/6,*",
   "\x8f\x5c", "\x8f\x5c\x93\xfa\x8a\xd4,\x96\xbc\x8e\x8c,\x95\x9b\x8e\x8c\x89\xc2\x94\x5c,*,*,*,*,\x8f\x5c\x93\xfa,\x83\x67\x83\x45\x83\x4a\x83\x4a\x83\x93,\x83\x67\x81\x5b\x83\x4a\x83\x4a\x83\x93,3/5,*",
   NULL, NULL
};

NJD_SET_DIGIT_RULE_H_END;

#endif                          /* !NJD_SET_DIGIT_RULE_H */
