// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom2d_TrimmedCurve_HeaderFile
#define _Geom2d_TrimmedCurve_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Geom2d_TrimmedCurve_HeaderFile
#include <Handle_Geom2d_TrimmedCurve.hxx>
#endif

#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Geom2d_BoundedCurve_HeaderFile
#include <Geom2d_BoundedCurve.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Geom2d_Geometry_HeaderFile
#include <Handle_Geom2d_Geometry.hxx>
#endif
class Geom2d_Curve;
class Standard_ConstructionError;
class Standard_RangeError;
class Standard_NoSuchObject;
class Geom2d_UndefinedDerivative;
class Geom2d_UndefinedValue;
class gp_Pnt2d;
class gp_Vec2d;
class gp_Trsf2d;
class Geom2d_Geometry;



//!  Defines a portion of a curve limited by two values of <br>
//!  parameters inside the parametric domain of the curve. <br>
//! The trimmed curve is defined by: <br>
//! - the basis curve, and <br>
//! - the two parameter values which limit it. <br>
//!  The trimmed curve can either have the same <br>
//! orientation as the basis curve or the opposite orientation. <br>
class Geom2d_TrimmedCurve : public Geom2d_BoundedCurve {

public:

  
//!  Creates a trimmed curve from the basis curve C limited between <br>
//!  U1 and U2. <br>
//! <br>
//!  . U1 can be greater or lower than U2. <br>
//!  . The returned curve is oriented from U1 to U2. <br>
//!  . If the basis curve C is periodic there is an ambiguity <br>
//!    because two parts are available. In this case by default <br>
//!    the trimmed curve has the same orientation as the basis <br>
//!    curve (Sense = True). If Sense = False then the orientation <br>
//!    of the trimmed curve is opposite to the orientation of the <br>
//!    basis curve C. <br>
//!  If the curve is closed but not periodic it is not possible <br>
//!    to keep the part of the curve including the junction point <br>
//!    (except if the junction point is at the beginning or <br>
//!    at the end of the trimmed curve) because you could lose the <br>
//!    fundamental characteristics of the basis curve which are <br>
//!    used for example to compute the derivatives of the trimmed <br>
//!    curve. So for a closed curve the rules are the same as for <br>
//!    a open curve. <br>
//! Warnings : <br>
//!  In this package the entities are not shared. The TrimmedCurve is <br>
//!  built with a copy of the curve C. So when C is modified the <br>
//!  TrimmedCurve is not modified <br>
//!  Warnings : <br>
//! If <C> is periodic, parametrics bounds of the TrimmedCurve, <br>
//! can be different to [<U1>;<U2>}, if <U1> or <U2> are not in the <br>
//! principal period. <br>
//! Include : <br>
//!  For more explanation see the scheme given with this class. <br>
//!    Raises ConstructionError the C is not periodic and U1 or U2 are out of <br>
//!  the bounds of C. <br>
//!  Raised if U1 = U2. <br>
  Standard_EXPORT   Geom2d_TrimmedCurve(const Handle(Geom2d_Curve)& C,const Standard_Real U1,const Standard_Real U2,const Standard_Boolean Sense = Standard_True);
  
//!  Changes the direction of parametrization of <me>. The first and <br>
//!  the last parametric values are modified. The "StartPoint" <br>
//!  of the initial curve becomes the "EndPoint" of the reversed <br>
//!  curve and the "EndPoint" of the initial curve becomes the <br>
//!  "StartPoint" of the reversed curve. <br>
//! Example  -   If the trimmed curve is defined by: <br>
//! - a basis curve whose parameter range is [ 0.,1. ], and <br>
//! - the two trim values U1 (first parameter) and U2 (last parameter), <br>
//!   the reversed trimmed curve is defined by: <br>
//! - the reversed basis curve, whose parameter range is still [ 0.,1. ], and <br>
//! - the two trim values 1. - U2 (first parameter) <br>
//!   and 1. - U1 (last parameter). <br>
  Standard_EXPORT     void Reverse() ;
  //! Returns the  parameter on the  reversed  curve for <br>
//!          the point of parameter U on <me>. <br>
//! <br>
//!          returns UFirst + ULast - U <br>
  Standard_EXPORT     Standard_Real ReversedParameter(const Standard_Real U) const;
  //! Changes this trimmed curve, by redefining the <br>
//! parameter values U1 and U2, which limit its basis curve. <br>
//! Note: If the basis curve is periodic, the trimmed curve <br>
//! has the same orientation as the basis curve if Sense <br>
//! is true (default value) or the opposite orientation if Sense is false. <br>
//! Warning <br>
//! If the basis curve is periodic, the bounds of the <br>
//! trimmed curve may be different from U1 and U2 if the <br>
//! parametric origin of the basis curve is within the arc <br>
//! of the trimmed curve. In this case, the modified <br>
//! parameter will be equal to U1 or U2 plus or minus the period. <br>
//! Exceptions <br>
//! Standard_ConstructionError if: <br>
//! - the basis curve is not periodic, and either U1 or U2 <br>
//!   are outside the bounds of the basis curve, or <br>
//! - U1 is equal to U2. <br>
  Standard_EXPORT     void SetTrim(const Standard_Real U1,const Standard_Real U2,const Standard_Boolean Sense = Standard_True) ;
  //! Returns the basis curve. <br>
//! Warning <br>
//! This function does not return a constant reference. <br>
//! Consequently, any modification of the returned value <br>
//! directly modifies the trimmed curve. <br>
  Standard_EXPORT     Handle_Geom2d_Curve BasisCurve() const;
  
//!  Returns the global continuity of the basis curve of this trimmed curve. <br>
//! C0 : only geometric continuity, <br>
//! C1 : continuity of the first derivative all along the Curve, <br>
//! C2 : continuity of the second derivative all along the Curve, <br>
//! C3 : continuity of the third derivative all along the Curve, <br>
//! CN : the order of continuity is infinite. <br>
  Standard_EXPORT     GeomAbs_Shape Continuity() const;
  //!--- Purpose <br>
//!  Returns True if the order of continuity of the <br>
//!  trimmed curve is N. A trimmed curve is at least "C0" continuous. <br>
//!  Warnings : <br>
//!  The continuity of the trimmed curve can be greater than <br>
//!  the continuity of the basis curve because you consider <br>
//!  only a part of the basis curve. <br>//!  Raised if N < 0. <br>
  Standard_EXPORT     Standard_Boolean IsCN(const Standard_Integer N) const;
  
//!  Returns the end point of <me>. This point is the <br>
//!  evaluation of the curve for the "LastParameter". <br>
  Standard_EXPORT     gp_Pnt2d EndPoint() const;
  
//!  Returns the value of the first parameter of <me>. <br>
//!  The first parameter is the parameter of the "StartPoint" <br>
//!  of the trimmed curve. <br>
  Standard_EXPORT     Standard_Real FirstParameter() const;
  
//!  Returns True if the distance between the StartPoint and <br>
//!  the EndPoint is lower or equal to Resolution from package <br>
//!  gp. <br>
  Standard_EXPORT     Standard_Boolean IsClosed() const;
  //! Returns true if the basis curve of this trimmed curve is periodic. <br>
  Standard_EXPORT     Standard_Boolean IsPeriodic() const;
  //! Returns the period of the basis curve of this trimmed curve. <br>
//! Exceptions <br>
//! Standard_NoSuchObject if the basis curve is not periodic. <br>
  Standard_EXPORT   virtual  Standard_Real Period() const;
  
//!  Returns the value of the last parameter of <me>. <br>
//!  The last parameter is the parameter of the "EndPoint" of the <br>
//!  trimmed curve. <br>
  Standard_EXPORT     Standard_Real LastParameter() const;
  
//!  Returns the start point of <me>. <br>
//!  This point is the evaluation of the curve from the <br>
//!  "FirstParameter". <br>//! value and derivatives <br>
//! Warnings : <br>
//!  The returned derivatives have the same orientation as the <br>
//!  derivatives of the basis curve. <br>
  Standard_EXPORT     gp_Pnt2d StartPoint() const;
  
//!  If the basis curve is an OffsetCurve sometimes it is not <br>
//!  possible to do the evaluation of the curve at the parameter <br>
//!  U (see class OffsetCurve). <br>
  Standard_EXPORT     void D0(const Standard_Real U,gp_Pnt2d& P) const;
  //! Raised if the continuity of the curve is not C1. <br>
  Standard_EXPORT     void D1(const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1) const;
  //! Raised if the continuity of the curve is not C2. <br>
  Standard_EXPORT     void D2(const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1,gp_Vec2d& V2) const;
  //! Raised if the continuity of the curve is not C3. <br>
  Standard_EXPORT     void D3(const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1,gp_Vec2d& V2,gp_Vec2d& V3) const;
  //! For the point of parameter U of this trimmed curve, <br>
//! computes the vector corresponding to the Nth derivative. <br>
//! Warning <br>
//! The returned derivative vector has the same <br>
//! orientation as the derivative vector of the basis curve, <br>
//! even if the trimmed curve does not have the same <br>
//! orientation as the basis curve. <br>
//! Exceptions <br>
//! Standard_RangeError if N is less than 1. <br>//! geometric transformations <br>
  Standard_EXPORT     gp_Vec2d DN(const Standard_Real U,const Standard_Integer N) const;
  //! Applies the transformation T to this trimmed curve. <br>
//! Warning The basis curve is also modified. <br>
  Standard_EXPORT     void Transform(const gp_Trsf2d& T) ;
  //! Returns the  parameter on the  transformed  curve for <br>
//!          the transform of the point of parameter U on <me>. <br>
//! <br>
//!          me->Transformed(T)->Value(me->TransformedParameter(U,T)) <br>
//! <br>
//!          is the same point as <br>
//! <br>
//!          me->Value(U).Transformed(T) <br>
//! <br>
//!          This methods calls the basis curve method. <br>
  Standard_EXPORT   virtual  Standard_Real TransformedParameter(const Standard_Real U,const gp_Trsf2d& T) const;
  //! Returns a  coefficient to compute the parameter on <br>
//!          the transformed  curve  for  the transform  of the <br>
//!          point on <me>. <br>
//! <br>
//!          Transformed(T)->Value(U * ParametricTransformation(T)) <br>
//! <br>
//!          is the same point as <br>
//! <br>
//!          Value(U).Transformed(T) <br>
//! <br>
//!          This methods calls the basis curve method. <br>
  Standard_EXPORT   virtual  Standard_Real ParametricTransformation(const gp_Trsf2d& T) const;
  
//! Creates a new object, which is a copy of this trimmed curve. <br>
  Standard_EXPORT     Handle_Geom2d_Geometry Copy() const;




  DEFINE_STANDARD_RTTI(Geom2d_TrimmedCurve)

protected:




private: 


Handle_Geom2d_Curve basisCurve;
Standard_Real uTrim1;
Standard_Real uTrim2;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
