/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.notification.ris;

import com.sourceforge.knecs.dsm.resourceobject.Bookmarks;
import com.sourceforge.knecs.dsm.resourceobject.IBookmarkService;
import com.sourceforge.knecs.dsm.resourceobject.RISException;
import com.sourceforge.knecs.notification.ris.JMSRISService;
import com.sourceforge.knecs.util.CMCSProperties;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class JMSRISBookmarkService
extends JMSRISService
implements IBookmarkService {
    private static String CLASSNAME = "com.sourceforge.knecs.dsm.resourceobject.Bookmarks";
    private static Vector mClassNames = new Vector();

    public JMSRISBookmarkService(String serviceURL) {
        super(serviceURL, mClassNames);
    }

    public synchronized Vector getURLFilters() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String svr = props.getProperty("samserver");
        String path = props.getProperty("portalobjects");
        String bookmarks = props.getProperty("bookmarks");
        Vector<String> ret = new Vector<String>();
        ret.add("%" + path + "/" + bookmarks + "%");
        return ret;
    }

    public Bookmarks[] getBookmarks() throws IOException {
        Collection objects = this.getAllResourceObjects(CLASSNAME);
        Iterator it = objects.iterator();
        Bookmarks[] ret = new Bookmarks[objects.size()];
        int idx = 0;
        while (it.hasNext()) {
            ret[idx++] = (Bookmarks)it.next();
        }
        return ret;
    }

    public Bookmarks[] getBookmarks(String owner) throws IOException {
        Collection objects = this.getResourceObjectsByOwner(owner, CLASSNAME);
        Iterator it = objects.iterator();
        Bookmarks[] ret = new Bookmarks[objects.size()];
        int idx = 0;
        while (it.hasNext()) {
            ret[idx++] = (Bookmarks)it.next();
        }
        return ret;
    }

    public int removeBookmarks(String owner) throws IOException {
        return this.removeResourceObjectsByOwner(owner, CLASSNAME);
    }

    public Bookmarks getBookmark(String id) throws IOException {
        return (Bookmarks)this.getResourceObjectById(id, CLASSNAME);
    }

    public void addBookmark(Bookmarks data) throws IOException {
        try {
            this.save(data);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to save Bookmark " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
    }

    public boolean deleteBookmark(Bookmarks data) throws IOException {
        try {
            this.remove(data);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to remove Bookmark " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
        return true;
    }

    static {
        mClassNames.add(CLASSNAME);
    }
}

