/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.torque.engine.database.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.turbine.torque.engine.database.model.Table;
import org.xml.sax.Attributes;

public class Index {
    private String indexName;
    private Table parentTable;
    private List indexColumns = new ArrayList(3);
    private boolean isUnique;

    public void loadFromXML(Attributes attrib) {
        this.indexName = attrib.getValue("name");
        String unique = attrib.getValue("unique");
        this.isUnique = unique != null && unique.equalsIgnoreCase("true");
    }

    public boolean getIsUnique() {
        return this.isUnique;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setTable(Table parent) {
        this.parentTable = parent;
    }

    public Table getTable() {
        return this.parentTable;
    }

    public String getTableName() {
        return this.parentTable.getName();
    }

    public void addColumn(Attributes attrib) {
        this.indexColumns.add(attrib.getValue("name"));
    }

    private String makeColumnList(List cols) {
        StringBuffer res = new StringBuffer(cols.get(0).toString());
        int i = 1;
        while (i < cols.size()) {
            res.append(", ").append(cols.get(i).toString());
            ++i;
        }
        return res.toString();
    }

    public String getIndexColumnList() {
        return this.makeColumnList(this.indexColumns);
    }

    public List getIndexColumns() {
        return this.indexColumns;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(" <index name=\"").append(this.indexName).append("\"");
        result.append(">\n");
        int i = 0;
        while (i < this.indexColumns.size()) {
            result.append("  <index-column name=\"").append(this.indexColumns.get(i)).append("\"/>\n");
            ++i;
        }
        result.append(" </index>\n");
        return result.toString();
    }
}

