/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.util.statlog;

import com.sourceforge.knecs.util.statlog.NameValuePair;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.XMLFormatter;

public class StatXMLFormatter
extends XMLFormatter {
    protected String mFileName;

    public StatXMLFormatter(String fileName) {
        this.mFileName = fileName;
    }

    public String format(LogRecord record) {
        Object[] params;
        try {
            RandomAccessFile raf = new RandomAccessFile(this.mFileName, "rwd");
            int fileLen = (int)raf.length();
            raf.setLength(fileLen - 7);
            raf.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer(1000);
        sb.append("<record>\n");
        sb.append("  <date>");
        this.appendISO8601(sb);
        sb.append("</date>\n");
        sb.append("  <millis>");
        sb.append(record.getMillis());
        sb.append("</millis>\n");
        if (record.getMessage() != null) {
            String message = this.formatMessage(record);
            sb.append("  <message>");
            this.escape(sb, message);
            sb.append("</message>");
            sb.append("\n");
        }
        if ((params = record.getParameters()) != null) {
            for (int i = 0; i < params.length; ++i) {
                NameValuePair pair = (NameValuePair)params[i];
                sb.append("  <");
                this.escape(sb, pair.getName());
                sb.append(">");
                this.escape(sb, pair.getValue());
                sb.append("</");
                this.escape(sb, pair.getName());
                sb.append(">\n");
            }
        }
        sb.append("</record>\n</log>\n");
        return sb.toString();
    }

    public String getHead(Handler h) {
        String ret = super.getHead(h);
        try {
            RandomAccessFile raf = new RandomAccessFile(this.mFileName, "rwd");
            int fileLen = (int)raf.length();
            if (fileLen > 7) {
                ret = "";
            }
            raf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public String getTail(Handler h) {
        return "";
    }

    protected void a2(StringBuffer sb, int x) {
        if (x < 10) {
            sb.append('0');
        }
        sb.append(x);
    }

    protected void appendISO8601(StringBuffer sb) {
        Calendar now = Calendar.getInstance();
        sb.append(now.get(1));
        sb.append('-');
        this.a2(sb, now.get(2) + 1);
        sb.append('-');
        this.a2(sb, now.get(5));
        sb.append('T');
        this.a2(sb, now.get(10));
        sb.append(':');
        this.a2(sb, now.get(12));
        sb.append(':');
        this.a2(sb, now.get(13));
    }

    private void escape(StringBuffer sb, String text) {
        if (text == null) {
            text = "";
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            if (ch == '&') {
                sb.append("&amp;");
                continue;
            }
            sb.append(ch);
        }
    }
}

