/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.resourceobject;

import com.sourceforge.knecs.dsm.resourceobject.ResourceObject;

public class DataRequest
extends ResourceObject {
    public static final String COMMONNAME = "http://purl.org/dc/elements/1.1/:title";
    public static final String SPECIESNAME = "http://purl.oclc.org/NET/cmcs/schema/:speciesname";
    public static final String CHEMPROPERTIES = "http://purl.oclc.org/NET/cmcs/schema/:chemicalproperty";
    public static final String PRIORITY = "http://purl.oclc.org/NET/cmcs/schema/:priority";
    public static final String MESSAGE = "http://purl.org/dc/elements/1.1/:message";
    public static final String RECIPIENTS = "http://purl.oclc.org/NET/cmcs/schema/:recipient";

    public DataRequest() {
        this.setAttributeTypes();
        try {
            this.add("http://purl.org/dc/elements/1.1/:type", this.getClass().getName());
        }
        catch (Exception dsme) {
            this.mLog.severe("Exception creating DataRequest class: " + dsme.toString());
        }
    }

    private void setAttributeTypes() {
        this.mAttributeTypes.put(COMMONNAME, String.class);
        this.mAttributeTypes.put(SPECIESNAME, String[].class);
        this.mAttributeTypes.put(CHEMPROPERTIES, String[].class);
        this.mAttributeTypes.put(PRIORITY, String.class);
        this.mAttributeTypes.put(MESSAGE, String.class);
        this.mAttributeTypes.put(RECIPIENTS, String[].class);
    }

    public String getCommonName() {
        Object commonname = this.mResourceEntry.get(COMMONNAME);
        return (String)commonname;
    }

    public String[] getSpeciesName() {
        return this.getAsStringArray(SPECIESNAME);
    }

    public String[] getChemProperties() {
        return this.getAsStringArray(CHEMPROPERTIES);
    }

    public String getPriority() {
        Object priority = this.mResourceEntry.get(PRIORITY);
        return (String)priority;
    }

    public String getMessage() {
        Object message = this.mResourceEntry.get(MESSAGE);
        return (String)message;
    }

    public String[] getRecipients() {
        return this.getAsStringArray(RECIPIENTS);
    }

    public void setCommonName(String commonname) {
        this.mResourceEntry.put(COMMONNAME, commonname);
    }

    public void setSpeciesName(String[] speciesName) {
        this.mResourceEntry.put(SPECIESNAME, speciesName);
    }

    public void setChemProperties(String[] chemProperties) {
        this.mResourceEntry.put(CHEMPROPERTIES, chemProperties);
    }

    public void setPriority(String priority) {
        this.mResourceEntry.put(PRIORITY, priority);
    }

    public void setMessage(String message) {
        this.mResourceEntry.put(MESSAGE, message);
    }

    public void setRecipients(String[] recipients) {
        this.mResourceEntry.put(RECIPIENTS, recipients);
    }
}

