import * as TS from "typescript";
import { Plugin } from "rollup";
interface ExtendedDiagnostic extends TS.Diagnostic {
    scope?: string;
}
interface CustomTransformerOptions {
    program: TS.Program | undefined;
    printer: TS.Printer;
    typescript: typeof TS;
    addDiagnostics(...diagnostics: ExtendedDiagnostic[]): void;
}
type CustomTransformersFunction = (options: CustomTransformerOptions) => TS.CustomTransformers;
// A Record from chunk file names to their stats
type DeclarationStats = Record<string, DeclarationChunkStats>;
interface DeclarationChunkStats {
    // An array of the external type dependencies for a declaration chunk
    externalTypes: ExternalType[];
}
interface ExternalType {
    // The name of the external library that provides the typings. For example, "typescript" or "@types/node"
    library: string;
    // The version of the referenced external library
    version: string;
}
// eslint-disable-next-line @typescript-eslint/no-explicit-any
type BabelConfig = Record<string, any>;
// eslint-disable-next-line @typescript-eslint/no-explicit-any
type SwcConfig = Record<string, any>;
type Transpiler = "typescript" | "babel" | "swc";
interface DebugTransformerData {
    kind: "transformer";
    fileName: string;
    text: string;
}
interface DebugEmitData {
    kind: "emit";
    fileName: string;
    text: string;
    fileKind: EmitPathKind;
}
interface DebugMetricsData {
    kind: "metrics";
    fileName?: string;
}
interface DebugTsconfigData {
    kind: "tsconfig";
}
type DebugData = DebugTransformerData | DebugEmitData | DebugMetricsData | DebugTsconfigData;
type DebugOptionCallback = (data: DebugData) => boolean;
interface BrowserslistPathConfig {
    path: string;
}
interface BrowserslistQueryConfig {
    query: string[] | string;
}
type BrowserslistConfig = BrowserslistPathConfig | BrowserslistQueryConfig;
interface TsConfigResolverWithFileName {
    fileName: string;
    hook(resolvedOptions: TS.CompilerOptions): TS.CompilerOptions;
}
type TsConfigResolver = TsConfigResolverWithFileName["hook"];
type OutputPathKind = "declaration" | "declarationMap" | "buildInfo";
type TranspilationPhase = "file" | "chunk";
type EmitPathKind = OutputPathKind | "javascript";
type OutputPathHook = (path: string, kind: OutputPathKind) => string | undefined;
type DiagnosticsHook = (diagnostics: readonly TS.Diagnostic[]) => readonly TS.Diagnostic[] | undefined;
type BabelConfigHook = (config: BabelConfig | undefined, fileName: string | undefined, phase: TranspilationPhase) => BabelConfig | undefined;
type SwcConfigHook = (config: SwcConfig | undefined, fileName: string | undefined, phase: TranspilationPhase) => SwcConfig | undefined;
type DeclarationStatsHook = (stats: DeclarationStats) => DeclarationStats | undefined;
interface HookRecord {
    outputPath: OutputPathHook;
    diagnostics: DiagnosticsHook;
    babelConfig: BabelConfigHook;
    swcConfig: SwcConfigHook;
    declarationStats: DeclarationStatsHook;
}
interface InputCompilerOptions extends Omit<TS.CompilerOptions, "module" | "moduleResolution" | "newLine" | "jsx" | "target"> {
    module: string;
    moduleResolution: string;
    newLine: string;
    jsx: string;
    target: string;
}
interface TypescriptPluginBaseOptions {
    transpiler: Transpiler;
    tsconfig?: string | Partial<TS.CompilerOptions> | Partial<InputCompilerOptions> | TS.ParsedCommandLine | TsConfigResolver | TsConfigResolverWithFileName;
    browserslist?: false | string[] | string | BrowserslistConfig;
    cwd: string;
    transformers?: (TS.CustomTransformers | CustomTransformersFunction)[] | TS.CustomTransformers | CustomTransformersFunction;
    include: string[] | string;
    exclude: string[] | string;
    transpileOnly?: boolean;
    fileSystem: TS.System;
    hook: Partial<HookRecord>;
    debug: boolean | DebugOptionCallback;
    typescript: typeof TS;
}
interface TypescriptPluginTypescriptOptions extends TypescriptPluginBaseOptions {
    transpiler: "typescript";
}
interface TypescriptPluginBabelOptions extends TypescriptPluginBaseOptions {
    transpiler: "babel";
    babelConfig?: string | Partial<BabelConfig>;
}
interface TypescriptPluginSwcOptions extends TypescriptPluginBaseOptions {
    transpiler: "swc";
    swcConfig?: string | Partial<SwcConfig>;
}
type TypescriptPluginOptions = TypescriptPluginTypescriptOptions | TypescriptPluginBabelOptions | TypescriptPluginSwcOptions;
/**
 * A Rollup plugin that transpiles the given input with Typescript
 */
declare function typescriptRollupPlugin(pluginInputOptions?: Partial<TypescriptPluginOptions>): Plugin;
export { CustomTransformerOptions, CustomTransformersFunction, DeclarationStats, DeclarationChunkStats, ExternalType, TypescriptPluginOptions, BrowserslistConfig, BrowserslistPathConfig, BrowserslistQueryConfig, TypescriptPluginBabelOptions, TypescriptPluginTypescriptOptions, typescriptRollupPlugin as default };
//# sourceMappingURL=index.d.ts.map