/***************************************************************************
 *   Copyright (C) 2005-2008 by Eugene V. Lyubimkin aka jackyf             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License                  *
 *   (version 3 or above) as published by the Free Software Foundation.    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU GPL                        *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA               *
 ***************************************************************************/
#include <vector>

#include <QObject>

#include <yf/time/time.hpp>

using std::vector;

class FortunesGetter;
class ExerciseResult;
class UserProfile;

class Logic: public QObject
{
	Q_OBJECT

 public:
	Logic(FortunesGetter& fortunesGetter, UserProfile& userProfile);

 signals:
	void startTyping(const QString& text, const QString& author);
	void endTyping();
	void wait(int milliseconds);
	void tooManyMistakes();
	void maxMistakeCount(int maxCount);
	void mistakeCount(int mistakeCount);
	void exerciseFinished(const ExerciseResult&);

 public slots:
	void typedSymbol();
	void errorOnSymbol();

	void startExercise();
	void terminateExercise();

 private:
	enum ExercisePart {FirstPartOfExercise, SecondPartOfExercise, NoExercise};

	ExercisePart exerciseState;
	vector<size_t> mistakes;
	QString typingText;
	size_t maxAllowedMistakeCount;
	size_t currentTextPosition;
	vector<yf::precise_time_t> typingTimestamps;

	FortunesGetter& fortunesGetter;
	UserProfile& userProfile;

	QChar randomFiller();
	void typedText();
	void touchTimestamp();
	void signalAboutMistakesState();
	QString getWorseTriLetter() const;
	size_t getRhythmPercent() const;
	void renewMaxAllowedMistakeCount();
};

