/* pdu-data.c
 
   PDU builder for data PDUs

   Copyright (C) 2007, 2008, 2009 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "pbuild-priv.h"

static void
build(const GNode *pdu, void *dest)
{
    struct payload *payload;
    struct node_data *node_data;
    GNode *child, *braced_args;
    long int len;

    for (child = g_node_first_child(pdu);
	 child && ( (struct node_data *) child->data)->type != PDU_NODE_PDU;
	 child = g_node_next_sibling(child) ) {
	node_data = child->data;

	if (!strcmp(node_data->name, "data") ) {
	    payload = node_data->_data_parm.data;
	    if (payload) {
		memcpy(dest, payload->data, payload->len);
		dest += payload->len;
	    }
	} else if (!strcmp(node_data->name, "random") ) {
	    if (!(braced_args = g_node_first_child(child) ) )
		continue;

	    node_data = braced_args->data;
	    len = *(long int *) node_data->_data_parm.data;
	    _pb_random_block(dest, len);
	    dest += len;
	}
    }
}

static size_t
get_len(const GNode *pdu)
{
    struct payload *payload;
    size_t len;
    struct node_data *node_data;
    GNode *child, *braced_args;

    for (len = 0, child = g_node_first_child(pdu);
	 child;
	 child = g_node_next_sibling(child) ) {
	node_data = child->data;

	if (!strcmp(node_data->name, "data") ) {
	    payload = node_data->_data_parm.data;
	    len += payload ? payload->len : 0;
	} else if (!strcmp(node_data->name, "random") ) {
	    if (!(braced_args = g_node_first_child(child) ) )
		continue;

	    node_data = braced_args->data;
	    len += *(long int *) node_data->_data_parm.data;
	}
    }

    return len;
}

#if 0
static void
pdu_data_dumper(pdu_t *p, const char *prefix)
{
    struct payload *hdr_data;

    hdr_data = p->header_data;

    printf("%s  Parameters:\n", prefix);
    printf("%s    Hex. dump of data payload:\n", prefix);
    pdu_dump_bytes(hdr_data->data, hdr_data->len);
}
#endif

static pdu_t pdu_data = {
    .name = "data",
    .description = "Data",
    .documented_in = "none",
    .fields = (field_t []) {
	{
	    .name = "data",
	    .type = PDU_FTYPE_DATA
	},
	{
	    .name = "random",
	    .type = PDU_FTYPE_BRACED_ARGS,
	    .data = (field_t []) {
		{.name = "length", .type = PDU_FTYPE_UINT},
		{.name = NULL}
	    },
	    .defval = NULL
	},
	{
	    .name = NULL
	},
    },
    .build = &build,
    .get_len = &get_len
};

void
_pb_register_data(void)
{
    _pb_register_protocol(&pdu_data);
}
