/* util.c
  
   Utility functions used by different parts of the libnumbers subsystem

   Copyright (C) 2008, 2009 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>
#include <string.h>
#include <dnet.h>

char *
_num_ipaddr2str(ip_addr_t ip)
{
    struct addr a;
    static char addr[20];

    memset(&a, 0, sizeof(struct addr) );
    a.addr_type = ADDR_TYPE_IP;
    a.addr_bits = IP_ADDR_BITS;
    a.addr_ip = ip;

    return addr_ntop(&a, addr, sizeof(addr) );
}

/*
 * Returns a random integer between a and b.
 */
int
_num_random_int(int a, int b)
{
    return (rand() % (b - a + 1) ) + a;
}
