/*
 * DO NOT ALTER OR 
 @Override
 public boolean verify(JComponent input) {
 throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
 }
 REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2014 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2014 Sun Microsystems, Inc.
 */
package org.netbeans.modules.terminal;

import org.netbeans.modules.terminal.support.TerminalPinSupport.TerminalCreationDetails;
import org.netbeans.modules.terminal.support.TerminalPinSupport.TerminalDetails;
import org.netbeans.modules.terminal.support.TerminalPinSupport.TerminalPinningDetails;

/**
 *
 * @author ilia
 */
public class PinPanel extends javax.swing.JPanel {

    /**
     * Creates new form PinPanel
     */
    public PinPanel(TerminalDetails details) {
	initComponents();

	TerminalCreationDetails creationDetails = details.getCreationDetails();
	TerminalPinningDetails pinningDetails = details.getPinningDetails();

	envField.setText(creationDetails.getExecEnv());
	titleField.setText(pinningDetails.getTitle());
	customCheckBox.setSelected(pinningDetails.isCustomTitle());
	customStateChanged(pinningDetails.isCustomTitle());
	if (pinningDetails.getCwd() != null) {
	    directoryField.setText(pinningDetails.getCwd());
	} else {
	    directoryField.setText("");
	}
    }

    public String getTitle() {
	return titleField.getText();
    }

    public boolean isCustomTitle() {
	return customCheckBox.isSelected();
    }

    public String getDirectory() {
	return directoryField.getText();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        envLabel = new javax.swing.JLabel();
        envField = new javax.swing.JTextField();
        titleLabel = new javax.swing.JLabel();
        titleField = new javax.swing.JTextField();
        customCheckBox = new javax.swing.JCheckBox();
        directoryLabel = new javax.swing.JLabel();
        directoryField = new javax.swing.JTextField();

        envLabel.setLabelFor(envField);
        org.openide.awt.Mnemonics.setLocalizedText(envLabel, org.openide.util.NbBundle.getMessage(PinPanel.class, "PinPanel.envLabel.text")); // NOI18N

        envField.setEditable(false);
        envField.setText(org.openide.util.NbBundle.getMessage(PinPanel.class, "PinPanel.envField.text")); // NOI18N
        envField.setFocusable(false);
        envField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                envFieldActionPerformed(evt);
            }
        });

        titleLabel.setLabelFor(titleField);
        org.openide.awt.Mnemonics.setLocalizedText(titleLabel, org.openide.util.NbBundle.getMessage(PinPanel.class, "PinPanel.titleLabel.text")); // NOI18N

        titleField.setText(org.openide.util.NbBundle.getMessage(PinPanel.class, "PinPanel.titleField.text")); // NOI18N

        customCheckBox.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(customCheckBox, org.openide.util.NbBundle.getMessage(PinPanel.class, "PinPanel.customCheckBox.text")); // NOI18N
        customCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                customCheckBoxActionPerformed(evt);
            }
        });

        directoryLabel.setLabelFor(directoryField);
        org.openide.awt.Mnemonics.setLocalizedText(directoryLabel, org.openide.util.NbBundle.getMessage(PinPanel.class, "PinPanel.directoryLabel.text")); // NOI18N

        directoryField.setText(org.openide.util.NbBundle.getMessage(PinPanel.class, "PinPanel.directoryField.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(directoryLabel)
                    .addComponent(titleLabel)
                    .addComponent(envLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(envField)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(titleField, javax.swing.GroupLayout.DEFAULT_SIZE, 117, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(customCheckBox))
                    .addComponent(directoryField))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(envLabel)
                    .addComponent(envField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(titleLabel)
                    .addComponent(titleField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(customCheckBox))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(directoryLabel)
                    .addComponent(directoryField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        envLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PinPanel.class, "PinPanel.envLabel.AccessibleContext.accessibleDescription")); // NOI18N
        envField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(PinPanel.class, "PinPanel.envField.AccessibleContext.accessibleName")); // NOI18N
        envField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PinPanel.class, "PinPanel.envField.AccessibleContext.accessibleDescription")); // NOI18N
        titleLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PinPanel.class, "PinPanel.titleLabel.AccessibleContext.accessibleDescription")); // NOI18N
        titleField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(PinPanel.class, "PinPanel.titleField.AccessibleContext.accessibleName")); // NOI18N
        titleField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PinPanel.class, "PinPanel.titleField.AccessibleContext.accessibleDescription")); // NOI18N
        customCheckBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PinPanel.class, "PinPanel.customCheckBox.AccessibleContext.accessibleDescription")); // NOI18N
        directoryLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PinPanel.class, "PinPanel.directoryLabel.AccessibleContext.accessibleDescription")); // NOI18N
        directoryField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(PinPanel.class, "PinPanel.directoryField.AccessibleContext.accessibleName")); // NOI18N
        directoryField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PinPanel.class, "PinPanel.directoryField.AccessibleContext.accessibleDescription")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void envFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_envFieldActionPerformed
	// TODO add your handling code here:
    }//GEN-LAST:event_envFieldActionPerformed

    private void customCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_customCheckBoxActionPerformed
	customStateChanged(customCheckBox.isSelected());
    }//GEN-LAST:event_customCheckBoxActionPerformed

    private void customStateChanged(boolean newState) {
	if (newState) {
	    titleField.setEnabled(true);
	    titleField.requestFocus();
	} else {
	    titleField.setEnabled(false);
	}
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox customCheckBox;
    private javax.swing.JTextField directoryField;
    private javax.swing.JLabel directoryLabel;
    private javax.swing.JTextField envField;
    private javax.swing.JLabel envLabel;
    private javax.swing.JTextField titleField;
    private javax.swing.JLabel titleLabel;
    // End of variables declaration//GEN-END:variables
}
