/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2011 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2011 Sun Microsystems, Inc.
 */

/*
 * SymfonyGoToViewActionPanel.java
 *
 * Created on 22.2.2011, 14:02:37
 */

package org.netbeans.modules.php.symfony.ui.actions;

import java.awt.Cursor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import org.netbeans.modules.csl.api.UiUtils;
import org.openide.filesystems.FileObject;

/**
 *
 * @author Ondřej Brejla <ondrej@brejla.cz>
 */
public class SymfonyGoToViewActionPanel extends javax.swing.JPanel implements FocusListener {

    private static final long serialVersionUID = 874543213245676L;

    private final List<FileObject> views;

    private final SymfonyGoToViewActionPopup popup;

    public SymfonyGoToViewActionPanel(List<FileObject> views, SymfonyGoToViewActionPopup popup) {
        this.views = views;
        this.popup = popup;

        initComponents();

        viewsList.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));

        addFocusListener(this);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        titleLabel = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        viewsList = new javax.swing.JList<SymfonyViewItem>();

        setFocusCycleRoot(true);
        setLayout(new java.awt.GridBagLayout());

        titleLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        titleLabel.setText(org.openide.util.NbBundle.getMessage(SymfonyGoToViewActionPanel.class, "SymfonyGoToViewActionPanel.titleLabel.text")); // NOI18N
        titleLabel.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(titleLabel, gridBagConstraints);

        viewsList.setModel(createListModel());
        viewsList.setSelectedIndex(0);
        viewsList.setVisibleRowCount(views.size());
        viewsList.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                viewsListMouseClicked(evt);
            }
        });
        viewsList.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                viewsListKeyPressed(evt);
            }
        });
        jScrollPane1.setViewportView(viewsList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jScrollPane1, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void viewsListKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_viewsListKeyPressed
        if (evt.getKeyCode() == KeyEvent.VK_ENTER && evt.getModifiers() == 0) {
            openSelected();
        }
    }//GEN-LAST:event_viewsListKeyPressed

    private void viewsListMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_viewsListMouseClicked
        if (evt.getButton() == MouseEvent.BUTTON1 && evt.getClickCount() == 1) {
            openSelected();
        }
    }//GEN-LAST:event_viewsListMouseClicked

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel titleLabel;
    private javax.swing.JList<SymfonyViewItem> viewsList;
    // End of variables declaration//GEN-END:variables

    private void openSelected() {
        SymfonyViewItem view = viewsList.getSelectedValue();

        if (view != null) {
            FileObject fo = view.getFileObject();
            if (fo != null) {
                UiUtils.open(fo, 0);
            }
        }

        popup.hide();
    }

    private ListModel<SymfonyViewItem> createListModel() {
        DefaultListModel<SymfonyViewItem> dlm = new DefaultListModel<>();

        for (FileObject view : views) {
            dlm.addElement(new SymfonyViewItem(view));
        }

        return dlm;
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        viewsList.requestFocus();
        viewsList.requestFocusInWindow();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }

    private static class SymfonyViewItem {

        private FileObject view;

        public SymfonyViewItem(FileObject view) {
            this.view = view;
        }

        public FileObject getFileObject() {
            return view;
        }

        @Override
        public String toString() {
            return view.getNameExt();
        }

    }

}
