/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2013 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2013 Sun Microsystems, Inc.
 */
package org.netbeans.modules.cnd.makeproject.runprofiles.ui;

import javax.swing.JButton;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/**
 *
 * @author alsimon
 */
public class RerunArguments extends javax.swing.JPanel {
    private final ProjectActionEvent[] paes;

    /**
     * Creates new form RerunArguments
     */
    public RerunArguments(ProjectActionEvent[] paes) {
        this.paes = paes;
        initComponents();
        for(ProjectActionEvent event : paes) {
            if (event.getType() == ProjectActionEvent.PredefinedType.RUN) {
                String args = event.getProfile().getRunCommand().getValue();
                argumentsField.setText(args);
                break;
            }
        }
    }
    
    public boolean showMe() {
        String title = NbBundle.getMessage(RerunArguments.class, "RerunArguments.title.text"); // NOI18N
        DialogDescriptor dd = new DialogDescriptor(this, title);
        dd.setOptionType(NotifyDescriptor.OK_CANCEL_OPTION);
        JButton run = new JButton(NbBundle.getMessage(RerunArguments.class, "LBL_run_advanced_run")); // NOI18N
        run.setDefaultCapable(true);
        JButton cancel = new JButton(NbBundle.getMessage(RerunArguments.class, "LBL_run_advanced_cancel")); // NOI18N
        dd.setOptions(new Object[] {run, cancel});
        dd.setModal(true);
        Object result = DialogDisplayer.getDefault().notify(dd);
        if (result.equals(run)) {
            for(ProjectActionEvent event : paes) {
                if (event.getType() == ProjectActionEvent.PredefinedType.RUN ||
                    event.getType() == ProjectActionEvent.PredefinedType.DEBUG ||
                    event.getType() == ProjectActionEvent.PredefinedType.DEBUG_STEPINTO) {
                    event.getProfile().getRunCommand().setValue(argumentsField.getText());
                    break;
                }
            }
            return true;
        }
        return false;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        argumentsLabel = new javax.swing.JLabel();
        argumentsField = new javax.swing.JTextField();

        setMaximumSize(new java.awt.Dimension(428, 66));

        argumentsLabel.setLabelFor(argumentsField);
        org.openide.awt.Mnemonics.setLocalizedText(argumentsLabel, org.openide.util.NbBundle.getMessage(RerunArguments.class, "RerunArguments.argumentsLabel.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(argumentsLabel)
                    .addComponent(argumentsField, javax.swing.GroupLayout.DEFAULT_SIZE, 404, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(argumentsLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(argumentsField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField argumentsField;
    private javax.swing.JLabel argumentsLabel;
    // End of variables declaration//GEN-END:variables
}
