/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action;

import org.netbeans.modules.j2ee.ejbcore.ui.EJBPreferences;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Adamek
 */
public class DeleteEJBDialog extends javax.swing.JPanel {

    public static final String DELETE_NOTHING = "deleteNothing";
    public static final String DELETE_ONLY_DD = "deleteOnlyDD";
    public static final String DELETE_ALL = "deleteAll";

    private final String ejbDisplayName;
    private final EJBPreferences ejbPreferences;
    
    private DeleteEJBDialog(String ejbDisplayName) {
        this.ejbDisplayName = ejbDisplayName;
        initComponents();
        ejbPreferences = new EJBPreferences();
        deleteClassesCheckBox.setSelected(ejbPreferences.isAgreedDeleteEJBGeneratedSources());
    }

    public static String open(String ejbDisplayName) {
        String title = NbBundle.getMessage(DeleteEJBDialog.class, "MSG_ConfirmDeleteObjectTitle");
        DeleteEJBDialog delDialog = new DeleteEJBDialog(ejbDisplayName);
        NotifyDescriptor desc = new NotifyDescriptor.Confirmation(delDialog, title, NotifyDescriptor.YES_NO_OPTION);
        Object result = DialogDisplayer.getDefault().notify(desc);
        if (result.equals(NotifyDescriptor.CLOSED_OPTION)) {
            return DELETE_NOTHING;
        } else if (result.equals(NotifyDescriptor.NO_OPTION)) {
            return DELETE_NOTHING;
        } else if (delDialog.deleteClassesCheckBox.isSelected()) {
            return DELETE_ALL;
        } else {
            return DELETE_ONLY_DD;
        }
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        deleteClassesCheckBox = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setText(org.openide.util.NbBundle.getMessage(DeleteEJBDialog.class, "MSG_ConfirmDeleteObject", new Object[] {ejbDisplayName}));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 8, 0);
        add(jLabel1, gridBagConstraints);

        deleteClassesCheckBox.setText(org.openide.util.NbBundle.getBundle(DeleteEJBDialog.class).getString("MSG_DeleteClasses"));
        deleteClassesCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteClassesCheckBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        add(deleteClassesCheckBox, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents

    private void deleteClassesCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteClassesCheckBoxActionPerformed
        ejbPreferences.setAgreedDeleteEJBGeneratedSources(deleteClassesCheckBox.isSelected());
    }//GEN-LAST:event_deleteClassesCheckBoxActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox deleteClassesCheckBox;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables
    
}
