---
name: QUAST
url: http://quast.bioinf.spbau.ru/
description: >
  A Quality Assessment Tool for Genome Assemblies by
  the Center for Algorithmic Biotechnology.
---

[QUAST](http://quast.bioinf.spbau.ru/) evaluates genome assemblies by
computing various metrics, including

- N50, length for which the collection of all contigs of that length or
  longer covers at least 50% of assembly length
- NG50, where length of the reference genome is being covered
- NA50 and NGA50, where aligned blocks instead of contigs are taken
- Misassemblies, misassembled and unaligned contigs or contigs bases
- Genes and operons covered

The QUAST MultiQC module parses the `report.tsv` files generated by
QUAST and adds key metrics to the report General Statistics table.
All statistics for all samples are saved to `multiqc_data/multiqc_quast.txt`.

#### Configuration

By default, the QUAST module is configured to work with large _de-novo_ genomes,
showing thousands of contigs, mega-base pairs and other sensible defaults.

If these aren't appropriate for your genomes, you can configure them as follows:

```yaml
quast_config:
  contig_length_multiplier: 0.001
  contig_length_suffix: "Kbp"
  total_length_multiplier: 0.000001
  total_length_suffix: "Mbp"
  total_number_contigs_multiplier: 0.001
  total_number_contigs_suffix: "K"
```

The default module values are shown above. See the
[main MultiQC documentation](http://multiqc.info/docs/#configuring-multiqc)
for more information about how to configure MultiQC.

#### MetaQUAST

The QUAST module will also parse output from
[MetaQUAST](http://quast.sourceforge.net/metaquast) runs (`metaquast.py`).

The `combined_reference/report.tsv` file is parsed, and folders
`runs_per_reference` and `not_aligned` are ignored.

If you want to run MultiQC against auxiliary MetaQUAST runs, you must
explicitly pass these files to MultiQC:

```bash
multiqc runs_per_reference/reference_1/report.tsv
```

Note that you can pass as many file paths to MultiQC as you like
and use glob expansion (eg. `runs_per_reference/*/report.tsv`).
