# Check for the GL,GLUT libraries (Linux only, in Windows use the build in .h & .lib)
# ===================================================

OPTION(DISABLE_OPENGL "Disable the OpenGL library" "OFF")
MARK_AS_ADVANCED(DISABLE_OPENGL)

IF (DISABLE_OPENGL)
	SET(CMAKE_MRPT_HAS_OPENGL_GLUT 0)
	SET(CMAKE_MRPT_HAS_OPENGL_GLUT_SYSTEM 0)

	SET(CMAKE_MRPT_HAS_GLUT 0)
	SET(CMAKE_MRPT_HAS_GLUT_SYSTEM 0)

ELSE (DISABLE_OPENGL)

	FIND_PACKAGE(OpenGL)
	IF(OPENGL_FOUND AND "${OPENGL_INCLUDE_DIR}")
		INCLUDE_DIRECTORIES("${OPENGL_INCLUDE_DIR}")
	ENDIF(OPENGL_FOUND AND "${OPENGL_INCLUDE_DIR}")

	IF(UNIX)
		FIND_PACKAGE(GLUT)

		IF (GLUT_FOUND AND OPENGL_gl_LIBRARY AND OPENGL_glu_LIBRARY AND GLUT_glut_LIBRARY)
			INCLUDE_DIRECTORIES("${GLUT_INCLUDE_DIR}")
			SET(CMAKE_MRPT_HAS_OPENGL_GLUT 1)
			SET(CMAKE_MRPT_HAS_OPENGL_GLUT_SYSTEM 1)

			SET(CMAKE_MRPT_HAS_GLUT 1)
			SET(CMAKE_MRPT_HAS_GLUT_SYSTEM 1)
		ELSE(GLUT_FOUND AND OPENGL_gl_LIBRARY AND OPENGL_glu_LIBRARY AND GLUT_glut_LIBRARY)
			MESSAGE(STATUS "**Warning**: OpenGL and/or GLUT not found! OpenGL capabilities will be disabled.")
			MESSAGE(STATUS "              	OPENGL_gl_LIBRARY: ${OPENGL_gl_LIBRARY}")
			MESSAGE(STATUS "              	OPENGL_glu_LIBRARY: ${OPENGL_glu_LIBRARY}")
			MESSAGE(STATUS "              	GLUT_glut_LIBRARY: ${GLUT_glut_LIBRARY}")
			MESSAGE(STATUS "              	OPENGL_INCLUDE_DIR: ${OPENGL_INCLUDE_DIR}")

			SET(CMAKE_MRPT_HAS_OPENGL_GLUT 0)
			SET(CMAKE_MRPT_HAS_OPENGL_GLUT_SYSTEM 0)

			SET(CMAKE_MRPT_HAS_GLUT 0)
			SET(CMAKE_MRPT_HAS_GLUT_SYSTEM 0)
		ENDIF(GLUT_FOUND AND OPENGL_gl_LIBRARY AND OPENGL_glu_LIBRARY AND GLUT_glut_LIBRARY)
	ELSE(UNIX)
		SET(CMAKE_MRPT_HAS_OPENGL_GLUT 1)
		SET(CMAKE_MRPT_HAS_OPENGL_GLUT_SYSTEM 1)

		SET(CMAKE_MRPT_HAS_GLUT 1)
		SET(CMAKE_MRPT_HAS_GLUT_SYSTEM 0)
	ENDIF(UNIX)

	IF(NOT MSVC)
		# GL, GLU, glut:
		IF(CMAKE_MRPT_HAS_OPENGL_GLUT)
			#APPEND_MRPT_LIBS(${OPENGL_gl_LIBRARY} ${OPENGL_glu_LIBRARY} ${GLUT_glut_LIBRARY})
			set(MRPT_OPENGL_LIBS ${OPENGL_gl_LIBRARY} ${OPENGL_glu_LIBRARY} ${GLUT_glut_LIBRARY})
		ENDIF(CMAKE_MRPT_HAS_OPENGL_GLUT)
	ENDIF(NOT MSVC)
ENDIF (DISABLE_OPENGL)

