/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.ResultTypeHandlerImpl;
import com.jclark.xsl.sax.XSLProcessor;
import com.jclark.xsl.sax.XSLProcessorImpl;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Driver {
    static Parser createParser() {
        String string = System.getProperty("com.jclark.xsl.sax.parser");
        if (string == null) {
            string = System.getProperty("org.xml.sax.parser");
        }
        if (string == null) {
            string = "com.jclark.xml.sax.CommentDriver";
        }
        try {
            return (Parser)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException.toString());
        }
        catch (InstantiationException instantiationException) {
            System.err.println(instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException.toString());
        }
        catch (ClassCastException classCastException) {
            System.err.println(string + " is not a SAX driver");
        }
        return null;
    }

    public static void main(String[] stringArray) {
        File file;
        Parser parser;
        if (stringArray.length != 2 && stringArray.length != 3) {
            System.err.println("usage: java com.jclark.xsl.sax.Driver source stylesheet [result]");
            System.exit(1);
        }
        if ((parser = Driver.createParser()) == null) {
            System.exit(1);
        }
        XSLProcessorImpl xSLProcessorImpl = new XSLProcessorImpl(parser);
        ResultTypeHandlerImpl resultTypeHandlerImpl = new ResultTypeHandlerImpl(xSLProcessorImpl);
        xSLProcessorImpl.setResultTypeHandler(resultTypeHandlerImpl);
        boolean bl = true;
        File file2 = new File(stringArray[0]);
        File file3 = new File(stringArray[1]);
        File file4 = file = stringArray.length == 3 ? new File(stringArray[2]) : null;
        if (!file2.isDirectory()) {
            bl = Driver.transformFile(xSLProcessorImpl, resultTypeHandlerImpl, file2, file3, file);
        } else {
            String[] stringArray2 = file2.list();
            int n = 0;
            while (n < stringArray2.length) {
                File file5 = new File(file2, stringArray2[n]);
                if (!file5.isDirectory()) {
                    if (!file3.isDirectory()) {
                        if (!Driver.transformFile(xSLProcessorImpl, resultTypeHandlerImpl, file5, file3, new File(file, stringArray2[n]))) {
                            bl = false;
                        }
                    } else {
                        int n2 = stringArray2[n].lastIndexOf(46);
                        File file6 = new File(file3, n2 < 0 ? stringArray2[n] : stringArray2[n].substring(0, n2) + ".xsl");
                        if (file6.exists() && !Driver.transformFile(xSLProcessorImpl, resultTypeHandlerImpl, file5, file6, new File(file, stringArray2[n]))) {
                            bl = false;
                        }
                    }
                }
                ++n;
            }
        }
        System.exit(bl ? 0 : 1);
    }

    static boolean transformFile(XSLProcessor xSLProcessor, ResultTypeHandlerImpl resultTypeHandlerImpl, File file, File file2, File file3) {
        FileOutputStream fileOutputStream = null;
        if (file3 == null) {
            fileOutputStream = new FileOutputStream(FileDescriptor.out);
        } else {
            try {
                fileOutputStream = new FileOutputStream(file3);
            }
            catch (IOException iOException) {
                System.err.println(iOException.toString());
                System.exit(1);
            }
        }
        resultTypeHandlerImpl.setOutputStream(fileOutputStream);
        xSLProcessor.setStylesheet(Driver.fileInputSource(file2));
        return Driver.transform(xSLProcessor, Driver.fileInputSource(file));
    }

    static boolean transform(XSLProcessor xSLProcessor, InputSource inputSource) {
        try {
            xSLProcessor.parse(inputSource);
            return true;
        }
        catch (SAXParseException sAXParseException) {
            String string = sAXParseException.getSystemId();
            int n = sAXParseException.getLineNumber();
            if (string != null) {
                System.err.print(string + ":");
            }
            if (n >= 0) {
                System.err.print(n + ":");
            }
            if (string != null || n >= 0) {
                System.err.print(" ");
            }
            System.err.println(sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            System.err.println(sAXException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
        return false;
    }

    public static InputSource fileInputSource(String string) {
        return Driver.fileInputSource(new File(string));
    }

    public static InputSource fileInputSource(File file) {
        String string = file.getAbsolutePath();
        String string2 = System.getProperty("file.separator");
        if (string2 != null && string2.length() == 1) {
            string = string.replace(string2.charAt(0), '/');
        }
        if (string.length() > 0 && string.charAt(0) != '/') {
            string = '/' + string;
        }
        try {
            return new InputSource(new URL("file", "", string).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }
}

