
type t = Automate.t

val make : string -> string -> t
val exit : t -> unit

val run_monotone_diff : 
  t ->
  <push : string -> unit; pop : unit -> unit; ..> ->
  ([>`SUB_PROC_ERROR of string | `OUTPUT of string] -> unit) ->
  string * string -> unit

val run_monotone_count_branches : t -> (string -> int)

val escape_selector : string -> string

val branches : t -> string list
val get_revision : t -> string -> Viz_types.node_data
val get_certs_and_revision : t -> string -> Viz_types.node_data
val cert_value : t -> string -> string -> string list
val select : t -> string -> string list
val agraph : t -> Viz_types.query -> Viz_types.agraph

val select_async : 
  t ->
  ([>`SUB_PROC_ERROR of string | `IDS of string list] -> unit) ->
  string list -> Automate.command_id list
