/*
 * Modest Maps JS v0.21.0
 * http://modestmaps.com/
 *
 * Copyright (c) 2011 Stamen Design, All Rights Reserved.
 *
 * Open source under the BSD License.
 * http://creativecommons.org/licenses/BSD/
 *
 * Versioned using Semantic Versioning (v.major.minor.patch)
 * See CHANGELOG and http://semver.org/ for more details.
 * 
 */
if(!com){var com={};if(!com.modestmaps){com.modestmaps={}}}(function(a){a.extend=function(d,b){for(var c in b.prototype){if(typeof d.prototype[c]=="undefined"){d.prototype[c]=b.prototype[c]}}return d};a.getFrame=function(){return function(b){(window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(c){window.setTimeout(function(){c(+new Date())},10)})(b)}}();a.transformProperty=(function(d){if(!this.document){return}var c=document.documentElement.style;for(var b=0;b<d.length;b++){if(d[b] in c){return d[b]}}return false})(["transformProperty","WebkitTransform","OTransform","MozTransform","msTransform"]);a.matrixString=function(b){if(b.scale*b.width%1){b.scale+=(1-b.scale*b.width%1)/b.width}if(a._browser.webkit3d){return"matrix3d("+[(b.scale||"1"),"0,0,0,0",(b.scale||"1"),"0,0","0,0,1,0",(b.x+(((b.width*b.scale)-b.width)/2)).toFixed(4),(b.y+(((b.height*b.scale)-b.height)/2)).toFixed(4),0,1].join(",")+")"}else{var c=(a.transformProperty=="MozTransform")?"px":"";return"matrix("+[(b.scale||"1"),0,0,(b.scale||"1"),(b.x+(((b.width*b.scale)-b.width)/2))+c,(b.y+(((b.height*b.scale)-b.height)/2))+c].join(",")+")"}};a._browser=(function(b){return{webkit:("WebKitCSSMatrix" in b),webkit3d:("WebKitCSSMatrix" in b)&&("m11" in new WebKitCSSMatrix())}})(this);a.moveElement=function(d,b){if(a.transformProperty){var c=a.matrixString(b);if(d[a.transformProperty]!==c){d.style[a.transformProperty]=d[a.transformProperty]=c}}else{d.style.left=b.x+"px";d.style.top=b.y+"px";d.style.width=Math.ceil(b.width*b.scale)+"px";d.style.height=Math.ceil(b.height*b.scale)+"px"}};a.cancelEvent=function(b){b.cancelBubble=true;b.cancel=true;b.returnValue=false;if(b.stopPropagation){b.stopPropagation()}if(b.preventDefault){b.preventDefault()}return false};a.addEvent=function(d,c,b){if(d.attachEvent){d["e"+c+b]=b;d[c+b]=function(){d["e"+c+b](window.event)};d.attachEvent("on"+c,d[c+b])}else{d.addEventListener(c,b,false);if(c=="mousewheel"){d.addEventListener("DOMMouseScroll",b,false)}}};a.bind=function(d,e){var f=Array.prototype.slice;var c=Function.prototype.bind;if(d.bind===c&&c){return c.apply(d,f.call(arguments,1))}var b=f.call(arguments,2);return function(){return d.apply(e,b.concat(f.call(arguments)))}};a.removeEvent=function(d,c,b){if(d.detachEvent){d.detachEvent("on"+c,d[c+b]);d[c+b]=null}else{d.removeEventListener(c,b,false);if(c=="mousewheel"){d.removeEventListener("DOMMouseScroll",b,false)}}};a.getStyle=function(c,b){if(c.currentStyle){return c.currentStyle[b]}else{if(window.getComputedStyle){return document.defaultView.getComputedStyle(c,null).getPropertyValue(b)}}};a.Point=function(b,c){this.x=parseFloat(b);this.y=parseFloat(c)};a.Point.prototype={x:0,y:0,toString:function(){return"("+this.x.toFixed(3)+", "+this.y.toFixed(3)+")"}};a.Point.distance=function(e,d){var c=(d.x-e.x);var b=(d.y-e.y);return Math.sqrt(c*c+b*b)};a.Point.interpolate=function(f,e,d){var c=f.x+(e.x-f.x)*d;var b=f.y+(e.y-f.y)*d;return new a.Point(c,b)};a.Coordinate=function(d,b,c){this.row=d;this.column=b;this.zoom=c};a.Coordinate.prototype={row:0,column:0,zoom:0,toString:function(){return"("+this.row.toFixed(3)+", "+this.column.toFixed(3)+" @"+this.zoom.toFixed(3)+")"},toKey:function(){return[this.zoom,this.row,this.column].join(",")},copy:function(){return new a.Coordinate(this.row,this.column,this.zoom)},container:function(){return new a.Coordinate(Math.floor(this.row),Math.floor(this.column),Math.floor(this.zoom))},zoomTo:function(b){var c=Math.pow(2,b-this.zoom);return new a.Coordinate(this.row*c,this.column*c,b)},zoomBy:function(c){var b=Math.pow(2,c);return new a.Coordinate(this.row*b,this.column*b,this.zoom+c)},up:function(b){if(b===undefined){b=1}return new a.Coordinate(this.row-b,this.column,this.zoom)},right:function(b){if(b===undefined){b=1}return new a.Coordinate(this.row,this.column+b,this.zoom)},down:function(b){if(b===undefined){b=1}return new a.Coordinate(this.row+b,this.column,this.zoom)},left:function(b){if(b===undefined){b=1}return new a.Coordinate(this.row,this.column-b,this.zoom)}};a.Location=function(b,c){this.lat=parseFloat(b);this.lon=parseFloat(c)};a.Location.prototype={lat:0,lon:0,toString:function(){return"("+this.lat.toFixed(3)+", "+this.lon.toFixed(3)+")"}};a.Location.distance=function(i,h,b){if(!b){b=6378000}var o=Math.PI/180,g=i.lat*o,n=i.lon*o,f=h.lat*o,m=h.lon*o,l=Math.cos(g)*Math.cos(n)*Math.cos(f)*Math.cos(m),k=Math.cos(g)*Math.sin(n)*Math.cos(f)*Math.sin(m),j=Math.sin(g)*Math.sin(f);return Math.acos(l+k+j)*b};a.Location.interpolate=function(i,g,m){if(i.lat===g.lat&&i.lon===g.lon){return new a.Location(i.lat,i.lon)}var s=Math.PI/180,k=i.lat*s,n=i.lon*s,j=g.lat*s,l=g.lon*s;var o=2*Math.asin(Math.sqrt(Math.pow(Math.sin((k-j)/2),2)+Math.cos(k)*Math.cos(j)*Math.pow(Math.sin((n-l)/2),2)));var t=Math.atan2(Math.sin(n-l)*Math.cos(j),Math.cos(k)*Math.sin(j)-Math.sin(k)*Math.cos(j)*Math.cos(n-l))/-(Math.PI/180);t=t<0?360+t:t;var e=Math.sin((1-m)*o)/Math.sin(o);var b=Math.sin(m*o)/Math.sin(o);var r=e*Math.cos(k)*Math.cos(n)+b*Math.cos(j)*Math.cos(l);var q=e*Math.cos(k)*Math.sin(n)+b*Math.cos(j)*Math.sin(l);var p=e*Math.sin(k)+b*Math.sin(j);var c=Math.atan2(p,Math.sqrt(Math.pow(r,2)+Math.pow(q,2)));var h=Math.atan2(q,r);return new a.Location(c/s,h/s)};a.Transformation=function(d,f,b,c,e,g){this.ax=d;this.bx=f;this.cx=b;this.ay=c;this.by=e;this.cy=g};a.Transformation.prototype={ax:0,bx:0,cx:0,ay:0,by:0,cy:0,transform:function(b){return new a.Point(this.ax*b.x+this.bx*b.y+this.cx,this.ay*b.x+this.by*b.y+this.cy)},untransform:function(b){return new a.Point((b.x*this.by-b.y*this.bx-this.cx*this.by+this.cy*this.bx)/(this.ax*this.by-this.ay*this.bx),(b.x*this.ay-b.y*this.ax-this.cx*this.ay+this.cy*this.ax)/(this.bx*this.ay-this.by*this.ax))}};a.deriveTransformation=function(l,k,f,e,b,o,h,g,d,c,n,m){var j=a.linearSolution(l,k,f,b,o,h,d,c,n);var i=a.linearSolution(l,k,e,b,o,g,d,c,m);return new a.Transformation(j[0],j[1],j[2],i[0],i[1],i[2])};a.linearSolution=function(f,o,i,e,n,h,d,m,g){f=parseFloat(f);o=parseFloat(o);i=parseFloat(i);e=parseFloat(e);n=parseFloat(n);h=parseFloat(h);d=parseFloat(d);m=parseFloat(m);g=parseFloat(g);var l=(((h-g)*(o-n))-((i-h)*(n-m)))/(((e-d)*(o-n))-((f-e)*(n-m)));var k=(((h-g)*(f-e))-((i-h)*(e-d)))/(((n-m)*(f-e))-((o-n)*(e-d)));var j=i-(f*l)-(o*k);return[l,k,j]};a.Projection=function(c,b){if(!b){b=new a.Transformation(1,0,0,0,1,0)}this.zoom=c;this.transformation=b};a.Projection.prototype={zoom:0,transformation:null,rawProject:function(b){throw"Abstract method not implemented by subclass."},rawUnproject:function(b){throw"Abstract method not implemented by subclass."},project:function(b){b=this.rawProject(b);if(this.transformation){b=this.transformation.transform(b)}return b},unproject:function(b){if(this.transformation){b=this.transformation.untransform(b)}b=this.rawUnproject(b);return b},locationCoordinate:function(c){var b=new a.Point(Math.PI*c.lon/180,Math.PI*c.lat/180);b=this.project(b);return new a.Coordinate(b.y,b.x,this.zoom)},coordinateLocation:function(c){c=c.zoomTo(this.zoom);var b=new a.Point(c.column,c.row);b=this.unproject(b);return new a.Location(180*b.y/Math.PI,180*b.x/Math.PI)}};a.LinearProjection=function(c,b){a.Projection.call(this,c,b)};a.LinearProjection.prototype={rawProject:function(b){return new a.Point(b.x,b.y)},rawUnproject:function(b){return new a.Point(b.x,b.y)}};a.extend(a.LinearProjection,a.Projection);a.MercatorProjection=function(c,b){a.Projection.call(this,c,b)};a.MercatorProjection.prototype={rawProject:function(b){return new a.Point(b.x,Math.log(Math.tan(0.25*Math.PI+0.5*b.y)))},rawUnproject:function(b){return new a.Point(b.x,2*Math.atan(Math.pow(Math.E,b.y))-0.5*Math.PI)}};a.extend(a.MercatorProjection,a.Projection);a.MapProvider=function(b){if(b){this.getTileUrl=b}};a.MapProvider.prototype={projection:new a.MercatorProjection(0,a.deriveTransformation(-Math.PI,Math.PI,0,0,Math.PI,Math.PI,1,0,-Math.PI,-Math.PI,0,1)),tileWidth:256,tileHeight:256,topLeftOuterLimit:new a.Coordinate(0,0,0),bottomRightInnerLimit:new a.Coordinate(1,1,0).zoomTo(18),getTileUrl:function(b){throw"Abstract method not implemented by subclass."},locationCoordinate:function(b){return this.projection.locationCoordinate(b)},coordinateLocation:function(b){return this.projection.coordinateLocation(b)},outerLimits:function(){return[this.topLeftOuterLimit.copy(),this.bottomRightInnerLimit.copy()]},setZoomRange:function(c,b){this.topLeftOuterLimit=this.topLeftOuterLimit.zoomTo(c);this.bottomRightInnerLimit=this.bottomRightInnerLimit.zoomTo(b)},sourceCoordinate:function(g){var b=this.topLeftOuterLimit.zoomTo(g.zoom);var d=this.bottomRightInnerLimit.zoomTo(g.zoom);var c=d.row-b.row;if(g.row<0|g.row>=c){return null}var f=d.column-b.column;var e=g.column%f;while(e<0){e+=f}return new a.Coordinate(g.row,e,g.zoom)}};a.TemplatedMapProvider=function(c,b){a.MapProvider.call(this,function(f){f=this.sourceCoordinate(f);if(!f){return null}var d=c;if(b&&b.length&&d.indexOf("{S}")>=0){var e=parseInt(f.zoom+f.row+f.column,10)%b.length;d=d.replace("{S}",b[e])}return d.replace("{Z}",f.zoom.toFixed(0)).replace("{X}",f.column.toFixed(0)).replace("{Y}",f.row.toFixed(0))})};a.extend(a.TemplatedMapProvider,a.MapProvider);a.getMousePoint=function(f,d){var b=new a.Point(f.clientX,f.clientY);b.x+=document.body.scrollLeft+document.documentElement.scrollLeft;b.y+=document.body.scrollTop+document.documentElement.scrollTop;for(var c=d.parent;c;c=c.offsetParent){b.x-=c.offsetLeft;b.y-=c.offsetTop}return b};a.MouseWheelHandler=function(b){if(b!==undefined){this.init(b)}};a.MouseWheelHandler.prototype={init:function(b){this.map=b;this._mouseWheel=a.bind(this.mouseWheel,this);a.addEvent(b.parent,"mousewheel",this._mouseWheel)},remove:function(){a.removeEvent(this.map.parent,"mousewheel",this._mouseWheel)},mouseWheel:function(d){var f=0;this.prevTime=this.prevTime||new Date().getTime();if(d.wheelDelta){f=d.wheelDelta}else{if(d.detail){f=-d.detail}}var c=new Date().getTime()-this.prevTime;if(Math.abs(f)>0&&(c>200)){var b=a.getMousePoint(d,this.map);this.map.zoomByAbout(f>0?1:-1,b);this.prevTime=new Date().getTime()}return a.cancelEvent(d)}};a.DoubleClickHandler=function(b){if(b!==undefined){this.init(b)}};a.DoubleClickHandler.prototype={init:function(b){this.map=b;this._doubleClick=a.bind(this.doubleClick,this);a.addEvent(b.parent,"dblclick",this._doubleClick)},remove:function(){a.removeEvent(this.map.parent,"dblclick",this._doubleClick)},doubleClick:function(c){var b=a.getMousePoint(c,this.map);this.map.zoomByAbout(c.shiftKey?-1:1,b);return a.cancelEvent(c)}};a.DragHandler=function(b){if(b!==undefined){this.init(b)}};a.DragHandler.prototype={init:function(b){this.map=b;this._mouseDown=a.bind(this.mouseDown,this);a.addEvent(b.parent,"mousedown",this._mouseDown)},remove:function(){a.removeEvent(this.map.parent,"mousedown",this._mouseDown)},mouseDown:function(b){a.addEvent(document,"mouseup",this._mouseUp=a.bind(this.mouseUp,this));a.addEvent(document,"mousemove",this._mouseMove=a.bind(this.mouseMove,this));this.prevMouse=new a.Point(b.clientX,b.clientY);this.map.parent.style.cursor="move";return a.cancelEvent(b)},mouseMove:function(b){if(this.prevMouse){this.map.panBy(b.clientX-this.prevMouse.x,b.clientY-this.prevMouse.y);this.prevMouse.x=b.clientX;this.prevMouse.y=b.clientY;this.prevMouse.t=+new Date()}return a.cancelEvent(b)},mouseUp:function(b){a.removeEvent(document,"mouseup",this._mouseUp);a.removeEvent(document,"mousemove",this._mouseMove);this.prevMouse=null;this.map.parent.style.cursor="";return a.cancelEvent(b)}};a.MouseHandler=function(b){if(b!==undefined){this.init(b)}};a.MouseHandler.prototype={init:function(b){this.map=b;this.handlers=[new a.DragHandler(b),new a.DoubleClickHandler(b),new a.MouseWheelHandler(b)]},remove:function(){for(var b=0;b<this.handlers.length;b++){this.handlers[b].remove()}}};a.TouchHandler=function(){};a.TouchHandler.prototype={maxTapTime:250,maxTapDistance:30,maxDoubleTapDelay:350,locations:{},taps:[],wasPinching:false,lastPinchCenter:null,init:function(c,b){this.map=c;b=b||{};this._touchStartMachine=a.bind(this.touchStartMachine,this);this._touchMoveMachine=a.bind(this.touchMoveMachine,this);this._touchEndMachine=a.bind(this.touchEndMachine,this);a.addEvent(c.parent,"touchstart",this._touchStartMachine);a.addEvent(c.parent,"touchmove",this._touchMoveMachine);a.addEvent(c.parent,"touchend",this._touchEndMachine);this.options={};this.options.snapToZoom=b.snapToZoom||true},remove:function(){a.removeEvent(this.map.parent,"touchstart",this._touchStartMachine);a.removeEvent(this.map.parent,"touchmove",this._touchMoveMachine);a.removeEvent(this.map.parent,"touchend",this._touchEndMachine)},updateTouches:function(f){for(var d=0;d<f.touches.length;d+=1){var c=f.touches[d];if(c.identifier in this.locations){var b=this.locations[c.identifier];b.x=c.screenX;b.y=c.screenY;b.scale=f.scale}else{this.locations[c.identifier]={scale:f.scale,startPos:{x:c.screenX,y:c.screenY},x:c.screenX,y:c.screenY,time:new Date().getTime()}}}},sameTouch:function(b,c){return(b&&b.touch)&&(c.identifier==b.touch.identifier)},touchStartMachine:function(b){this.updateTouches(b);return a.cancelEvent(b)},touchMoveMachine:function(b){switch(b.touches.length){case 1:this.onPanning(b.touches[0]);break;case 2:this.onPinching(b);break}this.updateTouches(b);return a.cancelEvent(b)},touchEndMachine:function(l){var c=new Date().getTime();if(l.touches.length===0&&this.wasPinching){this.onPinched(this.lastPinchCenter)}for(var h=0;h<l.changedTouches.length;h+=1){var o=l.changedTouches[h],k=this.locations[o.identifier];if(!k||k.wasPinch){continue}var n={x:o.screenX,y:o.screenY},f=c-k.time,d=a.Point.distance(n,k.startPos);if(d>this.maxTapDistance){}else{if(f>this.maxTapTime){n.end=c;n.duration=f;this.onHold(n)}else{n.time=c;this.onTap(n)}}}var m={};for(var g=0;g<l.touches.length;g++){m[l.touches[g].identifier]=true}for(var b in this.locations){if(!(b in m)){delete m[b]}}return a.cancelEvent(l)},onHold:function(b){},onTap:function(b){if(this.taps.length&&(b.time-this.taps[0].time)<this.maxDoubleTapDelay){this.onDoubleTap(b);this.taps=[];return}this.taps=[b]},onDoubleTap:function(c){var e=this.map.getZoom(),f=Math.round(e)+1,b=f-e;var d=new a.Point(c.x,c.y);this.map.zoomByAbout(b,d)},onPanning:function(d){var c={x:d.screenX,y:d.screenY},b=this.locations[d.identifier];this.map.panBy(c.x-b.x,c.y-b.y)},onPinching:function(i){var h=i.touches[0],g=i.touches[1],k=new a.Point(h.screenX,h.screenY),j=new a.Point(g.screenX,g.screenY),d=this.locations[h.identifier],c=this.locations[g.identifier];d.wasPinch=true;c.wasPinch=true;var b=a.Point.interpolate(k,j,0.5);this.map.zoomByAbout(Math.log(i.scale)/Math.LN2-Math.log(d.scale)/Math.LN2,b);var f=a.Point.interpolate(d,c,0.5);this.map.panBy(b.x-f.x,b.y-f.y);this.wasPinching=true;this.lastPinchCenter=b},onPinched:function(b){if(this.options.snapToZoom){var c=this.map.getZoom(),d=Math.round(c);this.map.zoomByAbout(d-c,b)}this.wasPinching=false}};a.CallbackManager=function(b,d){this.owner=b;this.callbacks={};for(var c=0;c<d.length;c++){this.callbacks[d[c]]=[]}};a.CallbackManager.prototype={owner:null,callbacks:null,addCallback:function(b,c){if(typeof(c)=="function"&&this.callbacks[b]){this.callbacks[b].push(c)}},removeCallback:function(e,f){if(typeof(f)=="function"&&this.callbacks[e]){var c=this.callbacks[e],b=c.length;for(var d=0;d<b;d++){if(c[d]===f){c.splice(d,1);break}}}},dispatchCallback:function(d,c){if(this.callbacks[d]){for(var b=0;b<this.callbacks[d].length;b+=1){try{this.callbacks[d][b](this.owner,c)}catch(f){}}}}};a.RequestManager=function(){this.loadingBay=document.createDocumentFragment();this.requestsById={};this.openRequestCount=0;this.maxOpenRequests=4;this.requestQueue=[];this.callbackManager=new a.CallbackManager(this,["requestcomplete"])};a.RequestManager.prototype={loadingBay:null,requestsById:null,requestQueue:null,openRequestCount:null,maxOpenRequests:null,callbackManager:null,addCallback:function(b,c){this.callbackManager.addCallback(b,c)},removeCallback:function(b,c){this.callbackManager.removeCallback(b,c)},dispatchCallback:function(c,b){this.callbackManager.dispatchCallback(c,b)},clear:function(){this.clearExcept({})},clearExcept:function(f){for(var e=0;e<this.requestQueue.length;e++){var g=this.requestQueue[e];if(g&&!(g.id in f)){this.requestQueue[e]=null}}var b=this.loadingBay.childNodes;for(var d=b.length-1;d>=0;d--){var c=b[d];if(!(c.id in f)){this.loadingBay.removeChild(c);this.openRequestCount--;c.src=c.coord=c.onload=c.onerror=null}}for(var k in this.requestsById){if(this.requestsById.hasOwnProperty(k)){if(!(k in f)){var h=this.requestsById[k];delete this.requestsById[k];if(h!==null){h=h.id=h.coord=h.url=null}}}}},hasRequest:function(b){return(b in this.requestsById)},requestTile:function(e,d,b){if(!(e in this.requestsById)){var c={id:e,coord:d.copy(),url:b};this.requestsById[e]=c;if(b){this.requestQueue.push(c)}}},getProcessQueue:function(){if(!this._processQueue){var b=this;this._processQueue=function(){b.processQueue()}}return this._processQueue},processQueue:function(d){if(d&&this.requestQueue.length>8){this.requestQueue.sort(d)}while(this.openRequestCount<this.maxOpenRequests&&this.requestQueue.length>0){var c=this.requestQueue.pop();if(c){this.openRequestCount++;var b=document.createElement("img");b.id=c.id;b.style.position="absolute";b.coord=c.coord;this.loadingBay.appendChild(b);b.onload=b.onerror=this.getLoadComplete();b.src=c.url;c=c.id=c.coord=c.url=null}}},_loadComplete:null,getLoadComplete:function(){if(!this._loadComplete){var b=this;this._loadComplete=function(d){d=d||window.event;var c=d.srcElement||d.target;c.onload=c.onerror=null;b.loadingBay.removeChild(c);b.openRequestCount--;delete b.requestsById[c.id];if(d.type==="load"&&(c.complete||(c.readyState&&c.readyState=="complete"))){b.dispatchCallback("requestcomplete",c)}else{c.src=null}setTimeout(b.getProcessQueue(),0)}}return this._loadComplete}};a.Map=function(e,h,f,g){if(typeof e=="string"){e=document.getElementById(e);if(!e){throw"The ID provided to modest maps could not be found."}}this.parent=e;this.parent.style.padding="0";this.parent.style.overflow="hidden";var b=a.getStyle(this.parent,"position");if(b!="relative"&&b!="absolute"){this.parent.style.position="relative"}if(!f){f=new a.Point(this.parent.offsetWidth,this.parent.offsetHeight);this.autoSize=true;var c=this;a.addEvent(window,"resize",this.windowResize())}else{this.autoSize=false;this.parent.style.width=Math.round(f.x)+"px";this.parent.style.height=Math.round(f.y)+"px"}this.dimensions=f;this.requestManager=new a.RequestManager(this.parent);this.requestManager.addCallback("requestcomplete",this.getTileComplete());this.layers={};this.layerParent=document.createElement("div");this.layerParent.id=this.parent.id+"-layers";this.layerParent.style.cssText="position: absolute; top: 0px; left: 0px; width: 100%; height: 100%; margin: 0; padding: 0; z-index: 0";this.parent.appendChild(this.layerParent);this.coordinate=new a.Coordinate(0.5,0.5,0);this.setProvider(h);this.enablePyramidLoading=false;this.callbackManager=new a.CallbackManager(this,["zoomed","panned","centered","extentset","resized","drawn"]);if(g===undefined){this.eventHandlers=[];this.eventHandlers.push(new a.MouseHandler(this))}else{this.eventHandlers=g;if(g instanceof Array){for(var d=0;d<g.length;d++){g[d].init(this)}}}};a.Map.prototype={parent:null,provider:null,dimensions:null,coordinate:null,tiles:null,layers:null,layerParent:null,requestManager:null,tileCacheSize:null,maxTileCacheSize:null,recentTiles:null,recentTilesById:null,recentTileSize:null,callbackManager:null,eventHandlers:null,autoSize:null,toString:function(){return"Map(#"+this.parent.id+")"},addCallback:function(b,c){this.callbackManager.addCallback(b,c);return this},removeCallback:function(b,c){this.callbackManager.removeCallback(b,c);return this},dispatchCallback:function(c,b){this.callbackManager.dispatchCallback(c,b);return this},windowResize:function(){if(!this._windowResize){var b=this;this._windowResize=function(c){b.dimensions=new a.Point(b.parent.offsetWidth,b.parent.offsetHeight);b.draw();b.dispatchCallback("resized",[b.dimensions])}}return this._windowResize},zoomBy:function(b){this.coordinate=this.enforceLimits(this.coordinate.zoomBy(b));a.getFrame(this.getRedraw());this.dispatchCallback("zoomed",b);return this},zoomIn:function(){return this.zoomBy(1)},zoomOut:function(){return this.zoomBy(-1)},setZoom:function(b){return this.zoomBy(b-this.coordinate.zoom)},zoomByAbout:function(c,b){var e=this.pointLocation(b);this.coordinate=this.enforceLimits(this.coordinate.zoomBy(c));var d=this.locationPoint(e);this.dispatchCallback("zoomed",c);return this.panBy(b.x-d.x,b.y-d.y)},panBy:function(c,b){this.coordinate.column-=c/this.provider.tileWidth;this.coordinate.row-=b/this.provider.tileHeight;this.coordinate=this.enforceLimits(this.coordinate);a.getFrame(this.getRedraw());this.dispatchCallback("panned",[c,b]);return this},panLeft:function(){return this.panBy(100,0)},panRight:function(){return this.panBy(-100,0)},panDown:function(){return this.panBy(0,-100)},panUp:function(){return this.panBy(0,100)},setCenter:function(b){return this.setCenterZoom(b,this.coordinate.zoom)},setCenterZoom:function(b,c){this.coordinate=this.provider.locationCoordinate(b).zoomTo(parseFloat(c)||0);this.draw();this.dispatchCallback("centered",[b,c]);return this},setExtent:function(q,g){var t,k;for(var l=0;l<q.length;l++){var m=this.provider.locationCoordinate(q[l]);if(t){t.row=Math.min(t.row,m.row);t.column=Math.min(t.column,m.column);t.zoom=Math.min(t.zoom,m.zoom);k.row=Math.max(k.row,m.row);k.column=Math.max(k.column,m.column);k.zoom=Math.max(k.zoom,m.zoom)}else{t=m.copy();k=m.copy()}}var j=this.dimensions.x+1;var h=this.dimensions.y+1;var n=(k.column-t.column)/(j/this.provider.tileWidth);var r=Math.log(n)/Math.log(2);var o=t.zoom-(g?r:Math.ceil(r));var p=(k.row-t.row)/(h/this.provider.tileHeight);var d=Math.log(p)/Math.log(2);var e=t.zoom-(g?d:Math.ceil(d));var b=Math.min(o,e);b=Math.min(b,this.provider.outerLimits()[1].zoom);b=Math.max(b,this.provider.outerLimits()[0].zoom);var c=(t.row+k.row)/2;var s=(t.column+k.column)/2;var f=t.zoom;this.coordinate=new a.Coordinate(c,s,f).zoomTo(b);this.draw();this.dispatchCallback("extentset",q);return this},setSize:function(c,b){if(c.hasOwnProperty("x")&&c.hasOwnProperty("y")){this.dimensions=c}else{if(b!==undefined&&!isNaN(b)){this.dimensions=new a.Point(c,b)}}this.parent.style.width=Math.round(this.dimensions.x)+"px";this.parent.style.height=Math.round(this.dimensions.y)+"px";this.draw();this.dispatchCallback("resized",[this.dimensions]);return this},coordinatePoint:function(c){if(c.zoom!=this.coordinate.zoom){c=c.zoomTo(this.coordinate.zoom)}var b=new a.Point(this.dimensions.x/2,this.dimensions.y/2);b.x+=this.provider.tileWidth*(c.column-this.coordinate.column);b.y+=this.provider.tileHeight*(c.row-this.coordinate.row);return b},pointCoordinate:function(b){var c=this.coordinate.copy();c.column+=(b.x-this.dimensions.x/2)/this.provider.tileWidth;c.row+=(b.y-this.dimensions.y/2)/this.provider.tileHeight;return c},locationPoint:function(b){return this.coordinatePoint(this.provider.locationCoordinate(b))},pointLocation:function(b){return this.provider.coordinateLocation(this.pointCoordinate(b))},getExtent:function(){var b=[];b.push(this.pointLocation(new a.Point(0,0)));b.push(this.pointLocation(this.dimensions));return b},getCenter:function(){return this.provider.coordinateLocation(this.coordinate)},getZoom:function(){return this.coordinate.zoom},setProvider:function(d){var e=false;if(this.provider===null){e=true}if(!e){this.requestManager.clear();for(var b in this.layers){if(this.layers.hasOwnProperty(b)){var c=this.layers[b];while(c.firstChild){c.removeChild(c.firstChild)}}}}this.tiles={};this.tileCacheSize=0;this.maxTileCacheSize=64;this.recentTiles=[];this.recentTilesById={};this.provider=d;if(!e){this.draw()}return this},enforceLimits:function(e){e=e.copy();var c=this.provider.outerLimits();if(c){var d=c[0].zoom;var b=c[1].zoom;if(e.zoom<d){e=e.zoomTo(d)}else{if(e.zoom>b){e=e.zoomTo(b)}}}return e},draw:function(){this.coordinate=this.enforceLimits(this.coordinate);var p=Math.round(this.coordinate.zoom);if(this.dimensions.x<=0||this.dimensions.y<=0){if(this.autoSize){var r=this.parent.offsetWidth,C=this.parent.offsetHeight;this.dimensions=new a.Point(r,C);if(r<=0||C<=0){return}}else{return}}var x=this.pointCoordinate(new a.Point(0,0)).zoomTo(p).container();var u=this.pointCoordinate(this.dimensions).zoomTo(p).container().right().down();var l=0;if(l){x=x.left(l).up(l);u=u.right(l).down(l)}var I={};var m=this.createOrGetLayer(x.zoom);var e=x.copy();for(e.column=x.column;e.column<=u.column;e.column+=1){for(e.row=x.row;e.row<=u.row;e.row+=1){var n=e.toKey();I[n]=true;if(n in this.tiles){var L=this.tiles[n];if(L.parentNode!=m){m.appendChild(L)}}else{if(!this.requestManager.hasRequest(n)){var o=this.provider.getTileUrl(e);this.requestManager.requestTile(n,e,o)}var s=false;var H=e.zoom;for(var t=1;t<=H;t++){var v=e.zoomBy(-t).container();var B=v.toKey();if(this.enablePyramidLoading){I[B]=true;var D=this.createOrGetLayer(v.zoom);if(B in this.tiles){var y=this.tiles[B];if(y.parentNode!=D){D.appendChild(y)}}else{if(!this.requestManager.hasRequest(B)){this.requestManager.requestTile(B,v,this.provider.getTileUrl(v))}}}else{if(B in this.tiles){I[B]=true;s=true;break}}}if(!s&&!this.enablePyramidLoading){var k=e.zoomBy(1);I[k.toKey()]=true;k.column+=1;I[k.toKey()]=true;k.row+=1;I[k.toKey()]=true;k.column-=1;I[k.toKey()]=true}}}}for(var M in this.layers){if(this.layers.hasOwnProperty(M)){var d=parseInt(M,10);if(d>=x.zoom-5&&d<x.zoom+2){continue}var K=this.layers[M];K.style.display="none";var G=K.getElementsByTagName("img");for(var z=G.length-1;z>=0;z--){K.removeChild(G[z])}}}var f=new Date().getTime();var E=x.zoom-5;var g=x.zoom+2;for(var A=E;A<g;A++){var K=this.layers[A];if(!K){continue}var J=1,c=this.coordinate.copy(),G=K.getElementsByTagName("img");if(G.length>0){K.style.display="block";J=Math.pow(2,this.coordinate.zoom-A);c=c.zoomTo(A)}else{K.style.display="none"}var b=this.provider.tileWidth*J,q=this.provider.tileHeight*J,F=new a.Point(this.dimensions.x/2,this.dimensions.y/2);for(var z=G.length-1;z>=0;z--){var L=G[z];if(!I[L.id]){K.removeChild(L)}else{a.moveElement(L,{x:Math.round(F.x+(L.coord.column-c.column)*b),y:Math.round(F.y+(L.coord.row-c.row)*q),scale:J,width:this.provider.tileWidth,height:this.provider.tileHeight});this.recentTilesById[L.id].lastTouchedTime=f}}}this.requestManager.clearExcept(I);this.requestManager.processQueue(this.getCenterDistanceCompare());this.checkCache();this.dispatchCallback("drawn")},_tileComplete:null,getTileComplete:function(){if(!this._tileComplete){var b=this;this._tileComplete=function(g,h){b.tiles[h.id]=h;b.tileCacheSize++;var e={id:h.id,lastTouchedTime:new Date().getTime()};b.recentTilesById[h.id]=e;b.recentTiles.push(e);var f=b.coordinate.zoomTo(h.coord.zoom);var j=Math.pow(2,b.coordinate.zoom-h.coord.zoom);var d=((b.dimensions.x/2)+(h.coord.column-f.column)*b.provider.tileWidth*j);var c=((b.dimensions.y/2)+(h.coord.row-f.row)*b.provider.tileHeight*j);a.moveElement(h,{x:Math.round(d),y:Math.round(c),scale:j,width:b.provider.tileWidth,height:b.provider.tileHeight});var i=b.layers[h.coord.zoom];i.appendChild(h);h.className="map-tile-loaded";if(Math.round(b.coordinate.zoom)===h.coord.zoom){i.style.display="block"}b.requestRedraw()}}return this._tileComplete},_redrawTimer:undefined,requestRedraw:function(){if(!this._redrawTimer){this._redrawTimer=setTimeout(this.getRedraw(),1000)}},_redraw:null,getRedraw:function(){if(!this._redraw){var b=this;this._redraw=function(){b.draw();b._redrawTimer=0}}return this._redraw},createOrGetLayer:function(c){if(c in this.layers){return this.layers[c]}var b=document.createElement("div");b.id=this.parent.id+"-zoom-"+c;b.style.cssText=this.layerParent.style.cssText;b.style.zIndex=c;this.layerParent.appendChild(b);this.layers[c]=b;return b},checkCache:function(){var f=this.parent.getElementsByTagName("img").length;var d=Math.max(f,this.maxTileCacheSize);if(this.tileCacheSize>d){this.recentTiles.sort(function(h,g){return g.lastTouchedTime<h.lastTouchedTime?-1:g.lastTouchedTime>h.lastTouchedTime?1:0})}while(this.tileCacheSize>d){var c=this.recentTiles.pop();var b=new Date().getTime();delete this.recentTilesById[c.id];var e=this.tiles[c.id];if(e.parentNode){alert("Gah: trying to removing cached tile even though it's still in the DOM")}else{delete this.tiles[c.id];this.tileCacheSize--}}},getCenterDistanceCompare:function(){var b=this.coordinate.zoomTo(Math.round(this.coordinate.zoom));return function(e,d){if(e&&d){var g=e.coord;var f=d.coord;if(g.zoom==f.zoom){var c=Math.abs(b.row-g.row-0.5)+Math.abs(b.column-g.column-0.5);var h=Math.abs(b.row-f.row-0.5)+Math.abs(b.column-f.column-0.5);return c<h?1:c>h?-1:0}else{return g.zoom<f.zoom?1:g.zoom>f.zoom?-1:0}}return e?1:d?-1:0}},destroy:function(){this.requestManager.clear();for(var b=0;b<this.eventHandlers.length;b++){this.eventHandlers[b].remove()}this.parent.removeChild(this.layerParent);a.removeEvent(window,"resize",this.windowResize());return this}};if(typeof module!=="undefined"&&module.exports){module.exports={Point:a.Point,Projection:a.Projection,MercatorProjection:a.MercatorProjection,LinearProjection:a.LinearProjection,Transformation:a.Transformation,Location:a.Location,MapProvider:a.MapProvider,TemplatedMapProvider:a.TemplatedMapProvider,Coordinate:a.Coordinate}}})(com.modestmaps);