/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQFolderItemProperty_H
#define MvQFolderItemProperty_H

#include <QFont>
#include <QMap>
#include <QFontMetrics> 

class IconObject;

#include "Desktop.h"

class MvQAbstractIconItemProperty
{
public:   	
  	MvQAbstractIconItemProperty();
    virtual ~MvQAbstractIconItemProperty() {}

	int iconSize() const {return iconSize_;}
	QFont font() const {return font_;}
	float scaling() const {return scaling_;}
	int textHeight();
	int textOffset() const {return textOffset_;}	
        bool setIconSize(int);
	int paddingX() const {return paddingX_;}
	int paddingY() const {return paddingY_;}

	virtual QPoint position(QString,QPoint)=0;
	virtual QPoint positionFromHotSpot(QString name, QPoint pos,QPointF hotSpotAtPos)=0;
	virtual QPoint referencePosition(QString,QPoint)=0;
	virtual QPoint adjsutReferencePosition(QString,QString,QPoint)=0;	
	virtual QSize size(QString)=0;
	virtual QRect textRect(QString)=0;
	virtual QRect iconRect(QString)=0;
	virtual QPoint storedPosition(QPoint viewRefPos)=0;
	virtual QPoint referencePosition(IconObject *)=0; 
	virtual QPoint referencePositionFromStored(QPoint storedPos)=0;
  
protected:
    	virtual void update()=0;
	int textWidth(QString);
	int refTextWidth(QString);
	int refTextHeight();
  	
	int iconSize_;
	const int refIconSize_;
	float scaling_;
	
	QFont font_;  
	QFont refFont_;
	QFontMetrics fm_;
	QFontMetrics refFm_; 
	int height_;
	int refHeight_;
	int textOffset_;
	int paddingX_;
	int paddingY_;
};	

class MvQClassicIconItemProperty : public MvQAbstractIconItemProperty
{
public:    	
  	MvQClassicIconItemProperty();

	QPoint position(QString,QPoint);
	QPoint positionFromHotSpot(QString name, QPoint pos,QPointF hotSpotAtPos);
	QPoint referencePosition(QString,QPoint);
	QPoint adjsutReferencePosition(QString,QString,QPoint);	
	QSize size(QString);
	QRect textRect(QString);
	QRect iconRect(QString);
	QPoint storedPosition(QPoint viewRefPos);
	QPoint referencePosition(IconObject *);
	QPoint referencePositionFromStored(QPoint storedPos);
protected:	
	void update();
};	

class MvQSimpleIconItemProperty : public MvQAbstractIconItemProperty
{
public:    	
  	MvQSimpleIconItemProperty();

	QPoint position(QString,QPoint);
	QPoint positionFromHotSpot(QString name, QPoint pos,QPointF hotSpotAtPos);
	QPoint referencePosition(QString,QPoint);
	QPoint adjsutReferencePosition(QString,QString,QPoint);	
	QSize size(QString);
	QRect textRect(QString);
	QRect iconRect(QString);
	QPoint storedPosition(QPoint viewRefPos);
	QPoint referencePosition(IconObject *);
	QPoint referencePositionFromStored(QPoint storedPos);
protected:	
	void update();
};	

class MvQDetailedIconItemProperty : public MvQAbstractIconItemProperty
{
public:    	
  	MvQDetailedIconItemProperty();

	QPoint position(QString,QPoint);
	QPoint positionFromHotSpot(QString name, QPoint pos,QPointF hotSpotAtPos);
	QPoint referencePosition(QString,QPoint);
	QPoint adjsutReferencePosition(QString,QString,QPoint);	
	QSize size(QString);
	QRect textRect(QString);
	QRect iconRect(QString);
	QPoint storedPosition(QPoint viewRefPos);
	QPoint referencePosition(IconObject *);
	QPoint referencePositionFromStored(QPoint storedPos);
protected:	
	void update();
};	


class MvQFolderItemProperty
{
public:
    	//enum TextPosMode {TextBelow,TextBeside};
  
  	MvQFolderItemProperty();
	~MvQFolderItemProperty();
	int iconSize();
	float scaling();	
	QFont font(); 
        QSize size(QString);
        int textHeight();
	int textOffset();
	int paddingX() const;
	int paddingY() const;
	QRect textRect(QString);
	QRect iconRect(QString);
	
        bool setIconSize(int);
	QPoint position(QString,QPoint);
	QPoint positionFromHotSpot(QString name, QPoint pos,QPointF hotSpotAtPos);
	QPoint referencePosition(QString,QPoint);
	QPoint adjsutReferencePosition(QString,QString,QPoint);
	void setViewMode(Desktop::FolderViewMode);
	Desktop::FolderViewMode viewMode() const {return viewMode_;}
	QPoint storedPosition(QPoint viewRefPos);
	QPoint referencePosition(IconObject *);
	QPoint referencePositionFromStored(QPoint storedPos);
	
protected:	
	int iconSize_;
  	Desktop::FolderViewMode viewMode_;
	QMap<Desktop::FolderViewMode,MvQAbstractIconItemProperty*> prop_;
	MvQAbstractIconItemProperty* current_;
	
	
};

#endif
