/*    
 *    MediathekView
 *    Copyright (C) 2008   W. Xaver
 *    W.Xaver[at]googlemail.com
 *    http://zdfmediathk.sourceforge.net/
 *    
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import mediathek.daten.Daten;
import mediathek.gui.PanelVorlage;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.TModel;

public class PanelErledigteUrls extends PanelVorlage {

    private boolean abo;

    public PanelErledigteUrls(Daten d, JFrame parentComponent) {
        super(d, parentComponent);
        initComponents();
        jTable1.addMouseListener(new BeobMausTabelle());
        jButtonLoeschen.setEnabled(false);
    }

    public void initAbo() {
        abo = true;
        ListenerMediathekView.addListener(new ListenerMediathekView(ListenerMediathekView.EREIGNIS_LISTE_ERLEDIGTE_ABOS, PanelErledigteUrls.class.getSimpleName()) {
            @Override
            public void ping() {
                if (jToggleButtonLaden.isSelected()) {
                    jTable1.setModel(new TModel(daten.erledigteAbos.getObjectData(), new String[]{"Url"}));
                }
            }
        });
        jButtonLoeschen.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                daten.erledigteAbos.alleLoeschen();
            }
        });
        jToggleButtonLaden.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (jToggleButtonLaden.isSelected()) {
                    jButtonLoeschen.setEnabled(true);
                    jTable1.setModel(new TModel(daten.erledigteAbos.getObjectData(), new String[]{"Url"}));
                } else {
                    jButtonLoeschen.setEnabled(false);
                    jTable1.setModel(new TModel(null, new String[]{"Url"}));
                }
            }
        });
    }

    public void initHistory() {
        abo = false;
        ListenerMediathekView.addListener(new ListenerMediathekView(ListenerMediathekView.EREIGNIS_LISTE_HISTORY_GEAENDERT, PanelErledigteUrls.class.getSimpleName()) {
            @Override
            public void ping() {
                if (jToggleButtonLaden.isSelected()) {
                    jTable1.setModel(new TModel(daten.history.getObjectData(), new String[]{"Url"}));
                }
            }
        });
        jButtonLoeschen.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                daten.history.loeschen();
            }
        });
        jToggleButtonLaden.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (jToggleButtonLaden.isSelected()) {
                    jButtonLoeschen.setEnabled(true);
                    jTable1.setModel(new TModel(daten.history.getObjectData(), new String[]{"Url"}));
                } else {
                    jButtonLoeschen.setEnabled(false);
                    jTable1.setModel(new TModel(null, new String[]{"Url"}));
                }
            }
        });
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        javax.swing.JScrollPane jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jButtonLoeschen = new javax.swing.JButton();
        jToggleButtonLaden = new javax.swing.JToggleButton();

        jTable1.setModel(new TModel());
        jScrollPane1.setViewportView(jTable1);

        jButtonLoeschen.setText("Liste löschen");

        jToggleButtonLaden.setText("Laden");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 492, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jToggleButtonLaden)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jButtonLoeschen)))
                .addContainerGap())
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jButtonLoeschen, jToggleButtonLaden});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 278, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonLoeschen)
                    .addComponent(jToggleButtonLaden))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonLoeschen;
    private javax.swing.JTable jTable1;
    private javax.swing.JToggleButton jToggleButtonLaden;
    // End of variables declaration//GEN-END:variables

    public class BeobMausTabelle extends MouseAdapter {
        //rechhte Maustaste in der Tabelle

        BeobLoeschen beobLoeschen = new BeobLoeschen();
        private Point p;

//        @Override
//        public void mouseClicked(MouseEvent arg0) {
//            if (arg0.getButton() == MouseEvent.BUTTON3) {
//                showMenu(arg0);
//            }
//        }
        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            p = evt.getPoint();
            int nr = jTable1.rowAtPoint(p);
            if (nr >= 0) {
                jTable1.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            //löschen
            JMenuItem item = new JMenuItem("Url aus der Liste löschen");
            item.addActionListener(beobLoeschen);
            jPopupMenu.add(item);
            //anzeigen
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private class BeobLoeschen implements ActionListener {

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedTableRow = jTable1.getSelectedRow();
                if (selectedTableRow >= 0) {
                    String del = jTable1.getValueAt(jTable1.convertRowIndexToModel(selectedTableRow), 0).toString();
                    if (abo) {
                        daten.erledigteAbos.urlAusLogfileLoeschen(del);
                    } else {
                        daten.history.remove(del);
                    }
                }
            }
        }
    }
}
