#!/usr/bin/python

import os
import sys

gpl_header = """\
/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
"""

lgpl_header = """\
/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
"""

def check_license_headers(rootdirs, copyright_header):
    failed = False
    for rootdir in rootdirs:
        for dirpath, dirnames, filenames in os.walk(rootdir):
            for filename in filenames:
                if filename.endswith('.cpp') or filename.endswith('.h'):
                    filepath = os.path.join(dirpath, filename)
                    header = open(filepath).read(len(copyright_header))

                    if header != copyright_header:
                        print '%s: Bad copyright header' % filepath
                        failed = True
    return failed

failed = False
failed |= check_license_headers(
    ['src/mediascanner', 'src/grlmediascanner'], lgpl_header)
failed |= check_license_headers(
    ['src/mediascanner-service', 'tests', 'examples'], gpl_header)

if failed:
    sys.exit(1)
