# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_point_locator import AbstractPointLocator


class StaticPointLocator2D(AbstractPointLocator):
    r"""
    StaticPointLocator2D - quickly locate points in 2-space
    
    Superclass: AbstractPointLocator
    
    StaticPointLocator2D is a spatial search object to quickly locate
    points in 2D.  StaticPointLocator2D works by dividing a specified
    region of space into a regular array of rectilinear buckets, and then
    keeping a list of points that lie in each bucket. Typical operation
    involves giving a position in 2D and finding the closest point; or
    finding the N closest points. (Note that the more general
    StaticPointLocator is available for 3D operations.) Other
    specialized methods for 2D have also been provided.
    
    StaticPointLocator2D is an accelerated version of PointLocator.
    It is threaded (via SMPTools), and supports one-time static
    construction (i.e., incremental point insertion is not supported). If
    you need to incrementally insert points, use the PointLocator or
    its kin to do so.
    
    Note that to satisfy the superclass's API, methods often assume a 3D
    point is provided. However, only the x,y values are used for
    processing. The z-value is only used to define location of the 2D
    plane.
    
    @warning
    This class is templated. It may run slower than serial execution if
    the code is not optimized during compilation. Build in Release or
    release_with_debug_info.
    
    @warning
    Make sure that you review the documentation for the superclasses
    AbstactPointLocator and Locator. In particular the Automatic
    data member can be used to automatically determine divisions based on
    the average number of points per bucket.
    
    @warning
    Other types of spatial locators have been developed such as octrees
    and kd-trees. These are often more efficient for the operations
    described here.
    
    @sa
    StaticPointLocator PointLocator CellLocator Locator
    AbstractPointLocator
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkStaticPointLocator2D, obj, update, **traits)
    
    divisions = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int", value=(50, 50), cols=2, desc=\
        r"""
        Set the number of divisions in x-y directions. If the Automatic
        data member is enabled, the Divisions are set according to the
        number_of_points_per_bucket and max_number_of_buckets data members. The
        number of divisions must be >= 1 in each direction.
        """
    )

    def _divisions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDivisions,
                        self.divisions)

    max_number_of_buckets = traits.Trait(2147483647, traits.Range(1000, 9223372036854775807, enter_set=True, auto_set=False), desc=\
        r"""
        Set the maximum number of buckets in the locator. By default the
        value is set to VTK_INT_MAX. Note that there are significant
        performance implications at work here. If the number of buckets
        is set very large (meaning > VTK_INT_MAX) then internal sorting
        may be performed using 64-bit integers (which is much slower than
        using a 32-bit int). Of course, memory requirements may
        dramatically increase as well.  It is recommended that the
        default value be used; but for extremely large data it may be
        desired to create a locator with an exceptionally large number of
        buckets. Note also that during initialization of the locator if
        the max_number_of_buckets threshold is exceeded, the Divisions are
        scaled down in such a way as not to exceed the max_number_of_buckets
        proportionally to the size of the bounding box in the x-y-z
        directions.
        """
    )

    def _max_number_of_buckets_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaxNumberOfBuckets,
                        self.max_number_of_buckets)

    number_of_points_per_bucket = traits.Trait(5, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        Specify the average number of points in each bucket. This data
        member is used in conjunction with the Automatic data member (if
        enabled) to determine the number of locator x-y divisions.
        """
    )

    def _number_of_points_per_bucket_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfPointsPerBucket,
                        self.number_of_points_per_bucket)

    def get_bucket_ids(self, *args):
        """
        get_bucket_ids(self, bNum:int, bList:IdList) -> None
        C++: void get_bucket_ids(IdType bNum, IdList *bList)
        Given a bucket number bNum between 0 <= bNum <
        this->get_number_of_buckets(), return a list of point ids contained
        within the bucket. The user must provide an instance of IdList
        to contain the result.
        """
        my_args = deref_array(args, [('int', 'vtkIdList')])
        ret = self._wrap_call(self._vtk_obj.GetBucketIds, *my_args)
        return ret

    def get_bucket_index(self, *args):
        """
        get_bucket_index(self, x:(float, ...)) -> int
        C++: IdType get_bucket_index(const double *x)"""
        ret = self._wrap_call(self._vtk_obj.GetBucketIndex, *args)
        return ret

    def get_bucket_indices(self, *args):
        """
        get_bucket_indices(self, x:(float, ...), ij:[int, int]) -> None
        C++: void get_bucket_indices(const double *x, int ij[2])
        Given a point x[3], return the locator index (i,j) which contains
        the point. This method is meant to be fast, so error checking is
        not performed. This method should only be called after the
        locator is built.
        """
        ret = self._wrap_call(self._vtk_obj.GetBucketIndices, *args)
        return ret

    def _get_large_ids(self):
        return self._vtk_obj.GetLargeIds()
    large_ids = traits.Property(_get_large_ids, desc=\
        r"""
        Inform the user as to whether large ids are being used. This flag
        only has meaning after the locator has been built. Large ids are
        used when the number of binned points, or the number of bins, is
        >= the maximum number of buckets (specified by the user). Note
        that large_ids are only available on 64-bit architectures.
        """
    )

    def get_number_of_points_in_bucket(self, *args):
        """
        get_number_of_points_in_bucket(self, bNum:int) -> int
        C++: IdType get_number_of_points_in_bucket(IdType bNum)
        Given a bucket number bNum between 0 <= bNum <
        this->get_number_of_buckets(), return the number of points found in
        the bucket. Note that a bucket can also be specified with locator
        indices (i,j) which converts to a the bucket number
        bNum=i+this->Divisions[0]*j.
        """
        ret = self._wrap_call(self._vtk_obj.GetNumberOfPointsInBucket, *args)
        return ret

    def _get_spacing(self):
        return self._vtk_obj.GetSpacing()
    spacing = traits.Property(_get_spacing, desc=\
        r"""
        Provide an accessor to the bucket spacing. Valid after the
        locator is built.
        """
    )

    def get_spacing(self, *args):
        """
        get_spacing(self) -> Pointer
        C++: virtual double *get_spacing()
        get_spacing(self, spacing:[float, float, float]) -> None
        C++: virtual void get_spacing(double spacing[3])
        Provide an accessor to the bucket spacing. Valid after the
        locator is built.
        """
        ret = self._wrap_call(self._vtk_obj.GetSpacing, *args)
        return ret

    def find_close_n_bounded_points(self, *args):
        """
        find_close_n_bounded_points(self, N:int, x:(float, float, float),
            result:IdList) -> float
        C++: double find_close_n_bounded_points(int N, const double x[3],
            IdList *result)
        Special method for 2D operations (e.g., Voronoi2D). The method
        returns the approximate number of points requested, returning the
        radius R of the furthest point, with the guarantee that all
        points are included that are closer than <=R.
        """
        my_args = deref_array(args, [('int', ('float', 'float', 'float'), 'vtkIdList')])
        ret = self._wrap_call(self._vtk_obj.FindCloseNBoundedPoints, *my_args)
        return ret

    def intersect_with_line(self, *args):
        """
        intersect_with_line(self, a0:[float, float, float], a1:[float,
            float, float], tol:float, t:float, lineX:[float, float,
            float], ptX:[float, float, float], ptId:int) -> int
        C++: int intersect_with_line(double a0[3], double a1[3], double tol,
             double &t, double lineX[3], double ptX[3], IdType &ptId)
        Intersect the points contained in the locator with the line
        defined by (a0,a1). Return the point within the tolerance tol
        that is closest to a0 (tol measured in the world coordinate
        system). If an intersection occurs (i.e., the method returns
        nonzero), then the parametric location along the line t, the
        closest position along the line lineX, and the coordinates of the
        picked ptId is returned in ptX. (This method is thread safe after
        the locator is built.)
        """
        ret = self._wrap_call(self._vtk_obj.IntersectWithLine, *args)
        return ret

    def merge_points(self, *args):
        """
        merge_points(self, tol:float, mergeMap:[int, ...]) -> None
        C++: void merge_points(double tol, IdType *mergeMap)
        Merge points in the locator given a tolerance. Return a merge map
        which represents the mapping of "concident" point ids to a single
        point. Note the number of points in the merge map is the number
        of points the locator was built with. The user is expected to
        pass in an allocated mergeMap.
        """
        ret = self._wrap_call(self._vtk_obj.MergePoints, *args)
        return ret

    _updateable_traits_ = \
    (('automatic', 'GetAutomatic'), ('use_existing_search_structure',
    'GetUseExistingSearchStructure'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('divisions',
    'GetDivisions'), ('max_number_of_buckets', 'GetMaxNumberOfBuckets'),
    ('number_of_points_per_bucket', 'GetNumberOfPointsPerBucket'),
    ('max_level', 'GetMaxLevel'), ('tolerance', 'GetTolerance'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['automatic', 'debug', 'global_warning_display',
    'use_existing_search_structure', 'divisions', 'max_level',
    'max_number_of_buckets', 'number_of_points_per_bucket', 'object_name',
    'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(StaticPointLocator2D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit StaticPointLocator2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['automatic', 'use_existing_search_structure'], [],
            ['divisions', 'max_level', 'max_number_of_buckets',
            'number_of_points_per_bucket', 'object_name', 'tolerance']),
            title='Edit StaticPointLocator2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit StaticPointLocator2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

