# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class GPUInfoList(Object):
    r"""
    GPUInfoList - Stores the list of GPUs VRAM information.
    
    Superclass: Object
    
    GPUInfoList stores a list of GPUInfo. An host can have several
    GPUs. It creates and sets the list by probing the host with system
    calls. This an abstract class. Concrete classes are OS specific.
    @sa
    GPUInfo DirectXGPUInfoList CoreGraphicsGPUInfoList
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGPUInfoList, obj, update, **traits)
    
    def get_gpu_info(self, *args):
        """
        get_gpu_info(self, i:int) -> GPUInfo
        C++: virtual GPUInfo *get_gpu_info(int i)
        Return information about GPU i.
        \\pre probed: is_probed()
        \\pre valid_index: i>=0 && i<get_number_of_gp_us()
        \\post result_exists: result!=0
        """
        ret = self._wrap_call(self._vtk_obj.GetGPUInfo, *args)
        return wrap_vtk(ret)

    def _get_number_of_gp_us(self):
        return self._vtk_obj.GetNumberOfGPUs()
    number_of_gp_us = traits.Property(_get_number_of_gp_us, desc=\
        r"""
        Return the number of GPUs.
        \pre probed: is_probed()
        """
    )

    def is_probed(self):
        """
        is_probed(self) -> bool
        C++: virtual bool is_probed()
        Tells if the operating system has been probed. Initial value is
        false.
        """
        ret = self._vtk_obj.IsProbed()
        return ret
        

    def probe(self):
        """
        probe(self) -> None
        C++: virtual void probe()
        Build the list of InfoGPU if not done yet. Default
        implementation created an empty list. Useful if there is no
        implementation available for a given architecture yet.
        \\post probed: is_probed()
        """
        ret = self._vtk_obj.Probe()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GPUInfoList, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GPUInfoList properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit GPUInfoList properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GPUInfoList properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

