# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Context3D(Object):
    r"""
    Context3D - Class for drawing 3D primitives to a graphical context.
    
    Superclass: Object
    
    This defines the interface for drawing onto a 3D context. The context
    must be set up with a ContextDevice3D derived class that provides
    the functions to facilitate the low level calls to the context.
    Currently only an open_gl based device is provided.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkContext3D, obj, update, **traits)
    
    def _get_transform(self):
        return wrap_vtk(self._vtk_obj.GetTransform())
    def _set_transform(self, arg):
        old_val = self._get_transform()
        self._wrap_call(self._vtk_obj.SetTransform,
                        deref_vtk(arg))
        self.trait_property_changed('transform', old_val, arg)
    transform = traits.Property(_get_transform, _set_transform, desc=\
        r"""
        Compute the current transform applied to the context.
        """
    )

    def _get_device(self):
        return wrap_vtk(self._vtk_obj.GetDevice())
    device = traits.Property(_get_device, desc=\
        r"""
        Get access to the underlying 3D context.
        """
    )

    def append_transform(self, *args):
        """
        append_transform(self, transform:Transform) -> None
        C++: void append_transform(Transform *transform)
        Append the transform for the context, the underlying device will
        use the matrix of the transform. Note, this is set immediately,
        later changes to the matrix will have no effect until it is set
        again. The matrix of the transform will multiply the current
        context transform.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AppendTransform, *my_args)
        return ret

    def apply_brush(self, *args):
        """
        apply_brush(self, brush:Brush) -> None
        C++: void apply_brush(Brush *brush)
        Apply the supplied brush which controls the outlines of shapes,
        as well as lines, points and related primitives. This makes a
        deep copy of the Brush object in the Context2D, it does not
        hold a pointer to the supplied object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ApplyBrush, *my_args)
        return ret

    def apply_pen(self, *args):
        """
        apply_pen(self, pen:Pen) -> None
        C++: void apply_pen(Pen *pen)
        Apply the supplied pen which controls the outlines of shapes, as
        well as lines, points and related primitives. This makes a deep
        copy of the Pen object in the Context2D, it does not hold a
        pointer to the supplied object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ApplyPen, *my_args)
        return ret

    def begin(self, *args):
        """
        begin(self, device:ContextDevice3D) -> bool
        C++: bool begin(ContextDevice3D *device)
        Begin painting on a ContextDevice3D, no painting can occur
        before this call has been made. Only one painter is allowed at a
        time on any given paint device. Returns true if successful,
        otherwise false.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Begin, *my_args)
        return ret

    def disable_clipping_plane(self, *args):
        """
        disable_clipping_plane(self, i:int) -> None
        C++: void disable_clipping_plane(int i)"""
        ret = self._wrap_call(self._vtk_obj.DisableClippingPlane, *args)
        return ret

    def draw_line(self, *args):
        """
        draw_line(self, start:Vector3f, end:Vector3f) -> None
        C++: void draw_line(const Vector3f &start,
            const Vector3f &end)
        Draw a line between the specified points.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DrawLine, *my_args)
        return ret

    def draw_point(self, *args):
        """
        draw_point(self, point:Vector3f) -> None
        C++: void draw_point(const Vector3f &point)
        Draw a point at the point in 3D space.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DrawPoint, *my_args)
        return ret

    def draw_points(self, *args):
        """
        draw_points(self, points:(float, ...), n:int) -> None
        C++: void draw_points(const float *points, int n)
        draw_points(self, points:(float, ...), n:int, colors:[int, ...],
            nc_comps:int) -> None
        C++: void draw_points(const float *points, int n,
            unsigned char *colors, int nc_comps)
        Draw a sequence of points at the specified locations.
        """
        ret = self._wrap_call(self._vtk_obj.DrawPoints, *args)
        return ret

    def draw_poly(self, *args):
        """
        draw_poly(self, points:(float, ...), n:int) -> None
        C++: void draw_poly(const float *points, int n)
        Draw a poly line between the specified points.
        """
        ret = self._wrap_call(self._vtk_obj.DrawPoly, *args)
        return ret

    def draw_triangle_mesh(self, *args):
        """
        draw_triangle_mesh(self, mesh:(float, ...), n:int, colors:(int, ...)
            , nc:int) -> None
        C++: void draw_triangle_mesh(const float *mesh, int n,
            const unsigned char *colors, int nc)
        Draw triangles to generate the specified mesh.
        """
        ret = self._wrap_call(self._vtk_obj.DrawTriangleMesh, *args)
        return ret

    def enable_clipping_plane(self, *args):
        """
        enable_clipping_plane(self, i:int, planeEquation:[float, ...])
            -> None
        C++: void enable_clipping_plane(int i, double *planeEquation)
        Enable/Disable the specified clipping plane. i is the index of
        the clipping plane being enabled or disabled (0 - 5).
        planeEquation points to the four coefficients of the equation for
        the clipping plane: Ax + By + Cz + D = 0.  This is the equation
        format expected by glclip_plane.
        """
        ret = self._wrap_call(self._vtk_obj.EnableClippingPlane, *args)
        return ret

    def end(self):
        """
        end(self) -> bool
        C++: bool end()
        Ends painting on the device, you would not usually need to call
        this as it should be called by the destructor. Returns true if
        the painter is no longer active, otherwise false.
        """
        ret = self._vtk_obj.End()
        return ret
        

    def pop_matrix(self):
        """
        pop_matrix(self) -> None
        C++: void pop_matrix()"""
        ret = self._vtk_obj.PopMatrix()
        return ret
        

    def push_matrix(self):
        """
        push_matrix(self) -> None
        C++: void push_matrix()
        Push/pop the transformation matrix for the painter (sets the
        underlying matrix for the device when available).
        """
        ret = self._vtk_obj.PushMatrix()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Context3D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Context3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit Context3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Context3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

