# Участие в проекте manpages-l10n

Как описано в файле README.md, проект manpages-l10n предоставляет подходящую 
инфраструктуру для перевода справочных страниц. Здесь мы описываем 
технологический процесс получения исходных справочных страниц, перевода и, 
наконец, публикации переводов.


## Получение исходных справочных страниц

Мы поддерживаем несколько дистрибутивов. Чтобы получить исходные справочные 
страницы, ведутся списки пакетов для каждого дистрибутива в
upstream/*имя_дистрибутива*/packages.txt. Обычно мы загружаем все 
перечисленные пакеты один или два раза в месяц и распаковываем справочные 
страницы, используя скрипт upstream/update-distribution-manpages.sh. Этот 
скрипт также объединяет ссылки, чтобы они позже не отображались в виде 
переводимых файлов.

Примечание: Иногда необходимо сохранить номер версии пакета в файлы 
packages.txt. В таких случаях убедитесь, что пакет с таким номером версии 
действительно существует в репозиториях дистрибутива. Если он не существует,
ничего загружено не будет, и справочные страницы этого пакета исчезнут из
каталога upstream/ и, наконец, исчезнут из соответствующих шаблонов перевода.
В настоящее время это относится к некоторым пакетам systemd* и sane-бэкендам
в Opensuse (как Tumbleweed, так и Leap) и openssl в Archlinux. Улучшения
скрипта приветствуются!

Чтобы получить общее представление о том, какие справочные страницы доступны 
из поддерживаемых пакетов, но все еще не переведены, создаются к файлы
upstream/*имя_дистрибутива*/untranslated.txt. Сюда входят только справочные 
страницы, для которых шаблон уже существует, т.е. для которых доступны
файлы .po для других языков. Поэтому список является неполным.
Если вы хотите перевести определенную справочную страницу, запустите скрипт
`../create-new-translation.sh` из каталога po/*ваш_язык*. Если это удается, 
соответствующая справочная страница уже существует по крайней мере в одном из
каталогов в upstream, и создается файл .po и соответствующий шаблон. Если это 
не удается, обратитесь к сопровождающему manpages-l10n, который даст несколько
подсказок, где можно найти справочную страницу (название пакета).


## Создание шаблонов

После обновления содержимого upstream/*имя_дистрибутива*/man* создаются 
шаблоны. Сценарий templates/update-all-templates.py обновляет существующие 
файлы \*.pot на основе новых исходных справочных страниц. Вы можете запустить 
скрипт templates/generate-one-template.sh чтобы создать новый или обновить 
существующий шаблон.


## Обновление переводов

Запустите команду `../update-translations.sh` для обновления существующих 
файлов \*.po (в идеале как `../update-translations.sh` из каталога вашего 
языка), основанного на ранее измененных шаблонах. Позже можно запустить 
`../update-po.sh ` для обновления одного файла .po или 
`../update-translations.sh`, чтобы снова обновить все существующие файлы .po 
из текущих шаблонов и файлов компендиума (смотрите ниже, как использовать 
компендиум).


## Используйте корректные заголовки файлов

Заголовок файла .po обычно выглядит следующим образом:

~~~
# German translation of manpages
# # This file is distributed under the same license as the manpages-l10n package.
# Copyright © of this file:
# Mario Blättermann <mario.blaettermann@gmail.com>, 2015.
~~~

Перевод:
~~~
# Немецкий перевод справочных страниц
# # Этот файл распространяется под той же лицензией, что и пакет manpages-l10n.
# Авторским правом © на этот файл владеет:
# Марио Блэттерманн <mario.blaettermann@gmail.com>, 2015 год.
~~~

Первые три строки будут добавлены автоматически, если они не существуют. 
Но начиная с четвертой строки, надо писать только строки с указанием имени 
переводчика, адреса электронной почты и год создания. Иначе некоторые из 
наших скриптов будут работать неправильно. Сценарию `../generate-manpage.sh `
это нужно для создания дополнений. Скрипт `create-authors-file.sh` также 
считывает оттуда имена переводчиков и выдает мусор, если есть какие-то 
дополнительные строки.

Единственное исключение: строки комментариев, начинающиеся с # FIXME, будут 
проигнорированы скриптами. Но гораздо полезнее поместить такие метки FIXME 
непосредственно над соответствующими строками Gettext.

## Технологический процесс Git для проверенных файлов .po

После перевода и проверки .po файла (при условии, что вы использовали копию 
этого файла и не применяли свои изменения непосредственно в вашем локальном 
Git checkout) вам следует выполнить следующие действия:

* Запустите "git pull", чтобы получить последние изменения от других 
  пользователей.
* Проверьте свой .po файл с помощью `msgfmt -vc`.
* Поместите свой .po файл в нужное место в иерархии Git (пока не фиксируйте 
  его).
* Запустите "git status" или "git diff", либо оба последовательно, чтобы 
  посмотреть, что будет изменено.
* Запустите скрипт `../update-po.sh` чтобы объединить ваш .po файл с 
последним шаблоном и сообщениями из компендиума. Теперь вам следует еще раз 
взглянуть на файл .po. Если что-то не так, исправьте это.
* Зафиксируйте свой po-файл. Команда должна выглядеть следующим образом:

~~~
git commit -a -m "[de] Update chown.1.po"
~~~

Перевод:

~~~
git commit -a -m "[de] Обновлён chown.1.po"
~~~

* Чтобы было легче различать разные языки, добавьте [код_вашего_языка] к 
  сообщению о фиксации. (прим. пер.: [de] из примера — это немецкий язык, 
  для русского — используйте код [ru])
* Запустите `git push`. Обычно после ввода вашего пароля SSH все должно быть 
в порядке. Но в некоторых случаях другой участник за это время внес некоторые 
изменения, а потому Git отказывает в фиксации. Тогда сначала выполните 
`git pull`. Это применяет удаленные изменения к вашему локальному репозиторию 
и открывает редактор, в котором вы можете изменить сообщение о фиксации. 
В большинстве случаев нет необходимости что-либо менять, просто закройте 
редактор (после сохранения сообщения при необходимости).


## Использование вспомогательных скриптов

Большинство вспомогательных скриптов в po/ имеют опцию `-h` для отображения 
короткого справочного сообщения. Обычно скрипты предназначены для вызова из 
подкаталога вашего языка, например `cd po/ru && ../format-po.sh `

### Создание новых переводов

Сценарий `../create-new-translation.sh ` создает новый файл .po. 
Это предполагает, что исходный файл Groff или Mdoc уже существует 
в upstream/man\* по крайней мере для одного из поддерживаемых нами 
дистрибутивов. Если нет, попробуйте выяснить название дистрибутива, 
содержащего эту справочную страницу, и свяжитесь 
с [Марио Блэттерманном].(mailto:mario.blaettermann@gmail.com ), чтобы 
поместить его в manpages-l10n. Помимо создания файла .po, скрипт при 
необходимости создает шаблон и обновляет шаблоны компендиума в templates/common/ 
и файлы компендиума для вашего языка в po/*your_language_code*/common. 
Сценарий никогда не влияет на другие языки, кроме вашего собственного. 
Примечание: Не забудьте запустить `git add <файл>` после того, как вы 
создали и/или обновили новый файл, прежде чем выполнять команду `git push`.
(прим. пер.: немного не так — сперва делаете `git add <файл>`, чтобы добавить
этот файл в фиксацию, потом делаете фиксацию командой `git commit` и только 
после этого выполняете команду `git push`)


### Заполнение и использование компендиума

Прим. пер.: компендиум — это местная реализация памяти переводов.

После проверки и фиксации .po файла можно запустить `../use-for-compendium.sh` 
для добавления ранее проверенных сообщения Gettext в ваш компендиум. 
Например: `../use-for-compendium.sh man1/chown.1.po`. Это имеет смысл, если 
ваш .po файл содержит некоторые строки, которые также присутствуют в 
других .po файлах. Скрипт распознает строки, которые встречаются хотя бы 
дважды в нашей коллекции справочных страниц. Обратите внимание, что нужно 
указывать относительный путь, просто имени файла недостаточно.

После добавления файла в компендиум можно записать изменения обратно во 
все .po файлы с помощью команды `../update-translations.sh`.

Может случиться так, что вы столкнетесь с неоднозначной строкой Gettext, а 
потому не должно использоваться в компендиуме. 
В этом случае добавьте строку в файл templates/exclude.pot как показано ниже:

~~~
msgid "I<source>"
msgstr ""
~~~

Не забудьте указать пустой `msgstr ""`, иначе в следующий раз обновление 
шаблонов завершится неудачей! После добавления строки сначала запустите 
скрипт `templates/create-common-templates.sh`. Это гарантирует, что 
нежелательная строка действительно исчезнет из компендиума. После этого также 
надо запустить скрипт `../update-common.sh` (как минимум для вашего родного 
языка), чтобы предотвратить от повторного использования этой строки Gettext в 
других скриптах типа `../create-new-translation.sh` или `../update-po.sh`. 
Хотя эта процедура будет выполнена для всех поддерживаемых языков во время 
следующего обновления из пакетов в upstream, может случиться так, что 
упомянутые скрипты позволят нежелательным сообщениям снова появиться в 
ваших .po файлах.

### Форматирование файлов \*.po

Сценарий `../format-po.sh` форматирует все .po файлы вашего языка так, как это 
сделал бы `msgcat -w 80`, т.е. делает все строки не длинее 80 символов. 
Кроме того, неиспользуемые строки Gettext в конце .po файлов будут удалены. 
Обратите внимание, что этот скрипт ожидает правильные po-файлы; запустите 
`msgfmt -vc *ваш_po_файл*`, чтобы убедиться, что файл правильно 
отформатирован в смысле Gettext. В противном случае скрипт может полностью 
уничтожить файл, и вам потребуется отменить изменения.


### Создание переведенных справочных страниц

Одну переведенную справочную страницу можно создать с помощью команды 
`../generate-manpage.sh *имя_дистрибутива* *ваш_po_файл*`, например 
(из вашего каталога .po) `../generate-manpage.sh archlinux man1/chown.1.po`. 
При этом создается справочная страница в подкаталоге с именем «archlinux». 
Но также можно сгенерировать все справочные страницы сразу из всех .po файлов 
с помощью команды `../generate-all-manpages.sh *имя_дистрибутива*`. 
Все сгенерированные справочные страницы получают дополнение, которое состоит 
из имен переводчиков и почтовых адресов, указанных в заголовках файла .po, и 
объявления лицензии, взятого из файла po/*код_вашего_языка*/license.add.

### Проверка безопасности с помощью git-хуков

Git-хуки — это способ запуска скриптов до или после определенных шагов. 
Каталог `hooks` в настоящее время содержит скрипт `pre-commit`, который 
проверит форматирование .po-файлов, подлежащих фиксации, и прервет фиксацию 
с объяснением в случае, если некоторые из этих файлов неправильные.

Чтобы 'установить' этот хук, запустите его из корневой папки проекта:

~~~
cp hooks/pre-commit.conf.template hooks/pre-commit.conf
~~~

### Автоматическое составление сообщений [DONE] с использованием git-перехватчиков

Используя тот же git-хук, что и выше, также возможно включить автоматическое 
создание сообщений "[DONE]" ("[ГОТОВО]") в ваш список рассылки l10n при 
фиксации новых переводов. Чтобы включить эту функцию, следуйте той же 
инструкции, что и выше, чтобы активировать git hook, затем создайте файл 
конфигурации, используя предоставленный шаблон:

~~~
cp hooks/pre-commit.conf.template hooks/pre-commit.conf
~~~

Как только файл _pre-commit.conf_ будет создан, просто заполните его 
необходимой информацией.

ПРЕДУПРЕЖДЕНИЕ: для этого хука требуется установить пакет curl.

## Примите участие в управлении пакетом

manpages-l10n предназначен для работы с несколькими дистрибутивами. Поэтому 
его необходимо выпускать каждые 3 месяца. Если вы хотите помочь в решении 
этих административных задач, вот что вам нужно сделать.

Во-первых, вам нужно получить соответствующие права в репозиторий salsa.

Далее:
* Выполните поиск с помощью grep по номеру текущей версии. Получится 
несколько вхождений в 'configure', 'configure.ac ', 'CHANGES.md " и так далее. 
(Не беспокойтесь о номерах версий в заголовках файлов .po)

~~~
grep '^AC_INIT' configure.ac | sed 's/.*\[\(.*\)\].*/\1/'
grep '^##' CHANGES.md | head -n1
~~~

* Замените старый номер версии на новый в configure.ac
* Напишите соответствующую запись в CHANGES.md.
* Запустите 'autoreconf'
* Зафиксируйте и протолкните изменения.

* Создайте соответствующий тег:
** В веб-интерфейсе нажмите на Tags в Repository, а потом на "New tag" и 
введите новый номер выпуска. Оставьте поле "Create from" на "master", а в 
поле "Message" введите "Release XXX", где XXX — номер выпуска

** В командной строке:
~~~
git tag -a v4.2.0 -m 'Release 4.2.0'
~~~

замените на соответствующий номер выпуска "-a" для аннотации, обычно 
используемую для выпусков (https://git-scm.com/docs/git-tag )

"-m " - это сообщение, о котором вы упомянули

"v4.2.0" - это название тега

Это все. Пользователи и последующие упаковщики теперь могут загружать архив 
из известного местоположения.
