.. -*- rst -*-

================================
Share instances (since API v2.3)
================================

Administrators can list, show information for, explicitly set the
state of, and force-delete share instances. Use the ``policy.json``
file to grant permissions for these actions to other roles.


List share instances
====================

.. rest_method::  GET /v2/{project_id}/share_instances

.. versionadded:: 2.3

Lists all share instances.

Response codes
--------------

.. rest_status_code:: success status.yaml

   - 200

.. rest_status_code:: error status.yaml

   - 400
   - 401
   - 403

Request
-------

.. rest_parameters:: parameters.yaml

   - project_id: project_id_path
   - export_location_id: export_location_id_query
   - export_location_path: export_location_path_query

Response parameters
-------------------

.. rest_parameters:: parameters.yaml

   - status: status_5
   - access_rules_status: access_rules_status
   - share_id: share_id_2
   - progress: progress_share_instance
   - availability_zone: availability_zone_1
   - created_at: created_at
   - replica_state: replica_state
   - export_location: export_location
   - export_locations: export_locations
   - cast_rules_to_readonly: share_instance_cast_rules_to_readonly
   - share_network_id: share_network_id_4
   - share_server_id: share_server_id
   - host: host_6
   - id: id_13

Response example
----------------

.. literalinclude:: samples/share-instances-list-response.json
   :language: javascript


Show share instance details
===========================

.. rest_method::  GET /v2/{project_id}/share_instances/{share_instance_id}

.. versionadded:: 2.3

Shows details for a share instance.

Response codes
--------------

.. rest_status_code:: success status.yaml

   - 200

.. rest_status_code:: error status.yaml

   - 400
   - 401
   - 403
   - 404

Request
-------

.. rest_parameters:: parameters.yaml

   - project_id: project_id_path
   - share_instance_id: share_instance_id

Response parameters
-------------------

.. rest_parameters:: parameters.yaml

   - status: status_5
   - access_rules_status: access_rules_status
   - share_id: share_id_2
   - progress: progress_share_instance
   - availability_zone: availability_zone_1
   - created_at: created_at
   - replica_state: replica_state
   - export_location: export_location
   - export_locations: export_locations
   - cast_rules_to_readonly: share_instance_cast_rules_to_readonly
   - share_network_id: share_network_id_4
   - share_server_id: share_server_id
   - host: host_6
   - id: id_13

Response example
----------------

.. literalinclude:: samples/share-show-instance-response.json
   :language: javascript


Reset share instance state
==========================

.. rest_method::  POST /v2/{project_id}/share_instances/{share_instance_id}/action

.. versionadded:: 2.3

Administrator only. Explicitly updates the state of a share instance.

Use the ``policy.json`` file to grant permissions for this action
to other roles.

Response codes
--------------

.. rest_status_code:: success status.yaml

   - 202

.. rest_status_code:: error status.yaml

   - 400
   - 401
   - 403
   - 404

Request
-------

.. rest_parameters:: parameters.yaml

   - project_id: project_id_path
   - share_instance_id: share_instance_id
   - status: status_5

Request example
---------------

.. literalinclude:: samples/share-instance-actions-reset-state-request.json
   :language: javascript


Force-delete share instance
===========================

.. rest_method::  POST /v2/{project_id}/share_instances/{share_instance_id}/action

.. versionadded:: 2.3

Administrator only. Force-deletes a share instance.

Use the ``policy.json`` file to grant permissions for this action
to other roles.

Response codes
--------------

.. rest_status_code:: success status.yaml

   - 202

.. rest_status_code:: error status.yaml

   - 400
   - 401
   - 403
   - 404

Request
-------

.. rest_parameters:: parameters.yaml

   - project_id: project_id_path
   - share_instance_id: share_instance_id
   - force_delete: force_delete_2

Request example
---------------

.. literalinclude:: samples/share-instance-actions-force-delete-request.json
   :language: javascript
