#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

"""create baylock table

Revision ID: 456126c6c9e9
Revises: 2ace4006498
Create Date: 2015-04-01 15:04:45.652672

"""

# revision identifiers, used by Alembic.
revision = '456126c6c9e9'
down_revision = '2ace4006498'

from alembic import op
import sqlalchemy as sa


def upgrade():
    op.create_table(
        'baylock',
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('bay_uuid', sa.String(length=36), nullable=True),
        sa.Column('conductor_id', sa.String(length=64), nullable=True),
        sa.PrimaryKeyConstraint('id'),
        mysql_ENGINE='InnoDB',
        mysql_DEFAULT_CHARSET='UTF8'
    )
