/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file IsoPlotAttributes.cc
    \brief Implementation of IsoPlot Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Apr 15 17:55:21 2013
*/    

#include "IsoPlotAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


IsoPlotAttributes::IsoPlotAttributes():
	legend_special_(ParameterManager::getString("contour_special_legend")),
	resolution_(ParameterManager::getDouble("contour_internal_reduction_factor")),
	technique_(ParameterManager::getString("contour_internal_technique")),
	legend_text_(ParameterManager::getString("contour_legend_text")),
	style_(MagTranslator<string, LineStyle>().magics("contour_line_style")),
	thickness_(ParameterManager::getInt("contour_line_thickness")),
	colour_(MagTranslator<string, Colour>().magics("contour_line_colour")),
	highlight_(MagTranslator<string, NoIsoHighlight>().magics("contour_highlight")),
	levelSelection_(MagTranslator<string, LevelSelection>().magics("contour_level_selection_type")),
	label_(MagTranslator<string, NoIsoLabel>().magics("contour_label")),
	shading_(MagTranslator<string, NoIsoShading>().magics("contour_shade")),
	legend_only_(ParameterManager::getBool("contour_legend_only"))
{
} 



IsoPlotAttributes::~IsoPlotAttributes()
{
}

    
void IsoPlotAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "contour_line";
	prefix[1] = "contour";

	setAttribute(prefix, "contour_special_legend", legend_special_, params);
	setAttribute(prefix, "contour_internal_reduction_factor", resolution_, params);
	setAttribute(prefix, "contour_internal_technique", technique_, params);
	setAttribute(prefix, "contour_legend_text", legend_text_, params);
	setAttribute(prefix, "contour_line_style", style_, params);
	setAttribute(prefix, "contour_line_thickness", thickness_, params);
	setAttribute(prefix, "contour_line_colour", colour_, params);
	setMember(prefix, "contour_highlight", highlight_, params);
	setMember(prefix, "contour_level_selection_type", levelSelection_, params);
	setMember(prefix, "contour_label", label_, params);
	setMember(prefix, "contour_shade", shading_, params);
	setAttribute(prefix, "contour_legend_only", legend_only_, params);
}

void IsoPlotAttributes::copy(const IsoPlotAttributes& other)
{
	legend_special_ = other.legend_special_;
	resolution_ = other.resolution_;
	technique_ = other.technique_;
	legend_text_ = other.legend_text_;
	style_ = other.style_;
	thickness_ = other.thickness_;
	colour_ = auto_ptr<Colour>(other.colour_->clone());
	highlight_ = auto_ptr<NoIsoHighlight>(other.highlight_->clone());
	levelSelection_ = auto_ptr<LevelSelection>(other.levelSelection_->clone());
	label_ = auto_ptr<NoIsoLabel>(other.label_->clone());
	shading_ = auto_ptr<NoIsoShading>(other.shading_->clone());
	legend_only_ = other.legend_only_;
} 


bool IsoPlotAttributes::accept(const string& node)
{	
	if ( magCompare(node, "isoline")  )
		return true;

	if ( acceptNode(node, highlight_) )
		return true;

	if ( acceptNode(node, levelSelection_) )
		return true;

	if ( acceptNode(node, label_) )
		return true;

	if ( acceptNode(node, shading_) )
		return true;
	return false;
}

void IsoPlotAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "isoline") )
		set(node.attributes());
	else {
		setMember(node.name(), highlight_, node);
		setMember(node.name(), levelSelection_, node);
		setMember(node.name(), label_, node);
		setMember(node.name(), shading_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), highlight_, *(*elt)); 
		setMember((*elt)->name(), levelSelection_, *(*elt)); 
		setMember((*elt)->name(), label_, *(*elt)); 
		setMember((*elt)->name(), shading_, *(*elt)); 
	}
}

void IsoPlotAttributes::print(ostream& out)  const
{
	out << "IsoPlotAttributes[";
	out << "legend_special = " << legend_special_;
	out << ", resolution = " << resolution_;
	out << ", technique = " << technique_;
	out << ", legend_text = " << legend_text_;
	out << ", style = " << style_;
	out << ", thickness = " << thickness_;
	out << ", colour = " << *colour_;
	out << ", highlight = " << *highlight_;
	out << ", levelSelection = " << *levelSelection_;
	out << ", label = " << *label_;
	out << ", shading = " << *shading_;
	out << ", legend_only = " << legend_only_;
	out << "]" << "\n";
}


void IsoPlotAttributes::toxml(ostream& out)  const
{
     out <<  "\"isoline\"";
	 out << ", \"contour_special_legend\":";
	 niceprint(out,legend_special_);
	 out << ", \"contour_internal_reduction_factor\":";
	 niceprint(out,resolution_);
	 out << ", \"contour_internal_technique\":";
	 niceprint(out,technique_);
	 out << ", \"contour_legend_text\":";
	 niceprint(out,legend_text_);
	 out << ", \"contour_line_style\":";
	 niceprint(out,style_);
	 out << ", \"contour_line_thickness\":";
	 niceprint(out,thickness_);
	 out << ", \"contour_line_colour\":";
	 niceprint(out, *colour_);
	 out << ", \"contour_highlight\":";
	 highlight_->toxml(out);
	 out << ", \"contour_level_selection_type\":";
	 levelSelection_->toxml(out);
	 out << ", \"contour_label\":";
	 label_->toxml(out);
	 out << ", \"contour_shade\":";
	 shading_->toxml(out);
	 out << ", \"contour_legend_only\":";
	 niceprint(out,legend_only_);
}
static MagicsParameter<string> contour_special_legend("contour_special_legend", "", "");
static MagicsParameter<double> contour_internal_reduction_factor("contour_internal_reduction_factor", 4, "");
static MagicsParameter<string> contour_internal_technique("contour_internal_technique", "interpolate", "");
static MagicsParameter<string> contour_legend_text("contour_legend_text", " ", "");
static MagicsParameter<string> contour_line_style("contour_line_style", "solid", " New Magics: Parameter contour_line_style sent to new Magics[IsoPlot].  ");
static MagicsParameter<int> contour_line_thickness("contour_line_thickness", 1, " New Magics: Parameter contour_line_thickness sent to new Magics[IsoPlot].  ");
static MagicsParameter<string> contour_line_colour("contour_line_colour", "blue", " New Magics: Parameter contour_line_colour sent to new Magics[IsoPlot].  ");
static MagicsParameter<string> contour_highlight("contour_highlight", "on", " New Magics: Parameter contour_highlight sent to new Magics[IsoPlot].  ");
static MagicsParameter<string> contour_level_selection_type("contour_level_selection_type", "count", "");
static MagicsParameter<string> contour_label("contour_label", "on", " New Magics: Parameter Contour sent to new Magics[Contour].  ");
static MagicsParameter<string> contour_shade("contour_shade", "off", " New Magics: Parameter contour_label sent to new Magics[Contour].  ");
static MagicsParameter<string> contour_legend_only("contour_legend_only", "off", "");
#include "IsoHighlight.h"
static SimpleObjectMaker<IsoHighlight, NoIsoHighlight> on_IsoHighlight("on");
static SimpleObjectMaker<IsoHighlight, NoIsoHighlight> highlight_IsoHighlight("highlight");
static SimpleObjectMaker<NoIsoHighlight, NoIsoHighlight> off_NoIsoHighlight("off");
static SimpleObjectMaker<NoIsoHighlight, NoIsoHighlight> nohighlight_NoIsoHighlight("nohighlight");
#include "CountSelectionType.h"
#include "IntervalSelectionType.h"
#include "LevelListSelectionType.h"
static SimpleObjectMaker<CountSelectionType, LevelSelection> count_CountSelectionType("count");
static SimpleObjectMaker<IntervalSelectionType, LevelSelection> interval_IntervalSelectionType("interval");
static SimpleObjectMaker<LevelListSelectionType, LevelSelection> level_list_LevelListSelectionType("level_list");
static SimpleObjectMaker<LevelListSelectionType, LevelSelection> list_LevelListSelectionType("list");
#include "IsoLabel.h"
static SimpleObjectMaker<IsoLabel, NoIsoLabel> on_IsoLabel("on");
static SimpleObjectMaker<IsoLabel, NoIsoLabel> label_IsoLabel("label");
static SimpleObjectMaker<NoIsoLabel, NoIsoLabel> off_NoIsoLabel("off");
static SimpleObjectMaker<NoIsoLabel, NoIsoLabel> nolabel_NoIsoLabel("nolabel");
#include "IsoShading.h"
static SimpleObjectMaker<IsoShading, NoIsoShading> on_IsoShading("on");
static SimpleObjectMaker<IsoShading, NoIsoShading> shading_IsoShading("shading");
static SimpleObjectMaker<NoIsoShading, NoIsoShading> off_NoIsoShading("off");
static SimpleObjectMaker<NoIsoShading, NoIsoShading> noshading_NoIsoShading("noshading");
