#
# @file    TestEvent.py
# @brief   SBML Event unit tests
#
# @author  Akiya Jouraku (Python conversion)
# @author  Ben Bornstein 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestEvent.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestEvent(unittest.TestCase):

  global E
  E = None

  def setUp(self):
    self.E = libsbml.Event(2,4)
    if (self.E == None):
      pass    
    pass  

  def tearDown(self):
    _dummyList = [ self.E ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_Event_create(self):
    self.assertTrue( self.E.getTypeCode() == libsbml.SBML_EVENT )
    self.assertTrue( self.E.getMetaId() == "" )
    self.assertTrue( self.E.getNotes() == None )
    self.assertTrue( self.E.getAnnotation() == None )
    self.assertTrue( self.E.getId() == "" )
    self.assertTrue( self.E.getName() == "" )
    self.assertTrue( self.E.getTrigger() == None )
    self.assertTrue( self.E.getDelay() == None )
    self.assertTrue( self.E.getTimeUnits() == "" )
    self.assertEqual( False, self.E.isSetId() )
    self.assertEqual( False, self.E.isSetTrigger() )
    self.assertEqual( False, self.E.isSetDelay() )
    self.assertEqual( True, self.E.isSetUseValuesFromTriggerTime() )
    self.assertTrue( self.E.getNumEventAssignments() == 0 )
    pass  

  def test_Event_createWithNS(self):
    xmlns = libsbml.XMLNamespaces()
    xmlns.add( "http://www.sbml.org", "testsbml")
    sbmlns = libsbml.SBMLNamespaces(2,4)
    sbmlns.addNamespaces(xmlns)
    object = libsbml.Event(sbmlns)
    self.assertTrue( object.getTypeCode() == libsbml.SBML_EVENT )
    self.assertTrue( object.getMetaId() == "" )
    self.assertTrue( object.getNotes() == None )
    self.assertTrue( object.getAnnotation() == None )
    self.assertTrue( object.getLevel() == 2 )
    self.assertTrue( object.getVersion() == 4 )
    self.assertTrue( object.getNamespaces() != None )
    self.assertTrue( object.getNamespaces().getLength() == 2 )
    _dummyList = [ object ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_Event_free_NULL(self):
    _dummyList = [ None ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_Event_full(self):
    math1 = libsbml.parseFormula("0")
    trigger = libsbml.Trigger(2,4)
    math = libsbml.parseFormula("0")
    e = libsbml.Event(2,4)
    ea = libsbml.EventAssignment(2,4)
    ea.setVariable( "k")
    ea.setMath(math)
    trigger.setMath(math1)
    e.setTrigger(trigger)
    e.setId( "e1")
    e.setName( "Set k2 to zero when P1 <= t")
    e.addEventAssignment(ea)
    self.assertTrue( e.getNumEventAssignments() == 1 )
    self.assertTrue( e.getEventAssignment(0) != ea )
    _dummyList = [ math ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ e ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_Event_removeEventAssignment(self):
    o1 = self.E.createEventAssignment()
    o2 = self.E.createEventAssignment()
    o3 = self.E.createEventAssignment()
    o3.setVariable("test")
    self.assertTrue( self.E.removeEventAssignment(0) == o1 )
    self.assertTrue( self.E.getNumEventAssignments() == 2 )
    self.assertTrue( self.E.removeEventAssignment(0) == o2 )
    self.assertTrue( self.E.getNumEventAssignments() == 1 )
    self.assertTrue( self.E.removeEventAssignment("test") == o3 )
    self.assertTrue( self.E.getNumEventAssignments() == 0 )
    _dummyList = [ o1 ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ o2 ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ o3 ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_Event_setDelay(self):
    math1 = libsbml.parseFormula("0")
    Delay = libsbml.Delay(2,4)
    Delay.setMath(math1)
    self.E.setDelay(Delay)
    self.assertTrue( self.E.getDelay() != None )
    self.assertEqual( True, self.E.isSetDelay() )
    if (self.E.getDelay() == Delay):
      pass    
    self.E.setDelay(self.E.getDelay())
    self.assertTrue( self.E.getDelay() != Delay )
    self.E.setDelay(None)
    self.assertEqual( False, self.E.isSetDelay() )
    if (self.E.getDelay() != None):
      pass    
    pass  

  def test_Event_setId(self):
    id =  "e1";
    self.E.setId(id)
    self.assertTrue(( id == self.E.getId() ))
    self.assertEqual( True, self.E.isSetId() )
    if (self.E.getId() == id):
      pass    
    self.E.setId(self.E.getId())
    self.assertTrue(( id == self.E.getId() ))
    self.E.setId("")
    self.assertEqual( False, self.E.isSetId() )
    if (self.E.getId() != None):
      pass    
    pass  

  def test_Event_setName(self):
    name =  "Set_k2";
    self.E.setName(name)
    self.assertTrue(( name == self.E.getName() ))
    self.assertEqual( True, self.E.isSetName() )
    if (self.E.getName() == name):
      pass    
    self.E.setName(self.E.getName())
    self.assertTrue(( name == self.E.getName() ))
    self.E.setName("")
    self.assertEqual( False, self.E.isSetName() )
    if (self.E.getName() != None):
      pass    
    pass  

  def test_Event_setTimeUnits(self):
    E1 = libsbml.Event(2,1)
    units =  "second";
    E1.setTimeUnits(units)
    self.assertTrue(( units == E1.getTimeUnits() ))
    self.assertEqual( True, E1.isSetTimeUnits() )
    if (E1.getTimeUnits() == units):
      pass    
    E1.setTimeUnits(E1.getTimeUnits())
    self.assertTrue(( units == E1.getTimeUnits() ))
    E1.setTimeUnits("")
    self.assertEqual( False, E1.isSetTimeUnits() )
    if (E1.getTimeUnits() != None):
      pass    
    _dummyList = [ E1 ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_Event_setTrigger(self):
    math1 = libsbml.parseFormula("0")
    trigger = libsbml.Trigger(2,4)
    trigger.setMath(math1)
    self.E.setTrigger(trigger)
    self.assertTrue( self.E.getTrigger() != None )
    self.assertEqual( True, self.E.isSetTrigger() )
    if (self.E.getTrigger() == trigger):
      pass    
    self.E.setTrigger(self.E.getTrigger())
    self.assertTrue( self.E.getTrigger() != trigger )
    self.E.setTrigger(None)
    self.assertEqual( False, self.E.isSetTrigger() )
    if (self.E.getTrigger() != None):
      pass    
    pass  

  def test_Event_setUseValuesFromTriggerTime(self):
    object = libsbml.Event(2,4)
    object.setUseValuesFromTriggerTime(False)
    self.assertTrue( object.getUseValuesFromTriggerTime() == False )
    object.setUseValuesFromTriggerTime(True)
    self.assertTrue( object.getUseValuesFromTriggerTime() == True )
    _dummyList = [ object ]; _dummyList[:] = []; del _dummyList
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.TestLoader.loadTestsFromTestCase(TestEvent))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
