// Copyright 2021 Filippo Rusconi
// GPLv3+

/////////////////////// StdLib includes


/////////////////////// Qt includes
#include <QString>


/////////////////////// Local includes
#include "massspectraceplotcontext.h"

namespace pappso
{


MassSpecTracePlotContext::MassSpecTracePlotContext()
{
}


MassSpecTracePlotContext::MassSpecTracePlotContext(
  const MassSpecTracePlotContext &other)
  : BasePlotContext(other),
    m_lastZ(other.m_lastZ),
    m_lastMz(other.m_lastMz),
    m_lastTicIntensity(other.m_lastTicIntensity),
    m_lastMr(other.m_lastMr),
    m_lastResolvingPower(other.m_lastResolvingPower)
{
  // qDebug() << "Constructing MassSpecTracePlotContext by copy.";
}


MassSpecTracePlotContext::~MassSpecTracePlotContext()
{
}

MassSpecTracePlotContext &
MassSpecTracePlotContext::operator=(const BasePlotContext &other)
{
  if(this == &other)
    return *this;

  // First the BasePlotContext members

  m_dataKind = other.m_dataKind;

  m_isMouseDragging  = other.m_isMouseDragging;
  m_wasMouseDragging = other.m_wasMouseDragging;

  m_isKeyBoardDragging            = other.m_isKeyBoardDragging;
  m_isLeftPseudoButtonKeyPressed  = other.m_isLeftPseudoButtonKeyPressed;
  m_isRightPseudoButtonKeyPressed = other.m_isRightPseudoButtonKeyPressed;
  m_wassKeyBoardDragging          = other.m_wassKeyBoardDragging;

  m_startDragPoint         = other.m_startDragPoint;
  m_currentDragPoint       = other.m_currentDragPoint;
  m_lastCursorHoveredPoint = other.m_lastCursorHoveredPoint;

  m_selectionPolygon     = other.m_selectionPolygon;
  m_selectRectangleWidth = other.m_selectRectangleWidth;

  // The effective range of the axes.
  m_xRange = other.m_xRange;
  m_yRange = other.m_yRange;

  // Tell if the mouse move was started onto either axis, because that will
  // condition if some calculations needs to be performed or not (for example,
  // if the mouse cursor motion was started on an axis, there is no point to
  // perform deconvolutions).
  m_wasClickOnXAxis = other.m_wasClickOnXAxis;
  m_wasClickOnYAxis = other.m_wasClickOnYAxis;

  m_isMeasuringDistance = other.m_isMeasuringDistance;

  // The user-selected region over the plot.
  // Note that we cannot use QCPRange structures because these are normalized by
  // QCustomPlot in such a manner that lower is actually < upper. But we need
  // for a number of our calculations (specifically for the deconvolutions) to
  // actually have the lower value be start drag point.x even if the drag
  // direction was from right to left.
  m_xRegionRangeStart = other.m_xRegionRangeStart;
  m_xRegionRangeEnd   = other.m_xRegionRangeEnd;

  m_yRegionRangeStart = other.m_yRegionRangeStart;
  m_yRegionRangeEnd   = other.m_yRegionRangeEnd;

  m_xDelta = other.m_xDelta;
  m_yDelta = other.m_yDelta;

  m_pressedKeyCode  = other.m_pressedKeyCode;
  m_releasedKeyCode = other.m_releasedKeyCode;

  m_keyboardModifiers = other.m_keyboardModifiers;

  m_lastPressedMouseButton  = other.m_lastPressedMouseButton;
  m_lastReleasedMouseButton = other.m_lastReleasedMouseButton;

  m_pressedMouseButtons = other.m_pressedMouseButtons;

  m_mouseButtonsAtMousePress   = other.m_mouseButtonsAtMousePress;
  m_mouseButtonsAtMouseRelease = other.m_mouseButtonsAtMouseRelease;

  return *this;
}


MassSpecTracePlotContext &
MassSpecTracePlotContext::operator=(const MassSpecTracePlotContext &other)
{
  if(this == &other)
    return *this;

  // First the BasePlotContext members

  m_dataKind = other.m_dataKind;

  m_isMouseDragging  = other.m_isMouseDragging;
  m_wasMouseDragging = other.m_wasMouseDragging;

  m_isKeyBoardDragging            = other.m_isKeyBoardDragging;
  m_isLeftPseudoButtonKeyPressed  = other.m_isLeftPseudoButtonKeyPressed;
  m_isRightPseudoButtonKeyPressed = other.m_isRightPseudoButtonKeyPressed;
  m_wassKeyBoardDragging          = other.m_wassKeyBoardDragging;

  m_startDragPoint         = other.m_startDragPoint;
  m_currentDragPoint       = other.m_currentDragPoint;
  m_lastCursorHoveredPoint = other.m_lastCursorHoveredPoint;

  m_selectionPolygon     = other.m_selectionPolygon;
  m_selectRectangleWidth = other.m_selectRectangleWidth;

  // The effective range of the axes.
  m_xRange = other.m_xRange;
  m_yRange = other.m_yRange;

  // Tell if the mouse move was started onto either axis, because that will
  // condition if some calculations needs to be performed or not (for example,
  // if the mouse cursor motion was started on an axis, there is no point to
  // perform deconvolutions).
  m_wasClickOnXAxis = other.m_wasClickOnXAxis;
  m_wasClickOnYAxis = other.m_wasClickOnYAxis;

  m_isMeasuringDistance = other.m_isMeasuringDistance;

  // The user-selected region over the plot.
  // Note that we cannot use QCPRange structures because these are normalized by
  // QCustomPlot in such a manner that lower is actually < upper. But we need
  // for a number of our calculations (specifically for the deconvolutions) to
  // actually have the lower value be start drag point.x even if the drag
  // direction was from right to left.
  m_xRegionRangeStart = other.m_xRegionRangeStart;
  m_xRegionRangeEnd   = other.m_xRegionRangeEnd;

  m_yRegionRangeStart = other.m_yRegionRangeStart;
  m_yRegionRangeEnd   = other.m_yRegionRangeEnd;

  m_xDelta = other.m_xDelta;
  m_yDelta = other.m_yDelta;

  m_pressedKeyCode  = other.m_pressedKeyCode;
  m_releasedKeyCode = other.m_releasedKeyCode;

  m_keyboardModifiers = other.m_keyboardModifiers;

  m_lastPressedMouseButton  = other.m_lastPressedMouseButton;
  m_lastReleasedMouseButton = other.m_lastReleasedMouseButton;

  m_pressedMouseButtons = other.m_pressedMouseButtons;

  m_mouseButtonsAtMousePress   = other.m_mouseButtonsAtMousePress;
  m_mouseButtonsAtMouseRelease = other.m_mouseButtonsAtMouseRelease;

  // Second the mass spec trace plot-specific members

  m_lastZ              = other.m_lastZ;
  m_lastMz             = other.m_lastMz;
  m_lastTicIntensity   = other.m_lastTicIntensity;
  m_lastMr             = other.m_lastMr;
  m_lastResolvingPower = other.m_lastResolvingPower;

  return *this;
}


QString
MassSpecTracePlotContext::toString() const
{
  QString text("Base context:\n");

  text += BasePlotContext::toString();

  text += "\n";

  text += "Mass spectrum trace plot context\n";

  text += QString("last z: %1").arg(m_lastZ);
  text += QString("last m/z: %1").arg(m_lastMz, 0, 'f', 6);
  text += QString("last TIC intensity: %1").arg(m_lastTicIntensity, 0, 'g', 0);
  text += QString("last Mr: %1").arg(m_lastMr, 0, 'f', 6);
  text +=
    QString("last resolving power: %1").arg(m_lastResolvingPower, 0, 'g', 0);

  text += "\n";

  return text;
}


} // namespace pappso
