#include "osl/container/boardMask.h"
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;

class BoardMaskTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(BoardMaskTest);
  CPPUNIT_TEST(testIndex);
  CPPUNIT_TEST(testTakeOneBit);
  CPPUNIT_TEST_SUITE_END();
public:
  void testIndex();
  void testTakeOneBit();
};

CPPUNIT_TEST_SUITE_REGISTRATION(BoardMaskTest);

void BoardMaskTest::testIndex()
{
  for(int x=1;x<=9;x++){
    for(int y=1;y<=9;y++){
      Square pos(x,y);
      CPPUNIT_ASSERT_EQUAL(BoardMask::index(x,y), BoardMask::index(pos));
    }
  }
}

void BoardMaskTest::testTakeOneBit()
{
  BoardMask squares;
  squares.clear();
  for(int x=1;x<=9;x++){
    for(int y=1;y<=9;y++){
      Square sq(x,y);
      CPPUNIT_ASSERT(!squares.any());
      squares.set(sq);
      CPPUNIT_ASSERT(squares.any());
      CPPUNIT_ASSERT_EQUAL(sq, squares.takeOneBit());
    }
  }

}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
