/**
 * centering5x3.t.cc
 */
#include "osl/centering5x3.h"
#include "osl/centering3x3.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;

class Centering5x3Test : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(Centering5x3Test);
  CPPUNIT_TEST(test11);
  CPPUNIT_TEST(test22);
  CPPUNIT_TEST(testXY);
  CPPUNIT_TEST_SUITE_END();
public:
  void testXY();
  void test11();
  void test22();
  bool inSafeRegion5x3(Square) const;
};

CPPUNIT_TEST_SUITE_REGISTRATION(Centering5x3Test);

bool Centering5x3Test::inSafeRegion5x3(Square center) const
{
  if (! center.isOnBoard())
    return false;
  if (center != Centering3x3::adjustCenter(center))
    return false;
  const Square tl(center.x()+2, center.y()-1);
  const Square tr(center.x()-2, center.y()-1);
  const Square bl(center.x()+2, center.y()+1);
  const Square br(center.x()-2, center.y()+1);
  return tl.isOnBoard()
    && tr.isOnBoard()
    && bl.isOnBoard()
    && br.isOnBoard();
}

void Centering5x3Test::test11()
{
  CPPUNIT_ASSERT_EQUAL(Square(3,2), 
		       Centering5x3::adjustCenter(Square(1,1)));
}
void Centering5x3Test::test22()
{
  CPPUNIT_ASSERT_EQUAL(Square(3,2), 
		       Centering5x3::adjustCenter(Square(2,2)));
}


void Centering5x3Test::testXY()
{
  for (int y=0; y<=10; ++y)
  {
    for (int x=0; x<=10; ++x)
    {
      const Square target = Square(x,y);
      if (target.isOnBoard())
      {
	const Square center = Centering5x3::adjustCenter(target);
	CPPUNIT_ASSERT_EQUAL(Centering5x3::adjustCenterNaive(target),
			     center);
	CPPUNIT_ASSERT(inSafeRegion5x3(center));
	CPPUNIT_ASSERT((! inSafeRegion5x3(target))
		       || (target == center)); // 移動の必要がないものはそのまま
      }
      else
      {
	CPPUNIT_ASSERT(Centering5x3::adjustCenter(target).isPieceStand());
      }
    }
  }
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
