/* pieceEval.h
 */

#ifndef EVAL_ML_PIECEEVAL_H
#define EVAL_ML_PIECEEVAL_H

#include "osl/ptype.h"
#include "osl/misc/carray.h"
#include "osl/state/numEffectState.h"
#include "osl/eval/ml/weights.h"

namespace osl
{
  namespace eval
  {
    namespace ml
    {
      class PieceEval
      {
	static CArray<int, PTYPEO_SIZE> table;
      public:
	static void setUp(const Weights &weights);
	static int eval(const NumEffectState &state);
	template<Player P>
	static int evalWithUpdate(const NumEffectState &,
			   Move moved, int last_value)
	{
	  assert(moved.player()==P);
	  int value = last_value;
	  if (moved.isPass() || moved.isDrop())
	    return last_value;
	  if (moved.isPromotion())
	  {
	    value -= table[moved.oldPtypeO() - PTYPEO_MIN];
	    value += table[moved.ptypeO() - PTYPEO_MIN];
	  }
	  Ptype captured = moved.capturePtype();
	  if (captured != PTYPE_EMPTY)
	  {
	    value -= table[newPtypeO(alt(P), captured) - PTYPEO_MIN];
	    value += table[newPtypeO(P, unpromote(captured)) - PTYPEO_MIN];
	  }
	  return value;
	}
	static int value(PtypeO ptypeO);
      };
    }
  }
}
#endif // EVAL_ML_PIECEEVAL_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
