/* ----- decode/761x1531, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_761x1531_checksums[] = {
  "1d9d419824942784f9810ac0967c6076bf6e4e800aa310466fd37e6292214244",
  "f6b6bd7f4f922914729cf66245a429da337b5b13f845154adecbd2406e12f045",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_761x1531_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_761x1531_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_761x1531_ITEMBYTES

static void *storage_decode_761x1531_x;
static unsigned char *test_decode_761x1531_x;
static void *storage_decode_761x1531_s;
static unsigned char *test_decode_761x1531_s;
static void *storage_decode_761x1531_x2;
static unsigned char *test_decode_761x1531_x2;
static void *storage_decode_761x1531_s2;
static unsigned char *test_decode_761x1531_s2;

#define precomputed_decode_761x1531_NUM 4

static const int16_t precomputed_decode_761x1531_x[precomputed_decode_761x1531_NUM][crypto_decode_ITEMS] = {
  {1575,384,705,1524,1230,999,1755,-1527,-738,519,2121,-366,-951,-2223,-1308,-555,516,-2247,-1164,1140,2265,264,1893,-2184,642,-63,591,-2049,-888,-1008,-2187,21,2232,-1485,-687,-1632,558,-117,-921,1989,-2145,684,-2127,-27,-1845,1209,168,540,1926,1680,531,-375,-2085,-666,48,-780,1341,-2253,-141,-609,1890,1716,1929,-2073,2253,-1050,2196,2238,1644,1425,-471,138,2181,1110,525,-1398,-1530,1782,-1980,-1203,-588,393,-192,-1368,-1503,762,363,-1596,462,-627,648,-423,-843,-2058,-1044,1425,-48,-1287,1266,1233,-696,228,-597,807,-1920,-879,-1200,1164,366,2046,1680,2082,-2094,1068,474,-2052,-1473,-126,1461,1554,-753,933,-1200,549,123,2292,-1668,-627,159,-1407,705,1422,-1020,2010,1125,-2025,-693,-1707,-387,36,-1587,2088,-111,1683,-1602,456,786,135,882,234,333,1368,639,1398,1587,303,786,2109,-1050,1446,-54,-1983,1476,-1965,273,-480,-546,1446,-1662,849,423,-1881,1947,-1569,777,-987,-909,855,-777,390,249,1173,-318,147,1638,-1380,-72,-711,1677,-1401,1095,1638,2133,-909,1167,-888,1242,-216,2037,-828,2199,-1692,-417,1938,1491,-1989,123,-363,-432,1545,-108,1401,-1128,-2178,-1530,-615,-1167,-1494,2025,1494,723,-2046,1029,-279,-2280,2142,1797,-1143,-1692,-2073,1947,-1110,1815,-996,-1905,-1137,1209,-864,-1506,-555,1923,-1506,984,102,477,-2076,-1464,-1020,2052,279,255,-75,1290,-213,198,-1929,-2076,-612,-2085,1725,-1536,1698,1953,-843,1491,1524,474,1152,-2058,-84,1497,639,-267,1611,-1641,-1236,-30,1545,1860,2214,1422,69,-636,420,1983,1758,1908,534,2088,-243,-2109,-624,1713,-120,-804,1140,252,414,-1353,348,1131,1209,351,-2097,-648,-120,-2259,-219,-2064,204,624,2001,-2169,-930,1257,-480,1650,-1944,600,123,-303,-1605,-411,1254,2262,-1839,-2154,-2151,-1095,1377,276,-1821,-1416,-1983,-1983,-2127,1284,-201,2295,-549,921,-855,159,-963,-219,-2085,-717,-2100,-1938,21,1230,-747,570,1755,2118,-1842,309,-1698,-768,867,1677,1296,-276,855,-1692,-522,1509,2226,-2202,-201,-402,-1569,888,-147,-660,1758,-2001,-1344,1965,969,-897,1056,1278,1362,-1926,564,138,-1764,-2136,-1059,-2283,-870,-2280,396,-321,-276,465,-966,1596,-2055,-87,-1254,-2193,477,720,1002,-243,-1599,-2157,1431,483,-1875,-1050,-1542,-534,822,-2154,-855,-1506,774,-1752,-1899,1515,-1959,642,-48,2169,576,-777,-1224,75,708,1050,-507,-2175,1308,-2088,-912,-1869,129,-1206,1653,-741,-2202,-783,2190,-351,888,942,-1695,-1257,-1527,-2280,-1050,1254,-324,-1569,-342,987,-1890,-330,-1356,297,1260,1587,819,-693,1380,1044,-474,-1851,1461,-2214,1164,-786,-1083,-540,-1440,1347,2100,-1686,-723,15,1200,-2010,531,1194,897,540,-1719,1515,2172,-966,1890,1308,1665,-261,1311,1284,-1470,-1851,-843,2139,-999,1614,-270,-1605,-2205,984,-1191,900,2085,-1410,-21,1080,2295,-1839,-1710,1248,-2013,-1911,1755,957,1533,-2283,-1068,-327,1914,-549,-1089,549,78,1806,180,-204,1041,-681,-1437,1500,-1362,315,-756,-936,255,-225,2037,-2235,315,1659,1899,1446,1083,1569,-1110,237,-387,-1680,1110,-1179,-1785,-1641,1293,1320,1824,-468,1548,-351,2016,1758,1611,1881,-894,2049,-2136,-426,525,-588,-1269,-768,-912,-498,48,630,1284,-699,1179,-1557,-1584,1122,1536,900,-1005,750,-1026,-951,-339,-1305,636,762,543,-1350,1038,-2109,210,-1440,-351,-273,960,-1815,1578,-1032,-1920,531,-1356,-1512,-405,450,-315,858,-1182,-108,801,-498,513,1524,1266,-459,-1086,1974,-852,-1170,495,312,1803,-1188,1422,-153,-801,-1515,-141,-117,-1479,-1734,-1431,1200,1926,-876,-771,-288,-2139,588,2223,-249,-1143,-1677,-729,-732,-870,-99,-1368,-1935,-1413,-1239,738,1062,-1500,384,-1104,-519,360,-1779,390,297,-861,1242,1095,-369,39,321,-1398,495,-1548,-1323,-900,2181,-81,-153,-2106,1035,456,-1143,-1014,0,2079,-660,1845,1845,-1035,-1572,1758,-1818,1479,657,1533,-1401,2172,-558,-81,1359,2214,2046,-1608,1293,1197,135,234,-141,1041,-1380,-153,-534,-1155,-2175,1635,1092,276,1059,1473,-1374,-1269,-1785,2187,-1662,474,444,-1386,-540,-2103,516,-1074,-516,651,1374,-1317,-1422,-852,1005,-1056,810,-1530,2154,2133,-825,1458,-813,1464,-420,2169,-756,1611,912},
  {-900,-1770,1947,-2238,198,375,879,-561,-1674,1293,2028,-1914,1920,339,-1623,-792,-1362,-2100,900,-1059,-1638,-333,627,2052,51,1125,363,-453,-633,-1464,873,711,357,-354,1581,-1446,-2241,1080,-372,1209,-1974,-144,-255,-1302,-1893,246,-1683,1893,-1305,-1359,-1926,1338,-1590,1155,-1536,-1014,2106,-1677,975,-936,-2253,-1821,-945,738,1692,123,-1638,-1902,-222,612,120,1731,1341,-315,-1164,1233,1458,2142,2094,1845,-249,-2235,1365,1362,687,-1245,1494,-2052,1818,-462,867,132,-1509,2154,-1335,-1728,1545,2118,-1800,-1263,-1278,1839,1695,-1821,-321,-744,-138,-462,-1011,-1083,1323,1095,-531,2079,-1386,1941,1059,-1434,1221,-1677,651,834,675,630,372,-1167,-558,-309,498,1011,729,-312,-1533,1680,-327,-1596,-90,-618,-219,2127,2205,1476,-48,312,-2037,-849,69,429,432,-345,612,-690,-1557,915,564,882,1953,-1221,-2235,-1299,-30,-1518,-498,-1956,-1911,63,-2160,681,390,-282,-1518,-408,1812,-369,630,1101,1803,-591,780,189,-1485,987,1335,-432,-720,-207,816,1524,2211,-1578,171,-243,336,-12,969,-579,-630,-363,-1050,1494,-573,-1611,1521,-402,1065,912,477,1329,-1143,225,-1524,-798,-2238,-645,690,717,-2295,453,-666,-1803,72,1968,1434,-1686,-1680,1941,2142,1659,-1545,-1950,708,1431,1041,-330,-93,-1623,1164,-870,1737,-1440,1425,624,-1059,2295,627,1515,-1707,849,540,39,-300,-825,576,2172,396,-2076,2049,375,-1878,-1764,-1524,-639,1626,-1143,-2031,-516,-1956,2091,948,-2043,1026,-1524,87,-612,555,-741,-249,-2109,579,-1992,1944,-963,-1023,-1704,-810,-1317,2202,-255,-2052,1947,2001,339,-1725,-642,-330,-2082,-1737,-222,1440,-1356,723,-1914,-639,432,-492,-378,-2283,2025,723,-624,486,-2112,534,969,1329,-2265,-246,1941,1839,1836,672,-540,-1974,282,-2148,-492,750,-2271,351,39,78,1050,852,1848,-1071,-1179,-864,1470,1692,-1047,1437,-1707,-1725,-762,504,-1803,399,1401,1458,-1620,-765,-1929,96,603,1431,1890,-2232,1956,744,321,-2178,372,-1848,-1257,39,-1176,1578,1179,1077,-1161,954,480,-51,1203,-1428,90,-1620,-1095,-9,-1134,1332,264,1806,-1263,480,-1521,-2010,-1593,1131,-1239,69,-75,1809,2079,-1344,2025,1548,621,2166,-1683,-663,1614,-1740,-1365,-759,1779,1878,1344,165,1155,-2019,-2148,-1203,1608,1917,1302,-162,1578,-444,-1944,-78,-672,-1602,-1836,-1305,-1788,1857,225,-390,639,552,1050,171,-1974,-1224,-1110,-756,912,-201,1512,-327,-381,1404,2025,1383,-1071,606,-543,1581,1494,-930,2250,-1119,57,222,318,-990,-1812,-1197,-777,1059,-1659,-375,1125,663,-1920,1806,285,2109,-1122,1710,-1956,603,1839,-1419,-1254,1512,1353,-582,1095,-810,-1926,-2202,93,-762,-1974,564,1305,1722,84,1089,-1953,-624,30,1206,810,-2040,1767,-486,1935,-48,579,1698,420,-1077,-990,3,-1464,-2142,1929,-2151,2214,-90,-2190,-879,-2025,-621,1068,1044,-1056,1062,432,1164,-144,-2040,-2280,-1761,-642,966,-222,-1536,300,699,411,-906,-1563,237,1782,231,-909,972,-1095,-627,852,1593,-1692,1974,717,-1359,720,-2001,-372,-1125,1437,1914,780,-1599,153,930,-1314,-1851,-2085,1542,966,-1545,2211,-2244,1788,-1779,-2088,-492,690,-462,-1623,-1236,-1590,1152,1017,-1776,-333,-228,-108,-750,39,-1995,-1026,-1743,-999,240,1806,1413,-960,-2184,387,180,1833,-315,2223,297,-1176,1689,-1179,603,-510,1617,2142,699,-57,-246,435,102,-1602,-543,-1884,1080,1953,-417,792,1827,27,-894,-117,93,420,459,1437,-2280,1377,-648,132,1581,-2103,-1323,1599,-102,786,-1578,-867,-1272,-441,771,477,1791,-582,-417,2169,-1353,-2160,-1920,648,1269,-546,-1347,-561,-1041,1215,-1161,-468,-723,-951,-669,-1689,2139,444,240,771,972,-366,-1290,-1287,-2148,1068,-741,963,-489,528,-1344,-1407,-1230,-405,-1089,1434,-1296,1887,-831,-2016,768,267,786,963,-30,1821,-1557,-330,1794,1368,1932,-759,942,471,-222,588,237,-213,1653,165,1233,-1392,1704,201,-2106,-465,1158,-1512,1359,-1482,-594,-2208,777,510,2118,-1944,657,-1629,594,2142,-1971,1710,-267,-1983,1377,603,723,-1791,2295,-1260,1578,-1506,-924,-783,2052,570,345,285,-735,-2091,1488,426,-891,-1644,1788,240,1746,-114,1560,33,-468,210,-1434,-1347,2172},
  {1509,1194,657,-2172,-123,-1008,780,1602,-831,-2097,1278,-2004,543,1605,-1317,1998,-1350,99,-1140,-1911,-2019,-1134,-171,1365,-1056,207,717,-1221,-1017,-1512,-237,-162,-1569,867,2202,-1338,2127,432,432,-1533,1365,-1680,1224,-1305,666,1110,621,-2208,2202,480,1020,-1788,-2262,-36,-1554,-72,-90,1305,-1188,1137,-402,-183,1698,2178,-1407,2154,-291,-1347,903,1641,-1200,1503,21,-1935,-438,1158,-1923,-1953,2073,1158,-2073,-576,798,825,117,1818,-2106,-2172,1692,1896,-726,-1395,-1542,-66,-1164,2097,765,1890,-2178,699,1881,-303,1500,2247,2139,831,1836,-297,-1278,591,-1512,-102,477,696,-867,-459,-2166,546,-1287,2133,-930,234,-1914,-489,1113,1839,1755,1701,456,2034,-1239,-786,2007,1941,1809,-2268,1221,-621,996,-1110,966,-1446,1191,-2079,15,387,-885,1392,-1173,39,-435,90,1890,750,-2004,-300,240,-168,-702,-1098,-522,2226,-1884,-1059,1227,-651,-2112,-30,-165,612,-2244,1065,-135,90,411,1383,1212,-27,-216,-267,-390,1674,138,552,-132,-1677,-2154,-429,912,-867,-1986,-1722,882,1668,-2229,2067,-1164,1890,2073,-189,597,1398,-1824,135,-1722,-141,-729,-1137,-2265,1215,-312,-1131,-2229,-1278,552,-1965,-1407,-999,255,1467,1824,-1632,1983,-858,-201,-1644,642,-1833,-1419,1938,2076,1524,567,-1431,1581,-1662,36,-1242,-465,1500,2061,-1806,-1185,-93,-1779,1473,1104,-723,1923,-48,-2073,162,-2073,2061,378,2187,-1566,-1686,1272,1647,180,-2073,-1878,1059,834,1572,-576,1170,2052,1647,-2295,-1821,-2118,1365,966,990,-1476,-222,-780,-207,930,-315,-1314,1692,-1356,723,-1428,1080,915,-2295,900,-546,1485,1554,-1803,432,1632,-621,-2262,1047,342,-735,-306,-1674,-2130,-840,-141,-807,1806,675,-591,672,-225,-1209,-1713,1812,291,204,-141,-720,1341,1758,-1725,-756,90,972,-2199,-1662,1818,1503,216,-141,765,657,-1626,1584,1965,-54,1710,-2175,1782,279,159,1305,1536,-561,-318,-1515,2277,1701,-1104,-474,1071,-1722,-1602,-2190,-600,-588,666,-489,411,1584,537,-1164,1332,1020,-681,1596,-342,279,-918,1839,1920,339,600,-888,0,-1611,-648,-399,234,1182,1404,348,1578,858,-354,2151,201,2292,663,1611,759,1254,-1785,2205,1068,-357,-639,948,2133,1563,-954,-1950,1359,-816,-1764,2046,-675,1092,-420,-756,-636,801,-1305,-2106,-408,1839,1638,-375,-2085,330,-1638,852,2115,-1131,798,1338,1131,189,-693,-1314,1794,-1365,1299,1311,1224,1629,336,2181,-2163,-1038,-723,-405,2142,723,297,-2247,-1347,-423,-369,-2235,1794,-15,858,-1281,-1296,-2073,1095,-1731,-699,1389,180,-210,-627,261,183,2109,-384,-852,-849,753,522,-1008,1941,996,-546,-951,-129,813,-369,2262,435,273,-108,2010,2148,1998,-1497,327,-1725,813,-96,-717,-741,-687,-537,-810,-1926,1833,237,-831,807,324,-1785,-1629,1410,-879,1926,390,-714,1152,1710,-966,-321,-1359,-1671,2049,606,-2085,-2145,1521,-1224,-1800,1872,1848,1587,477,-645,-552,-1527,906,-996,858,-1668,-894,1059,918,-1152,219,2235,-486,-1104,-162,-525,2031,-393,-618,1842,291,-426,-1953,909,-1539,1152,-900,1155,285,210,1239,1026,-1050,777,2061,2160,-1323,-1059,1047,2253,186,-681,-1743,-2094,-1188,465,-1635,-1926,-1896,327,-723,1674,579,-1212,741,-2241,-1431,-1875,177,-615,222,-105,216,546,-84,138,399,384,900,-783,-2169,-1161,-2004,2055,-1143,-72,315,-2127,12,-1863,-42,-570,-510,-1203,9,327,1863,-1185,1317,-1764,-1071,-1440,-579,1527,-1995,213,2007,-960,-675,-2073,849,1089,-2166,-1791,813,-1038,-1290,1356,-1758,-153,2022,1128,540,-798,-1308,1407,-1794,2229,-1869,-975,399,1668,1257,-15,-1800,1767,1953,1374,1401,-1503,-687,-606,177,-285,1269,1236,-2226,-507,114,-1059,1986,-2286,1572,1836,-51,1776,2280,1614,-1938,2097,2211,2103,-102,492,-834,-2031,162,1950,-384,801,210,-642,-795,1317,942,2229,-1260,198,-1581,2256,-369,-1011,-1959,1824,1908,-1902,276,-2124,1905,-2154,-2202,423,-2205,669,-1254,-1266,-1938,-555,-1578,-1461,999,-570,1263,804,-933,-843,819,1881,1080,672,-1362,1431,-675,1224,-822,-555,594,-474,1149,2031,-1932,-1980,1842,-81,1659,-1806,-1185,438,915,-1194,-189,-2241,-1347,-132,2241,930,2157,-1908,-1821,639,-897,-774},
  {-591,1875,444,2268,-1326,1224,-375,1656,894,-1119,-1629,-792,-609,-282,2001,-1023,1869,2013,-981,1548,-1341,-276,240,-1149,-1851,1755,-2217,-1578,-2157,1764,1356,-1374,-2121,504,1011,795,1296,2232,813,1884,279,-825,2076,171,2061,438,-213,324,-483,1086,1419,-1236,606,2184,-513,-321,1515,-744,279,1383,81,1626,-1431,1002,1965,-387,-2232,285,1821,-1527,-351,-2091,-1443,-2082,780,-1545,-2052,51,-147,-2289,564,1698,-1902,1608,-1479,-549,-12,1455,162,-1785,615,-1983,660,1257,1113,-1497,312,1887,-141,-360,-810,-1263,-747,-1101,1746,246,2262,501,-369,-1437,-717,-1860,2211,18,-732,-1791,-621,-1422,270,630,444,-1797,441,-918,1299,867,1131,-1218,-2157,2049,-1551,-657,1173,1653,-108,2073,-696,1401,1290,552,-2154,12,825,-54,123,216,1320,-108,1302,492,1914,561,1626,1536,2160,1926,1224,-1512,2085,525,-1434,-228,1161,-96,1986,525,-174,-1632,171,1524,-327,-1086,-1212,2289,-291,-2274,1176,-2136,-1590,-1848,1395,1032,492,-654,-1314,-198,-2205,-1095,-672,-261,-1977,2100,1338,-1908,1131,960,888,-1284,-669,1113,-831,510,-1449,42,2244,-834,558,1548,639,489,-1860,990,-618,-528,-1206,-6,132,2130,531,795,1758,-93,480,2241,-300,-189,-804,963,-2109,-273,1254,-336,-942,1305,351,-1128,2052,1137,498,-492,-78,894,-489,-375,756,-822,-702,1674,960,-1872,237,-2235,2175,-15,1494,645,2058,747,-1359,-1008,516,2058,-1713,-831,-672,-1527,1374,834,-1626,2238,624,-129,411,1287,-810,300,228,-810,2034,-1218,-510,-1728,1083,-300,1926,1809,-1653,450,1503,2127,393,-1236,1623,2265,-882,1680,-714,-2112,474,-24,1614,-234,-1014,-180,-33,1563,-408,1767,-981,165,762,1671,-399,1473,-1053,-1911,891,-999,1035,447,-1539,1554,876,1440,855,-1746,435,1878,-1248,-57,966,-1239,-1614,-1461,-1422,2076,-78,-1353,-1515,609,753,345,-24,1656,-144,-894,204,351,1338,2277,1749,2040,1518,-699,2154,570,1545,-981,1539,828,-291,-225,-1281,471,1812,24,1263,-1194,-1929,1902,1983,-1773,-858,-1764,-1116,-219,2094,-1119,-1818,1446,-636,582,174,1065,1104,1989,-2241,-150,-1941,750,-663,-2121,-1485,36,-435,162,1884,834,939,-354,1464,-1137,1887,1851,690,-2220,672,-603,-957,-990,-2172,213,1710,-2250,942,-123,-441,510,177,885,2256,-1851,-1017,807,-468,-285,915,-921,1149,1161,48,453,882,2058,1245,-1473,-2250,-1776,-1146,-2295,-1461,-1335,1302,-1572,-2034,-1266,-1137,2016,-1269,-1779,621,1296,-1665,900,1701,840,-1191,-312,318,-1590,1410,-258,-846,1740,1950,-1278,648,402,-1317,-1533,-2043,-315,2022,-1659,1872,-1425,-1404,1086,1974,-1149,1800,1590,-1239,-1032,993,1647,771,1617,213,582,1290,1941,2295,2199,-1716,1464,-318,-1554,-2265,1842,2121,1206,1434,1212,1638,-1197,2265,18,189,-1785,-1446,876,642,-606,1716,1914,-471,1902,-648,1137,-93,-1689,1536,1902,1824,2007,-411,-1722,-2226,-1074,207,2220,657,2163,1146,252,-84,-1176,600,-1569,-819,153,1953,-2097,-2202,645,612,-1800,-840,-966,-2013,-1803,-177,396,-1737,48,1029,-219,-1797,1011,-1911,-2259,-1011,-2202,654,-291,1929,-1947,21,-1008,903,1713,729,2235,-939,-1227,-1803,-1914,1332,852,1605,1539,-2259,-144,-1341,2175,-2082,1752,-1590,1680,-903,-153,-1737,918,-831,225,2202,129,-288,-138,-1194,-651,1014,1788,1944,1773,-453,-312,1074,-1083,909,1815,-990,-1008,1440,-1869,-210,-2268,1812,-2055,1299,-192,723,2226,-1935,-474,-309,-1353,549,-2244,1686,-2001,1209,678,792,-522,1143,-1026,-1944,165,-2277,-888,534,1074,-846,-1131,-1890,-894,1794,-2157,1500,903,-1209,1431,1833,1014,21,-1995,-1701,135,525,1413,-1299,-1101,816,-1953,1929,-945,1164,1470,1965,-390,-2001,2088,438,1071,993,-1446,1170,-1275,-2253,1053,288,135,1512,867,-1869,-558,1293,-1347,-489,1689,-456,-675,1797,690,2244,534,-1473,1758,-1413,612,-1317,-384,-267,930,-726,1323,384,-1281,306,402,-1356,1332,1533,153,2040,-795,-1686,-1671,-1101,1929,-2076,1902,435,-318,942,-1551,1209,-882,-30,510,1443,-375,-1623,-774,1248,-87,1725,1698,-1044,1311,366,-105,2118,861,-2106,-1482,231,-2094,99,-1545,-1620,891,-1176,1164,1785,2124,1422,1797,1884},
} ;

static const unsigned char precomputed_decode_761x1531_s[precomputed_decode_761x1531_NUM][crypto_decode_STRBYTES] = {
  {153,11,37,70,181,49,72,245,89,28,71,187,75,40,116,16,159,199,137,230,205,116,198,192,158,46,171,48,118,212,86,14,209,86,233,137,169,213,116,77,185,180,33,233,187,165,89,105,93,171,168,4,69,232,52,174,94,6,243,213,254,233,73,245,106,181,162,178,66,79,99,242,254,49,172,147,199,36,87,68,227,195,135,236,91,216,204,124,76,127,188,173,42,149,90,207,190,89,18,23,237,227,240,146,109,201,194,15,65,245,79,52,34,212,87,207,229,248,63,179,91,170,47,200,231,222,29,221,84,26,254,20,17,42,234,214,54,245,243,14,115,124,47,14,89,93,15,148,174,5,166,40,252,136,8,213,71,207,218,7,26,89,247,63,168,67,29,80,7,156,208,134,86,201,99,131,93,204,129,103,203,31,62,133,125,189,41,190,49,76,1,216,222,182,41,189,128,109,241,129,25,22,118,36,236,226,184,0,207,12,33,198,50,31,1,137,183,179,68,198,183,107,197,207,79,90,234,202,59,163,114,59,200,41,126,32,150,19,184,33,143,65,249,195,241,225,124,233,44,74,32,86,232,80,21,165,89,131,201,199,34,80,7,41,108,65,58,1,132,222,97,43,126,22,216,225,81,224,162,34,126,228,92,119,217,81,159,19,139,252,22,130,118,85,130,195,180,4,53,129,136,239,117,113,105,52,145,183,175,220,177,15,202,133,42,77,183,62,16,254,134,27,18,237,153,87,42,156,194,211,186,161,50,188,7,49,10,137,80,145,197,47,106,143,109,41,131,45,48,142,13,236,21,217,103,46,240,179,22,63,223,146,172,214,133,124,204,166,9,182,35,105,190,59,16,247,123,117,97,147,102,93,171,183,98,42,18,181,232,249,221,167,139,23,244,37,107,225,138,116,63,201,55,28,12,104,250,111,71,229,1,184,209,109,192,14,196,89,5,78,146,146,19,38,51,236,119,88,13,70,249,105,183,149,211,237,184,73,149,187,98,86,108,185,118,206,157,220,35,153,14,110,28,120,34,196,5,114,62,87,222,129,20,67,168,201,235,215,155,46,162,144,221,142,47,7,109,135,239,116,143,75,44,130,91,227,216,20,92,16,199,30,62,164,54,188,54,134,170,191,16,48,222,47,140,199,135,87,33,206,188,82,73,185,72,224,232,19,19,205,171,138,150,222,79,124,122,10,137,110,147,183,67,63,9,25,223,31,248,10,91,218,109,29,29,146,58,209,233,36,164,110,195,127,227,209,73,254,142,251,45,220,172,243,91,134,83,46,152,234,16,65,188,85,24,219,219,192,11,135,140,38,86,81,107,123,70,141,249,4,192,47,40,141,18,216,182,142,37,49,166,63,37,248,156,19,66,147,77,96,76,173,100,255,114,80,169,245,96,218,224,237,156,182,64,211,90,172,12,132,160,202,77,54,120,135,0,28,28,26,233,235,59,191,92,126,252,169,24,121,16,140,157,30,199,151,21,212,230,87,164,242,211,48,149,17,26,209,93,100,43,109,65,60,100,232,214,26,37,18,58,191,43,3,138,197,235,130,84,135,126,141,219,31,41,85,235,159,3,6,68,197,126,192,179,236,117,65,188,136,57,241,98,38,252,6,192,220,106,81,170,188,234,5,151,20,141,143,165,3,254,197,69,5,60,66,185,224,168,221,100,163,16,28,193,120,67,175,218,131,157,28,15,185,121,18,222,89,225,79,40,26,188,69,184,119,23,213,239,250,2,9,215,195,68,24,11,137,165,212,92,115,236,185,136,155,5,32,65,66,156,106,95,192,39,244,209,224,66,250,220,132,231,54,126,109,202,141,148,50,4,117,87,32,235,26,214,113,255,81,205,220,230,25,255,42,149,4,215,19,123,135,129,198,33,185,104,54,81,11,240,234,2,76,176,132,101,105,105,192,70,224,84,89,23,50,138,158,241,77,7,64,103,66,125,208,17,227,146,240,239,123,55,238,15,90,208,74,78,254,29,40,215,115,115,241,6,237,63,137,14,178,31,99,74,203,118,64,122,48,27,13,240,188,240,205,215,217,128,50,171,185,112,113,213,96,8,13,187,143,169,39,217,99,154,121,125,122,94,117,32,70,249,46,107,72,80,125,101,229,254,134,252,194,57,134,1,86,168,68,122,134,192,238,21,202,216,249,254,128,84,200,200,215,72,104,190,246,84,58,210,242,161,223,66,27,47,216,217,79,138,200,231,200,66,233,47,127,12,142,79,98,155,122,217,248,19,190,19,22,10,61,124,195,204,16,23},
  {102,39,221,216,115,38,87,23,242,29,21,129,202,120,193,142,209,133,25,177,106,49,251,136,50,212,117,166,181,105,248,3,115,76,198,239,216,129,0,195,70,245,12,90,108,81,15,143,69,237,105,28,121,224,200,164,210,155,195,142,119,211,33,85,29,7,29,3,244,234,79,244,236,88,219,86,16,10,138,152,228,34,38,205,100,186,207,179,62,213,176,153,117,48,51,218,144,20,151,244,202,165,127,4,24,66,85,71,28,235,84,228,57,9,187,167,141,126,58,175,215,186,0,76,127,7,168,20,70,22,57,155,195,227,149,78,37,152,116,197,217,207,145,147,179,114,251,44,59,192,115,103,222,228,13,110,111,134,23,125,112,164,116,207,64,80,32,84,90,17,8,195,113,114,126,156,63,155,104,237,202,211,193,109,2,42,38,154,17,107,16,159,147,205,150,160,222,29,5,211,173,171,122,190,190,103,3,17,144,32,82,234,253,0,97,238,31,174,32,241,26,177,210,95,97,48,56,68,142,140,58,60,105,139,25,2,220,93,53,41,136,147,232,73,190,46,10,88,227,209,55,134,23,149,179,213,48,22,73,72,158,128,60,239,192,24,72,11,193,68,113,175,35,243,151,221,58,118,248,208,54,196,164,124,83,234,3,202,237,231,116,209,33,72,154,35,175,89,42,23,236,39,53,84,229,156,155,189,89,64,165,111,74,29,88,204,234,204,163,67,242,43,98,89,84,65,242,200,149,76,44,241,87,178,191,76,208,249,117,21,75,19,23,79,205,39,43,122,129,53,238,190,32,183,245,85,102,119,166,189,118,130,224,89,156,234,166,61,232,241,2,164,180,54,151,208,16,221,18,243,171,164,97,135,162,255,209,213,185,216,89,85,171,151,150,208,5,44,255,91,246,255,154,163,61,234,64,246,146,23,208,17,41,158,113,204,81,226,92,251,112,39,126,91,93,154,253,41,79,140,64,221,126,225,3,219,194,27,220,185,211,63,233,123,203,253,57,45,6,1,46,139,31,43,1,153,133,136,231,98,205,193,57,235,170,180,13,106,81,99,173,152,201,88,76,234,111,160,23,138,159,230,41,7,174,39,49,132,20,75,127,80,13,71,19,78,7,146,62,213,186,181,27,233,57,226,100,157,191,12,151,142,221,170,211,82,111,86,144,209,171,198,39,253,176,133,118,182,201,47,177,213,94,58,55,120,174,10,239,117,195,209,73,46,187,44,65,39,196,114,73,4,15,237,205,40,219,94,132,54,237,43,147,83,249,140,95,127,90,199,184,48,157,127,185,187,13,149,103,64,40,43,194,98,89,11,142,200,97,52,197,229,236,176,102,49,234,45,126,191,50,237,212,131,4,77,30,81,35,246,44,241,123,80,53,48,192,49,117,166,217,25,189,59,113,236,151,134,219,143,241,249,210,215,112,249,96,116,4,200,20,200,185,100,182,255,95,56,72,154,43,207,212,159,24,168,36,83,147,203,112,234,78,91,221,165,52,121,113,144,112,88,90,22,132,161,170,75,83,72,199,187,135,1,76,118,173,194,14,148,250,172,11,230,183,37,83,150,20,155,101,241,139,220,90,222,175,216,88,168,55,157,208,228,202,190,17,156,72,166,101,35,65,36,178,245,69,7,65,12,82,93,105,35,180,202,154,19,54,195,0,252,128,178,25,194,25,27,76,75,87,28,97,146,93,191,122,22,238,39,16,106,88,1,237,20,243,123,109,214,251,164,31,254,156,47,40,208,247,117,94,13,180,40,222,15,161,137,78,187,254,153,148,197,177,164,222,6,179,9,205,164,92,5,142,33,5,67,195,179,3,41,98,190,74,179,242,166,207,34,153,95,154,231,75,87,210,130,71,89,140,63,34,105,126,241,193,135,254,90,221,231,118,25,18,141,122,3,252,227,185,39,165,246,137,111,35,168,250,16,130,247,184,229,93,87,89,149,11,96,83,209,229,189,148,44,44,37,61,156,112,100,18,74,74,27,243,69,101,165,89,41,181,3,4,37,38,88,58,65,207,251,197,18,239,207,85,123,72,181,192,60,255,221,10,153,112,200,217,189,212,254,216,118,162,56,21,180,201,28,207,27,109,17,64,186,38,232,72,73,16,245,146,241,98,199,125,12,250,42,110,228,21,48,251,249,245,144,65,174,132,170,164,44,213,77,202,91,229,229,173,150,72,186,89,132,246,166,6,2,20,238,1,239,214,85,123,202,42,202,234,96,253,5,173,160,1,14,236,72,246,137,8,91,27,107,162},
  {61,11,115,162,158,194,78,83,165,1,205,240,83,238,145,203,92,160,1,151,195,35,176,59,202,4,86,126,111,25,183,20,49,112,138,179,172,240,66,53,25,183,93,114,232,47,120,225,189,169,120,95,108,95,137,190,35,232,172,124,80,189,134,66,102,141,6,43,174,146,184,34,140,213,68,229,160,100,116,72,224,125,226,126,217,49,73,148,205,129,164,162,203,9,225,172,86,176,58,250,185,203,185,128,48,1,119,143,184,212,12,55,125,209,149,212,26,237,46,173,125,28,36,49,221,75,238,77,252,251,199,181,230,174,255,234,103,220,146,97,79,82,147,40,46,198,221,227,55,73,71,140,190,30,1,231,160,5,25,141,89,185,214,1,161,63,196,158,245,111,141,194,179,127,240,178,167,56,24,25,69,83,36,197,201,225,87,156,137,205,168,156,132,149,99,108,223,94,195,11,166,128,33,110,15,108,1,15,139,159,47,94,42,96,74,179,69,52,9,73,253,190,33,16,12,30,123,129,219,190,24,166,136,142,24,10,74,23,135,150,215,214,210,214,248,130,151,142,159,155,196,253,84,155,4,158,144,122,136,105,90,44,116,2,205,41,42,178,115,31,31,170,36,143,141,53,64,104,178,65,56,164,121,218,197,130,14,76,226,46,117,165,114,116,205,129,78,161,176,38,149,42,231,51,229,160,108,88,238,185,241,6,66,49,210,145,108,24,66,175,0,134,143,30,46,9,191,162,183,144,27,106,38,165,189,214,197,132,196,98,115,30,89,22,185,99,161,39,153,99,124,0,198,225,148,244,21,4,153,164,21,43,158,119,202,78,254,117,243,69,122,36,105,169,185,230,73,55,107,184,205,229,212,250,244,154,205,5,224,61,20,191,93,165,176,105,189,99,124,190,240,100,188,213,180,231,39,84,242,62,54,176,154,126,142,29,9,4,247,146,46,143,147,91,187,18,96,127,42,1,183,211,65,81,222,246,143,159,139,147,3,22,36,223,62,144,105,95,195,163,95,206,184,50,18,154,40,199,55,186,86,107,64,232,247,246,24,244,110,65,80,122,122,203,240,155,243,6,239,99,97,240,100,212,244,175,148,99,30,65,189,7,32,32,65,141,248,234,65,84,215,139,34,146,174,112,253,253,204,136,211,52,209,121,39,5,120,150,121,224,112,187,174,76,174,163,41,169,172,229,97,78,17,227,178,179,99,25,87,23,128,204,153,110,69,131,201,148,60,41,135,41,174,154,78,118,20,92,177,158,210,157,219,21,135,176,96,109,239,81,211,223,119,193,97,152,29,148,170,168,69,99,15,57,216,14,0,233,11,141,123,182,28,123,85,132,128,17,105,77,38,169,181,236,119,26,19,3,195,157,45,58,239,35,117,74,199,120,7,14,8,207,7,152,111,208,47,37,11,215,113,247,167,5,235,104,218,11,146,24,3,42,143,241,186,198,220,88,178,137,237,77,199,130,132,166,12,40,195,219,161,211,250,3,93,13,162,84,32,84,95,215,250,150,107,209,236,206,149,114,187,167,104,172,19,125,230,170,201,9,100,78,222,148,84,144,29,62,83,196,77,52,222,122,226,43,26,231,234,17,81,25,98,61,227,32,119,14,88,219,13,129,229,31,245,33,98,48,107,67,95,118,137,218,199,110,204,167,26,152,18,5,130,220,241,229,193,255,208,246,248,218,47,141,12,1,0,193,175,216,34,81,107,43,11,20,141,188,8,194,101,251,66,45,255,247,164,74,3,43,88,167,53,7,191,164,68,24,129,176,101,172,74,197,147,86,231,162,158,120,172,88,34,217,29,59,127,16,214,229,96,173,23,244,237,14,17,157,203,149,203,97,125,139,5,138,123,188,211,133,189,154,182,176,238,65,241,85,195,24,19,222,192,159,251,151,162,25,145,99,124,195,101,126,216,49,17,231,54,37,213,23,189,171,25,173,43,184,36,22,166,41,101,252,215,79,87,127,228,123,119,205,50,200,49,144,154,66,209,92,107,212,210,35,207,113,141,151,162,211,110,172,153,68,100,157,148,30,169,94,163,135,182,153,53,94,34,65,231,40,245,161,67,220,146,51,234,130,145,177,147,159,51,181,3,84,240,102,38,135,114,166,254,129,193,93,191,129,72,157,138,74,107,91,217,159,241,33,213,219,202,22,136,194,43,210,111,122,41,126,68,111,15,199,34,206,231,41,191,252,17,168,99,55,3,136,14,29,250,199,100,63,218,130,67,5,37,71,238,138,4,15,13,45,185,157,31},
  {18,220,90,199,127,21,23,80,96,177,25,215,54,111,193,194,1,48,52,215,200,163,225,169,89,241,158,120,221,104,145,169,32,73,92,52,185,31,11,194,186,26,178,143,225,194,185,62,43,53,55,62,184,187,236,57,207,193,127,76,83,153,24,115,230,78,208,105,5,34,42,121,205,120,138,227,42,82,124,88,170,47,55,114,89,177,145,121,124,2,37,242,160,78,223,205,54,69,144,238,165,227,102,178,178,46,174,132,90,144,241,21,227,187,20,222,83,217,81,230,32,218,98,60,124,232,250,203,221,215,82,58,29,104,92,179,52,10,158,160,162,105,199,247,40,155,106,246,222,210,172,230,212,3,178,41,240,30,182,124,237,208,135,99,203,95,117,174,193,28,200,60,174,7,247,11,147,36,114,169,34,80,64,119,39,44,106,5,15,68,110,87,137,27,163,254,225,109,18,147,91,116,102,217,63,213,236,19,39,132,9,120,75,60,252,41,204,66,174,127,214,250,164,113,250,107,5,203,135,208,144,158,232,70,80,112,123,195,38,25,10,39,158,134,137,23,184,72,192,27,245,6,249,225,234,118,212,210,13,205,236,170,91,185,36,221,210,230,152,11,252,62,251,144,62,42,61,121,208,32,68,17,203,60,163,18,114,208,41,60,30,11,36,238,10,222,207,128,19,146,187,186,9,125,127,106,82,23,138,201,253,127,157,116,95,69,53,122,55,113,221,192,79,104,109,31,40,213,16,244,136,134,211,182,254,37,217,165,193,223,66,139,95,63,128,106,217,229,126,175,57,213,165,125,227,212,156,12,225,187,14,246,175,95,93,176,94,249,61,61,39,53,51,244,251,60,35,240,139,51,114,123,198,219,117,202,16,26,183,179,165,156,51,202,139,55,48,89,139,154,82,161,144,221,229,158,137,59,155,237,172,135,148,169,189,43,48,116,11,7,212,81,39,234,240,87,19,248,248,118,17,219,5,154,105,114,46,162,64,46,144,250,231,164,29,121,96,31,186,191,138,199,204,213,130,60,78,153,68,65,205,44,215,20,220,33,143,73,173,163,95,143,13,73,181,48,153,62,218,117,24,16,22,229,90,36,232,193,23,66,88,4,72,183,216,62,71,135,192,177,97,26,142,211,49,15,19,142,83,160,44,253,103,47,114,227,59,47,155,187,237,66,218,178,62,131,16,117,104,245,46,72,65,227,39,76,148,72,113,85,54,237,84,206,95,191,49,150,238,8,181,248,129,130,193,86,219,218,110,134,24,165,71,83,157,71,0,122,88,26,10,98,228,151,130,183,219,184,200,63,15,143,137,182,14,134,132,145,56,56,8,54,124,83,186,239,64,179,104,157,115,238,34,247,103,185,136,239,242,202,194,37,4,192,71,132,48,0,143,18,185,21,152,64,47,159,226,59,26,85,236,158,185,0,245,90,97,10,152,67,121,167,221,249,153,250,183,19,80,198,225,246,186,106,68,28,114,188,41,253,47,33,133,186,170,255,100,192,22,52,160,65,159,75,160,226,234,54,108,43,25,212,50,188,77,92,53,93,231,124,124,210,230,188,52,148,197,111,174,63,111,218,95,73,180,114,178,111,245,213,36,204,85,181,220,124,254,26,41,165,253,88,135,246,142,0,46,28,221,15,142,112,133,18,55,156,104,170,255,220,204,16,179,212,199,169,48,180,135,249,43,145,61,115,85,80,128,163,88,145,247,162,46,199,93,175,39,0,206,209,63,87,27,11,140,127,200,25,97,152,101,81,124,78,139,139,147,93,139,69,23,17,102,104,211,44,39,120,107,107,16,38,41,225,30,2,146,18,85,172,131,186,118,127,229,201,232,196,239,243,96,156,128,133,149,145,233,202,138,140,26,92,109,103,190,113,121,67,6,238,170,123,164,120,170,165,86,105,240,170,145,13,88,226,195,128,133,63,131,191,61,191,172,31,251,104,122,126,102,235,164,198,18,142,61,159,10,237,201,140,186,116,135,173,65,151,252,244,193,222,67,160,224,153,33,182,108,127,31,1,67,74,119,242,91,55,164,227,178,251,8,16,229,197,74,75,180,25,108,176,25,226,232,173,108,229,106,182,115,191,247,87,193,155,147,161,132,126,102,143,14,68,56,174,185,15,218,238,24,71,31,218,36,172,173,177,136,99,20,203,196,192,79,63,31,0,62,200,194,224,212,21,176,66,110,107,31,192,206,249,10,225,83,97,167,172,255,163,202,241,149,75,70,70,104,140,79,103,230,143,180,114,102,111,3,0,148},
} ;

static void test_decode_761x1531_impl(long long impl)
{
  unsigned char *x = test_decode_761x1531_x;
  unsigned char *s = test_decode_761x1531_s;
  unsigned char *x2 = test_decode_761x1531_x2;
  unsigned char *s2 = test_decode_761x1531_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_761x1531_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_761x1531(impl);
    printf("decode_761x1531 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_761x1531_implementation(impl),ntruprime_dispatch_decode_761x1531_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_761x1531;
    printf("decode_761x1531 selected implementation %s compiler %s\n",ntruprime_decode_761x1531_implementation(),ntruprime_decode_761x1531_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_761x1531_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_761x1531_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_761x1531_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_761x1531_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_761x1531_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_761x1531_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_761x1531(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"761x1531")) return;
  storage_decode_761x1531_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_761x1531_x = aligned(storage_decode_761x1531_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_761x1531_s = callocplus(crypto_decode_STRBYTES);
  test_decode_761x1531_s = aligned(storage_decode_761x1531_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_761x1531_x2 = callocplus(maxalloc);
  test_decode_761x1531_x2 = aligned(storage_decode_761x1531_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_761x1531_s2 = callocplus(maxalloc);
  test_decode_761x1531_s2 = aligned(storage_decode_761x1531_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_761x1531 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_761x1531();++impl)
      forked(test_decode_761x1531_impl,impl);
    ++test_decode_761x1531_x;
    ++test_decode_761x1531_s;
    ++test_decode_761x1531_x2;
    ++test_decode_761x1531_s2;
  }
  free(storage_decode_761x1531_s2);
  free(storage_decode_761x1531_x2);
  free(storage_decode_761x1531_s);
  free(storage_decode_761x1531_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

