/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.lib.ddl;

/**
* Interface of foreign key constraint.
*
* @author Slavek Psenicka
*/
public interface ForeignKeyConstraintDescriptor extends TableConstraintDescriptor
{
    /** Returns name of Referenced table */
    public String getReferencedTableName();

    /** Sets name of Referenced table
    * @param cname Referenced table name.
    */
    public void setReferencedTableName(String cname);

    /** Returns name of Referenced column */
    public String getReferencedColumnName();

    /** Sets name of Referenced column
    * @param cname Referenced column name.
    */
    public void setReferencedColumnName(String cname);
}

/*
* <<Log>>
*  4    Gandalf   1.3         10/22/99 Ian Formanek    NO SEMANTIC CHANGE - Sun 
*       Microsystems Copyright in File Comment
*  3    Gandalf   1.2         5/14/99  Slavek Psenicka new version
*  2    Gandalf   1.1         4/23/99  Slavek Psenicka new version
*  1    Gandalf   1.0         4/6/99   Slavek Psenicka 
* $
*/
