package Locales::DB::Language::et;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Language::et::VERSION = '0.09';

$Locales::DB::Language::et::cldr_version = '2.0';

%Locales::DB::Language::et::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => ' ',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Keel\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ ja\ \{1\}",
            'end'    => "\{0\}\ ja\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Regioon\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '“',
        'alternate_quotation_start' => '„',
        'quotation_end'             => '“',
        'quotation_start'           => '„'
    },
    'fallback' => [
        'fi',
        'en'
    ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
            }
        }
    },
    'posix' => {
        'nostr'  => "ei\:e",
        'yesstr' => "jah\:j"
    },
);

%Locales::DB::Language::et::code_to_name = (
    'aa'     => 'afari',
    'ab'     => 'abhaasi',
    'ace'    => 'atšehi',
    'ach'    => 'akoli',
    'ada'    => 'adangme',
    'ady'    => 'adõgee',
    'ae'     => 'avesta',
    'af'     => 'afrikaani',
    'afa'    => "afroaasia\ keel",
    'afh'    => 'afrihili',
    'agq'    => 'Aghem',
    'ain'    => 'ainu',
    'ak'     => 'akani',
    'akk'    => 'akadi',
    'ale'    => 'aleuudi',
    'alg'    => "algonkini\ keel",
    'alt'    => 'altai',
    'am'     => 'amhari',
    'an'     => 'aragoni',
    'ang'    => 'vanainglise',
    'anp'    => 'angika',
    'apa'    => "apatši\ keel",
    'ar'     => 'araabia',
    'arc'    => 'aramea',
    'arn'    => 'araukaani',
    'arp'    => 'arapaho',
    'art'    => "muu\ tehiskeel",
    'arw'    => 'aravaki',
    'as'     => 'assami',
    'asa'    => 'Asu',
    'ast'    => 'astuuria',
    'ath'    => "atapaski\ keeled",
    'aus'    => "austraali\ keel",
    'av'     => 'avaari',
    'awa'    => 'avadhi',
    'ay'     => 'aimara',
    'az'     => 'aseri',
    'ba'     => 'baškiiri',
    'bad'    => 'banda',
    'bai'    => "bamileke\ keel",
    'bal'    => 'belutši',
    'ban'    => 'bali',
    'bas'    => 'basa',
    'bat'    => "balti\ keel",
    'be'     => 'valgevene',
    'bej'    => 'bedža',
    'bem'    => 'bemba',
    'ber'    => 'berberi',
    'bez'    => 'Bena',
    'bg'     => 'bulgaaria',
    'bh'     => 'bihaari',
    'bho'    => 'bhodžpuri',
    'bi'     => 'bislama',
    'bik'    => 'bikoli',
    'bin'    => 'edo',
    'bla'    => 'siksika',
    'bm'     => 'bambara',
    'bn'     => 'bengali',
    'bnt'    => 'bantu',
    'bo'     => 'tiibeti',
    'br'     => 'bretooni',
    'bra'    => 'bradži',
    'brx'    => 'Bodo',
    'bs'     => 'bosnia',
    'btk'    => 'bataki',
    'bua'    => 'burjaadi',
    'bug'    => 'bugi',
    'byn'    => 'bilini',
    'ca'     => 'katalaani',
    'cad'    => 'kado',
    'cai'    => "Kesk\-Ameerika\ indiaani\ keel",
    'car'    => 'kariibi',
    'cau'    => "kaukaasia\ keel",
    'cay'    => 'Cayuga',
    'cch'    => 'atsami',
    'ce'     => 'tšetšeeni',
    'ceb'    => 'sebu',
    'cel'    => "keldi\ keel",
    'cgg'    => 'Chiga',
    'ch'     => 'tšamorro',
    'chb'    => 'tšibtša',
    'chg'    => 'tšagatai',
    'chk'    => 'tšuugi',
    'chm'    => 'mari',
    'chn'    => "tšinuki\ žargoon",
    'cho'    => 'tšokto',
    'chp'    => 'tšipevai',
    'chr'    => 'tšerokii',
    'chy'    => 'šaieeni',
    'cmc'    => "tšami\ keeled",
    'co'     => 'korsika',
    'cop'    => 'kopti',
    'cpe'    => "inglispõhjalised\ kreool\-\ ja\ pidžinkeeled",
    'cpf'    => "prantsuspõhjalised\ kreool\-\ ja\ pidžinkeeled",
    'cpp'    => "portugalipõhjalised\ kreooli\-\/pidžinkeeled",
    'cr'     => 'krii',
    'crh'    => 'krimmitatari',
    'crp'    => "kreool\-\ või\ pidžinkeel",
    'cs'     => 'tšehhi',
    'csb'    => 'kašuubi',
    'cu'     => 'kirikuslaavi',
    'cus'    => "muu\ kuši\ keel",
    'cv'     => 'tšuvaši',
    'cy'     => 'kõmri',
    'da'     => 'taani',
    'dak'    => 'siuu',
    'dar'    => 'dargi',
    'dav'    => 'Taita',
    'day'    => 'dajaki',
    'de'     => 'saksa',
    'de_at'  => "Austrian\ German",
    'de_ch'  => "saksa\ \(kõrgsaksa\)",
    'del'    => 'delavari',
    'den'    => 'sleivi',
    'dgr'    => 'dogribi',
    'din'    => 'dinka',
    'dje'    => 'Zarma',
    'doi'    => 'dogri',
    'dra'    => "draviidi\ keel",
    'dsb'    => 'alamsorbi',
    'dua'    => 'duala',
    'dum'    => 'keskhollandi',
    'dv'     => 'maldiivi',
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'djula',
    'dz'     => 'bhutani',
    'ebu'    => 'Embu',
    'ee'     => 'eve',
    'efi'    => 'ibibio',
    'egy'    => 'muinasegiptuse',
    'eka'    => 'ekadžuki',
    'el'     => 'kreeka',
    'elx'    => 'eelami',
    'en'     => 'inglise',
    'en_au'  => "Australian\ English",
    'en_ca'  => "Canadian\ English",
    'en_gb'  => "inglise\ \(Briti\)",
    'en_us'  => "inglise\ \(USA\)",
    'enm'    => 'keskinglise',
    'eo'     => 'esperanto',
    'es'     => 'hispaania',
    'es_419' => "hispaania\ \(Ladina\-Ameerika\)",
    'es_es'  => "hispaania\ \(Ibeeria\)",
    'et'     => 'eesti',
    'eu'     => 'baski',
    'ewo'    => 'evondo',
    'fa'     => 'pärsia',
    'fan'    => 'fangi',
    'fat'    => 'fanti',
    'ff'     => 'fulbe',
    'fi'     => 'soome',
    'fil'    => 'filipino',
    'fiu'    => "soomeugri\ keel",
    'fj'     => 'fidži',
    'fo'     => 'fääri',
    'fon'    => 'foni',
    'fr'     => 'prantsuse',
    'fr_ca'  => "Canadian\ French",
    'fr_ch'  => "Swiss\ French",
    'frm'    => 'keskprantsuse',
    'fro'    => 'vanaprantsuse',
    'frr'    => 'põhjafriisi',
    'frs'    => 'idafriisi',
    'fur'    => 'friuuli',
    'fy'     => 'läänefriisi',
    'ga'     => 'iiri',
    'gaa'    => 'gaa',
    'gay'    => 'gajo',
    'gba'    => 'gbaja',
    'gd'     => 'gaeli',
    'gem'    => "germaani\ keel",
    'gez'    => 'etioopia',
    'gil'    => 'kiribati',
    'gl'     => 'galeegi',
    'gmh'    => 'keskülemsaksa',
    'gn'     => 'guaranii',
    'goh'    => 'vanaülemsaksa',
    'gon'    => 'gondi',
    'gor'    => 'gorontalo',
    'got'    => 'gooti',
    'grb'    => 'grebo',
    'grc'    => 'vanakreeka',
    'gsw'    => 'alemanni',
    'gu'     => 'gudžarati',
    'guz'    => 'Gusii',
    'gv'     => 'mänksi',
    'gwi'    => 'gvitšini',
    'ha'     => 'hausa',
    'hai'    => 'haida',
    'haw'    => 'havai',
    'he'     => 'heebrea',
    'hi'     => 'hindi',
    'hil'    => 'hiligainoni',
    'him'    => 'himtšali',
    'hit'    => 'heti',
    'hmn'    => 'hmongi',
    'ho'     => 'motu',
    'hr'     => 'horvaadi',
    'hsb'    => 'ülemsorbi',
    'ht'     => 'haiti',
    'hu'     => 'ungari',
    'hup'    => 'hupa',
    'hy'     => 'armeenia',
    'hz'     => 'herero',
    'ia'     => 'interlingua',
    'iba'    => 'ibani',
    'id'     => 'indoneesia',
    'ie'     => 'interlingue',
    'ig'     => 'ibo',
    'ii'     => "sichuani\ jii",
    'ijo'    => 'idžo',
    'ik'     => 'injupiaki',
    'ilo'    => 'iloko',
    'inc'    => "india\ keel",
    'ine'    => "indoeuroopa\ keel",
    'inh'    => 'inguši',
    'io'     => 'ido',
    'ira'    => "iraani\ keeled",
    'iro'    => "irokeesi\ keel",
    'is'     => 'islandi',
    'it'     => 'itaalia',
    'iu'     => 'inuktituti',
    'ja'     => 'jaapani',
    'jbo'    => 'lojbani',
    'jmc'    => 'Machame',
    'jpr'    => 'juudipärsia',
    'jrb'    => 'juudiaraabia',
    'jv'     => 'jaava',
    'ka'     => 'gruusia',
    'kaa'    => 'karakalpaki',
    'kab'    => 'kabiili',
    'kac'    => 'katšini',
    'kaj'    => 'jju',
    'kam'    => 'kamba',
    'kar'    => "kareni\ keel",
    'kaw'    => 'kaavi',
    'kbd'    => "kabardi\-tšerkessi",
    'kcg'    => 'tyapi',
    'kde'    => 'Makonde',
    'kea'    => 'Kabuverdianu',
    'kfo'    => 'koro',
    'kg'     => 'kongo',
    'kha'    => 'khasi',
    'khi'    => "khoisani\ keel",
    'kho'    => 'saki',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'kikuju',
    'kj'     => 'ambo',
    'kk'     => 'kasahhi',
    'kl'     => 'grööni',
    'kln'    => 'Kalenjin',
    'km'     => 'khmeeri',
    'kmb'    => 'mbundu',
    'kn'     => 'kannada',
    'ko'     => 'korea',
    'kok'    => 'konkani',
    'kos'    => 'kosrae',
    'kpe'    => 'kpelle',
    'kr'     => 'kanuri',
    'krc'    => "karatšai\-balkaari",
    'krl'    => 'karjala',
    'kro'    => 'kruu',
    'kru'    => 'oraoni',
    'ks'     => 'kašmiiri',
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'kurdi',
    'kum'    => 'kumõki',
    'kut'    => 'kutenai',
    'kv'     => 'komi',
    'kw'     => 'korni',
    'ky'     => 'kirgiisi',
    'la'     => 'ladina',
    'lad'    => 'ladiino',
    'lag'    => 'Langi',
    'lah'    => 'lahnda',
    'lam'    => 'lamba',
    'lb'     => 'letseburgi',
    'lez'    => 'lesgi',
    'lg'     => 'ganda',
    'li'     => 'limburgi',
    'ln'     => 'lingala',
    'lo'     => 'lao',
    'lol'    => 'mongo',
    'loz'    => 'lozi',
    'lt'     => 'leedu',
    'lu'     => 'luba',
    'lua'    => 'lulua',
    'lui'    => 'luisenjo',
    'lun'    => 'lunda',
    'luo'    => 'luo',
    'lus'    => 'lušei',
    'luy'    => 'Luyia',
    'lv'     => 'läti',
    'mad'    => 'madura',
    'mag'    => 'magali',
    'mai'    => 'maithili',
    'mak'    => 'makassari',
    'man'    => 'malinke',
    'map'    => "austroneesia\ keel",
    'mas'    => 'masai',
    'mdf'    => 'mokša',
    'mdr'    => 'mandari',
    'men'    => 'mende',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'malagassi',
    'mga'    => 'keskiiri',
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'maršalli',
    'mi'     => 'maoori',
    'mic'    => 'mikmaki',
    'min'    => 'minangkabau',
    'mis'    => 'üksikkeeled',
    'mk'     => 'makedoonia',
    'mkh'    => "moni\-khmeeri\ keel",
    'ml'     => 'malajalami',
    'mn'     => 'mongoli',
    'mnc'    => 'mandžu',
    'mni'    => 'manipuri',
    'mno'    => "manobo\ keel",
    'mo'     => 'moldova',
    'moh'    => 'mohoogi',
    'mos'    => 'more',
    'mr'     => 'marathi',
    'ms'     => 'malai',
    'mt'     => 'malta',
    'mua'    => 'Mundang',
    'mul'    => "mitu\ keelt",
    'mun'    => "munda\ keel",
    'mus'    => 'maskogi',
    'mwl'    => 'miranda',
    'mwr'    => 'marvari',
    'my'     => 'birma',
    'myn'    => "maia\ keeled",
    'myv'    => 'ersa',
    'na'     => 'nauru',
    'nah'    => 'nahua',
    'nai'    => "Põhja\-Ameerika\ indiaani\ keel",
    'nap'    => 'napoli',
    'naq'    => 'Nama',
    'nb'     => "norra\ bokmål",
    'nd'     => 'põhjandebele',
    'nds'    => 'alamsaksa',
    'ne'     => 'nepali',
    'new'    => 'nevari',
    'ng'     => 'ndonga',
    'nia'    => 'niasi',
    'nic'    => "Nigeri\-Kordofani\ keel",
    'niu'    => 'niue',
    'nl'     => 'hollandi',
    'nl_be'  => 'flaami',
    'nmg'    => 'Kwasio',
    'nn'     => "norra\ nynorsk",
    'no'     => 'norra',
    'nog'    => 'nogai',
    'non'    => 'vanapõhjala',
    'nqo'    => 'nkoo',
    'nr'     => 'lõunandebele',
    'nso'    => 'pedi',
    'nub'    => "nuubia\ keel",
    'nus'    => 'Nuer',
    'nv'     => 'navaho',
    'nwc'    => 'vananevari',
    'ny'     => 'njandža',
    'nym'    => 'njamvesi',
    'nyn'    => 'nkole',
    'nyo'    => 'njoro',
    'nzi'    => 'nzima',
    'oc'     => 'oksitaani',
    'oj'     => 'odžibvei',
    'om'     => 'oromo',
    'or'     => 'oria',
    'os'     => 'osseedi',
    'osa'    => 'oseidži',
    'ota'    => 'osmanitürgi',
    'oto'    => "otomi\ keel",
    'pa'     => 'pandžabi',
    'paa'    => "paapua\ keel",
    'pag'    => 'pangasinani',
    'pal'    => 'pahlavi',
    'pam'    => 'pampanga',
    'pap'    => 'papiamento',
    'pau'    => 'belau',
    'peo'    => 'vanapärsia',
    'phi'    => "filipiini\ keel",
    'phn'    => 'foiniikia',
    'pi'     => 'paali',
    'pl'     => 'poola',
    'pon'    => 'poonpei',
    'pra'    => "praakriti\ keel",
    'pro'    => 'vanaprovansi',
    'ps'     => 'puštu',
    'pt'     => 'portugali',
    'pt_br'  => "Brazilian\ Portuguese",
    'pt_pt'  => "portugali\ \(Ibeeria\)",
    'qu'     => 'ketšua',
    'raj'    => 'radžastani',
    'rap'    => 'rapanui',
    'rar'    => 'rarotonga',
    'rm'     => 'retoromaani',
    'rn'     => 'rundi',
    'ro'     => 'rumeenia',
    'roa'    => "romaani\ keel",
    'rof'    => 'Rombo',
    'rom'    => 'mustlaskeel',
    'ru'     => 'vene',
    'rup'    => 'aromuuni',
    'rw'     => 'ruanda',
    'rwk'    => 'Rwa',
    'sa'     => 'sanskriti',
    'sad'    => 'sandave',
    'sah'    => 'jakuudi',
    'sai'    => "Lõuna\-Ameerika\ indiaani\ keel",
    'sal'    => "sališi\ keel",
    'sam'    => "samaaria\ aramea",
    'saq'    => 'Samburu',
    'sas'    => 'sasaki',
    'sat'    => 'santali',
    'sbp'    => 'Sangu',
    'sc'     => 'sardiinia',
    'scn'    => 'sitsiilia',
    'sco'    => 'šoti',
    'sd'     => 'sindhi',
    'se'     => 'põhjasaami',
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'sölkupi',
    'sem'    => "semi\ keel",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'sango',
    'sga'    => 'vanaiiri',
    'sgn'    => 'viipekeel',
    'sh'     => "serbia\-horvaadi",
    'shi'    => 'Tachelhit',
    'shn'    => 'šani',
    'si'     => 'singali',
    'sid'    => 'sidamo',
    'sio'    => "siuu\ keel",
    'sit'    => "hiina\-tiibeti\ keel",
    'sk'     => 'slovaki',
    'sl'     => 'sloveeni',
    'sla'    => "slaavi\ keel",
    'sm'     => 'samoa',
    'sma'    => 'lõunasaami',
    'smi'    => "muu\ saami",
    'smj'    => "lule\ saami",
    'smn'    => "inari\ saami",
    'sms'    => 'koltasaami',
    'sn'     => 'šona',
    'snk'    => 'soninke',
    'so'     => 'somaali',
    'sog'    => 'sogdi',
    'son'    => 'songai',
    'sq'     => 'albaania',
    'sr'     => 'serbia',
    'srn'    => 'sranani',
    'srr'    => 'sereri',
    'ss'     => 'svaasi',
    'ssa'    => "Niiluse\-Sahara\ keel",
    'ssy'    => 'Saho',
    'st'     => 'lõunasotho',
    'su'     => 'sunda',
    'suk'    => 'sukuma',
    'sus'    => 'susu',
    'sux'    => 'sumeri',
    'sv'     => 'rootsi',
    'sw'     => 'suahiili',
    'swb'    => 'komoori',
    'swc'    => "Congo\ Swahili",
    'syc'    => "Classical\ Syriac",
    'syr'    => 'süüria',
    'ta'     => 'tamili',
    'tai'    => "tai\ keel",
    'te'     => 'telugu',
    'tem'    => 'temne',
    'teo'    => 'Teso',
    'ter'    => 'tereno',
    'tet'    => 'tetumi',
    'tg'     => 'tadžiki',
    'th'     => 'tai',
    'ti'     => 'tigrinja',
    'tig'    => 'tigree',
    'tiv'    => 'tivi',
    'tk'     => 'türkmeeni',
    'tkl'    => 'tokelau',
    'tl'     => 'tagalogi',
    'tlh'    => 'klingoni',
    'tli'    => 'tlingiti',
    'tmh'    => 'tamašeki',
    'tn'     => 'tsvana',
    'to'     => 'tonga',
    'tog'    => 'tšitonga',
    'tpi'    => 'uusmelaneesia',
    'tr'     => 'türgi',
    'trv'    => 'Taroko',
    'ts'     => 'tsonga',
    'tsi'    => 'tšimši',
    'tt'     => 'tatari',
    'tum'    => 'tumbuka',
    'tup'    => "tupii\ keeled",
    'tut'    => "altai\ keel",
    'tvl'    => 'tuvalu',
    'tw'     => 'tvii',
    'twq'    => 'Tasawaq',
    'ty'     => 'tahiti',
    'tyv'    => 'tõva',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'udmurdi',
    'ug'     => "uiguuri\ keel",
    'uga'    => 'ugariti',
    'uk'     => 'ukraina',
    'umb'    => 'umbundu',
    'und'    => 'määramata',
    'ur'     => 'urdu',
    'uz'     => 'usbeki',
    'vai'    => 'vai',
    've'     => 'venda',
    'vi'     => 'vietnami',
    'vo'     => 'volapüki',
    'vot'    => 'vadja',
    'vun'    => 'Vunjo',
    'wa'     => 'vallooni',
    'wae'    => 'Walser',
    'wak'    => "vakaši\ keel",
    'wal'    => 'volamo',
    'war'    => 'varai',
    'was'    => 'vašo',
    'wen'    => "sorbi\ keel",
    'wo'     => 'volofi',
    'xal'    => 'kalmõki',
    'xh'     => 'koosa',
    'xog'    => 'Soga',
    'yao'    => 'jao',
    'yap'    => 'japi',
    'yav'    => 'Yangben',
    'yi'     => 'jidiši',
    'yo'     => 'joruba',
    'ypk'    => "jupiki\ keel",
    'yue'    => 'kantoni',
    'za'     => 'tšuangi',
    'zap'    => 'sapoteegi',
    'zbl'    => 'Blissymbols',
    'zen'    => 'zenaga',
    'zh'     => 'hiina',
    'znd'    => 'zande',
    'zu'     => 'suulu',
    'zun'    => 'sunji',
    'zxx'    => 'mittekeeleline',
    'zza'    => 'Zaza',
);

%Locales::DB::Language::et::name_to_code = (
    'abhaasi'                                    => 'ab',
    'adangme'                                    => 'ada',
    'adõgee'                                    => 'ady',
    'afari'                                      => 'aa',
    'afrihili'                                   => 'afh',
    'afrikaani'                                  => 'af',
    'afroaasiakeel'                              => 'afa',
    'aghem'                                      => 'agq',
    'aimara'                                     => 'ay',
    'ainu'                                       => 'ain',
    'akadi'                                      => 'akk',
    'akani'                                      => 'ak',
    'akoli'                                      => 'ach',
    'alamsaksa'                                  => 'nds',
    'alamsorbi'                                  => 'dsb',
    'albaania'                                   => 'sq',
    'alemanni'                                   => 'gsw',
    'aleuudi'                                    => 'ale',
    'algonkinikeel'                              => 'alg',
    'altai'                                      => 'alt',
    'altaikeel'                                  => 'tut',
    'ambo'                                       => 'kj',
    'amhari'                                     => 'am',
    'angika'                                     => 'anp',
    'apatšikeel'                                => 'apa',
    'araabia'                                    => 'ar',
    'aragoni'                                    => 'an',
    'aramea'                                     => 'arc',
    'arapaho'                                    => 'arp',
    'araukaani'                                  => 'arn',
    'aravaki'                                    => 'arw',
    'armeenia'                                   => 'hy',
    'aromuuni'                                   => 'rup',
    'aseri'                                      => 'az',
    'assami'                                     => 'as',
    'astuuria'                                   => 'ast',
    'asu'                                        => 'asa',
    'atapaskikeeled'                             => 'ath',
    'atsami'                                     => 'cch',
    'atšehi'                                    => 'ace',
    'austraalikeel'                              => 'aus',
    'australianenglish'                          => 'en_au',
    'austriangerman'                             => 'de_at',
    'austroneesiakeel'                           => 'map',
    'avaari'                                     => 'av',
    'avadhi'                                     => 'awa',
    'avesta'                                     => 'ae',
    'bafia'                                      => 'ksf',
    'bali'                                       => 'ban',
    'baltikeel'                                  => 'bat',
    'bambara'                                    => 'bm',
    'bamilekekeel'                               => 'bai',
    'banda'                                      => 'bad',
    'bantu'                                      => 'bnt',
    'basa'                                       => 'bas',
    'baski'                                      => 'eu',
    'bataki'                                     => 'btk',
    'baškiiri'                                  => 'ba',
    'bedža'                                     => 'bej',
    'belau'                                      => 'pau',
    'belutši'                                   => 'bal',
    'bemba'                                      => 'bem',
    'bena'                                       => 'bez',
    'bengali'                                    => 'bn',
    'berberi'                                    => 'ber',
    'bhodžpuri'                                 => 'bho',
    'bhutani'                                    => 'dz',
    'bihaari'                                    => 'bh',
    'bikoli'                                     => 'bik',
    'bilini'                                     => 'byn',
    'birma'                                      => 'my',
    'bislama'                                    => 'bi',
    'blissymbols'                                => 'zbl',
    'bodo'                                       => 'brx',
    'bosnia'                                     => 'bs',
    'bradži'                                    => 'bra',
    'brazilianportuguese'                        => 'pt_br',
    'bretooni'                                   => 'br',
    'bugi'                                       => 'bug',
    'bulgaaria'                                  => 'bg',
    'burjaadi'                                   => 'bua',
    'canadianenglish'                            => 'en_ca',
    'canadianfrench'                             => 'fr_ca',
    'cayuga'                                     => 'cay',
    'centralmoroccotamazight'                    => 'tzm',
    'chiga'                                      => 'cgg',
    'classicalsyriac'                            => 'syc',
    'colognian'                                  => 'ksh',
    'congoswahili'                               => 'swc',
    'dajaki'                                     => 'day',
    'dargi'                                      => 'dar',
    'delavari'                                   => 'del',
    'dinka'                                      => 'din',
    'djula'                                      => 'dyu',
    'dogri'                                      => 'doi',
    'dogribi'                                    => 'dgr',
    'draviidikeel'                               => 'dra',
    'duala'                                      => 'dua',
    'edo'                                        => 'bin',
    'eelami'                                     => 'elx',
    'eesti'                                      => 'et',
    'ekadžuki'                                  => 'eka',
    'embu'                                       => 'ebu',
    'ersa'                                       => 'myv',
    'esperanto'                                  => 'eo',
    'etioopia'                                   => 'gez',
    'eve'                                        => 'ee',
    'evondo'                                     => 'ewo',
    'fangi'                                      => 'fan',
    'fanti'                                      => 'fat',
    'fidži'                                     => 'fj',
    'filipiinikeel'                              => 'phi',
    'filipino'                                   => 'fil',
    'flaami'                                     => 'nl_be',
    'foiniikia'                                  => 'phn',
    'foni'                                       => 'fon',
    'friuuli'                                    => 'fur',
    'fulbe'                                      => 'ff',
    'fääri'                                    => 'fo',
    'gaa'                                        => 'gaa',
    'gaeli'                                      => 'gd',
    'gajo'                                       => 'gay',
    'galeegi'                                    => 'gl',
    'ganda'                                      => 'lg',
    'gbaja'                                      => 'gba',
    'germaanikeel'                               => 'gem',
    'gondi'                                      => 'gon',
    'gooti'                                      => 'got',
    'gorontalo'                                  => 'gor',
    'grebo'                                      => 'grb',
    'gruusia'                                    => 'ka',
    'grööni'                                   => 'kl',
    'guaranii'                                   => 'gn',
    'gudžarati'                                 => 'gu',
    'gusii'                                      => 'guz',
    'gvitšini'                                  => 'gwi',
    'haida'                                      => 'hai',
    'haiti'                                      => 'ht',
    'hausa'                                      => 'ha',
    'havai'                                      => 'haw',
    'heebrea'                                    => 'he',
    'herero'                                     => 'hz',
    'heti'                                       => 'hit',
    'hiina'                                      => 'zh',
    'hiinatiibetikeel'                           => 'sit',
    'hiligainoni'                                => 'hil',
    'himtšali'                                  => 'him',
    'hindi'                                      => 'hi',
    'hispaania'                                  => 'es',
    'hispaaniaibeeria'                           => 'es_es',
    'hispaanialadinaameerika'                    => 'es_419',
    'hmongi'                                     => 'hmn',
    'hollandi'                                   => 'nl',
    'horvaadi'                                   => 'hr',
    'hupa'                                       => 'hup',
    'ibani'                                      => 'iba',
    'ibibio'                                     => 'efi',
    'ibo'                                        => 'ig',
    'idafriisi'                                  => 'frs',
    'ido'                                        => 'io',
    'idžo'                                      => 'ijo',
    'iiri'                                       => 'ga',
    'iloko'                                      => 'ilo',
    'inarisaami'                                 => 'smn',
    'indiakeel'                                  => 'inc',
    'indoeuroopakeel'                            => 'ine',
    'indoneesia'                                 => 'id',
    'inglise'                                    => 'en',
    'inglisebriti'                               => 'en_gb',
    'ingliseusa'                                 => 'en_us',
    'inglispõhjalisedkreooljapidžinkeeled'     => 'cpe',
    'inguši'                                    => 'inh',
    'injupiaki'                                  => 'ik',
    'interlingua'                                => 'ia',
    'interlingue'                                => 'ie',
    'inuktituti'                                 => 'iu',
    'iraanikeeled'                               => 'ira',
    'irokeesikeel'                               => 'iro',
    'islandi'                                    => 'is',
    'itaalia'                                    => 'it',
    'jaapani'                                    => 'ja',
    'jaava'                                      => 'jv',
    'jakuudi'                                    => 'sah',
    'jao'                                        => 'yao',
    'japi'                                       => 'yap',
    'jidiši'                                    => 'yi',
    'jju'                                        => 'kaj',
    'jolafonyi'                                  => 'dyo',
    'joruba'                                     => 'yo',
    'jupikikeel'                                 => 'ypk',
    'juudiaraabia'                               => 'jrb',
    'juudipärsia'                               => 'jpr',
    'kaavi'                                      => 'kaw',
    'kabarditšerkessi'                          => 'kbd',
    'kabiili'                                    => 'kab',
    'kabuverdianu'                               => 'kea',
    'kado'                                       => 'cad',
    'kalenjin'                                   => 'kln',
    'kalmõki'                                   => 'xal',
    'kamba'                                      => 'kam',
    'kannada'                                    => 'kn',
    'kantoni'                                    => 'yue',
    'kanuri'                                     => 'kr',
    'karakalpaki'                                => 'kaa',
    'karatšaibalkaari'                          => 'krc',
    'karenikeel'                                 => 'kar',
    'kariibi'                                    => 'car',
    'karjala'                                    => 'krl',
    'kasahhi'                                    => 'kk',
    'katalaani'                                  => 'ca',
    'katšini'                                   => 'kac',
    'kaukaasiakeel'                              => 'cau',
    'kašmiiri'                                  => 'ks',
    'kašuubi'                                   => 'csb',
    'keldikeel'                                  => 'cel',
    'keskameerikaindiaanikeel'                   => 'cai',
    'keskhollandi'                               => 'dum',
    'keskiiri'                                   => 'mga',
    'keskinglise'                                => 'enm',
    'keskprantsuse'                              => 'frm',
    'keskülemsaksa'                             => 'gmh',
    'ketšua'                                    => 'qu',
    'khasi'                                      => 'kha',
    'khmeeri'                                    => 'km',
    'khoisanikeel'                               => 'khi',
    'kikuju'                                     => 'ki',
    'kirgiisi'                                   => 'ky',
    'kiribati'                                   => 'gil',
    'kirikuslaavi'                               => 'cu',
    'klingoni'                                   => 'tlh',
    'koltasaami'                                 => 'sms',
    'komi'                                       => 'kv',
    'komoori'                                    => 'swb',
    'kongo'                                      => 'kg',
    'konkani'                                    => 'kok',
    'koosa'                                      => 'xh',
    'kopti'                                      => 'cop',
    'korea'                                      => 'ko',
    'korni'                                      => 'kw',
    'koro'                                       => 'kfo',
    'korsika'                                    => 'co',
    'kosrae'                                     => 'kos',
    'koyraborosenni'                             => 'ses',
    'koyrachiini'                                => 'khq',
    'kpelle'                                     => 'kpe',
    'kreeka'                                     => 'el',
    'kreoolvõipidžinkeel'                      => 'crp',
    'krii'                                       => 'cr',
    'krimmitatari'                               => 'crh',
    'kruu'                                       => 'kro',
    'kumõki'                                    => 'kum',
    'kurdi'                                      => 'ku',
    'kutenai'                                    => 'kut',
    'kwasio'                                     => 'nmg',
    'kõmri'                                     => 'cy',
    'ladiino'                                    => 'lad',
    'ladina'                                     => 'la',
    'lahnda'                                     => 'lah',
    'lamba'                                      => 'lam',
    'langi'                                      => 'lag',
    'lao'                                        => 'lo',
    'leedu'                                      => 'lt',
    'lesgi'                                      => 'lez',
    'letseburgi'                                 => 'lb',
    'limburgi'                                   => 'li',
    'lingala'                                    => 'ln',
    'lojbani'                                    => 'jbo',
    'lozi'                                       => 'loz',
    'luba'                                       => 'lu',
    'luisenjo'                                   => 'lui',
    'lulesaami'                                  => 'smj',
    'lulua'                                      => 'lua',
    'lunda'                                      => 'lun',
    'luo'                                        => 'luo',
    'luyia'                                      => 'luy',
    'lušei'                                     => 'lus',
    'läti'                                      => 'lv',
    'läänefriisi'                              => 'fy',
    'lõunaameerikaindiaanikeel'                 => 'sai',
    'lõunandebele'                              => 'nr',
    'lõunasaami'                                => 'sma',
    'lõunasotho'                                => 'st',
    'machame'                                    => 'jmc',
    'madura'                                     => 'mad',
    'magali'                                     => 'mag',
    'maiakeeled'                                 => 'myn',
    'maithili'                                   => 'mai',
    'makassari'                                  => 'mak',
    'makedoonia'                                 => 'mk',
    'makhuwameetto'                              => 'mgh',
    'makonde'                                    => 'kde',
    'malagassi'                                  => 'mg',
    'malai'                                      => 'ms',
    'malajalami'                                 => 'ml',
    'maldiivi'                                   => 'dv',
    'malinke'                                    => 'man',
    'malta'                                      => 'mt',
    'mandari'                                    => 'mdr',
    'mandžu'                                    => 'mnc',
    'manipuri'                                   => 'mni',
    'manobokeel'                                 => 'mno',
    'maoori'                                     => 'mi',
    'marathi'                                    => 'mr',
    'mari'                                       => 'chm',
    'marvari'                                    => 'mwr',
    'maršalli'                                  => 'mh',
    'masai'                                      => 'mas',
    'maskogi'                                    => 'mus',
    'mbundu'                                     => 'kmb',
    'mende'                                      => 'men',
    'meru'                                       => 'mer',
    'mikmaki'                                    => 'mic',
    'minangkabau'                                => 'min',
    'miranda'                                    => 'mwl',
    'mittekeeleline'                             => 'zxx',
    'mitukeelt'                                  => 'mul',
    'mohoogi'                                    => 'moh',
    'mokša'                                     => 'mdf',
    'moldova'                                    => 'mo',
    'mongo'                                      => 'lol',
    'mongoli'                                    => 'mn',
    'monikhmeerikeel'                            => 'mkh',
    'more'                                       => 'mos',
    'morisyen'                                   => 'mfe',
    'motu'                                       => 'ho',
    'muinasegiptuse'                             => 'egy',
    'mundakeel'                                  => 'mun',
    'mundang'                                    => 'mua',
    'mustlaskeel'                                => 'rom',
    'muukušikeel'                               => 'cus',
    'muusaami'                                   => 'smi',
    'muutehiskeel'                               => 'art',
    'mänksi'                                    => 'gv',
    'määramata'                                => 'und',
    'nahua'                                      => 'nah',
    'nama'                                       => 'naq',
    'napoli'                                     => 'nap',
    'nauru'                                      => 'na',
    'navaho'                                     => 'nv',
    'ndonga'                                     => 'ng',
    'nepali'                                     => 'ne',
    'nevari'                                     => 'new',
    'niasi'                                      => 'nia',
    'nigerikordofanikeel'                        => 'nic',
    'niilusesaharakeel'                          => 'ssa',
    'niue'                                       => 'niu',
    'njamvesi'                                   => 'nym',
    'njandža'                                   => 'ny',
    'njoro'                                      => 'nyo',
    'nkole'                                      => 'nyn',
    'nkoo'                                       => 'nqo',
    'nogai'                                      => 'nog',
    'norra'                                      => 'no',
    'norrabokmål'                               => 'nb',
    'norranynorsk'                               => 'nn',
    'nuer'                                       => 'nus',
    'nuubiakeel'                                 => 'nub',
    'nzima'                                      => 'nzi',
    'odžibvei'                                  => 'oj',
    'oksitaani'                                  => 'oc',
    'oraoni'                                     => 'kru',
    'oria'                                       => 'or',
    'oromo'                                      => 'om',
    'oseidži'                                   => 'osa',
    'osmanitürgi'                               => 'ota',
    'osseedi'                                    => 'os',
    'otomikeel'                                  => 'oto',
    'paali'                                      => 'pi',
    'paapuakeel'                                 => 'paa',
    'pahlavi'                                    => 'pal',
    'pampanga'                                   => 'pam',
    'pandžabi'                                  => 'pa',
    'pangasinani'                                => 'pag',
    'papiamento'                                 => 'pap',
    'pedi'                                       => 'nso',
    'poola'                                      => 'pl',
    'poonpei'                                    => 'pon',
    'portugali'                                  => 'pt',
    'portugaliibeeria'                           => 'pt_pt',
    "portugalipõhjalisedkreooli\/pidžinkeeled" => 'cpp',
    'praakritikeel'                              => 'pra',
    'prantsuse'                                  => 'fr',
    'prantsuspõhjalisedkreooljapidžinkeeled'   => 'cpf',
    'puštu'                                     => 'ps',
    'pärsia'                                    => 'fa',
    'põhjaameerikaindiaanikeel'                 => 'nai',
    'põhjafriisi'                               => 'frr',
    'põhjandebele'                              => 'nd',
    'põhjasaami'                                => 'se',
    'radžastani'                                => 'raj',
    'rapanui'                                    => 'rap',
    'rarotonga'                                  => 'rar',
    'retoromaani'                                => 'rm',
    'romaanikeel'                                => 'roa',
    'rombo'                                      => 'rof',
    'rootsi'                                     => 'sv',
    'ruanda'                                     => 'rw',
    'rumeenia'                                   => 'ro',
    'rundi'                                      => 'rn',
    'rwa'                                        => 'rwk',
    'saho'                                       => 'ssy',
    'saki'                                       => 'kho',
    'saksa'                                      => 'de',
    'saksakõrgsaksa'                            => 'de_ch',
    'sališikeel'                                => 'sal',
    'samaariaaramea'                             => 'sam',
    'samburu'                                    => 'saq',
    'samoa'                                      => 'sm',
    'sandave'                                    => 'sad',
    'sango'                                      => 'sg',
    'sangu'                                      => 'sbp',
    'sanskriti'                                  => 'sa',
    'santali'                                    => 'sat',
    'sapoteegi'                                  => 'zap',
    'sardiinia'                                  => 'sc',
    'sasaki'                                     => 'sas',
    'sebu'                                       => 'ceb',
    'semikeel'                                   => 'sem',
    'sena'                                       => 'seh',
    'seneca'                                     => 'see',
    'serbia'                                     => 'sr',
    'serbiahorvaadi'                             => 'sh',
    'sereri'                                     => 'srr',
    'shambala'                                   => 'ksb',
    'sichuanijii'                                => 'ii',
    'sidamo'                                     => 'sid',
    'siksika'                                    => 'bla',
    'sindhi'                                     => 'sd',
    'singali'                                    => 'si',
    'sitsiilia'                                  => 'scn',
    'siuu'                                       => 'dak',
    'siuukeel'                                   => 'sio',
    'slaavikeel'                                 => 'sla',
    'sleivi'                                     => 'den',
    'slovaki'                                    => 'sk',
    'sloveeni'                                   => 'sl',
    'soga'                                       => 'xog',
    'sogdi'                                      => 'sog',
    'somaali'                                    => 'so',
    'songai'                                     => 'son',
    'soninke'                                    => 'snk',
    'soome'                                      => 'fi',
    'soomeugrikeel'                              => 'fiu',
    'sorbikeel'                                  => 'wen',
    'sranani'                                    => 'srn',
    'suahiili'                                   => 'sw',
    'sukuma'                                     => 'suk',
    'sumeri'                                     => 'sux',
    'sunda'                                      => 'su',
    'sunji'                                      => 'zun',
    'susu'                                       => 'sus',
    'suulu'                                      => 'zu',
    'svaasi'                                     => 'ss',
    'swissfrench'                                => 'fr_ch',
    'sölkupi'                                   => 'sel',
    'süüria'                                   => 'syr',
    'taani'                                      => 'da',
    'tachelhit'                                  => 'shi',
    'tadžiki'                                   => 'tg',
    'tagalogi'                                   => 'tl',
    'tahiti'                                     => 'ty',
    'tai'                                        => 'th',
    'taikeel'                                    => 'tai',
    'taita'                                      => 'dav',
    'tamašeki'                                  => 'tmh',
    'tamili'                                     => 'ta',
    'taroko'                                     => 'trv',
    'tasawaq'                                    => 'twq',
    'tatari'                                     => 'tt',
    'telugu'                                     => 'te',
    'temne'                                      => 'tem',
    'tereno'                                     => 'ter',
    'teso'                                       => 'teo',
    'tetumi'                                     => 'tet',
    'tigree'                                     => 'tig',
    'tigrinja'                                   => 'ti',
    'tiibeti'                                    => 'bo',
    'tivi'                                       => 'tiv',
    'tlingiti'                                   => 'tli',
    'tokelau'                                    => 'tkl',
    'tonga'                                      => 'to',
    'tsonga'                                     => 'ts',
    'tsvana'                                     => 'tn',
    'tumbuka'                                    => 'tum',
    'tupiikeeled'                                => 'tup',
    'tuvalu'                                     => 'tvl',
    'tvii'                                       => 'tw',
    'tyapi'                                      => 'kcg',
    'tõva'                                      => 'tyv',
    'türgi'                                     => 'tr',
    'türkmeeni'                                 => 'tk',
    'tšagatai'                                  => 'chg',
    'tšamikeeled'                               => 'cmc',
    'tšamorro'                                  => 'ch',
    'tšehhi'                                    => 'cs',
    'tšerokii'                                  => 'chr',
    'tšetšeeni'                                => 'ce',
    'tšibtša'                                  => 'chb',
    'tšimši'                                   => 'tsi',
    'tšinukižargoon'                           => 'chn',
    'tšipevai'                                  => 'chp',
    'tšitonga'                                  => 'tog',
    'tšokto'                                    => 'cho',
    'tšuangi'                                   => 'za',
    'tšuugi'                                    => 'chk',
    'tšuvaši'                                  => 'cv',
    'udmurdi'                                    => 'udm',
    'ugariti'                                    => 'uga',
    'uiguurikeel'                                => 'ug',
    'ukraina'                                    => 'uk',
    'umbundu'                                    => 'umb',
    'ungari'                                     => 'hu',
    'urdu'                                       => 'ur',
    'usbeki'                                     => 'uz',
    'uusmelaneesia'                              => 'tpi',
    'vadja'                                      => 'vot',
    'vai'                                        => 'vai',
    'vakašikeel'                                => 'wak',
    'valgevene'                                  => 'be',
    'vallooni'                                   => 'wa',
    'vanaiiri'                                   => 'sga',
    'vanainglise'                                => 'ang',
    'vanakreeka'                                 => 'grc',
    'vananevari'                                 => 'nwc',
    'vanaprantsuse'                              => 'fro',
    'vanaprovansi'                               => 'pro',
    'vanapärsia'                                => 'peo',
    'vanapõhjala'                               => 'non',
    'vanaülemsaksa'                             => 'goh',
    'varai'                                      => 'war',
    'vašo'                                      => 'was',
    'venda'                                      => 've',
    'vene'                                       => 'ru',
    'vietnami'                                   => 'vi',
    'viipekeel'                                  => 'sgn',
    'volamo'                                     => 'wal',
    'volapüki'                                  => 'vo',
    'volofi'                                     => 'wo',
    'vunjo'                                      => 'vun',
    'walser'                                     => 'wae',
    'yangben'                                    => 'yav',
    'zande'                                      => 'znd',
    'zarma'                                      => 'dje',
    'zaza'                                       => 'zza',
    'zenaga'                                     => 'zen',
    'üksikkeeled'                               => 'mis',
    'ülemsorbi'                                 => 'hsb',
    'šaieeni'                                   => 'chy',
    'šani'                                      => 'shn',
    'šona'                                      => 'sn',
    'šoti'                                      => 'sco',
);

1;
