/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.security.AllPermission;
import java.security.BasicPermission;
import java.security.SecurityPermission;

public final class SecurityConstants {
    public static final String FILE_DELETE_ACTION = "delete";
    public static final String FILE_EXECUTE_ACTION = "execute";
    public static final String FILE_READ_ACTION = "read";
    public static final String FILE_WRITE_ACTION = "write";
    public static final String SOCKET_RESOLVE_ACTION = "resolve";
    public static final String SOCKET_CONNECT_ACTION = "connect";
    public static final String SOCKET_LISTEN_ACTION = "listen";
    public static final String SOCKET_ACCEPT_ACTION = "accept";
    public static final String SOCKET_CONNECT_ACCEPT_ACTION = "connect,accept";
    public static final String PROPERTY_RW_ACTION = "read,write";
    public static final String PROPERTY_READ_ACTION = "read";
    public static final String PROPERTY_WRITE_ACTION = "write";
    public static final AllPermission ALL_PERMISSION = new AllPermission();
    public static final NetPermission SPECIFY_HANDLER_PERMISSION = new NetPermission("specifyStreamHandler");
    public static final RuntimePermission CREATE_CLASSLOADER_PERMISSION = new RuntimePermission("createClassLoader");
    public static final RuntimePermission CHECK_MEMBER_ACCESS_PERMISSION = new RuntimePermission("accessDeclaredMembers");
    public static final RuntimePermission MODIFY_THREAD_PERMISSION = new RuntimePermission("modifyThread");
    public static final RuntimePermission MODIFY_THREADGROUP_PERMISSION = new RuntimePermission("modifyThreadGroup");
    public static final RuntimePermission GET_PD_PERMISSION = new RuntimePermission("getProtectionDomain");
    public static final RuntimePermission GET_CLASSLOADER_PERMISSION = new RuntimePermission("getClassLoader");
    public static final RuntimePermission STOP_THREAD_PERMISSION = new RuntimePermission("stopThread");
    public static final SecurityPermission CREATE_ACC_PERMISSION = new SecurityPermission("createAccessControlContext");
    public static final SecurityPermission GET_COMBINER_PERMISSION = new SecurityPermission("getDomainCombiner");
    public static final SecurityPermission GET_POLICY_PERMISSION = new SecurityPermission("getPolicy");
    public static final SocketPermission LOCAL_LISTEN_PERMISSION = new SocketPermission("localhost:1024-", "listen");
    private static BasicPermission topLevelWindowPermission;
    private static BasicPermission accessClipboardPermission;
    private static BasicPermission checkAwtEventQueuePermission;

    private SecurityConstants() {
    }

    public static BasicPermission getTopLevelWindowPermission() {
        return topLevelWindowPermission;
    }

    public static BasicPermission getAccessClipboardPermission() {
        return accessClipboardPermission;
    }

    public static BasicPermission getCheckAwtEventQueuePermission() {
        return checkAwtEventQueuePermission;
    }

    static {
        Constructor constructor = null;
        try {
            constructor = Class.forName("java.awt.AWTPermission").getConstructor(new Class[]{String.class});
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SecurityException("AWTPermission constructor changed");
        }
        if (constructor != null) {
            try {
                topLevelWindowPermission = (BasicPermission)constructor.newInstance(new Object[]{"showWindowWithoutWarningBanner"});
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            try {
                checkAwtEventQueuePermission = (BasicPermission)constructor.newInstance(new Object[]{"accessEventQueue"});
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            try {
                accessClipboardPermission = (BasicPermission)constructor.newInstance(new Object[]{"accessClipboard"});
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }
}

