/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import sun.misc.CVM;
import sun.security.util.Debug;

public final class AccessController {
    private static AccessControlContext sysACC = new AccessControlContext(null, false, null);
    private static AccessControlContext privACC = new AccessControlContext(null, true, null);

    private AccessController() {
    }

    public static Object doPrivileged(PrivilegedAction privilegedAction) {
        return AccessController.doPrivileged(privilegedAction, null);
    }

    public static Object doPrivileged(PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        return privilegedAction.run();
    }

    public static Object doPrivileged(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return AccessController.doPrivileged(privilegedExceptionAction, null);
    }

    public static Object doPrivileged(PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        try {
            return privilegedExceptionAction.run();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PrivilegedActionException(exception);
        }
        catch (Throwable throwable) {
            throw CVM.throwLocalException(throwable);
        }
    }

    private static native void fillInContext(ProtectionDomain[] var0, int var1);

    private static native int computeContext(boolean[] var0, AccessControlContext[] var1);

    private static AccessControlContext getStackAccessControlContext() {
        AccessControlContext[] accessControlContextArray = new AccessControlContext[1];
        boolean[] blArray = new boolean[1];
        int n = AccessController.computeContext(blArray, accessControlContextArray);
        boolean bl = blArray[0];
        AccessControlContext accessControlContext = accessControlContextArray[0];
        if (n == 0) {
            if (bl && accessControlContext == null) {
                return null;
            }
            if (accessControlContext != null) {
                return new AccessControlContext(null, bl, accessControlContext);
            }
            if (!bl) {
                return sysACC;
            }
            throw new InternalError();
        }
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[n];
        AccessController.fillInContext(protectionDomainArray, n);
        return new AccessControlContext(protectionDomainArray, bl, accessControlContext);
    }

    static native AccessControlContext getInheritedAccessControlContext();

    public static AccessControlContext getContext() {
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            return privACC;
        }
        return accessControlContext.optimize();
    }

    public static void checkPermission(Permission permission) throws AccessControlException {
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            Debug debug = AccessControlContext.getDebug();
            if (debug != null) {
                if (Debug.isOn("stack")) {
                    Thread.currentThread();
                    Thread.dumpStack();
                }
                if (Debug.isOn("domain")) {
                    debug.println("domain (context is null)");
                }
                debug.println("access allowed " + permission);
            }
            return;
        }
        AccessControlContext accessControlContext2 = accessControlContext.optimize();
        accessControlContext2.checkPermission(permission);
    }
}

