/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.sun.jsr239.BufferManager;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBufferImpl;
import java.nio.DirectByteBuffer;
import java.nio.FloatBuffer;
import java.nio.HeapByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public abstract class ByteBuffer
extends Buffer
implements Comparable {
    byte[] array;
    boolean isDirect;
    boolean disposed = false;

    ByteBuffer() {
    }

    public static ByteBuffer allocateDirect(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = ByteBufferImpl._allocNative(n);
        DirectByteBuffer directByteBuffer = new DirectByteBuffer(n, null, n2);
        BufferManager.newBuffer(directByteBuffer, n2);
        return directByteBuffer;
    }

    public static ByteBuffer wrap(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        HeapByteBuffer heapByteBuffer = new HeapByteBuffer(byArray.length, byArray, 0);
        heapByteBuffer.position(n);
        heapByteBuffer.limit(n + n2);
        return heapByteBuffer;
    }

    public static ByteBuffer wrap(byte[] byArray) {
        return ByteBuffer.wrap(byArray, 0, byArray.length);
    }

    public abstract ByteBuffer slice();

    public abstract byte get();

    public abstract ByteBuffer put(byte var1);

    public abstract byte get(int var1);

    public abstract ByteBuffer put(int var1, byte var2);

    public ByteBuffer get(byte[] byArray, int n, int n2) {
        ByteBuffer.checkBounds(n, n2, byArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.copyToArray(byArray, n, n2);
        this.position += n2;
        return this;
    }

    abstract void copyToArray(byte[] var1, int var2, int var3);

    public ByteBuffer get(byte[] byArray) {
        return this.get(byArray, 0, byArray.length);
    }

    public ByteBuffer put(ByteBuffer byteBuffer) {
        if (byteBuffer == this) {
            throw new IllegalArgumentException();
        }
        ByteBufferImpl byteBufferImpl = (ByteBufferImpl)byteBuffer;
        int n = byteBufferImpl.limit - byteBufferImpl.position;
        if (n > this.limit - this.position) {
            throw new BufferOverflowException();
        }
        if (this.isDirect && byteBufferImpl.isDirect) {
            ByteBufferImpl._copyBytes(byteBufferImpl.arrayOffset + byteBufferImpl.position, this.arrayOffset + this.position, n);
        } else if (this.isDirect && !byteBufferImpl.isDirect) {
            ByteBufferImpl._putBytes(this.arrayOffset + this.position, byteBufferImpl.array, byteBufferImpl.arrayOffset + byteBufferImpl.position, n);
        } else if (!this.isDirect && byteBufferImpl.isDirect) {
            ByteBufferImpl._getBytes(byteBufferImpl.arrayOffset + byteBufferImpl.position, this.array, this.arrayOffset + this.position, n);
        } else if (!this.isDirect && !byteBufferImpl.isDirect) {
            System.arraycopy(byteBufferImpl.array, byteBufferImpl.arrayOffset + byteBufferImpl.position, this.array, this.arrayOffset + this.position, n);
        }
        byteBufferImpl.position += n;
        this.position += n;
        return this;
    }

    public ByteBuffer put(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 > this.limit - this.position) {
            throw new BufferOverflowException();
        }
        if (this.isDirect) {
            ByteBufferImpl._putBytes(this.arrayOffset + this.position, byArray, n, n2);
        } else {
            System.arraycopy(byArray, n, this.array, this.arrayOffset + this.position, n2);
        }
        this.position += n2;
        return this;
    }

    public final ByteBuffer put(byte[] byArray) {
        return this.put(byArray, 0, byArray.length);
    }

    public final boolean hasArray() {
        return !this.isDirect;
    }

    public final byte[] array() {
        if (this.isDirect) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    public final int arrayOffset() {
        if (this.isDirect) {
            throw new UnsupportedOperationException();
        }
        return this.arrayOffset;
    }

    public abstract boolean isDirect();

    public String toString() {
        return "java.nio.ByteBuffer[pos=" + this.position() + "lim=" + this.limit() + "cap=" + this.capacity() + "]";
    }

    public int hashCode() {
        int n = 1;
        int n2 = this.position();
        for (int i = this.limit() - 1; i >= n2; --i) {
            n = 31 * n + this.get(i);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer byteBuffer = (ByteBuffer)object;
        if (this.remaining() != byteBuffer.remaining()) {
            return false;
        }
        int n = this.position();
        int n2 = this.limit() - 1;
        int n3 = byteBuffer.limit() - 1;
        while (n2 >= n) {
            byte by;
            byte by2 = this.get(n2);
            if (by2 != (by = byteBuffer.get(n3)) && (by2 == by2 || by == by)) {
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    public int compareTo(Object object) {
        ByteBuffer byteBuffer = (ByteBuffer)object;
        int n = this.position() + Math.min(this.remaining(), byteBuffer.remaining());
        int n2 = this.position();
        int n3 = byteBuffer.position();
        while (n2 < n) {
            byte by;
            byte by2 = this.get(n2);
            if (by2 != (by = byteBuffer.get(n3)) && (by2 == by2 || by == by)) {
                if (by2 < by) {
                    return -1;
                }
                return 1;
            }
            ++n2;
            ++n3;
        }
        return this.remaining() - byteBuffer.remaining();
    }

    public abstract short getShort();

    public abstract ByteBuffer putShort(short var1);

    public abstract short getShort(int var1);

    public abstract ByteBuffer putShort(int var1, short var2);

    public abstract ShortBuffer asShortBuffer();

    public abstract int getInt();

    public abstract ByteBuffer putInt(int var1);

    public abstract int getInt(int var1);

    public abstract ByteBuffer putInt(int var1, int var2);

    public abstract IntBuffer asIntBuffer();

    public abstract float getFloat();

    public abstract ByteBuffer putFloat(float var1);

    public abstract float getFloat(int var1);

    public abstract ByteBuffer putFloat(int var1, float var2);

    public abstract FloatBuffer asFloatBuffer();
}

