------------------------------------------------------------------------------
--                                                                          --
--                	        G N A T . RAVENSCAR                         --
--                                                                          --
--                      Copyright (C) 2008-2017, AdaCore                    --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.Ravenscar.Timed_Out_Sporadic_Server;

package Test_All.Timed_Out_Sporadic_Server is

   type Request_T is
      record
         I : Integer;
      end record;
   procedure Sporadic_OP (Req : Request_T);
   procedure Time_Out_Handler;
   package My_Timed_Out_Sporadic_Server is new
     GNAT.Ravenscar.Timed_Out_Sporadic_Server
       (10, 20, 50, System_Start_Up, 15, 4,
        Request_T, Sporadic_OP, Time_Out_Handler);

private

   Time_Out_Counter : Integer := 0;
   Max_Time_Out_Counter : Integer := 5;

   procedure Update_Time_Out_Counter;

end Test_All.Timed_Out_Sporadic_Server;
