with GNATCOLL.Projects;     use GNATCOLL.Projects;
with GNATCOLL.Projects.Aux; use GNATCOLL.Projects.Aux;
--with GNATCOLL.Traces;   use GNATCOLL.Traces;
with GNATCOLL.VFS;      use GNATCOLL.VFS;

--with Ada.Command_Line;  use Ada.Command_Line;
with Ada.Text_IO;       use Ada.Text_IO;
with GNAT.Strings;      use GNAT.Strings;

procedure Main is

   Env       : Project_Environment_Access;
   Tree      : Project_Tree;
   Root      : Project_Type;
begin
   Initialize (Env);
   Env.Set_Target_And_Runtime;
   Set_Automatic_Config_File (Env.all);

   Tree.Load (Create (+"simple.gpr"), Env, Recompute_View=>False);
   Tree.Recompute_View;

   declare
      Target_Name : constant String :=
        Get_Target (Tree.Root_Project, Default_To_Host => False);
   begin
      if Target_Name /= "" then
         Put_Line ("Target is >>" & Target_Name & "<< but should be empty");
      end if;
   end;
   
   Delete_All_Temp_Files (Tree.Root_Project);
end Main;
