/* config-impl-keyfile.c generated by valac 0.10.4, the Vala compiler
 * generated from config-impl-keyfile.vala, do not modify */

/*
 * A GKeyFile-based implementation of the Config interface.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/config.h>
#include <libdesktop-agnostic/vfs.h>
#include <stdlib.h>
#include <string.h>
#include <config-notify-delegate.c>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>


#define DESKTOP_AGNOSTIC_CONFIG_TYPE_GKEY_FILE (desktop_agnostic_config_gkey_file_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_GKEY_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_GKEY_FILE, DesktopAgnosticConfigGKeyFile))
#define DESKTOP_AGNOSTIC_CONFIG_GKEY_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_GKEY_FILE, DesktopAgnosticConfigGKeyFileClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_GKEY_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_GKEY_FILE))
#define DESKTOP_AGNOSTIC_CONFIG_IS_GKEY_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_GKEY_FILE))
#define DESKTOP_AGNOSTIC_CONFIG_GKEY_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_GKEY_FILE, DesktopAgnosticConfigGKeyFileClass))

typedef struct _DesktopAgnosticConfigGKeyFile DesktopAgnosticConfigGKeyFile;
typedef struct _DesktopAgnosticConfigGKeyFileClass DesktopAgnosticConfigGKeyFileClass;
typedef struct _DesktopAgnosticConfigGKeyFilePrivate DesktopAgnosticConfigGKeyFilePrivate;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _desktop_agnostic_config_notify_delegate_free0(var) ((var == NULL) ? NULL : (var = (desktop_agnostic_config_notify_delegate_free (var), NULL)))

struct _DesktopAgnosticConfigGKeyFile {
	DesktopAgnosticConfigBackend parent_instance;
	DesktopAgnosticConfigGKeyFilePrivate * priv;
};

struct _DesktopAgnosticConfigGKeyFileClass {
	DesktopAgnosticConfigBackendClass parent_class;
};

struct _DesktopAgnosticConfigGKeyFilePrivate {
	GKeyFile* _data;
	DesktopAgnosticVFSFile* _keyfile;
	DesktopAgnosticVFSFileMonitor* _keyfile_monitor;
	gulong _monitor_changed_id;
	char* _checksum;
	gboolean _autosave;
	GData* _notifiers;
};


static gpointer desktop_agnostic_config_gkey_file_parent_class = NULL;

GType desktop_agnostic_config_gkey_file_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_CONFIG_GKEY_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_CONFIG_TYPE_GKEY_FILE, DesktopAgnosticConfigGKeyFilePrivate))
enum  {
	DESKTOP_AGNOSTIC_CONFIG_GKEY_FILE_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_CONFIG_GKEY_FILE_NAME
};
static void desktop_agnostic_config_gkey_file_save_config (DesktopAgnosticConfigGKeyFile* self, GError** error);
static void desktop_agnostic_config_gkey_file_update_config (DesktopAgnosticConfigGKeyFile* self, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_gkey_file_get_data_from_file (DesktopAgnosticConfigGKeyFile* self, DesktopAgnosticVFSFile* file, char** contents, gsize* length, char** checksum, GError** error);
static void desktop_agnostic_config_gkey_file_load_data (DesktopAgnosticConfigGKeyFile* self, DesktopAgnosticVFSFile* file, GError** error);
static void desktop_agnostic_config_gkey_file_set_value_from_keyfile (DesktopAgnosticConfigGKeyFile* self, GKeyFile* keyfile, const char* group, const char* key, GError** error);
static GValueArray* desktop_agnostic_config_gkey_file_generate_valuearray_from_keyfile (DesktopAgnosticConfigGKeyFile* self, GKeyFile* keyfile, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_gkey_file_on_keyfile_changed (DesktopAgnosticConfigGKeyFile* self, DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* other, DesktopAgnosticVFSFileMonitorEvent event, DesktopAgnosticVFSFileMonitor* monitor);
static void desktop_agnostic_config_gkey_file_ensure_directory (DesktopAgnosticConfigGKeyFile* self, const char* path);
static gboolean desktop_agnostic_config_gkey_file_create_file_monitor (DesktopAgnosticConfigGKeyFile* self);
static void desktop_agnostic_config_gkey_file_real_constructed (GObject* base);
static gboolean _desktop_agnostic_config_gkey_file_create_file_monitor_gsource_func (gpointer self);
static void desktop_agnostic_config_gkey_file_real_reset (DesktopAgnosticConfigBackend* base, GError** error);
static void desktop_agnostic_config_gkey_file_real_notify_add (DesktopAgnosticConfigBackend* base, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error);
static void desktop_agnostic_config_gkey_file_real_notify (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_gkey_file_real_notify_remove (DesktopAgnosticConfigBackend* base, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error);
static void desktop_agnostic_config_gkey_file_real_remove (DesktopAgnosticConfigBackend* base, GError** error);
static void desktop_agnostic_config_gkey_file_real_get_value (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GValue* result, GError** error);
static gboolean desktop_agnostic_config_gkey_file_real_get_bool (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_gkey_file_real_set_bool (DesktopAgnosticConfigBackend* base, const char* group, const char* key, gboolean value, GError** error);
static float desktop_agnostic_config_gkey_file_real_get_float (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_gkey_file_real_set_float (DesktopAgnosticConfigBackend* base, const char* group, const char* key, float value, GError** error);
static gint desktop_agnostic_config_gkey_file_real_get_int (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_gkey_file_real_set_int (DesktopAgnosticConfigBackend* base, const char* group, const char* key, gint value, GError** error);
static char* desktop_agnostic_config_gkey_file_real_get_string (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_gkey_file_real_set_string (DesktopAgnosticConfigBackend* base, const char* group, const char* key, const char* value, GError** error);
static GValueArray* desktop_agnostic_config_gkey_file_real_get_list (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_gkey_file_real_set_list (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GValueArray* value, GError** error);
static void _vala_array_add1 (gboolean** array, int* length, int* size, gboolean value);
static void _vala_array_add2 (gint** array, int* length, int* size, gint value);
static void _vala_array_add3 (double** array, int* length, int* size, double value);
static void _vala_array_add4 (char*** array, int* length, int* size, char* value);
static void _vala_array_add5 (char*** array, int* length, int* size, char* value);
DesktopAgnosticConfigGKeyFile* desktop_agnostic_config_gkey_file_new (void);
DesktopAgnosticConfigGKeyFile* desktop_agnostic_config_gkey_file_construct (GType object_type);
static GObject * desktop_agnostic_config_gkey_file_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void desktop_agnostic_config_gkey_file_finalize (GObject* obj);
static void desktop_agnostic_config_gkey_file_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType register_plugin (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



/**
     * Saves the current state of the configuration to the filesystem,
     * suppressing the "changed" signal from the file monitor.
     */
static void desktop_agnostic_config_gkey_file_save_config (DesktopAgnosticConfigGKeyFile* self, GError** error) {
	char* data;
	gsize length = 0UL;
	char* _tmp0_;
	char* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	data = NULL;
	data = (_tmp0_ = g_key_file_to_data (self->priv->_data, &length, NULL), _g_free0 (data), _tmp0_);
	self->priv->_checksum = (_tmp1_ = g_compute_checksum_for_string (G_CHECKSUM_SHA256, data, length), _g_free0 (self->priv->_checksum), _tmp1_);
	if (self->priv->_monitor_changed_id != 0) {
		g_signal_handler_block (self->priv->_keyfile_monitor, self->priv->_monitor_changed_id);
	}
	desktop_agnostic_vfs_file_replace_contents (self->priv->_keyfile, data, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (data);
		return;
	}
	if (self->priv->_monitor_changed_id != 0) {
		g_signal_handler_unblock (self->priv->_keyfile_monitor, self->priv->_monitor_changed_id);
	}
	_g_free0 (data);
}


/**
     * Saves the current configuration state to the filesystem (if autosave is
     * on) and emits the notify signal.
     */
static void desktop_agnostic_config_gkey_file_update_config (DesktopAgnosticConfigGKeyFile* self, const char* group, const char* key, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	if (self->priv->_autosave) {
		desktop_agnostic_config_gkey_file_save_config (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	desktop_agnostic_config_backend_notify ((DesktopAgnosticConfigBackend*) self, group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void desktop_agnostic_config_gkey_file_get_data_from_file (DesktopAgnosticConfigGKeyFile* self, DesktopAgnosticVFSFile* file, char** contents, gsize* length, char** checksum, GError** error) {
	char* _tmp0_ = NULL;
	char* _tmp1_;
	char* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	if (contents != NULL) {
		*contents = NULL;
	}
	if (checksum != NULL) {
		*checksum = NULL;
	}
	desktop_agnostic_vfs_file_load_contents (file, &_tmp0_, length, &_inner_error_);
	*contents = (_tmp1_ = _tmp0_, _g_free0 (*contents), _tmp1_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	*checksum = (_tmp2_ = g_compute_checksum_for_string (G_CHECKSUM_SHA256, *contents, *length), _g_free0 (*checksum), _tmp2_);
}


static void desktop_agnostic_config_gkey_file_load_data (DesktopAgnosticConfigGKeyFile* self, DesktopAgnosticVFSFile* file, GError** error) {
	char* data;
	gsize length = 0UL;
	char* _tmp0_ = NULL;
	char* _tmp1_;
	char* _tmp2_ = NULL;
	char* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	data = NULL;
	(desktop_agnostic_config_gkey_file_get_data_from_file (self, file, &_tmp0_, &length, &_tmp2_, &_inner_error_), data = (_tmp1_ = _tmp0_, _g_free0 (data), _tmp1_));
	self->priv->_checksum = (_tmp3_ = _tmp2_, _g_free0 (self->priv->_checksum), _tmp3_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (data);
		return;
	}
	g_key_file_load_from_data (self->priv->_data, data, (gsize) ((gulong) length), G_KEY_FILE_NONE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (data);
		return;
	}
	_g_free0 (data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void desktop_agnostic_config_gkey_file_set_value_from_keyfile (DesktopAgnosticConfigGKeyFile* self, GKeyFile* keyfile, const char* group, const char* key, GError** error) {
	DesktopAgnosticConfigSchemaOption* option;
	GType type;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (keyfile != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	option = _g_object_ref0 (desktop_agnostic_config_schema_get_option (desktop_agnostic_config_backend_get_schema ((DesktopAgnosticConfigBackend*) self), group, key));
	type = desktop_agnostic_config_schema_option_get_option_type (option);
	if (type == G_TYPE_BOOLEAN) {
		gboolean _tmp0_;
		_tmp0_ = g_key_file_get_boolean (keyfile, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (option);
			return;
		}
		desktop_agnostic_config_backend_set_bool ((DesktopAgnosticConfigBackend*) self, group, key, _tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (option);
			return;
		}
	} else {
		if (type == G_TYPE_INT) {
			gint _tmp1_;
			_tmp1_ = g_key_file_get_integer (keyfile, group, key, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (option);
				return;
			}
			desktop_agnostic_config_backend_set_int ((DesktopAgnosticConfigBackend*) self, group, key, _tmp1_, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (option);
				return;
			}
		} else {
			if (type == G_TYPE_FLOAT) {
				double _tmp2_;
				_tmp2_ = g_key_file_get_double (keyfile, group, key, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (option);
					return;
				}
				desktop_agnostic_config_backend_set_float ((DesktopAgnosticConfigBackend*) self, group, key, (float) _tmp2_, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (option);
					return;
				}
			} else {
				if (type == G_TYPE_STRING) {
					char* _tmp3_;
					char* _tmp4_;
					_tmp3_ = g_key_file_get_string (keyfile, group, key, &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (option);
						return;
					}
					desktop_agnostic_config_backend_set_string ((DesktopAgnosticConfigBackend*) self, group, key, _tmp4_ = _tmp3_, &_inner_error_);
					_g_free0 (_tmp4_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (option);
						return;
					}
				} else {
					if (type == G_TYPE_VALUE_ARRAY) {
						GValueArray* arr;
						GValueArray* _tmp5_;
						GValueArray* _tmp6_;
						arr = NULL;
						_tmp5_ = desktop_agnostic_config_gkey_file_generate_valuearray_from_keyfile (self, keyfile, group, key, &_inner_error_);
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							_g_value_array_free0 (arr);
							_g_object_unref0 (option);
							return;
						}
						arr = (_tmp6_ = _tmp5_, _g_value_array_free0 (arr), _tmp6_);
						desktop_agnostic_config_backend_set_list ((DesktopAgnosticConfigBackend*) self, group, key, arr, &_inner_error_);
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							_g_value_array_free0 (arr);
							_g_object_unref0 (option);
							return;
						}
						_g_value_array_free0 (arr);
					} else {
						DesktopAgnosticConfigSchemaType* st;
						GValue val = {0};
						char* _tmp7_;
						char* _tmp8_;
						GValue _tmp9_ = {0};
						GValue _tmp10_;
						GValue _tmp11_;
						GValue _tmp12_;
						st = _g_object_ref0 (desktop_agnostic_config_schema_find_type (type));
						if (st == NULL) {
							_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_INVALID_TYPE, "'%s' is an invalid config type.", g_type_name (type));
							{
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (st);
								_g_object_unref0 (option);
								return;
							}
						}
						_tmp7_ = g_key_file_get_string (keyfile, group, key, &_inner_error_);
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
							_g_object_unref0 (st);
							_g_object_unref0 (option);
							return;
						}
						_tmp11_ = (_tmp10_ = (desktop_agnostic_config_schema_type_deserialize (st, _tmp8_ = _tmp7_, &_tmp9_, &_inner_error_), _tmp9_), _g_free0 (_tmp8_), _tmp10_);
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
							_g_object_unref0 (st);
							_g_object_unref0 (option);
							return;
						}
						val = (_tmp12_ = _tmp11_, G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp12_);
						desktop_agnostic_config_backend_set_value ((DesktopAgnosticConfigBackend*) self, group, key, &val, &_inner_error_);
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
							_g_object_unref0 (st);
							_g_object_unref0 (option);
							return;
						}
						G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
						_g_object_unref0 (st);
					}
				}
			}
		}
	}
	_g_object_unref0 (option);
}


static GValueArray* desktop_agnostic_config_gkey_file_generate_valuearray_from_keyfile (DesktopAgnosticConfigGKeyFile* self, GKeyFile* keyfile, const char* group, const char* key, GError** error) {
	GValueArray* result = NULL;
	DesktopAgnosticConfigSchemaOption* option;
	GType list_type = 0UL;
	GValueArray* arr;
	DesktopAgnosticConfigSchemaOption* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (keyfile != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	option = NULL;
	arr = NULL;
	option = (_tmp0_ = _g_object_ref0 (desktop_agnostic_config_schema_get_option (desktop_agnostic_config_backend_get_schema ((DesktopAgnosticConfigBackend*) self), group, key)), _g_object_unref0 (option), _tmp0_);
	if (option == NULL) {
		_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_KEY_NOT_FOUND, "The key %s/%s is invalid.", group, key);
		{
			g_propagate_error (error, _inner_error_);
			_g_value_array_free0 (arr);
			_g_object_unref0 (option);
			return NULL;
		}
	} else {
		gboolean _tmp1_;
		_tmp1_ = g_key_file_has_key (keyfile, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_value_array_free0 (arr);
			_g_object_unref0 (option);
			return NULL;
		}
		if (!_tmp1_) {
			result = g_value_array_new ((guint) 0);
			_g_value_array_free0 (arr);
			_g_object_unref0 (option);
			return result;
		}
	}
	list_type = desktop_agnostic_config_schema_option_get_list_type (option);
	if (list_type == G_TYPE_BOOLEAN) {
		gint list_data_length1;
		gint _list_data_size_;
		gboolean* list_data;
		GValue val = {0};
		gint _tmp3__length1;
		gint __tmp3__size_;
		gboolean* _tmp4_;
		gsize _tmp2_;
		gboolean* _tmp3_;
		gboolean* _tmp5_;
		GValueArray* _tmp6_;
		list_data = (list_data_length1 = 0, NULL);
		_tmp3_ = (_tmp4_ = g_key_file_get_boolean_list (keyfile, group, key, &_tmp2_, &_inner_error_), _tmp3__length1 = _tmp2_, __tmp3__size_ = _tmp3__length1, _tmp4_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			list_data = (g_free (list_data), NULL);
			_g_value_array_free0 (arr);
			_g_object_unref0 (option);
			return NULL;
		}
		list_data = (_tmp5_ = _tmp3_, list_data = (g_free (list_data), NULL), list_data_length1 = _tmp3__length1, _list_data_size_ = list_data_length1, _tmp5_);
		arr = (_tmp6_ = g_value_array_new ((guint) list_data_length1), _g_value_array_free0 (arr), _tmp6_);
		{
			gboolean* item_collection;
			int item_collection_length1;
			int item_it;
			item_collection = list_data;
			item_collection_length1 = list_data_length1;
			for (item_it = 0; item_it < list_data_length1; item_it = item_it + 1) {
				gboolean item;
				item = item_collection[item_it];
				{
					GValue _tmp7_ = {0};
					GValue _tmp8_;
					val = (_tmp8_ = (g_value_init (&_tmp7_, G_TYPE_BOOLEAN), g_value_set_boolean (&_tmp7_, item), _tmp7_), G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp8_);
					g_value_array_append (arr, &val);
				}
			}
		}
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		list_data = (g_free (list_data), NULL);
	} else {
		if (list_type == G_TYPE_INT) {
			gint list_data_length1;
			gint _list_data_size_;
			gint* list_data;
			GValue val = {0};
			gint _tmp10__length1;
			gint __tmp10__size_;
			gint* _tmp11_;
			gsize _tmp9_;
			gint* _tmp10_;
			gint* _tmp12_;
			GValueArray* _tmp13_;
			list_data = (list_data_length1 = 0, NULL);
			_tmp10_ = (_tmp11_ = g_key_file_get_integer_list (keyfile, group, key, &_tmp9_, &_inner_error_), _tmp10__length1 = _tmp9_, __tmp10__size_ = _tmp10__length1, _tmp11_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
				list_data = (g_free (list_data), NULL);
				_g_value_array_free0 (arr);
				_g_object_unref0 (option);
				return NULL;
			}
			list_data = (_tmp12_ = _tmp10_, list_data = (g_free (list_data), NULL), list_data_length1 = _tmp10__length1, _list_data_size_ = list_data_length1, _tmp12_);
			arr = (_tmp13_ = g_value_array_new ((guint) list_data_length1), _g_value_array_free0 (arr), _tmp13_);
			{
				gint* item_collection;
				int item_collection_length1;
				int item_it;
				item_collection = list_data;
				item_collection_length1 = list_data_length1;
				for (item_it = 0; item_it < list_data_length1; item_it = item_it + 1) {
					gint item;
					item = item_collection[item_it];
					{
						GValue _tmp14_ = {0};
						GValue _tmp15_;
						val = (_tmp15_ = (g_value_init (&_tmp14_, G_TYPE_INT), g_value_set_int (&_tmp14_, item), _tmp14_), G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp15_);
						g_value_array_append (arr, &val);
					}
				}
			}
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			list_data = (g_free (list_data), NULL);
		} else {
			if (list_type == G_TYPE_FLOAT) {
				gint list_data_length1;
				gint _list_data_size_;
				double* list_data;
				GValue val = {0};
				gint _tmp17__length1;
				gint __tmp17__size_;
				double* _tmp18_;
				gsize _tmp16_;
				double* _tmp17_;
				double* _tmp19_;
				GValueArray* _tmp20_;
				list_data = (list_data_length1 = 0, NULL);
				_tmp17_ = (_tmp18_ = g_key_file_get_double_list (keyfile, group, key, &_tmp16_, &_inner_error_), _tmp17__length1 = _tmp16_, __tmp17__size_ = _tmp17__length1, _tmp18_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					list_data = (g_free (list_data), NULL);
					_g_value_array_free0 (arr);
					_g_object_unref0 (option);
					return NULL;
				}
				list_data = (_tmp19_ = (double*) _tmp17_, list_data = (g_free (list_data), NULL), list_data_length1 = _tmp17__length1, _list_data_size_ = list_data_length1, _tmp19_);
				arr = (_tmp20_ = g_value_array_new ((guint) list_data_length1), _g_value_array_free0 (arr), _tmp20_);
				{
					double* item_collection;
					int item_collection_length1;
					int item_it;
					item_collection = list_data;
					item_collection_length1 = list_data_length1;
					for (item_it = 0; item_it < list_data_length1; item_it = item_it + 1) {
						double item;
						item = item_collection[item_it];
						{
							GValue _tmp21_ = {0};
							GValue _tmp22_;
							val = (_tmp22_ = (g_value_init (&_tmp21_, G_TYPE_FLOAT), g_value_set_float (&_tmp21_, (float) item), _tmp21_), G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp22_);
							g_value_array_append (arr, &val);
						}
					}
				}
				G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
				list_data = (g_free (list_data), NULL);
			} else {
				if (list_type == G_TYPE_STRING) {
					gint list_data_length1;
					gint _list_data_size_;
					char** list_data;
					GValue val = {0};
					gint _tmp24__length1;
					gint __tmp24__size_;
					char** _tmp25_;
					gsize _tmp23_;
					char** _tmp24_;
					char** _tmp26_;
					GValueArray* _tmp27_;
					list_data = (list_data_length1 = 0, NULL);
					_tmp24_ = (_tmp25_ = g_key_file_get_string_list (keyfile, group, key, &_tmp23_, &_inner_error_), _tmp24__length1 = _tmp23_, __tmp24__size_ = _tmp24__length1, _tmp25_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
						list_data = (_vala_array_free (list_data, list_data_length1, (GDestroyNotify) g_free), NULL);
						_g_value_array_free0 (arr);
						_g_object_unref0 (option);
						return NULL;
					}
					list_data = (_tmp26_ = _tmp24_, list_data = (_vala_array_free (list_data, list_data_length1, (GDestroyNotify) g_free), NULL), list_data_length1 = _tmp24__length1, _list_data_size_ = list_data_length1, _tmp26_);
					arr = (_tmp27_ = g_value_array_new ((guint) list_data_length1), _g_value_array_free0 (arr), _tmp27_);
					{
						char** item_collection;
						int item_collection_length1;
						int item_it;
						item_collection = list_data;
						item_collection_length1 = list_data_length1;
						for (item_it = 0; item_it < list_data_length1; item_it = item_it + 1) {
							char* item;
							item = g_strdup (item_collection[item_it]);
							{
								GValue _tmp28_ = {0};
								GValue _tmp29_;
								val = (_tmp29_ = (g_value_init (&_tmp28_, G_TYPE_STRING), g_value_set_string (&_tmp28_, item), _tmp28_), G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp29_);
								g_value_array_append (arr, &val);
								_g_free0 (item);
							}
						}
					}
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					list_data = (_vala_array_free (list_data, list_data_length1, (GDestroyNotify) g_free), NULL);
				} else {
					DesktopAgnosticConfigSchemaType* st;
					gint list_data_length1;
					gint _list_data_size_;
					char** list_data;
					gint _tmp31__length1;
					gint __tmp31__size_;
					char** _tmp32_;
					gsize _tmp30_;
					char** _tmp31_;
					char** _tmp33_;
					GValueArray* _tmp34_;
					st = _g_object_ref0 (desktop_agnostic_config_schema_find_type (list_type));
					if (st == NULL) {
						_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_INVALID_TYPE, "'%s' is an invalid config type.", g_type_name (list_type));
						{
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (st);
							_g_value_array_free0 (arr);
							_g_object_unref0 (option);
							return NULL;
						}
					}
					list_data = (list_data_length1 = 0, NULL);
					_tmp31_ = (_tmp32_ = g_key_file_get_string_list (keyfile, group, key, &_tmp30_, &_inner_error_), _tmp31__length1 = _tmp30_, __tmp31__size_ = _tmp31__length1, _tmp32_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						list_data = (_vala_array_free (list_data, list_data_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (st);
						_g_value_array_free0 (arr);
						_g_object_unref0 (option);
						return NULL;
					}
					list_data = (_tmp33_ = _tmp31_, list_data = (_vala_array_free (list_data, list_data_length1, (GDestroyNotify) g_free), NULL), list_data_length1 = _tmp31__length1, _list_data_size_ = list_data_length1, _tmp33_);
					arr = (_tmp34_ = g_value_array_new ((guint) list_data_length1), _g_value_array_free0 (arr), _tmp34_);
					{
						char** item_collection;
						int item_collection_length1;
						int item_it;
						item_collection = list_data;
						item_collection_length1 = list_data_length1;
						for (item_it = 0; item_it < list_data_length1; item_it = item_it + 1) {
							char* item;
							item = g_strdup (item_collection[item_it]);
							{
								GValue _tmp35_ = {0};
								GValue _tmp36_;
								GValue _tmp37_;
								GValue _tmp38_;
								_tmp36_ = (desktop_agnostic_config_schema_type_deserialize (st, item, &_tmp35_, &_inner_error_), _tmp35_);
								if (_inner_error_ != NULL) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (item);
									list_data = (_vala_array_free (list_data, list_data_length1, (GDestroyNotify) g_free), NULL);
									_g_object_unref0 (st);
									_g_value_array_free0 (arr);
									_g_object_unref0 (option);
									return NULL;
								}
								g_value_array_append (arr, (_tmp38_ = _tmp37_ = _tmp36_, &_tmp38_));
								G_IS_VALUE (&_tmp37_) ? (g_value_unset (&_tmp37_), NULL) : NULL;
								_g_free0 (item);
							}
						}
					}
					list_data = (_vala_array_free (list_data, list_data_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (st);
				}
			}
		}
	}
	result = arr;
	_g_object_unref0 (option);
	return result;
}


static void desktop_agnostic_config_gkey_file_on_keyfile_changed (DesktopAgnosticConfigGKeyFile* self, DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* other, DesktopAgnosticVFSFileMonitorEvent event, DesktopAgnosticVFSFileMonitor* monitor) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (monitor != NULL);
	switch (event) {
		case DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_CREATED:
		{
			desktop_agnostic_config_gkey_file_load_data (self, file, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			break;
		}
		case DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_CHANGED:
		{
			char* data;
			gsize length = 0UL;
			char* checksum;
			char* _tmp0_ = NULL;
			char* _tmp1_;
			char* _tmp2_ = NULL;
			char* _tmp3_;
			data = NULL;
			checksum = NULL;
			(desktop_agnostic_config_gkey_file_get_data_from_file (self, file, &_tmp0_, &length, &_tmp2_, &_inner_error_), data = (_tmp1_ = _tmp0_, _g_free0 (data), _tmp1_));
			checksum = (_tmp3_ = _tmp2_, _g_free0 (checksum), _tmp3_);
			if (_inner_error_ != NULL) {
				_g_free0 (checksum);
				_g_free0 (data);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			if (_vala_strcmp0 (self->priv->_checksum, checksum) != 0) {
				DesktopAgnosticConfigSchema* schema;
				GKeyFile* new_data;
				schema = desktop_agnostic_config_backend_get_schema ((DesktopAgnosticConfigBackend*) self);
				new_data = g_key_file_new ();
				g_key_file_load_from_data (new_data, data, length, G_KEY_FILE_NONE, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_key_file_free0 (new_data);
					_g_free0 (checksum);
					_g_free0 (data);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				self->priv->_autosave = FALSE;
				{
					GList* group_collection;
					GList* group_it;
					group_collection = desktop_agnostic_config_schema_get_groups (schema);
					for (group_it = group_collection; group_it != NULL; group_it = group_it->next) {
						const char* group;
						group = (const char*) group_it->data;
						{
							{
								GList* key_collection;
								GList* key_it;
								key_collection = desktop_agnostic_config_schema_get_keys (schema, group);
								for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
									const char* key;
									key = (const char*) key_it->data;
									{
										if (g_key_file_has_group (self->priv->_data, group)) {
											gboolean _tmp4_ = FALSE;
											gboolean _tmp5_ = FALSE;
											gboolean _tmp6_;
											_tmp6_ = g_key_file_has_key (self->priv->_data, group, key, &_inner_error_);
											if (_inner_error_ != NULL) {
												_g_list_free0 (group_collection);
												_g_key_file_free0 (new_data);
												_g_free0 (checksum);
												_g_free0 (data);
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return;
											}
											if (_tmp6_) {
												char* _tmp7_;
												char* _tmp8_;
												char* _tmp9_;
												char* _tmp10_;
												_tmp7_ = g_key_file_get_value (self->priv->_data, group, key, &_inner_error_);
												if (_inner_error_ != NULL) {
													_g_list_free0 (group_collection);
													_g_key_file_free0 (new_data);
													_g_free0 (checksum);
													_g_free0 (data);
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return;
												}
												_tmp8_ = g_key_file_get_value (new_data, group, key, &_inner_error_);
												if (_inner_error_ != NULL) {
													_g_list_free0 (group_collection);
													_g_key_file_free0 (new_data);
													_g_free0 (checksum);
													_g_free0 (data);
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return;
												}
												_tmp5_ = _vala_strcmp0 (_tmp9_ = _tmp7_, _tmp10_ = _tmp8_) != 0;
												_g_free0 (_tmp10_);
												_g_free0 (_tmp9_);
											} else {
												_tmp5_ = FALSE;
											}
											if (_tmp5_) {
												_tmp4_ = TRUE;
											} else {
												_tmp4_ = desktop_agnostic_config_schema_option_get_option_type (desktop_agnostic_config_schema_get_option (schema, group, key)) == G_TYPE_VALUE_ARRAY;
											}
											if (_tmp4_) {
												desktop_agnostic_config_gkey_file_set_value_from_keyfile (self, new_data, group, key, &_inner_error_);
												if (_inner_error_ != NULL) {
													_g_list_free0 (group_collection);
													_g_key_file_free0 (new_data);
													_g_free0 (checksum);
													_g_free0 (data);
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return;
												}
											}
										}
									}
								}
							}
						}
					}
					_g_list_free0 (group_collection);
				}
				self->priv->_autosave = TRUE;
				_g_key_file_free0 (new_data);
			}
			_g_free0 (checksum);
			_g_free0 (data);
			break;
		}
		case DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_DELETED:
		{
			desktop_agnostic_config_backend_reset ((DesktopAgnosticConfigBackend*) self, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			break;
		}
		default:
		{
			break;
		}
	}
}


static void desktop_agnostic_config_gkey_file_ensure_directory (DesktopAgnosticConfigGKeyFile* self, const char* path) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	if (!g_file_test (path, G_FILE_TEST_EXISTS)) {
		gint d_errno;
		d_errno = g_mkdir_with_parents (path, 0755);
		if (d_errno != 0) {
			g_critical ("config-impl-keyfile.vala:315: Config file error: %s", g_strerror (d_errno));
		}
	}
}


static gboolean desktop_agnostic_config_gkey_file_create_file_monitor (DesktopAgnosticConfigGKeyFile* self) {
	gboolean result = FALSE;
	DesktopAgnosticVFSFileMonitor* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->_keyfile_monitor = (_tmp0_ = desktop_agnostic_vfs_file_monitor (self->priv->_keyfile), _g_object_unref0 (self->priv->_keyfile_monitor), _tmp0_);
	self->priv->_monitor_changed_id = g_signal_connect_swapped (self->priv->_keyfile_monitor, "changed", (GCallback) desktop_agnostic_config_gkey_file_on_keyfile_changed, self);
	result = FALSE;
	return result;
}


/**
     * Determines the path to the config file and creates/loads it.
     */
static gboolean _desktop_agnostic_config_gkey_file_create_file_monitor_gsource_func (gpointer self) {
	gboolean result;
	result = desktop_agnostic_config_gkey_file_create_file_monitor (self);
	return result;
}


static void desktop_agnostic_config_gkey_file_real_constructed (GObject* base) {
	DesktopAgnosticConfigGKeyFile * self;
	char* base_path;
	char* path;
	DesktopAgnosticConfigSchema* schema;
	char* _tmp0_;
	DesktopAgnosticVFSFile* _tmp5_;
	DesktopAgnosticVFSFile* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGKeyFile*) base;
	base_path = NULL;
	path = NULL;
	schema = _g_object_ref0 (desktop_agnostic_config_backend_get_schema ((DesktopAgnosticConfigBackend*) self));
	base_path = (_tmp0_ = g_build_filename (g_get_user_config_dir (), "desktop-agnostic", NULL), _g_free0 (base_path), _tmp0_);
	if (desktop_agnostic_config_backend_get_instance_id ((DesktopAgnosticConfigBackend*) self) == NULL) {
		char* _tmp1_;
		char* _tmp2_;
		path = (_tmp2_ = g_build_filename (base_path, _tmp1_ = g_strdup_printf ("%s.ini", desktop_agnostic_config_schema_get_app_name (schema)), NULL), _g_free0 (path), _tmp2_);
		_g_free0 (_tmp1_);
	} else {
		char* _tmp3_;
		char* _tmp4_;
		path = (_tmp4_ = g_build_filename (base_path, "instances", _tmp3_ = g_strdup_printf ("%s-%s.ini", desktop_agnostic_config_schema_get_app_name (schema), desktop_agnostic_config_backend_get_instance_id ((DesktopAgnosticConfigBackend*) self)), NULL), _g_free0 (path), _tmp4_);
		_g_free0 (_tmp3_);
	}
	_tmp5_ = desktop_agnostic_vfs_file_new_for_path (path, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (schema);
		_g_free0 (path);
		_g_free0 (base_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->_keyfile = (_tmp6_ = _tmp5_, _g_object_unref0 (self->priv->_keyfile), _tmp6_);
	{
		if (desktop_agnostic_vfs_file_exists (self->priv->_keyfile)) {
			desktop_agnostic_config_gkey_file_load_data (self, self->priv->_keyfile, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
		} else {
			char* _tmp7_;
			desktop_agnostic_config_gkey_file_ensure_directory (self, _tmp7_ = g_path_get_dirname (path));
			_g_free0 (_tmp7_);
			desktop_agnostic_config_backend_reset ((DesktopAgnosticConfigBackend*) self, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("config-impl-keyfile.vala:369: Config error: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (schema);
		_g_free0 (path);
		_g_free0 (base_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _desktop_agnostic_config_gkey_file_create_file_monitor_gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (schema);
	_g_free0 (path);
	_g_free0 (base_path);
}


static void desktop_agnostic_config_gkey_file_real_reset (DesktopAgnosticConfigBackend* base, GError** error) {
	DesktopAgnosticConfigGKeyFile * self;
	DesktopAgnosticConfigSchema* schema;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGKeyFile*) base;
	schema = desktop_agnostic_config_backend_get_schema ((DesktopAgnosticConfigBackend*) self);
	if (schema == NULL) {
		_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_NO_SCHEMA, "The schema was not loaded.");
		{
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	self->priv->_autosave = FALSE;
	{
		GList* group_collection;
		GList* group_it;
		group_collection = desktop_agnostic_config_schema_get_groups (schema);
		for (group_it = group_collection; group_it != NULL; group_it = group_it->next) {
			const char* group;
			group = (const char*) group_it->data;
			{
				{
					GList* key_collection;
					GList* key_it;
					key_collection = desktop_agnostic_config_schema_get_keys (schema, group);
					for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
						const char* key;
						key = (const char*) key_it->data;
						{
							DesktopAgnosticConfigSchemaOption* option;
							gboolean _tmp0_ = FALSE;
							option = _g_object_ref0 (desktop_agnostic_config_schema_get_option (schema, group, key));
							if (desktop_agnostic_config_backend_get_instance_id ((DesktopAgnosticConfigBackend*) self) == NULL) {
								_tmp0_ = TRUE;
							} else {
								_tmp0_ = desktop_agnostic_config_schema_option_get_per_instance (option);
							}
							if (_tmp0_) {
								GValue _tmp1_ = {0};
								GValue _tmp2_;
								desktop_agnostic_config_backend_set_value ((DesktopAgnosticConfigBackend*) self, group, key, (_tmp2_ = (desktop_agnostic_config_schema_option_get_default_value (option, &_tmp1_), _tmp1_), &_tmp2_), &_inner_error_);
								if (_inner_error_ != NULL) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (option);
									_g_list_free0 (group_collection);
									return;
								}
							}
							_g_object_unref0 (option);
						}
					}
				}
			}
		}
		_g_list_free0 (group_collection);
	}
	self->priv->_autosave = TRUE;
	desktop_agnostic_config_gkey_file_save_config (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void desktop_agnostic_config_gkey_file_real_notify_add (DesktopAgnosticConfigBackend* base, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error) {
	DesktopAgnosticConfigGKeyFile * self;
	char* full_key;
	GSList* funcs;
	DesktopAgnosticConfigNotifyDelegate* data;
	DesktopAgnosticConfigNotifyDelegate* _tmp0_;
	self = (DesktopAgnosticConfigGKeyFile*) base;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	full_key = g_strdup_printf ("%s/%s", group, key);
	funcs = (GSList*) g_datalist_get_data (&self->priv->_notifiers, full_key);
	data = desktop_agnostic_config_notify_delegate_new (callback, callback_target);
	funcs = g_slist_append (funcs, (_tmp0_ = data, data = NULL, _tmp0_));
	g_datalist_set_data (&self->priv->_notifiers, full_key, funcs);
	_desktop_agnostic_config_notify_delegate_free0 (data);
	_g_free0 (full_key);
}


static void desktop_agnostic_config_gkey_file_real_notify (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error) {
	DesktopAgnosticConfigGKeyFile * self;
	char* full_key;
	GValue _tmp0_ = {0};
	GValue value;
	GSList* funcs;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGKeyFile*) base;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	full_key = g_strdup_printf ("%s/%s", group, key);
	value = (desktop_agnostic_config_backend_get_value ((DesktopAgnosticConfigBackend*) self, group, key, &_tmp0_, &_inner_error_), _tmp0_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		return;
	}
	funcs = (GSList*) g_datalist_get_data (&self->priv->_notifiers, full_key);
	{
		GSList* data_collection;
		GSList* data_it;
		data_collection = funcs;
		for (data_it = data_collection; data_it != NULL; data_it = data_it->next) {
			DesktopAgnosticConfigNotifyDelegate* data;
			data = (DesktopAgnosticConfigNotifyDelegate*) data_it->data;
			{
				gboolean _tmp1_ = FALSE;
				if (data != NULL) {
					_tmp1_ = data->callback != NULL;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					desktop_agnostic_config_notify_delegate_execute (data, group, key, &value);
				}
			}
		}
	}
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	_g_free0 (full_key);
}


static void desktop_agnostic_config_gkey_file_real_notify_remove (DesktopAgnosticConfigBackend* base, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error) {
	DesktopAgnosticConfigGKeyFile * self;
	char* full_key;
	GSList* funcs;
	DesktopAgnosticConfigNotifyDelegate* ndata;
	GSList* node;
	self = (DesktopAgnosticConfigGKeyFile*) base;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	full_key = g_strdup_printf ("%s/%s", group, key);
	funcs = (GSList*) g_datalist_get_data (&self->priv->_notifiers, full_key);
	ndata = desktop_agnostic_config_notify_delegate_new (callback, callback_target);
	node = NULL;
	node = g_slist_find_custom (funcs, ndata, (GCompareFunc) desktop_agnostic_config_notify_delegate_compare);
	if (node != NULL) {
		DesktopAgnosticConfigNotifyDelegate* _tmp0_;
		node->data = (_tmp0_ = NULL, _desktop_agnostic_config_notify_delegate_free0 (node->data), _tmp0_);
		funcs = g_slist_delete_link (funcs, node);
		g_datalist_set_data (&self->priv->_notifiers, full_key, funcs);
	}
	_desktop_agnostic_config_notify_delegate_free0 (ndata);
	_g_free0 (full_key);
}


/**
     * Removes the config file from the file system. Implies reset(), but does
     * not save to disk.
     */
static void desktop_agnostic_config_gkey_file_real_remove (DesktopAgnosticConfigBackend* base, GError** error) {
	DesktopAgnosticConfigGKeyFile * self;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGKeyFile*) base;
	desktop_agnostic_vfs_file_remove (self->priv->_keyfile, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	desktop_agnostic_config_backend_reset ((DesktopAgnosticConfigBackend*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void desktop_agnostic_config_gkey_file_real_get_value (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GValue* result, GError** error) {
	DesktopAgnosticConfigGKeyFile * self;
	DesktopAgnosticConfigSchema* schema;
	DesktopAgnosticConfigSchemaOption* option;
	GType option_type = 0UL;
	GValue _result_ = {0};
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGKeyFile*) base;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	schema = _g_object_ref0 (desktop_agnostic_config_backend_get_schema ((DesktopAgnosticConfigBackend*) self));
	option = _g_object_ref0 (desktop_agnostic_config_schema_get_option (schema, group, key));
	if (option == NULL) {
		_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_KEY_NOT_FOUND, "Could not find group and/or key in schema.");
		{
			g_propagate_error (error, _inner_error_);
			G_IS_VALUE (&_result_) ? (g_value_unset (&_result_), NULL) : NULL;
			_g_object_unref0 (option);
			_g_object_unref0 (schema);
			return;
		}
	}
	option_type = desktop_agnostic_config_schema_option_get_option_type (option);
	if (option_type == G_TYPE_BOOLEAN) {
		gboolean _tmp0_;
		GValue _tmp1_ = {0};
		GValue _tmp2_;
		_tmp0_ = desktop_agnostic_config_backend_get_bool ((DesktopAgnosticConfigBackend*) self, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			G_IS_VALUE (&_result_) ? (g_value_unset (&_result_), NULL) : NULL;
			_g_object_unref0 (option);
			_g_object_unref0 (schema);
			return;
		}
		_result_ = (_tmp2_ = (g_value_init (&_tmp1_, G_TYPE_BOOLEAN), g_value_set_boolean (&_tmp1_, _tmp0_), _tmp1_), G_IS_VALUE (&_result_) ? (g_value_unset (&_result_), NULL) : NULL, _tmp2_);
	} else {
		if (option_type == G_TYPE_FLOAT) {
			float _tmp3_;
			GValue _tmp4_ = {0};
			GValue _tmp5_;
			_tmp3_ = desktop_agnostic_config_backend_get_float ((DesktopAgnosticConfigBackend*) self, group, key, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				G_IS_VALUE (&_result_) ? (g_value_unset (&_result_), NULL) : NULL;
				_g_object_unref0 (option);
				_g_object_unref0 (schema);
				return;
			}
			_result_ = (_tmp5_ = (g_value_init (&_tmp4_, G_TYPE_FLOAT), g_value_set_float (&_tmp4_, _tmp3_), _tmp4_), G_IS_VALUE (&_result_) ? (g_value_unset (&_result_), NULL) : NULL, _tmp5_);
		} else {
			if (option_type == G_TYPE_INT) {
				gint _tmp6_;
				GValue _tmp7_ = {0};
				GValue _tmp8_;
				_tmp6_ = desktop_agnostic_config_backend_get_int ((DesktopAgnosticConfigBackend*) self, group, key, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					G_IS_VALUE (&_result_) ? (g_value_unset (&_result_), NULL) : NULL;
					_g_object_unref0 (option);
					_g_object_unref0 (schema);
					return;
				}
				_result_ = (_tmp8_ = (g_value_init (&_tmp7_, G_TYPE_INT), g_value_set_int (&_tmp7_, _tmp6_), _tmp7_), G_IS_VALUE (&_result_) ? (g_value_unset (&_result_), NULL) : NULL, _tmp8_);
			} else {
				if (option_type == G_TYPE_STRING) {
					char* _tmp9_;
					GValue _tmp10_ = {0};
					GValue _tmp11_;
					_tmp9_ = desktop_agnostic_config_backend_get_string ((DesktopAgnosticConfigBackend*) self, group, key, &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						G_IS_VALUE (&_result_) ? (g_value_unset (&_result_), NULL) : NULL;
						_g_object_unref0 (option);
						_g_object_unref0 (schema);
						return;
					}
					_result_ = (_tmp11_ = (g_value_init (&_tmp10_, G_TYPE_STRING), g_value_take_string (&_tmp10_, _tmp9_), _tmp10_), G_IS_VALUE (&_result_) ? (g_value_unset (&_result_), NULL) : NULL, _tmp11_);
				} else {
					if (option_type == G_TYPE_VALUE_ARRAY) {
						GValueArray* _tmp12_;
						GValue _tmp13_ = {0};
						GValue _tmp14_;
						_tmp12_ = desktop_agnostic_config_backend_get_list ((DesktopAgnosticConfigBackend*) self, group, key, &_inner_error_);
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							G_IS_VALUE (&_result_) ? (g_value_unset (&_result_), NULL) : NULL;
							_g_object_unref0 (option);
							_g_object_unref0 (schema);
							return;
						}
						_result_ = (_tmp14_ = (g_value_init (&_tmp13_, G_TYPE_VALUE_ARRAY), g_value_take_boxed (&_tmp13_, _tmp12_), _tmp13_), G_IS_VALUE (&_result_) ? (g_value_unset (&_result_), NULL) : NULL, _tmp14_);
					} else {
						DesktopAgnosticConfigSchemaType* st;
						st = _g_object_ref0 (desktop_agnostic_config_schema_find_type (option_type));
						if (st == NULL) {
							_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_INVALID_TYPE, "'%s' is an invalid config type.", g_type_name (option_type));
							{
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (st);
								G_IS_VALUE (&_result_) ? (g_value_unset (&_result_), NULL) : NULL;
								_g_object_unref0 (option);
								_g_object_unref0 (schema);
								return;
							}
						} else {
							char* _tmp15_;
							char* _tmp16_;
							GValue _tmp17_ = {0};
							GValue _tmp18_;
							GValue _tmp19_;
							GValue _tmp20_;
							_tmp15_ = desktop_agnostic_config_backend_get_string ((DesktopAgnosticConfigBackend*) self, group, key, &_inner_error_);
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (st);
								G_IS_VALUE (&_result_) ? (g_value_unset (&_result_), NULL) : NULL;
								_g_object_unref0 (option);
								_g_object_unref0 (schema);
								return;
							}
							_tmp19_ = (_tmp18_ = (desktop_agnostic_config_schema_type_deserialize (st, _tmp16_ = _tmp15_, &_tmp17_, &_inner_error_), _tmp17_), _g_free0 (_tmp16_), _tmp18_);
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (st);
								G_IS_VALUE (&_result_) ? (g_value_unset (&_result_), NULL) : NULL;
								_g_object_unref0 (option);
								_g_object_unref0 (schema);
								return;
							}
							_result_ = (_tmp20_ = _tmp19_, G_IS_VALUE (&_result_) ? (g_value_unset (&_result_), NULL) : NULL, _tmp20_);
						}
						_g_object_unref0 (st);
					}
				}
			}
		}
	}
	*result = _result_;
	_g_object_unref0 (option);
	_g_object_unref0 (schema);
	return;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean desktop_agnostic_config_gkey_file_real_get_bool (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error) {
	DesktopAgnosticConfigGKeyFile * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGKeyFile*) base;
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	{
		gboolean _tmp0_;
		_tmp0_ = g_key_file_get_boolean (self->priv->_data, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			gboolean _tmp1_ = FALSE;
			if (g_error_matches (err, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = g_error_matches (err, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND);
			}
			if (_tmp1_) {
				_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_KEY_NOT_FOUND, err->message);
				{
					_g_error_free0 (err);
					goto __finally1;
				}
			} else {
				_inner_error_ = _g_error_copy0 (err);
				{
					_g_error_free0 (err);
					goto __finally1;
				}
			}
			_g_error_free0 (err);
		}
	}
	__finally1:
	{
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
}


static void desktop_agnostic_config_gkey_file_real_set_bool (DesktopAgnosticConfigBackend* base, const char* group, const char* key, gboolean value, GError** error) {
	DesktopAgnosticConfigGKeyFile * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGKeyFile*) base;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	if (!g_key_file_has_group (self->priv->_data, group)) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = g_key_file_has_key (self->priv->_data, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp1_ = !_tmp2_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_;
		_tmp3_ = desktop_agnostic_config_backend_get_bool ((DesktopAgnosticConfigBackend*) self, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp0_ = _tmp3_ != value;
	}
	if (_tmp0_) {
		g_key_file_set_boolean (self->priv->_data, group, key, value);
		desktop_agnostic_config_gkey_file_update_config (self, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


static float desktop_agnostic_config_gkey_file_real_get_float (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error) {
	DesktopAgnosticConfigGKeyFile * self;
	float result = 0.0F;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGKeyFile*) base;
	g_return_val_if_fail (group != NULL, 0.0F);
	g_return_val_if_fail (key != NULL, 0.0F);
	{
		double _tmp0_;
		_tmp0_ = g_key_file_get_double (self->priv->_data, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch2_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0.0F;
		}
		result = (float) _tmp0_;
		return result;
	}
	goto __finally2;
	__catch2_g_key_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			gboolean _tmp1_ = FALSE;
			if (g_error_matches (err, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = g_error_matches (err, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND);
			}
			if (_tmp1_) {
				_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_KEY_NOT_FOUND, err->message);
				{
					_g_error_free0 (err);
					goto __finally2;
				}
			} else {
				_inner_error_ = _g_error_copy0 (err);
				{
					_g_error_free0 (err);
					goto __finally2;
				}
			}
			_g_error_free0 (err);
		}
	}
	__finally2:
	{
		if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0.0F;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0.0F;
		}
	}
}


static void desktop_agnostic_config_gkey_file_real_set_float (DesktopAgnosticConfigBackend* base, const char* group, const char* key, float value, GError** error) {
	DesktopAgnosticConfigGKeyFile * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGKeyFile*) base;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	if (!g_key_file_has_group (self->priv->_data, group)) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = g_key_file_has_key (self->priv->_data, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp1_ = !_tmp2_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		float _tmp3_;
		_tmp3_ = desktop_agnostic_config_backend_get_float ((DesktopAgnosticConfigBackend*) self, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp0_ = _tmp3_ != value;
	}
	if (_tmp0_) {
		g_key_file_set_double (self->priv->_data, group, key, (double) value);
		desktop_agnostic_config_gkey_file_update_config (self, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


static gint desktop_agnostic_config_gkey_file_real_get_int (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error) {
	DesktopAgnosticConfigGKeyFile * self;
	gint result = 0;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGKeyFile*) base;
	g_return_val_if_fail (group != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	{
		gint _tmp0_;
		_tmp0_ = g_key_file_get_integer (self->priv->_data, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch3_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally3;
	__catch3_g_key_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			gboolean _tmp1_ = FALSE;
			if (g_error_matches (err, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = g_error_matches (err, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND);
			}
			if (_tmp1_) {
				_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_KEY_NOT_FOUND, err->message);
				{
					_g_error_free0 (err);
					goto __finally3;
				}
			} else {
				_inner_error_ = _g_error_copy0 (err);
				{
					_g_error_free0 (err);
					goto __finally3;
				}
			}
			_g_error_free0 (err);
		}
	}
	__finally3:
	{
		g_propagate_error (error, _inner_error_);
		return 0;
	}
}


static void desktop_agnostic_config_gkey_file_real_set_int (DesktopAgnosticConfigBackend* base, const char* group, const char* key, gint value, GError** error) {
	DesktopAgnosticConfigGKeyFile * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGKeyFile*) base;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	if (!g_key_file_has_group (self->priv->_data, group)) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = g_key_file_has_key (self->priv->_data, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp1_ = !_tmp2_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp3_;
		_tmp3_ = desktop_agnostic_config_backend_get_int ((DesktopAgnosticConfigBackend*) self, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp0_ = _tmp3_ != value;
	}
	if (_tmp0_) {
		g_key_file_set_integer (self->priv->_data, group, key, value);
		desktop_agnostic_config_gkey_file_update_config (self, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


static char* desktop_agnostic_config_gkey_file_real_get_string (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error) {
	DesktopAgnosticConfigGKeyFile * self;
	char* result = NULL;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGKeyFile*) base;
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		char* _tmp0_;
		_tmp0_ = g_key_file_get_string (self->priv->_data, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch4_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally4;
	__catch4_g_key_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			gboolean _tmp1_ = FALSE;
			if (g_error_matches (err, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = g_error_matches (err, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND);
			}
			if (_tmp1_) {
				_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_KEY_NOT_FOUND, err->message);
				{
					_g_error_free0 (err);
					goto __finally4;
				}
			} else {
				_inner_error_ = _g_error_copy0 (err);
				{
					_g_error_free0 (err);
					goto __finally4;
				}
			}
			_g_error_free0 (err);
		}
	}
	__finally4:
	{
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
}


static void desktop_agnostic_config_gkey_file_real_set_string (DesktopAgnosticConfigBackend* base, const char* group, const char* key, const char* value, GError** error) {
	DesktopAgnosticConfigGKeyFile * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGKeyFile*) base;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	if (!g_key_file_has_group (self->priv->_data, group)) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = g_key_file_has_key (self->priv->_data, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp1_ = !_tmp2_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		char* _tmp3_;
		char* _tmp4_;
		_tmp3_ = desktop_agnostic_config_backend_get_string ((DesktopAgnosticConfigBackend*) self, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp0_ = _vala_strcmp0 (_tmp4_ = _tmp3_, value) != 0;
		_g_free0 (_tmp4_);
	}
	if (_tmp0_) {
		g_key_file_set_string (self->priv->_data, group, key, value);
		desktop_agnostic_config_gkey_file_update_config (self, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


static GValueArray* desktop_agnostic_config_gkey_file_real_get_list (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GError** error) {
	DesktopAgnosticConfigGKeyFile * self;
	GValueArray* result = NULL;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGKeyFile*) base;
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		GValueArray* _tmp0_;
		_tmp0_ = desktop_agnostic_config_gkey_file_generate_valuearray_from_keyfile (self, self->priv->_data, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch5_g_key_file_error;
			}
			goto __finally5;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally5;
	__catch5_g_key_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			gboolean _tmp1_ = FALSE;
			if (g_error_matches (err, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = g_error_matches (err, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND);
			}
			if (_tmp1_) {
				_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_KEY_NOT_FOUND, err->message);
				{
					_g_error_free0 (err);
					goto __finally5;
				}
			} else {
				_inner_error_ = _g_error_copy0 (err);
				{
					_g_error_free0 (err);
					goto __finally5;
				}
			}
			_g_error_free0 (err);
		}
	}
	__finally5:
	{
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
}


static void _vala_array_add1 (gboolean** array, int* length, int* size, gboolean value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gboolean, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add2 (gint** array, int* length, int* size, gint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add3 (double** array, int* length, int* size, double value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (double, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add4 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void desktop_agnostic_config_gkey_file_real_set_list (DesktopAgnosticConfigBackend* base, const char* group, const char* key, GValueArray* value, GError** error) {
	DesktopAgnosticConfigGKeyFile * self;
	DesktopAgnosticConfigSchemaOption* option;
	GType list_type;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticConfigGKeyFile*) base;
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	option = _g_object_ref0 (desktop_agnostic_config_schema_get_option (desktop_agnostic_config_backend_get_schema ((DesktopAgnosticConfigBackend*) self), group, key));
	list_type = desktop_agnostic_config_schema_option_get_list_type (option);
	if (g_key_file_has_group (self->priv->_data, group)) {
		gboolean _tmp1_;
		_tmp1_ = g_key_file_has_key (self->priv->_data, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (option);
			return;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GValueArray* old_value;
		GValueArray* _tmp2_;
		GValueArray* _tmp3_;
		old_value = NULL;
		_tmp2_ = desktop_agnostic_config_backend_get_list ((DesktopAgnosticConfigBackend*) self, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_value_array_free0 (old_value);
			_g_object_unref0 (option);
			return;
		}
		old_value = (_tmp3_ = _tmp2_, _g_value_array_free0 (old_value), _tmp3_);
		if (old_value->n_values == value->n_values) {
			gboolean is_equal;
			is_equal = TRUE;
			{
				guint i;
				i = (guint) 0;
				{
					gboolean _tmp4_;
					_tmp4_ = TRUE;
					while (TRUE) {
						GValue old_val = {0};
						GValue new_val = {0};
						gboolean _tmp5_ = FALSE;
						if (!_tmp4_) {
							i++;
						}
						_tmp4_ = FALSE;
						if (!(i < value->n_values)) {
							break;
						}
						old_val = *g_value_array_get_nth (old_value, i);
						new_val = *g_value_array_get_nth (value, i);
						if (G_VALUE_TYPE (&old_val) != G_VALUE_TYPE (&new_val)) {
							_tmp5_ = TRUE;
						} else {
							char* _tmp6_;
							char* _tmp7_;
							_tmp5_ = _vala_strcmp0 (_tmp6_ = g_strdup_value_contents (&old_val), _tmp7_ = g_strdup_value_contents (&new_val)) != 0;
							_g_free0 (_tmp7_);
							_g_free0 (_tmp6_);
						}
						if (_tmp5_) {
							is_equal = FALSE;
							break;
						}
					}
				}
			}
			if (is_equal) {
				_g_value_array_free0 (old_value);
				_g_object_unref0 (option);
				return;
			}
		}
		_g_value_array_free0 (old_value);
	}
	if (value->n_values == 0) {
		gboolean _tmp8_;
		if (!g_key_file_has_group (self->priv->_data, group)) {
			_g_object_unref0 (option);
			return;
		}
		_tmp8_ = g_key_file_has_key (self->priv->_data, group, key, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (option);
			return;
		}
		if (_tmp8_) {
			g_key_file_remove_key (self->priv->_data, group, key, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (option);
				return;
			}
		}
	} else {
		if (list_type == G_TYPE_BOOLEAN) {
			gint list_length1;
			gint _list_size_;
			gboolean* _tmp10_;
			gboolean* _tmp9_ = NULL;
			gboolean* list;
			list = (_tmp10_ = (_tmp9_ = g_new0 (gboolean, 0), _tmp9_), list_length1 = 0, _list_size_ = list_length1, _tmp10_);
			{
				GValueArray* val_collection;
				guint val_index;
				val_collection = value;
				for (val_index = 0; val_index < val_collection->n_values; val_index = val_index + 1) {
					GValue val;
					val = *g_value_array_get_nth (val_collection, val_index);
					{
						_vala_array_add1 (&list, &list_length1, &_list_size_, g_value_get_boolean (&val));
					}
				}
			}
			g_key_file_set_boolean_list (self->priv->_data, group, key, list, list_length1);
			list = (g_free (list), NULL);
		} else {
			if (list_type == G_TYPE_INT) {
				gint list_length1;
				gint _list_size_;
				gint* _tmp12_;
				gint* _tmp11_ = NULL;
				gint* list;
				list = (_tmp12_ = (_tmp11_ = g_new0 (gint, 0), _tmp11_), list_length1 = 0, _list_size_ = list_length1, _tmp12_);
				{
					GValueArray* val_collection;
					guint val_index;
					val_collection = value;
					for (val_index = 0; val_index < val_collection->n_values; val_index = val_index + 1) {
						GValue val;
						val = *g_value_array_get_nth (val_collection, val_index);
						{
							gint _tmp13_;
							_tmp13_ = desktop_agnostic_config_backend_get_int_from_value (&val, &_inner_error_);
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								list = (g_free (list), NULL);
								_g_object_unref0 (option);
								return;
							}
							_vala_array_add2 (&list, &list_length1, &_list_size_, _tmp13_);
						}
					}
				}
				g_key_file_set_integer_list (self->priv->_data, group, key, list, list_length1);
				list = (g_free (list), NULL);
			} else {
				if (list_type == G_TYPE_FLOAT) {
					gint list_length1;
					gint _list_size_;
					double* _tmp15_;
					double* _tmp14_ = NULL;
					double* list;
					list = (_tmp15_ = (_tmp14_ = g_new0 (double, 0), _tmp14_), list_length1 = 0, _list_size_ = list_length1, _tmp15_);
					{
						GValueArray* val_collection;
						guint val_index;
						val_collection = value;
						for (val_index = 0; val_index < val_collection->n_values; val_index = val_index + 1) {
							GValue val;
							val = *g_value_array_get_nth (val_collection, val_index);
							{
								float _tmp16_;
								_tmp16_ = desktop_agnostic_config_backend_get_float_from_value (&val, &_inner_error_);
								if (_inner_error_ != NULL) {
									g_propagate_error (error, _inner_error_);
									list = (g_free (list), NULL);
									_g_object_unref0 (option);
									return;
								}
								_vala_array_add3 (&list, &list_length1, &_list_size_, (double) _tmp16_);
							}
						}
					}
					g_key_file_set_double_list (self->priv->_data, group, key, list, list_length1);
					list = (g_free (list), NULL);
				} else {
					if (list_type == G_TYPE_STRING) {
						gint list_length1;
						gint _list_size_;
						char** _tmp18_;
						char** _tmp17_ = NULL;
						char** list;
						list = (_tmp18_ = (_tmp17_ = g_new0 (char*, 0 + 1), _tmp17_), list_length1 = 0, _list_size_ = list_length1, _tmp18_);
						{
							GValueArray* val_collection;
							guint val_index;
							val_collection = value;
							for (val_index = 0; val_index < val_collection->n_values; val_index = val_index + 1) {
								GValue val;
								val = *g_value_array_get_nth (val_collection, val_index);
								{
									_vala_array_add4 (&list, &list_length1, &_list_size_, g_strdup (g_value_get_string (&val)));
								}
							}
						}
						g_key_file_set_string_list (self->priv->_data, group, key, (const gchar* const*) list, list_length1);
						list = (_vala_array_free (list, list_length1, (GDestroyNotify) g_free), NULL);
					} else {
						DesktopAgnosticConfigSchemaType* st;
						gint list_length1;
						gint _list_size_;
						char** _tmp20_;
						char** _tmp19_ = NULL;
						char** list;
						st = _g_object_ref0 (desktop_agnostic_config_schema_find_type (list_type));
						if (st == NULL) {
							_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_INVALID_TYPE, "'%s' is an invalid config type.", g_type_name (list_type));
							{
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (st);
								_g_object_unref0 (option);
								return;
							}
						}
						list = (_tmp20_ = (_tmp19_ = g_new0 (char*, 0 + 1), _tmp19_), list_length1 = 0, _list_size_ = list_length1, _tmp20_);
						{
							GValueArray* val_collection;
							guint val_index;
							val_collection = value;
							for (val_index = 0; val_index < val_collection->n_values; val_index = val_index + 1) {
								GValue val;
								val = *g_value_array_get_nth (val_collection, val_index);
								{
									char* _tmp21_;
									_tmp21_ = desktop_agnostic_config_schema_type_serialize (st, &val, &_inner_error_);
									if (_inner_error_ != NULL) {
										g_propagate_error (error, _inner_error_);
										list = (_vala_array_free (list, list_length1, (GDestroyNotify) g_free), NULL);
										_g_object_unref0 (st);
										_g_object_unref0 (option);
										return;
									}
									_vala_array_add5 (&list, &list_length1, &_list_size_, _tmp21_);
								}
							}
						}
						g_key_file_set_string_list (self->priv->_data, group, key, (const gchar* const*) list, list_length1);
						list = (_vala_array_free (list, list_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (st);
					}
				}
			}
		}
	}
	desktop_agnostic_config_gkey_file_update_config (self, group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (option);
		return;
	}
	_g_object_unref0 (option);
}


DesktopAgnosticConfigGKeyFile* desktop_agnostic_config_gkey_file_construct (GType object_type) {
	DesktopAgnosticConfigGKeyFile * self = NULL;
	self = (DesktopAgnosticConfigGKeyFile*) desktop_agnostic_config_backend_construct (object_type);
	return self;
}


DesktopAgnosticConfigGKeyFile* desktop_agnostic_config_gkey_file_new (void) {
	return desktop_agnostic_config_gkey_file_construct (DESKTOP_AGNOSTIC_CONFIG_TYPE_GKEY_FILE);
}


static char* desktop_agnostic_config_gkey_file_real_get_name (DesktopAgnosticConfigBackend* base) {
	char* result;
	DesktopAgnosticConfigGKeyFile* self;
	self = (DesktopAgnosticConfigGKeyFile*) base;
	result = g_strdup ("GKeyFile");
	return result;
}


static GObject * desktop_agnostic_config_gkey_file_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DesktopAgnosticConfigGKeyFile * self;
	parent_class = G_OBJECT_CLASS (desktop_agnostic_config_gkey_file_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DESKTOP_AGNOSTIC_CONFIG_GKEY_FILE (obj);
	{
		self->priv->_autosave = TRUE;
		self->priv->_monitor_changed_id = (gulong) 0;
		if (desktop_agnostic_config_backend_get_schema ((DesktopAgnosticConfigBackend*) self) != NULL) {
			GKeyFile* _tmp0_;
			GData* _tmp1_ = {0};
			self->priv->_data = (_tmp0_ = g_key_file_new (), _g_key_file_free0 (self->priv->_data), _tmp0_);
			self->priv->_notifiers = (g_datalist_init (&_tmp1_), _tmp1_);
		}
	}
	return obj;
}


static void desktop_agnostic_config_gkey_file_class_init (DesktopAgnosticConfigGKeyFileClass * klass) {
	desktop_agnostic_config_gkey_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticConfigGKeyFilePrivate));
	G_OBJECT_CLASS (klass)->constructed = desktop_agnostic_config_gkey_file_real_constructed;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->reset = desktop_agnostic_config_gkey_file_real_reset;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->notify_add = desktop_agnostic_config_gkey_file_real_notify_add;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->notify = desktop_agnostic_config_gkey_file_real_notify;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->notify_remove = desktop_agnostic_config_gkey_file_real_notify_remove;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->remove = desktop_agnostic_config_gkey_file_real_remove;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_value = desktop_agnostic_config_gkey_file_real_get_value;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_bool = desktop_agnostic_config_gkey_file_real_get_bool;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->set_bool = desktop_agnostic_config_gkey_file_real_set_bool;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_float = desktop_agnostic_config_gkey_file_real_get_float;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->set_float = desktop_agnostic_config_gkey_file_real_set_float;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_int = desktop_agnostic_config_gkey_file_real_get_int;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->set_int = desktop_agnostic_config_gkey_file_real_set_int;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_string = desktop_agnostic_config_gkey_file_real_get_string;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->set_string = desktop_agnostic_config_gkey_file_real_set_string;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_list = desktop_agnostic_config_gkey_file_real_get_list;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->set_list = desktop_agnostic_config_gkey_file_real_set_list;
	DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS (klass)->get_name = desktop_agnostic_config_gkey_file_real_get_name;
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_config_gkey_file_get_property;
	G_OBJECT_CLASS (klass)->constructor = desktop_agnostic_config_gkey_file_constructor;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_config_gkey_file_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_GKEY_FILE_NAME, "name");
}


static void desktop_agnostic_config_gkey_file_instance_init (DesktopAgnosticConfigGKeyFile * self) {
	self->priv = DESKTOP_AGNOSTIC_CONFIG_GKEY_FILE_GET_PRIVATE (self);
}


static void desktop_agnostic_config_gkey_file_finalize (GObject* obj) {
	DesktopAgnosticConfigGKeyFile * self;
	self = DESKTOP_AGNOSTIC_CONFIG_GKEY_FILE (obj);
	{
		desktop_agnostic_vfs_file_monitor_cancel (self->priv->_keyfile_monitor);
		g_signal_handler_disconnect (self->priv->_keyfile_monitor, self->priv->_monitor_changed_id);
	}
	_g_key_file_free0 (self->priv->_data);
	_g_object_unref0 (self->priv->_keyfile);
	_g_object_unref0 (self->priv->_keyfile_monitor);
	_g_free0 (self->priv->_checksum);
	G_OBJECT_CLASS (desktop_agnostic_config_gkey_file_parent_class)->finalize (obj);
}


GType desktop_agnostic_config_gkey_file_get_type (void) {
	static volatile gsize desktop_agnostic_config_gkey_file_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_config_gkey_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticConfigGKeyFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_config_gkey_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticConfigGKeyFile), 0, (GInstanceInitFunc) desktop_agnostic_config_gkey_file_instance_init, NULL };
		GType desktop_agnostic_config_gkey_file_type_id;
		desktop_agnostic_config_gkey_file_type_id = g_type_register_static (DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND, "DesktopAgnosticConfigGKeyFile", &g_define_type_info, 0);
		g_once_init_leave (&desktop_agnostic_config_gkey_file_type_id__volatile, desktop_agnostic_config_gkey_file_type_id);
	}
	return desktop_agnostic_config_gkey_file_type_id__volatile;
}


static void desktop_agnostic_config_gkey_file_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticConfigGKeyFile * self;
	self = DESKTOP_AGNOSTIC_CONFIG_GKEY_FILE (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_CONFIG_GKEY_FILE_NAME:
		g_value_take_string (value, desktop_agnostic_config_backend_get_name ((DesktopAgnosticConfigBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType register_plugin (void) {
	GType result = 0UL;
	result = DESKTOP_AGNOSTIC_CONFIG_TYPE_GKEY_FILE;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




