<?php
/////////////////////////////////////////
// File Name : Print_Report.php
// Creation Date : July 2006
// Description : This is one of the options a user may select to print the informations
//		   This report will print all the nodes in the selected tree give informations on the valid ones
//
// Modifications : -
//
/////////////////////////////////////////////////////////////////////////

	$valid_nodes = $_SESSION['valid_nodes'];
	$shown_nodes = 0;
	$tree = $_SESSION['tree'];
	
	// Hides the childs of a node
	if( isset( $_GET['close'] ) ){
		$tree[ $_GET['close'] ]->close();
	}
	
	// Shows the childs of a node
	if( isset( $_GET['open'] ) ){
		$tree[ $_GET['open'] ]->open();
	}

	printRapport( $tree[0] );
	if( $shown_nodes == 0 ){
		echo getMessage('stats_no_node');
	}

	function  printRapport( $node ){
		global $valid_nodes, $shown_nodes;
		// if a node isn't checked, don't show it.
		if( $node->status > 0 ){
			$shown_nodes ++;
			global $tree, $shown_page;
			$conditions = $_SESSION['conditions'];
			$useHeritage = $_SESSION['useHeritage'];
			
			$config_info = $node->attributes[ "config" ];
			$hardware_info = $node->attributes[ "hardware" ];
			$network_info = $node->attributes[ "network" ];
			
			$showHR = false;
			
			// The CSS is different if the node is a Context or a Terminal
			if( $node->type == 0 ){
				$css = "context";
			} else {
				$css = "terminal";
			}

			$title = getNodeFullPath( $node );
			echo "<fieldset class='".$css."-rapport' title='".$title."'>";
				echo "<legend align=top class='titre-node-rapport'>";
					echo "<a name='".$node->id."' href='".$shown_page."?step=3&";
					if( $node->is_opened ){
						echo "close=".$node->id."#".$node->id_parent."'";
					} else {
						echo "open=".$node->id."#".$node->id."'";
					}
					echo "><img src='images/";
					if( $node->is_opened ){
						echo "minus.gif' alt='-'";
					} else {
						echo "plus.gif' alt='+'";
					}
					echo " title='' name='".$node->toString()."'></a>";
					echo "<img src='images/";
					if( $node->type == 0 ){
						echo "context.gif";
					} else {
						echo "terminal.gif";
					}
					echo "' title='' alt=''>";
					echo "<u>".$node->toString()."</u>";
				echo "</legend>";
				if( $node->is_opened ){
					echo "<fieldset class='".$css."-rapport-infos'>";
						echo "<legend align=top class='titre-attribut-rapport'>";
							echo getMessage('stats_attribute');
						echo "</legend>";
						// if a Node has a Status of 2, show it's informations
						if( ( count( $config_info ) + count( $hardware_info ) + count( $network_info ) ) == 0 ){
							echo getMessage('stats_report_no_attr');
						} else if( $node->status == 2 && in_array( $title."/".$node->toString(), $valid_nodes ) ){
							if( count( $config_info ) > 0 ){
								$showHR = true;
								foreach( $config_info as $nom => $config ){
									echo $nom." : ".$config."<br>";
								}
							}
							// We only test Terminals for those Attributes
							if( $node->type == 1 ){
								if( count( $hardware_info ) > 0 ){
									if( $showHR ){
										echo "<hr>";
										$showHR = false;
									}
									$showHR = true;
									foreach( $hardware_info as $nom => $hardware ){
										echo $nom." : ".$hardware."<br>";
									}
								}
								if( count( $network_info ) > 0 ){
									if( $showHR ){
										echo "<hr>";
										$showHR = false;
									}
									foreach( $network_info as $nom => $network ){
										echo $nom." : ".$network."<br>";
									}
								}
							}
						} else {
							echo getMessage('stats_report_err_cond');
						}
					echo "</fieldset>";
					$childs = $node->returnChild( $tree );
					for( $i = 0; $i < count( $childs ); $i++ ){
						printRapport( $tree[ $childs[ $i ] ] );
					}
				}
			echo "</fieldset>";
		}
	}
?>