<?php
/////////////////////////////////////////
// File Name : Node.php
// Creation Date : July 2007
// Description : This is constructor and all the functions of the object Node used below
//
// Modifications : -
//
/////////////////////////////////////////////////////////////////////////

class node{
	var $id;
	var $id_parent;
	var $name;		// Node's real name for a Context, it's Mac Address for a Terminal
	var $type;		// 0 context, 1 terminal
	var $is_opened;	// TRUE opened, FALSE closed
	var $status;	// 0 unchecked or no sons checked, 1 checked or some sons checked, 2 checked and all sons checked
	var $attributes;// Array of all the configs associated to a node
	
	// Node constructor
	// NB : When created, a node is unchecked, closed and it's sons are all unchecked
	function node( $id, $id_parent, $name, $type ){
		$this->id = $id;
		$this->id_parent = $id_parent;
		$this->name = $name;
		$this->type = $type;
		$this->is_opened = false;
		$this->status = 0;
		$this->clearAttributes();
	}
	
	function close(){
		$this->is_opened = false;
	}
	
	function open(){
		$this->is_opened = true;
	}

	// If the status of a node is higher than 0, it is checked
	function is_checked(){
		$retour = false;
		if( $this->status > 0 ){
			$retour = true;
		}
		return $retour;
	}
	
	// Returns an array of the IDs from the direct childs of a node
	function returnChild( $tree ){
		$childs = array();
		foreach( $tree as $node ){
			if( $node->id_parent == $this->id && $node->id <> $this->id ){
				$childs[] = $node->id;
			}
		}
		return $childs;
	}

	// Returns what will be shown when the node will be printed
	function toString(){
		return $this->name;
	}

	// Empties the array of attributes of the node
	function clearAttributes(){
		$this->attributes = array();
		$this->attributes[ "config" ] = array();
		$this->attributes[ "hardware" ] = array();
		$this->attributes[ "network" ] = array();
	}
}
?>