/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "includes.h"

void lt_colorset_html() { /* this will set up the colors for the parseansi() function */

        /* 
         * determine if user asked us to "beep" on red events, and set up the value of
         * color.red accordingly. 
         */

	strcpy(color.red, "<FONT color=#BB0000>");
	strcpy(color.brightred, "<FONT color=FF0000>");

	strcpy(color.green, "<FONT color=#009900>");
	strcpy(color.brightgreen, "<FONT color=#00FF00>");
        
	strcpy(color.yellow, "<FONT color=#CCCC00>");
	strcpy(color.brightyellow, "<FONT color=#FFFF00>");
        
	strcpy(color.dimwhite, "<FONT color=#606060>");
	strcpy(color.white, "<FONT color=#CCCCCC>");
	strcpy(color.brightwhite, "<FONT color=#FFFFFF>");
        
	strcpy(color.cyan, "<FONT color=#009090>");
	strcpy(color.brightcyan, "<FONT color=#00F0F0>");
        
	strcpy(color.blue, "<FONT color=#0000CC>");
	strcpy(color.brightblue, "<FONT color=#1010FF>");

	strcpy(color.magenta, "<FONT color=#CC00CC>");
	strcpy(color.brightmagenta, "<FONT color=#FF00FF>");
	
	strcpy(color.unknown, "<FONT color=#CCCCCC>");
	strcpy(color.end, "</FONT>");
}

void lto_parse_html() {
	long int i = 0;
	/* we have to escape <, >, and &'s for nice HTML */
        char *tmp_pmsg = NULL;
        char tc[2];
	/* make string == event.pmsg                                            */
        char *str = event.pmsg;

        /* we should never wind up 8 times the length of the original event     */
        tmp_pmsg = malloc(strlen(event.pmsg) * 8);
	/* zero this memory, or we get odd things happening (I don't know why!) */
	bzero(tmp_pmsg, (strlen(event.pmsg) * 8));
        /* here is our main parsing loop; we'll run through the message, replacing \033 escapes */
        /* with the appropriate color.* relevant to the current output module                   */
        for(i = 0 ; str[i] != '\0'; ++i) {
		switch(str[i]) {
			case '<':
				strcat(tmp_pmsg, "&lt;");
				break;
			case '>':
        	                strcat(tmp_pmsg, "&gt;");
				break;
			case '&':
				strcat(tmp_pmsg, "&amp;");
				break;
			default:
				tc[0] = str[i];
				tc[1] = '\0';
				strcat(tmp_pmsg, tc);
				break;
		}		
	}
	fprintf(stderr, "%s\n", tmp_pmsg);
	/* put our parsed string into event.pmsg */
	strcpy(event.pmsg, tmp_pmsg);
        /* free our tmp_pmsg                                            */
        free(tmp_pmsg);
	/* now we parse results to get proper HTML fonts and such */			
	parse_pmsg();
							
}

void lto_html() {

        /* parse the \033e escpae sequences into native ANSI    */
        lto_parse_html();

        /* if it's a duplicate message, just print the "!" warning to screen    */
        if(event.type != EVENT_UNKNOWN && cf.input == TRUE && cf.supdupes == TRUE && 
			strcmp(event.message, event.lmessage) == 0 && strcmp(event.source, event.lsource) == 0) {
                printf("%s!%s", color.brightwhite, color.end);
        } else {
                /* if this isn't the first message, print a \newline                    */
                if(cf.input == TRUE) {
                        printf("<BR>\n");
                }
                /* print yee old message as parsed by the module in question    */
		cf.input = TRUE;
                printf("<NOBR>%s", event.pmsg);
        }
        fflush(stdout);
}

